/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.VirtualFileManagerImpl;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.RefreshSession;
import com.intellij.util.messages.MessageBus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlatformVirtualFileManager
extends VirtualFileManagerImpl {
    @NotNull
    private final ManagingFS myManagingFS;

    public PlatformVirtualFileManager(@NotNull VirtualFileSystem[] fileSystems, @NotNull MessageBus bus, @NotNull ManagingFS managingFS) {
        if (fileSystems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSystems", "com/intellij/openapi/vfs/PlatformVirtualFileManager", "<init>"));
        }
        if (bus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bus", "com/intellij/openapi/vfs/PlatformVirtualFileManager", "<init>"));
        }
        if (managingFS == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "managingFS", "com/intellij/openapi/vfs/PlatformVirtualFileManager", "<init>"));
        }
        super(fileSystems, bus);
        this.myManagingFS = managingFS;
    }

    @Override
    protected long doRefresh(boolean asynchronous, @Nullable Runnable postAction) {
        if (!asynchronous) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        }
        RefreshSession session = RefreshQueue.getInstance().createSession(asynchronous, true, postAction);
        session.addAllFiles(this.myManagingFS.getRoots());
        session.launch();
        super.doRefresh(asynchronous, postAction);
        return session.getId();
    }

    @Override
    public long getModificationCount() {
        return this.myManagingFS.getCheapFileSystemModificationCount();
    }
}

