/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection;

import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.profile.Profile;
import com.intellij.profile.ProfileManager;
import java.io.File;
import java.io.IOException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionProfileLoadUtil {
    @NonNls
    private static final String PROFILE_NAME_TAG = "profile_name";
    @NonNls
    public static final String PROFILE_TAG = "profile";

    private static String getProfileName(@NotNull File file, @NotNull Document document) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/profile/codeInspection/InspectionProfileLoadUtil", "getProfileName"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/profile/codeInspection/InspectionProfileLoadUtil", "getProfileName"));
        }
        String name = InspectionProfileLoadUtil.getRootElementAttribute(PROFILE_NAME_TAG, document);
        if (name != null) {
            return name;
        }
        return FileUtil.getNameWithoutExtension((File)file);
    }

    private static String getRootElementAttribute(@NotNull Document document, @NonNls String name) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/profile/codeInspection/InspectionProfileLoadUtil", "getRootElementAttribute"));
        }
        Element root = document.getRootElement();
        return root.getAttributeValue(name);
    }

    @Nullable
    private static String getRootElementAttribute(@NonNls String name, Document doc) {
        return InspectionProfileLoadUtil.getRootElementAttribute(doc, name);
    }

    @NotNull
    public static String getProfileName(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/profile/codeInspection/InspectionProfileLoadUtil", "getProfileName"));
        }
        String name = InspectionProfileLoadUtil.getRootElementAttribute(document, PROFILE_NAME_TAG);
        if (name != null) {
            String string = name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/InspectionProfileLoadUtil", "getProfileName"));
            }
            return string;
        }
        if ("unnamed" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/InspectionProfileLoadUtil", "getProfileName"));
        }
        return "unnamed";
    }

    @NotNull
    public static Profile load(@NotNull File file, @NotNull InspectionToolRegistrar registrar, @NotNull ProfileManager profileManager) throws JDOMException, IOException, InvalidDataException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/profile/codeInspection/InspectionProfileLoadUtil", "load"));
        }
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/profile/codeInspection/InspectionProfileLoadUtil", "load"));
        }
        if (profileManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profileManager", "com/intellij/profile/codeInspection/InspectionProfileLoadUtil", "load"));
        }
        Document document = JDOMUtil.loadDocument((File)file);
        InspectionProfileImpl profile = new InspectionProfileImpl(InspectionProfileLoadUtil.getProfileName(file, document), registrar, profileManager);
        Element rootElement = document.getRootElement();
        Element profileElement = rootElement.getChild(PROFILE_TAG);
        if (profileElement != null) {
            rootElement = profileElement;
        }
        profile.readExternal(rootElement);
        InspectionProfileImpl inspectionProfileImpl = profile;
        if (inspectionProfileImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/InspectionProfileLoadUtil", "load"));
        }
        return inspectionProfileImpl;
    }
}

