/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.psi.PsiElement;
import org.intellij.lang.regexp.DefaultRegExpPropertiesProvider;
import org.intellij.lang.regexp.RegExpLanguageHost;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaRegExpHost
implements RegExpLanguageHost {
    private final DefaultRegExpPropertiesProvider myPropertiesProvider = DefaultRegExpPropertiesProvider.getInstance();

    @Override
    public boolean characterNeedsEscaping(char c) {
        return c == ']' || c == '}';
    }

    @Override
    public boolean supportsPerl5EmbeddedComments() {
        return false;
    }

    @Override
    public boolean supportsPossessiveQuantifiers() {
        return true;
    }

    @Override
    public boolean supportsPythonConditionalRefs() {
        return false;
    }

    @Override
    public boolean supportsNamedGroupSyntax(RegExpGroup group) {
        Sdk sdk;
        Module module;
        if (group.isRubyNamedGroup() && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)group)) != null && (sdk = ModuleRootManager.getInstance((Module)module).getSdk()) != null && sdk.getSdkType() instanceof JavaSdk) {
            JavaSdkVersion version = JavaSdk.getInstance().getVersion(sdk);
            return version != null && version.isAtLeast(JavaSdkVersion.JDK_1_7);
        }
        return false;
    }

    @Override
    public boolean isValidCategory(@NotNull String category) {
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/psi/impl/JavaRegExpHost", "isValidCategory"));
        }
        return this.myPropertiesProvider.isValidCategory(category);
    }

    @Override
    @NotNull
    public String[][] getAllKnownProperties() {
        String[][] stringArray = this.myPropertiesProvider.getAllKnownProperties();
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaRegExpHost", "getAllKnownProperties"));
        }
        return stringArray;
    }

    @Override
    @Nullable
    public String getPropertyDescription(@Nullable String name) {
        return this.myPropertiesProvider.getPropertyDescription(name);
    }

    @Override
    @NotNull
    public String[][] getKnownCharacterClasses() {
        String[][] stringArray = this.myPropertiesProvider.getKnownCharacterClasses();
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaRegExpHost", "getKnownCharacterClasses"));
        }
        return stringArray;
    }
}

