/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceParameter;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceHandlerBase;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.inplace.AbstractInplaceIntroducer;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.refactoring.introduceParameter.AbstractJavaInplaceIntroducer;
import com.intellij.refactoring.introduceParameter.EnclosingMethodSelectionDialog;
import com.intellij.refactoring.introduceParameter.InplaceIntroduceParameterPopup;
import com.intellij.refactoring.introduceParameter.IntroduceParameterDialog;
import com.intellij.refactoring.introduceParameter.IntroduceParameterProcessor;
import com.intellij.refactoring.introduceParameter.Util;
import com.intellij.refactoring.ui.MethodCellRenderer;
import com.intellij.refactoring.ui.NameSuggestionsGenerator;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.occurrences.ExpressionOccurrenceManager;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBList;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import gnu.trove.TIntArrayList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntroduceParameterHandler
extends IntroduceHandlerBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.introduceParameter.IntroduceParameterHandler");
    static final String REFACTORING_NAME = RefactoringBundle.message((String)"introduce.parameter.title");
    private JBPopup myEnclosingMethodsPopup;
    private InplaceIntroduceParameterPopup myInplaceIntroduceParameterPopup;

    public void invoke(final @NotNull Project project, final Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/introduceParameter/IntroduceParameterHandler", "invoke"));
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        ElementToWorkOn.processElementToWorkOn(editor, file, REFACTORING_NAME, "refactoring.introduceParameter", project, new ElementToWorkOn.ElementsProcessor<ElementToWorkOn>(){

            @Override
            public boolean accept(ElementToWorkOn el) {
                return true;
            }

            @Override
            public void pass(ElementToWorkOn elementToWorkOn) {
                if (elementToWorkOn == null) {
                    return;
                }
                PsiExpression expr = elementToWorkOn.getExpression();
                PsiLocalVariable localVar = elementToWorkOn.getLocalVariable();
                boolean isInvokedOnDeclaration = elementToWorkOn.isInvokedOnDeclaration();
                IntroduceParameterHandler.this.invoke(editor, project, expr, localVar, isInvokedOnDeclaration);
            }
        });
    }

    @Override
    protected boolean invokeImpl(Project project, PsiExpression tempExpr, Editor editor) {
        return this.invoke(editor, project, tempExpr, null, false);
    }

    @Override
    protected boolean invokeImpl(Project project, PsiLocalVariable localVariable, Editor editor) {
        return this.invoke(editor, project, null, localVariable, true);
    }

    private boolean invoke(Editor editor, Project project, PsiExpression expr, PsiLocalVariable localVar, boolean invokedOnDeclaration) {
        PsiMethod methodToIntroduceParameterTo;
        PsiType typeByExpression;
        PsiElement parent;
        LOG.assertTrue(!PsiDocumentManager.getInstance((Project)project).hasUncommitedDocuments());
        PsiMethod method = expr != null ? Util.getContainingMethod((PsiElement)expr) : Util.getContainingMethod((PsiElement)localVar);
        if (LOG.isDebugEnabled()) {
            LOG.debug("expression:" + expr);
        }
        if (expr == null && localVar == null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"selected.block.should.represent.an.expression"));
            IntroduceParameterHandler.showErrorMessage(project, message, editor);
            return false;
        }
        if (localVar != null && !((parent = localVar.getParent()) instanceof PsiDeclarationStatement)) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.local.or.expression.name"));
            IntroduceParameterHandler.showErrorMessage(project, message, editor);
            return false;
        }
        if (method == null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"is.not.supported.in.the.current.context", (Object[])new Object[]{REFACTORING_NAME}));
            IntroduceParameterHandler.showErrorMessage(project, message, editor);
            return false;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)method)) {
            return false;
        }
        PsiType psiType = typeByExpression = invokedOnDeclaration ? null : RefactoringUtil.getTypeByExpressionWithExpectedType(expr);
        if (!invokedOnDeclaration && (typeByExpression == null || LambdaUtil.notInferredType((PsiType)typeByExpression))) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"type.of.the.selected.expression.cannot.be.determined"));
            IntroduceParameterHandler.showErrorMessage(project, message, editor);
            return false;
        }
        if (!invokedOnDeclaration && PsiType.VOID.equals((Object)typeByExpression)) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"selected.expression.has.void.type"));
            IntroduceParameterHandler.showErrorMessage(project, message, editor);
            return false;
        }
        List<PsiMethod> validEnclosingMethods = IntroduceParameterHandler.getEnclosingMethods(method);
        if (validEnclosingMethods.isEmpty()) {
            return false;
        }
        Introducer introducer = new Introducer(project, expr, localVar, editor);
        boolean unitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        if ((validEnclosingMethods.size() == 1 || unitTestMode) && ((methodToIntroduceParameterTo = validEnclosingMethods.get(0)).findDeepestSuperMethod() == null || unitTestMode)) {
            introducer.introduceParameter(methodToIntroduceParameterTo, methodToIntroduceParameterTo);
            return true;
        }
        this.chooseMethodToIntroduceParameter(editor, validEnclosingMethods, introducer);
        return true;
    }

    private void chooseMethodToIntroduceParameter(final Editor editor, List<PsiMethod> validEnclosingMethods, final Introducer introducer) {
        AbstractInplaceIntroducer inplaceIntroducer = AbstractInplaceIntroducer.getActiveIntroducer(editor);
        if (inplaceIntroducer instanceof InplaceIntroduceParameterPopup) {
            InplaceIntroduceParameterPopup introduceParameterPopup = (InplaceIntroduceParameterPopup)inplaceIntroducer;
            introducer.introduceParameter(introduceParameterPopup.getMethodToIntroduceParameter(), introduceParameterPopup.getMethodToSearchFor());
            return;
        }
        JPanel panel = new JPanel(new BorderLayout());
        final JCheckBox superMethod = new JCheckBox("Refactor super method", true);
        superMethod.setMnemonic('U');
        panel.add((Component)superMethod, "South");
        final JBList list = new JBList(validEnclosingMethods.toArray());
        list.setVisibleRowCount(5);
        list.setCellRenderer((ListCellRenderer)new MethodCellRenderer());
        list.getSelectionModel().setSelectionMode(0);
        list.setSelectedIndex(0);
        final ArrayList<RangeHighlighter> highlighters = new ArrayList<RangeHighlighter>();
        final TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PsiMethod selectedMethod = (PsiMethod)list.getSelectedValue();
                if (selectedMethod == null) {
                    return;
                }
                IntroduceParameterHandler.dropHighlighters(highlighters);
                IntroduceParameterHandler.updateView(selectedMethod, editor, attributes, highlighters, superMethod);
            }
        });
        IntroduceParameterHandler.updateView(validEnclosingMethods.get(0), editor, attributes, highlighters, superMethod);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)list);
        scrollPane.setBorder(null);
        panel.add((Component)scrollPane, "Center");
        List<Pair> keyboardActions = Collections.singletonList(Pair.create((Object)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final PsiMethod methodToSearchIn = (PsiMethod)list.getSelectedValue();
                if (IntroduceParameterHandler.this.myEnclosingMethodsPopup != null && IntroduceParameterHandler.this.myEnclosingMethodsPopup.isVisible()) {
                    IntroduceParameterHandler.this.myEnclosingMethodsPopup.cancel();
                }
                final PsiMethod methodToSearchFor = superMethod.isEnabled() && superMethod.isSelected() ? methodToSearchIn.findDeepestSuperMethod() : methodToSearchIn;
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        introducer.introduceParameter(methodToSearchIn, methodToSearchFor);
                    }
                };
                IdeFocusManager.findInstance().doWhenFocusSettlesDown(runnable);
            }
        }, (Object)KeyStroke.getKeyStroke(10, 0)));
        this.myEnclosingMethodsPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel, (JComponent)list).setTitle("Introduce parameter to method").setMovable(false).setResizable(false).setRequestFocus(true).setKeyboardActions(keyboardActions).addListener((JBPopupListener)new JBPopupAdapter(){

            public void onClosed(LightweightWindowEvent event) {
                IntroduceParameterHandler.dropHighlighters(highlighters);
            }
        }).createPopup();
        this.myEnclosingMethodsPopup.showInBestPositionFor(editor);
    }

    private static void updateView(PsiMethod selectedMethod, Editor editor, TextAttributes attributes, List<RangeHighlighter> highlighters, JCheckBox superMethod) {
        MarkupModel markupModel = editor.getMarkupModel();
        PsiIdentifier nameIdentifier = selectedMethod.getNameIdentifier();
        if (nameIdentifier != null) {
            TextRange textRange = nameIdentifier.getTextRange();
            RangeHighlighter rangeHighlighter = markupModel.addRangeHighlighter(textRange.getStartOffset(), textRange.getEndOffset(), 5999, attributes, HighlighterTargetArea.EXACT_RANGE);
            highlighters.add(rangeHighlighter);
        }
        superMethod.setEnabled(selectedMethod.findDeepestSuperMethod() != null);
    }

    private static void dropHighlighters(List<RangeHighlighter> highlighters) {
        for (RangeHighlighter highlighter : highlighters) {
            highlighter.dispose();
        }
        highlighters.clear();
    }

    protected static NameSuggestionsGenerator createNameSuggestionGenerator(final PsiExpression expr, final String propName, final Project project, final String enteredName) {
        return new NameSuggestionsGenerator(){

            @Override
            public SuggestedNameInfo getSuggestedNameInfo(PsiType type) {
                JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
                SuggestedNameInfo info = codeStyleManager.suggestVariableName(VariableKind.PARAMETER, propName, expr != null && expr.isValid() ? expr : null, type);
                if (expr != null && expr.isValid()) {
                    info = codeStyleManager.suggestUniqueVariableName(info, (PsiElement)expr, true);
                }
                String[] strings = AbstractJavaInplaceIntroducer.appendUnresolvedExprName(JavaCompletionUtil.completeVariableNameForRefactoring(codeStyleManager, type, VariableKind.LOCAL_VARIABLE, info), expr);
                return new SuggestedNameInfo.Delegate(enteredName != null ? ArrayUtil.mergeArrays((String[])new String[]{enteredName}, (String[])strings) : strings, info);
            }
        };
    }

    private static void showErrorMessage(Project project, String message, Editor editor) {
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.introduceParameter");
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/introduceParameter/IntroduceParameterHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/introduceParameter/IntroduceParameterHandler", "invoke"));
        }
    }

    public static List<PsiMethod> getEnclosingMethods(PsiMethod nearest) {
        ArrayList<PsiMethod> enclosingMethods = new ArrayList<PsiMethod>();
        enclosingMethods.add(nearest);
        PsiMethod method = nearest;
        while ((method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)method, PsiMethod.class, (boolean)true)) != null) {
            enclosingMethods.add(method);
        }
        if (enclosingMethods.size() > 1) {
            ArrayList<PsiMethod> methodsNotImplementingLibraryInterfaces = new ArrayList<PsiMethod>();
            for (PsiMethod enclosing : enclosingMethods) {
                PsiMethod[] superMethods = enclosing.findDeepestSuperMethods();
                boolean libraryInterfaceMethod = false;
                for (PsiMethod superMethod : superMethods) {
                    libraryInterfaceMethod |= IntroduceParameterHandler.isLibraryInterfaceMethod(superMethod);
                }
                if (libraryInterfaceMethod) continue;
                methodsNotImplementingLibraryInterfaces.add(enclosing);
            }
            if (methodsNotImplementingLibraryInterfaces.size() > 0) {
                return methodsNotImplementingLibraryInterfaces;
            }
        }
        return enclosingMethods;
    }

    @Nullable
    public static PsiMethod chooseEnclosingMethod(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/refactoring/introduceParameter/IntroduceParameterHandler", "chooseEnclosingMethod"));
        }
        List<PsiMethod> validEnclosingMethods = IntroduceParameterHandler.getEnclosingMethods(method);
        if (validEnclosingMethods.size() > 1 && !ApplicationManager.getApplication().isUnitTestMode()) {
            EnclosingMethodSelectionDialog dialog = new EnclosingMethodSelectionDialog(method.getProject(), validEnclosingMethods);
            dialog.show();
            if (!dialog.isOK()) {
                return null;
            }
            method = dialog.getSelectedMethod();
        } else if (validEnclosingMethods.size() == 1) {
            method = validEnclosingMethods.get(0);
        }
        return method;
    }

    private static boolean isLibraryInterfaceMethod(PsiMethod method) {
        return method.hasModifierProperty("abstract") && !method.getManager().isInProject((PsiElement)method);
    }

    @Override
    public AbstractInplaceIntroducer getInplaceIntroducer() {
        return this.myInplaceIntroduceParameterPopup;
    }

    private class Introducer {
        private final Project myProject;
        private PsiExpression myExpr;
        private PsiLocalVariable myLocalVar;
        private final Editor myEditor;

        public Introducer(Project project, PsiExpression expr, PsiLocalVariable localVar, Editor editor) {
            this.myProject = project;
            this.myExpr = expr;
            this.myLocalVar = localVar;
            this.myEditor = editor;
        }

        public void introduceParameter(PsiMethod method, PsiMethod methodToSearchFor) {
            boolean isInplaceAvailableOnDataContext;
            if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)this.myProject, (PsiElement)methodToSearchFor)) {
                return;
            }
            PsiExpression[] occurences = this.myExpr != null ? new ExpressionOccurrenceManager(this.myExpr, (PsiElement)method, null).findExpressionOccurrences() : CodeInsightUtil.findReferenceExpressions((PsiElement)method, (PsiElement)this.myLocalVar);
            String enteredName = null;
            boolean replaceAllOccurrences = false;
            boolean delegate = false;
            PsiType initializerType = IntroduceParameterProcessor.getInitializerType(null, this.myExpr, this.myLocalVar);
            AbstractInplaceIntroducer activeIntroducer = AbstractInplaceIntroducer.getActiveIntroducer(this.myEditor);
            if (activeIntroducer != null) {
                activeIntroducer.stopIntroduce(this.myEditor);
                this.myExpr = (PsiExpression)activeIntroducer.getExpr();
                this.myLocalVar = (PsiLocalVariable)activeIntroducer.getLocalVariable();
                occurences = (PsiExpression[])activeIntroducer.getOccurrences();
                enteredName = activeIntroducer.getInputName();
                replaceAllOccurrences = activeIntroducer.isReplaceAllOccurrences();
                delegate = ((InplaceIntroduceParameterPopup)activeIntroducer).isGenerateDelegate();
                initializerType = ((AbstractJavaInplaceIntroducer)activeIntroducer).getType();
            }
            boolean mustBeFinal = false;
            for (PsiExpression occurrence : occurences) {
                if (PsiTreeUtil.getParentOfType((PsiElement)occurrence, (Class[])new Class[]{PsiClass.class, PsiMethod.class}) == method) continue;
                mustBeFinal = true;
                break;
            }
            ArrayList<UsageInfo> localVars = new ArrayList<UsageInfo>();
            ArrayList<UsageInfo> classMemberRefs = new ArrayList<UsageInfo>();
            ArrayList<UsageInfo> params = new ArrayList<UsageInfo>();
            if (this.myExpr != null) {
                Util.analyzeExpression(this.myExpr, localVars, classMemberRefs, params);
            }
            String propName = this.myLocalVar != null ? JavaCodeStyleManager.getInstance((Project)this.myProject).variableNameToPropertyName(this.myLocalVar.getName(), VariableKind.LOCAL_VARIABLE) : null;
            boolean bl = isInplaceAvailableOnDataContext = this.myEditor != null && this.myEditor.getSettings().isVariableInplaceRenameEnabled();
            if (this.myExpr != null) {
                isInplaceAvailableOnDataContext &= this.myExpr.isPhysical();
            }
            if (isInplaceAvailableOnDataContext && activeIntroducer == null) {
                IntroduceParameterHandler.this.myInplaceIntroduceParameterPopup = new InplaceIntroduceParameterPopup(this.myProject, this.myEditor, classMemberRefs, this.createTypeSelectorManager(occurences, initializerType), this.myExpr, this.myLocalVar, method, methodToSearchFor, occurences, this.getParamsToRemove(method, occurences), mustBeFinal);
                if (IntroduceParameterHandler.this.myInplaceIntroduceParameterPopup.startInplaceIntroduceTemplate()) {
                    return;
                }
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                String parameterName = "anObject";
                boolean replaceAllOccurences = true;
                boolean isDeleteLocalVariable = true;
                PsiExpression initializer = this.myLocalVar != null && this.myExpr == null ? this.myLocalVar.getInitializer() : this.myExpr;
                new IntroduceParameterProcessor(this.myProject, method, methodToSearchFor, initializer, this.myExpr, this.myLocalVar, isDeleteLocalVariable, parameterName, replaceAllOccurences, 0, mustBeFinal, false, null, this.getParamsToRemove(method, occurences)).run();
            } else {
                if (this.myEditor != null) {
                    RefactoringUtil.highlightAllOccurrences(this.myProject, (PsiElement[])occurences, this.myEditor);
                }
                IntroduceParameterDialog dialog = new IntroduceParameterDialog(this.myProject, classMemberRefs, occurences, this.myLocalVar, this.myExpr, IntroduceParameterHandler.createNameSuggestionGenerator(this.myExpr, propName, this.myProject, enteredName), this.createTypeSelectorManager(occurences, initializerType), methodToSearchFor, method, this.getParamsToRemove(method, occurences), mustBeFinal);
                dialog.setReplaceAllOccurrences(replaceAllOccurrences);
                dialog.setGenerateDelegate(delegate);
                dialog.show();
                if (this.myEditor != null) {
                    this.myEditor.getSelectionModel().removeSelection();
                }
            }
        }

        private TypeSelectorManagerImpl createTypeSelectorManager(PsiExpression[] occurences, PsiType initializerType) {
            return this.myExpr != null ? new TypeSelectorManagerImpl(this.myProject, initializerType, this.myExpr, occurences) : new TypeSelectorManagerImpl(this.myProject, initializerType, occurences);
        }

        private TIntArrayList getParamsToRemove(PsiMethod method, PsiExpression[] occurences) {
            PsiExpression expressionToRemoveParamFrom = this.myExpr;
            if (this.myExpr == null) {
                expressionToRemoveParamFrom = this.myLocalVar.getInitializer();
            }
            return expressionToRemoveParamFrom == null ? new TIntArrayList() : Util.findParametersToRemove(method, expressionToRemoveParamFrom, occurences);
        }
    }
}

