/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.ui.EditorTextField;
import org.jetbrains.annotations.Nullable;

public class MethodSignatureComponent
extends EditorTextField {
    public MethodSignatureComponent(String signature, Project project, FileType filetype) {
        this(EditorFactory.getInstance().createDocument((CharSequence)signature), project, filetype);
    }

    public MethodSignatureComponent(Document document, Project project, FileType filetype) {
        super(document, project, filetype, true, false);
        this.setFont(EditorColorsManager.getInstance().getGlobalScheme().getFont(EditorFontType.PLAIN));
        this.setBackground(EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.CARET_ROW_COLOR));
    }

    public void setSignature(String signature) {
        this.setText(signature);
        EditorEx editor = (EditorEx)this.getEditor();
        if (editor != null) {
            editor.getScrollingModel().scrollVertically(0);
            editor.getScrollingModel().scrollHorizontally(0);
        }
    }

    @Override
    protected EditorEx createEditor() {
        EditorEx editor = super.createEditor();
        String fileName = this.getFileName();
        if (fileName != null) {
            editor.setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter(this.getProject(), fileName));
        }
        editor.getSettings().setWhitespacesShown(false);
        editor.setHorizontalScrollbarVisible(true);
        editor.setVerticalScrollbarVisible(true);
        return editor;
    }

    @Nullable
    protected String getFileName() {
        return null;
    }
}

