/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.handlers;

import com.intellij.dupLocator.iterators.ArrayBackedNodeIterator;
import com.intellij.dupLocator.iterators.CountingNodeIterator;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiVariable;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.iterators.SsrFilteringNodeIterator;

public class DeclarationStatementHandler
extends MatchingHandler {
    private MatchingHandler myCommentHandler;

    @Override
    public boolean match(PsiElement patternNode, PsiElement matchedNode, MatchContext context) {
        boolean result;
        if (patternNode instanceof PsiComment) {
            return this.myCommentHandler.match(patternNode, matchedNode, context);
        }
        if (!super.match(patternNode, matchedNode, context)) {
            return false;
        }
        PsiDeclarationStatement dcl = (PsiDeclarationStatement)patternNode;
        if (matchedNode instanceof PsiDeclarationStatement) {
            result = GlobalMatchingVisitor.continueMatchingSequentially(new SsrFilteringNodeIterator(patternNode.getFirstChild()), new SsrFilteringNodeIterator(matchedNode.getFirstChild()), context);
        } else {
            PsiElement[] declared = dcl.getDeclaredElements();
            if (declared.length > 0 && (declared[0] instanceof PsiVariable && matchedNode instanceof PsiVariable || declared[0] instanceof PsiClass && matchedNode instanceof PsiClass) && !(matchedNode.getParent() instanceof PsiDeclarationStatement)) {
                PsiElement[] children;
                PsiElement lastChild;
                result = GlobalMatchingVisitor.continueMatchingSequentially(new ArrayBackedNodeIterator(declared), new CountingNodeIterator(declared.length, new SsrFilteringNodeIterator(matchedNode)), context);
                if (result && declared[0] instanceof PsiVariable && matchedNode instanceof PsiField && (lastChild = (children = dcl.getChildren())[children.length - 1]) instanceof PsiComment) {
                    PsiElement[] fieldChildren = matchedNode.getChildren();
                    result = context.getPattern().getHandler(lastChild).match(lastChild, fieldChildren[fieldChildren.length - 1], context);
                }
            } else {
                result = false;
            }
        }
        return result;
    }

    @Override
    public boolean shouldAdvanceTheMatchFor(PsiElement patternElement, PsiElement matchedElement) {
        if (patternElement instanceof PsiComment && (matchedElement instanceof PsiField || matchedElement instanceof PsiClass)) {
            return false;
        }
        return super.shouldAdvanceTheMatchFor(patternElement, matchedElement);
    }

    public void setCommentHandler(MatchingHandler commentHandler) {
        this.myCommentHandler = commentHandler;
    }
}

