/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.plugin.StructuralSearchPlugin;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBList;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ExistingTemplatesComponent {
    private final Tree patternTree;
    private final DefaultTreeModel patternTreeModel;
    private final DefaultMutableTreeNode userTemplatesNode;
    private final JComponent panel;
    private final DefaultListModel historyModel;
    private final JList historyList;
    private final JComponent historyPanel;
    private DialogWrapper owner;
    private final Project project;

    private ExistingTemplatesComponent(Project project) {
        this.project = project;
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(null);
        this.patternTreeModel = new DefaultTreeModel(root);
        DefaultMutableTreeNode parent = null;
        String lastCategory = null;
        LinkedList<DefaultMutableTreeNode> nodesToExpand = new LinkedList<DefaultMutableTreeNode>();
        List<Configuration> predefined = StructuralSearchUtil.getPredefinedTemplates();
        for (Configuration info : predefined) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(info);
            if (lastCategory == null || !lastCategory.equals(info.getCategory())) {
                if (info.getCategory().length() > 0) {
                    parent = new DefaultMutableTreeNode(info.getCategory());
                    root.add(parent);
                    nodesToExpand.add(parent);
                    lastCategory = info.getCategory();
                } else {
                    root.add(defaultMutableTreeNode);
                    continue;
                }
            }
            parent.add(defaultMutableTreeNode);
        }
        this.userTemplatesNode = parent = new DefaultMutableTreeNode(SSRBundle.message("user.defined.category", new Object[0]));
        root.add(parent);
        nodesToExpand.add(parent);
        final ConfigurationManager configurationManager = StructuralSearchPlugin.getInstance(this.project).getConfigurationManager();
        if (configurationManager.getConfigurations() != null) {
            for (Configuration configuration : configurationManager.getConfigurations()) {
                parent.add(new DefaultMutableTreeNode(configuration));
            }
        }
        this.patternTree = ExistingTemplatesComponent.createTree(this.patternTreeModel);
        for (Configuration configuration : nodesToExpand) {
            this.patternTree.expandPath(new TreePath(new Object[]{root, configuration}));
        }
        this.panel = ToolbarDecorator.createDecorator((JTree)this.patternTree).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ExistingTemplatesComponent.this.addSelectedTreeNodeAndClose();
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                DefaultMutableTreeNode node;
                Object selection = ExistingTemplatesComponent.this.patternTree.getLastSelectedPathComponent();
                if (selection instanceof DefaultMutableTreeNode && (node = (DefaultMutableTreeNode)selection).getUserObject() instanceof Configuration) {
                    Configuration configuration = (Configuration)node.getUserObject();
                    ExistingTemplatesComponent.this.patternTreeModel.removeNodeFromParent(node);
                    configurationManager.removeConfiguration(configuration);
                }
            }
        }).createPanel();
        new JPanel(new BorderLayout());
        this.configureSelectTemplateAction((JComponent)this.patternTree);
        this.historyModel = new DefaultListModel();
        this.historyPanel = new JPanel(new BorderLayout());
        this.historyPanel.add("North", new JLabel(SSRBundle.message("used.templates", new Object[0])));
        this.historyList = new JBList((ListModel)this.historyModel);
        JBList view = this.historyList;
        this.historyPanel.add("Center", ScrollPaneFactory.createScrollPane((Component)view));
        this.historyList.setCellRenderer(new ListCellRenderer());
        this.historyList.setSelectionMode(0);
        new ListSpeedSearch(this.historyList);
        if (configurationManager.getHistoryConfigurations() != null) {
            for (Configuration configuration : configurationManager.getHistoryConfigurations()) {
                this.historyModel.addElement(configuration);
            }
            this.historyList.setSelectedIndex(0);
        }
        this.configureSelectTemplateAction(this.historyList);
    }

    private void configureSelectTemplateAction(JComponent component) {
        component.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ExistingTemplatesComponent.this.owner.close(0);
                }
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                ExistingTemplatesComponent.this.owner.close(0);
                return true;
            }
        }.installOn((Component)component);
    }

    private void addSelectedTreeNodeAndClose() {
        this.addConfigurationToUserTemplates(Configuration.getConfigurationCreator().createConfiguration());
        this.owner.close(0);
    }

    private static Tree createTree(TreeModel treeModel) {
        Tree tree = new Tree(treeModel);
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.setDragEnabled(false);
        tree.setEditable(false);
        tree.getSelectionModel().setSelectionMode(4);
        tree.setCellRenderer((javax.swing.tree.TreeCellRenderer)new TreeCellRenderer());
        new TreeSpeedSearch(tree, new Convertor<TreePath, String>(){

            public String convert(TreePath object) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)object.getLastPathComponent();
                Object displayValue = node.getUserObject();
                displayValue = displayValue instanceof Configuration ? ((Configuration)displayValue).getName() : "";
                return displayValue.toString();
            }
        });
        return tree;
    }

    public JTree getPatternTree() {
        return this.patternTree;
    }

    public JComponent getTemplatesPanel() {
        return this.panel;
    }

    public static ExistingTemplatesComponent getInstance(Project project) {
        StructuralSearchPlugin plugin = StructuralSearchPlugin.getInstance(project);
        if (plugin.getExistingTemplatesComponent() == null) {
            plugin.setExistingTemplatesComponent(new ExistingTemplatesComponent(project));
        }
        return plugin.getExistingTemplatesComponent();
    }

    void addConfigurationToHistory(Configuration configuration) {
        this.historyModel.insertElementAt(configuration, 0);
        ConfigurationManager configurationManager = StructuralSearchPlugin.getInstance(this.project).getConfigurationManager();
        configurationManager.addHistoryConfigurationToFront(configuration);
        this.historyList.setSelectedIndex(0);
        if (this.historyModel.getSize() > 25) {
            configurationManager.removeHistoryConfiguration((Configuration)this.historyModel.getElementAt(25));
            this.historyModel.removeElementAt(25);
        }
    }

    private void insertNode(Configuration configuration, DefaultMutableTreeNode parent, int index) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(configuration);
        this.patternTreeModel.insertNodeInto(node, parent, index);
        TreeUtil.selectPath((JTree)this.patternTree, (TreePath)new TreePath(new Object[]{this.patternTreeModel.getRoot(), parent, node}));
    }

    void addConfigurationToUserTemplates(Configuration configuration) {
        this.insertNode(configuration, this.userTemplatesNode, this.userTemplatesNode.getChildCount());
        ConfigurationManager configurationManager = StructuralSearchPlugin.getInstance(this.project).getConfigurationManager();
        configurationManager.addConfiguration(configuration);
    }

    boolean isConfigurationFromHistory(Configuration config) {
        return this.historyModel.indexOf(config) != -1;
    }

    public JList getHistoryList() {
        return this.historyList;
    }

    public JComponent getHistoryPanel() {
        return this.historyPanel;
    }

    public void setOwner(DialogWrapper owner) {
        this.owner = owner;
    }

    static class TreeCellRenderer
    extends DefaultTreeCellRenderer {
        TreeCellRenderer() {
            this.setOpenIcon(null);
            this.setLeafIcon(null);
            this.setClosedIcon(null);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)value;
            Object displayValue = treeNode.getUserObject();
            if (displayValue instanceof Configuration) {
                displayValue = ((Configuration)displayValue).getName();
            }
            Component comp = super.getTreeCellRendererComponent(tree, displayValue, sel, expanded, leaf, row, hasFocus);
            return comp;
        }
    }

    static class ListCellRenderer
    extends DefaultListCellRenderer {
        ListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof Configuration) {
                value = ((Configuration)value).getName();
            }
            Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            return comp;
        }
    }
}

