/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.template.impl.Variable;
import com.intellij.find.FindBundle;
import com.intellij.find.FindSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.scopeChooser.ScopeChooserCombo;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.impl.FileTypeRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchProfileBase;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.UnsupportedPatternException;
import com.intellij.structuralsearch.impl.matcher.MatcherImpl;
import com.intellij.structuralsearch.plugin.StructuralSearchPlugin;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationCreator;
import com.intellij.structuralsearch.plugin.ui.ConfigurationManager;
import com.intellij.structuralsearch.plugin.ui.EditVarConstraintsDialog;
import com.intellij.structuralsearch.plugin.ui.ExistingTemplatesComponent;
import com.intellij.structuralsearch.plugin.ui.SearchCommand;
import com.intellij.structuralsearch.plugin.ui.SearchConfiguration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.SearchModel;
import com.intellij.structuralsearch.plugin.ui.SelectTemplateDialog;
import com.intellij.structuralsearch.plugin.ui.SubstitutionShortInfoHandler;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.TitledSeparator;
import com.intellij.util.Alarm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SearchDialog
extends DialogWrapper
implements ConfigurationCreator {
    protected SearchContext searchContext;
    protected Editor searchCriteriaEdit;
    private ScopeChooserCombo myScopeChooserCombo;
    private JCheckBox recursiveMatching;
    private JCheckBox caseSensitiveMatch;
    private JComboBox fileTypes;
    private JComboBox contexts;
    private JComboBox dialects;
    private JLabel status;
    private JLabel statusText;
    protected SearchModel model;
    private JCheckBox openInNewTab;
    private final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD);
    public static final String USER_DEFINED = SSRBundle.message("new.template.defaultname", new Object[0]);
    protected final ExistingTemplatesComponent existingTemplatesComponent;
    private boolean useLastConfiguration;
    @NonNls
    private FileType ourFtSearchVariant = StructuralSearchUtil.getDefaultFileType();
    private static Language ourDialect = null;
    private static String ourContext = null;
    private final boolean myShowScopePanel;
    private final boolean myRunFindActionOnClose;
    private boolean myDoingOkAction;
    private String mySavedEditorText;
    private JPanel myContentPanel;
    private JComponent myEditorPanel;

    public SearchDialog(SearchContext searchContext) {
        this(searchContext, true, true);
    }

    public SearchDialog(SearchContext searchContext, boolean showScope, boolean runFindActionOnClose) {
        super(searchContext.getProject(), true);
        if (showScope) {
            this.setModal(false);
        }
        this.myShowScopePanel = showScope;
        this.myRunFindActionOnClose = runFindActionOnClose;
        this.searchContext = (SearchContext)searchContext.clone();
        this.setTitle(this.getDefaultTitle());
        if (runFindActionOnClose) {
            this.setOKButtonText(FindBundle.message("find.dialog.find.button", new Object[0]));
        }
        this.existingTemplatesComponent = ExistingTemplatesComponent.getInstance(this.searchContext.getProject());
        this.model = new SearchModel(this.createConfiguration());
        this.init();
    }

    public void setUseLastConfiguration(boolean useLastConfiguration) {
        this.useLastConfiguration = useLastConfiguration;
    }

    public void setSearchPattern(Configuration config) {
        this.model.setShadowConfig(config);
        this.setValuesFromConfig(config);
        this.initiateValidation();
    }

    protected Editor createEditor(SearchContext searchContext, String text) {
        Editor editor = null;
        if (this.fileTypes != null) {
            FileType fileType = (FileType)this.fileTypes.getSelectedItem();
            Language dialect = (Language)this.dialects.getSelectedItem();
            StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(fileType);
            if (profile != null) {
                editor = profile.createEditor(searchContext, fileType, dialect, text, this.useLastConfiguration);
            }
        }
        if (editor == null) {
            EditorFactory factory = EditorFactory.getInstance();
            Document document = factory.createDocument((CharSequence)"");
            editor = factory.createEditor(document, searchContext.getProject());
            editor.getSettings().setFoldingOutlineShown(false);
        }
        editor.getDocument().addDocumentListener(new DocumentListener(){

            public void beforeDocumentChange(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                SearchDialog.this.initiateValidation();
            }
        });
        return editor;
    }

    private void initiateValidation() {
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                try {
                    new WriteAction(){

                        protected void run(Result result) {
                            if (!SearchDialog.this.isValid()) {
                                SearchDialog.this.getOKAction().setEnabled(false);
                            } else {
                                SearchDialog.this.getOKAction().setEnabled(true);
                                SearchDialog.this.reportMessage(null, null, new Object[0]);
                            }
                        }
                    }.execute();
                }
                catch (RuntimeException e) {
                    Logger.getInstance(SearchDialog.class).error((Throwable)e);
                }
            }
        }, 500);
    }

    protected void buildOptions(JPanel searchOptions) {
        this.recursiveMatching = new JCheckBox(SSRBundle.message("recursive.matching.checkbox", new Object[0]), true);
        if (this.isRecursiveSearchEnabled()) {
            searchOptions.add(UIUtil.createOptionLine(this.recursiveMatching));
        }
        this.caseSensitiveMatch = new JCheckBox(FindBundle.message("find.options.case.sensitive", new Object[0]), true);
        searchOptions.add(UIUtil.createOptionLine(this.caseSensitiveMatch));
        ArrayList<FileType> types = new ArrayList<FileType>();
        for (FileType fileType : StructuralSearchUtil.getSuitableFileTypes()) {
            if (StructuralSearchUtil.getProfileByFileType(fileType) == null) continue;
            types.add(fileType);
        }
        Collections.sort(types, new Comparator<FileType>(){

            @Override
            public int compare(FileType o1, FileType o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        DefaultComboBoxModel<FileType> comboBoxModel = new DefaultComboBoxModel<FileType>(types.toArray(new FileType[types.size()]));
        comboBoxModel.setSelectedItem(this.ourFtSearchVariant);
        this.fileTypes = new ComboBox(comboBoxModel);
        this.fileTypes.setRenderer(new FileTypeRenderer());
        new ComboboxSpeedSearch(this.fileTypes){

            @Override
            protected String getElementText(Object element) {
                return ((FileType)element).getName();
            }
        };
        this.fileTypes.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SearchDialog.this.updateDialectsAndContexts();
                SearchDialog.this.updateEditor();
            }
        });
        this.contexts = new JComboBox(new DefaultComboBoxModel());
        this.contexts.setPreferredSize(new Dimension(60, -1));
        this.dialects = new JComboBox(new DefaultComboBoxModel());
        this.dialects.setRenderer(new ListCellRendererWrapper(){

            public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value == null) {
                    this.setText("None");
                } else if (value instanceof Language) {
                    this.setText(((Language)value).getDisplayName());
                }
            }
        });
        this.dialects.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SearchDialog.this.updateEditor();
            }
        });
        new ComboboxSpeedSearch(this.dialects);
        this.dialects.setPreferredSize(new Dimension(120, -1));
        JLabel jLabel = new JLabel(SSRBundle.message("search.dialog.file.type.label", new Object[0]));
        JLabel jLabel2 = new JLabel(SSRBundle.message("search.dialog.context.label", new Object[0]));
        JLabel jLabel3 = new JLabel(SSRBundle.message("search.dialog.file.dialect.label", new Object[0]));
        searchOptions.add(UIUtil.createOptionLine(new JComponent[]{jLabel, this.fileTypes, (JComponent)Box.createHorizontalStrut(8), jLabel2, this.contexts, (JComponent)Box.createHorizontalStrut(8), jLabel3, this.dialects}));
        jLabel.setLabelFor(this.fileTypes);
        jLabel2.setLabelFor(this.contexts);
        jLabel3.setLabelFor(this.dialects);
        this.detectFileTypeAndDialect();
        this.fileTypes.setSelectedItem(this.ourFtSearchVariant);
        this.fileTypes.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    SearchDialog.this.initiateValidation();
                }
            }
        });
        this.dialects.setSelectedItem(ourDialect);
        this.contexts.setSelectedItem(ourContext);
        this.updateDialectsAndContexts();
    }

    private void updateEditor() {
        if (this.myContentPanel != null) {
            if (this.myEditorPanel != null) {
                this.myContentPanel.remove(this.myEditorPanel);
            }
            this.disposeEditorContent();
            this.myEditorPanel = this.createEditorContent();
            this.myContentPanel.add((Component)this.myEditorPanel, "Center");
            this.myContentPanel.revalidate();
        }
    }

    private void updateDialectsAndContexts() {
        String[] contextNames;
        StructuralSearchProfile profile;
        FileType fileType = (FileType)this.fileTypes.getSelectedItem();
        if (fileType instanceof LanguageFileType) {
            Language language = ((LanguageFileType)fileType).getLanguage();
            Language[] languageDialects = LanguageUtil.getLanguageDialects((Language)language);
            Arrays.sort(languageDialects, new Comparator<Language>(){

                @Override
                public int compare(Language o1, Language o2) {
                    return o1.getDisplayName().compareTo(o2.getDisplayName());
                }
            });
            Language[] variants = new Language[languageDialects.length + 1];
            variants[0] = null;
            System.arraycopy(languageDialects, 0, variants, 1, languageDialects.length);
            this.dialects.setModel(new DefaultComboBoxModel<Language>(variants));
            this.dialects.setEnabled(variants.length > 1);
        }
        if ((profile = StructuralSearchUtil.getProfileByFileType(fileType)) instanceof StructuralSearchProfileBase && (contextNames = ((StructuralSearchProfileBase)profile).getContextNames()).length > 0) {
            this.contexts.setModel(new DefaultComboBoxModel<String>(contextNames));
            this.contexts.setSelectedItem(contextNames[0]);
            this.contexts.setEnabled(true);
            return;
        }
        this.contexts.setSelectedItem(null);
        this.contexts.setEnabled(false);
    }

    private void detectFileTypeAndDialect() {
        PsiFile file = this.searchContext.getFile();
        if (file != null) {
            FileType fileType;
            PsiFile context = null;
            if (this.searchContext.getEditor() != null && (context = file.findElementAt(this.searchContext.getEditor().getCaretModel().getOffset())) != null) {
                context = context.getParent();
            }
            if (context == null) {
                context = file;
            }
            FileType detectedFileType = null;
            StructuralSearchProfile profile = StructuralSearchUtil.getProfileByPsiElement((PsiElement)context);
            if (profile != null && (fileType = profile.detectFileType((PsiElement)context)) != null) {
                detectedFileType = fileType;
            }
            if (detectedFileType == null) {
                for (FileType fileType2 : StructuralSearchUtil.getSuitableFileTypes()) {
                    if (!(fileType2 instanceof LanguageFileType) || !((LanguageFileType)fileType2).getLanguage().equals(context.getLanguage())) continue;
                    detectedFileType = fileType2;
                    break;
                }
            }
            this.ourFtSearchVariant = detectedFileType != null ? detectedFileType : StructuralSearchUtil.getDefaultFileType();
        }
    }

    protected boolean isRecursiveSearchEnabled() {
        return true;
    }

    public void setValuesFromConfig(Configuration configuration) {
        this.setDialogTitle(configuration);
        MatchOptions matchOptions = configuration.getMatchOptions();
        UIUtil.setContent(this.searchCriteriaEdit, matchOptions.getSearchPattern(), 0, this.searchCriteriaEdit.getDocument().getTextLength(), this.searchContext.getProject());
        this.model.getConfig().getMatchOptions().setSearchPattern(matchOptions.getSearchPattern());
        this.recursiveMatching.setSelected(this.isRecursiveSearchEnabled() && matchOptions.isRecursiveSearch());
        this.caseSensitiveMatch.setSelected(matchOptions.isCaseSensitiveMatch());
        this.model.getConfig().getMatchOptions().clearVariableConstraints();
        if (matchOptions.hasVariableConstraints()) {
            Iterator<String> i = matchOptions.getVariableConstraintNames();
            while (i.hasNext()) {
                MatchVariableConstraint constraint = (MatchVariableConstraint)matchOptions.getVariableConstraint(i.next()).clone();
                this.model.getConfig().getMatchOptions().addVariableConstraint(constraint);
            }
        }
        MatchOptions options = configuration.getMatchOptions();
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(options.getFileType());
        assert (profile != null);
        this.fileTypes.setSelectedItem(options.getFileType());
        this.dialects.setSelectedItem(options.getDialect());
        if (options.getPatternContext() != null) {
            this.contexts.setSelectedItem(options.getPatternContext());
        }
    }

    private void setDialogTitle(Configuration configuration) {
        this.setTitle(this.getDefaultTitle() + " - " + configuration.getName());
    }

    @Override
    public Configuration createConfiguration() {
        SearchConfiguration configuration = new SearchConfiguration();
        configuration.setName(USER_DEFINED);
        return configuration;
    }

    protected void addOrReplaceSelection(String selection) {
        this.addOrReplaceSelectionForEditor(selection, this.searchCriteriaEdit);
    }

    protected final void addOrReplaceSelectionForEditor(String selection, Editor editor) {
        final Project project = this.searchContext.getProject();
        UIUtil.setContent(editor, selection, 0, -1, project);
        final Document document = editor.getDocument();
        editor.getSelectionModel().setSelection(0, document.getTextLength());
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        documentManager.commitDocument(document);
        final PsiFile file = documentManager.getPsiFile(document);
        if (file == null) {
            return;
        }
        new WriteCommandAction(project, new PsiFile[]{file}){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/structuralsearch/plugin/ui/SearchDialog$10", "run"));
                }
                CodeStyleManager.getInstance((Project)project).adjustLineIndent(file, new TextRange(0, document.getTextLength()));
            }
        }.execute();
    }

    protected void startSearching() {
        new SearchCommand(this.model.getConfig(), this.searchContext).startSearching();
    }

    protected String getDefaultTitle() {
        return SSRBundle.message("structural.search.title", new Object[0]);
    }

    protected JComponent createEditorContent() {
        JPanel result = new JPanel(new BorderLayout());
        result.add("North", new JLabel(SSRBundle.message("search.template", new Object[0])));
        this.searchCriteriaEdit = this.createEditor(this.searchContext, this.mySavedEditorText != null ? this.mySavedEditorText : "");
        result.add("Center", this.searchCriteriaEdit.getComponent());
        result.setMinimumSize(new Dimension(150, 100));
        return result;
    }

    protected int getRowsCount() {
        return 4;
    }

    protected JComponent createCenterPanel() {
        this.myContentPanel = new JPanel(new BorderLayout());
        this.myEditorPanel = this.createEditorContent();
        this.myContentPanel.add("Center", this.myEditorPanel);
        this.myContentPanel.add("South", Box.createVerticalStrut(8));
        JPanel centerPanel = new JPanel(new BorderLayout());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add("Center", this.myContentPanel);
        panel.add("South", this.createTemplateManagementButtons());
        centerPanel.add("Center", panel);
        JPanel optionsContent = new JPanel(new BorderLayout());
        centerPanel.add("South", optionsContent);
        JPanel searchOptions = new JPanel();
        searchOptions.setLayout(new GridLayout(this.getRowsCount(), 1, 0, 0));
        searchOptions.setBorder((Border)IdeBorderFactory.createTitledBorder((String)SSRBundle.message("ssdialog.options.group.border", new Object[0]), (boolean)true));
        this.myScopeChooserCombo = new ScopeChooserCombo(this.searchContext.getProject(), true, false, FindSettings.getInstance().getDefaultScopeName());
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myScopeChooserCombo);
        JPanel allOptions = new JPanel(new BorderLayout());
        if (this.myShowScopePanel) {
            JPanel scopePanel = new JPanel(new GridBagLayout());
            TitledSeparator separator = new TitledSeparator(SSRBundle.message("search.dialog.scope.label", new Object[0]), (JComponent)this.myScopeChooserCombo.getComboBox());
            scopePanel.add((Component)separator, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
            scopePanel.add((Component)((Object)this.myScopeChooserCombo), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
            allOptions.add((Component)scopePanel, "South");
            this.myScopeChooserCombo.getComboBox().addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SearchDialog.this.initiateValidation();
                }
            });
        }
        this.buildOptions(searchOptions);
        allOptions.add((Component)searchOptions, "Center");
        optionsContent.add((Component)allOptions, "Center");
        if (this.myRunFindActionOnClose) {
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
            this.openInNewTab = new JCheckBox(FindBundle.message("find.open.in.new.tab.checkbox", new Object[0]));
            this.openInNewTab.setSelected(FindSettings.getInstance().isShowResultsInSeparateView());
            ToolWindow findWindow = ToolWindowManager.getInstance((Project)this.searchContext.getProject()).getToolWindow(ToolWindowId.FIND);
            this.openInNewTab.setEnabled(findWindow != null && findWindow.isAvailable());
            panel2.add((Component)this.openInNewTab, "East");
            optionsContent.add("South", panel2);
        }
        this.updateEditor();
        return centerPanel;
    }

    protected JComponent createSouthPanel() {
        JPanel statusPanel = new JPanel(new BorderLayout(5, 0));
        statusPanel.add((Component)super.createSouthPanel(), "North");
        this.statusText = new JLabel(SSRBundle.message("status.message", new Object[0]));
        statusPanel.add((Component)this.statusText, "West");
        this.status = new JLabel();
        statusPanel.add((Component)this.status, "Center");
        return statusPanel;
    }

    private JPanel createTemplateManagementButtons() {
        JPanel panel = new JPanel(null);
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createHorizontalGlue());
        panel.add(this.createJButtonForAction(new AbstractAction(){
            {
                this.putValue("Name", SSRBundle.message("save.template.text.button", new Object[0]));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = SearchDialog.this.showSaveTemplateAsDialog();
                if (name != null) {
                    Project project = SearchDialog.this.searchContext.getProject();
                    ConfigurationManager configurationManager = StructuralSearchPlugin.getInstance(project).getConfigurationManager();
                    Collection<Configuration> configurations = configurationManager.getConfigurations();
                    if (configurations != null && (name = ConfigurationManager.findAppropriateName(configurations, name, project)) == null) {
                        return;
                    }
                    SearchDialog.this.model.getConfig().setName(name);
                    SearchDialog.this.setValuesToConfig(SearchDialog.this.model.getConfig());
                    SearchDialog.this.setDialogTitle(SearchDialog.this.model.getConfig());
                    if (SearchDialog.this.model.getShadowConfig() == null || SearchDialog.this.model.getShadowConfig().isPredefined()) {
                        SearchDialog.this.existingTemplatesComponent.addConfigurationToUserTemplates(SearchDialog.this.model.getConfig());
                    } else {
                        SearchDialog.this.setValuesToConfig(SearchDialog.this.model.getShadowConfig());
                        SearchDialog.this.model.getShadowConfig().setName(name);
                    }
                }
            }
        }));
        panel.add(Box.createHorizontalStrut(8));
        panel.add(this.createJButtonForAction(new AbstractAction(){
            {
                this.putValue("Name", SSRBundle.message("edit.variables.button", new Object[0]));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                EditVarConstraintsDialog.setProject(SearchDialog.this.searchContext.getProject());
                new EditVarConstraintsDialog(SearchDialog.this.searchContext.getProject(), SearchDialog.this.model, SearchDialog.this.getVariablesFromListeners(), SearchDialog.this.isReplaceDialog(), (FileType)SearchDialog.this.fileTypes.getSelectedItem()).show();
                SearchDialog.this.initiateValidation();
                EditVarConstraintsDialog.setProject(null);
            }
        }));
        panel.add(Box.createHorizontalStrut(8));
        panel.add(this.createJButtonForAction(new AbstractAction(){
            {
                this.putValue("Name", SSRBundle.message("history.button", new Object[0]));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectTemplateDialog dialog = new SelectTemplateDialog(SearchDialog.this.searchContext.getProject(), true, SearchDialog.this.isReplaceDialog());
                dialog.show();
                if (!dialog.isOK()) {
                    return;
                }
                Configuration[] configurations = dialog.getSelectedConfigurations();
                if (configurations.length == 1) {
                    SearchDialog.this.setSearchPattern(configurations[0]);
                }
            }
        }));
        panel.add(Box.createHorizontalStrut(8));
        panel.add(this.createJButtonForAction(new AbstractAction(){
            {
                this.putValue("Name", SSRBundle.message("copy.existing.template.button", new Object[0]));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectTemplateDialog dialog = new SelectTemplateDialog(SearchDialog.this.searchContext.getProject(), false, SearchDialog.this.isReplaceDialog());
                dialog.show();
                if (!dialog.isOK()) {
                    return;
                }
                Configuration[] configurations = dialog.getSelectedConfigurations();
                if (configurations.length == 1) {
                    SearchDialog.this.setSearchPattern(configurations[0]);
                }
            }
        }));
        return panel;
    }

    protected List<Variable> getVariablesFromListeners() {
        return SearchDialog.getVarsFrom(this.searchCriteriaEdit);
    }

    protected static ArrayList<Variable> getVarsFrom(Editor searchCriteriaEdit) {
        SubstitutionShortInfoHandler handler = (SubstitutionShortInfoHandler)searchCriteriaEdit.getUserData(UIUtil.LISTENER_KEY);
        return new ArrayList<Variable>(handler.getVariables());
    }

    public final Project getProject() {
        return this.searchContext.getProject();
    }

    public String showSaveTemplateAsDialog() {
        return ConfigurationManager.showSaveTemplateAsDialog(this.model.getShadowConfig() != null ? this.model.getShadowConfig().getName() : SSRBundle.message("user.defined.category", new Object[0]), this.searchContext.getProject());
    }

    protected boolean isReplaceDialog() {
        return false;
    }

    public void show() {
        StructuralSearchPlugin.getInstance(this.getProject()).setDialogVisible(true);
        Configuration.setActiveCreator(this);
        this.searchCriteriaEdit.putUserData(SubstitutionShortInfoHandler.CURRENT_CONFIGURATION_KEY, (Object)this.model.getConfig());
        if (!this.useLastConfiguration) {
            int selection;
            SelectionModel selectionModel;
            Editor editor = FileEditorManager.getInstance((Project)this.searchContext.getProject()).getSelectedTextEditor();
            boolean setSomeText = false;
            if (editor != null && (selectionModel = editor.getSelectionModel()).hasSelection()) {
                this.addOrReplaceSelection(selectionModel.getSelectedText());
                this.existingTemplatesComponent.getPatternTree().setSelectionPath(null);
                this.existingTemplatesComponent.getHistoryList().setSelectedIndex(-1);
                setSomeText = true;
            }
            if (!setSomeText && (selection = this.existingTemplatesComponent.getHistoryList().getSelectedIndex()) != -1) {
                this.setValuesFromConfig((Configuration)this.existingTemplatesComponent.getHistoryList().getSelectedValue());
            }
        }
        this.initiateValidation();
        super.show();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.searchCriteriaEdit.getContentComponent();
    }

    protected void doOKAction() {
        SearchScope selectedScope = this.getSelectedScope();
        if (selectedScope == null) {
            return;
        }
        this.myDoingOkAction = true;
        boolean result = this.isValid();
        this.myDoingOkAction = false;
        if (!result) {
            return;
        }
        this.myAlarm.cancelAllRequests();
        super.doOKAction();
        if (!this.myRunFindActionOnClose) {
            return;
        }
        FindSettings findSettings = FindSettings.getInstance();
        findSettings.setDefaultScopeName(selectedScope.getDisplayName());
        findSettings.setShowResultsInSeparateView(this.openInNewTab.isSelected());
        try {
            if (this.model.getShadowConfig() != null && this.model.getShadowConfig().isPredefined()) {
                this.model.getConfig().setName(this.model.getShadowConfig().getName());
            }
            this.existingTemplatesComponent.addConfigurationToHistory(this.model.getConfig());
            this.startSearching();
        }
        catch (MalformedPatternException ex) {
            this.reportMessage("this.pattern.is.malformed.message", this.searchCriteriaEdit, ex.getMessage());
        }
    }

    public Configuration getConfiguration() {
        return this.model.getConfig();
    }

    private SearchScope getSelectedScope() {
        return this.myScopeChooserCombo.getSelectedScope();
    }

    protected boolean isValid() {
        this.setValuesToConfig(this.model.getConfig());
        boolean result = true;
        try {
            MatcherImpl.validate(this.searchContext.getProject(), this.model.getConfig().getMatchOptions());
        }
        catch (MalformedPatternException ex) {
            if (this.myRunFindActionOnClose) {
                this.reportMessage("this.pattern.is.malformed.message", this.searchCriteriaEdit, ex.getMessage() != null ? ex.getMessage() : "");
                result = false;
            }
        }
        catch (UnsupportedPatternException ex) {
            this.reportMessage("this.pattern.is.unsupported.message", this.searchCriteriaEdit, ex.getMessage());
            result = false;
        }
        return result;
    }

    protected void reportMessage(@NonNls String messageId, Editor editor, Object ... params) {
        String message = messageId != null ? SSRBundle.message(messageId, params) : "";
        this.status.setText(message);
        this.status.setToolTipText(message);
        this.status.revalidate();
        this.statusText.setLabelFor(editor != null ? editor.getContentComponent() : null);
    }

    protected void setValuesToConfig(Configuration config) {
        MatchOptions options = config.getMatchOptions();
        boolean searchWithinHierarchy = IdeBundle.message((String)"scope.class.hierarchy", (Object[])new Object[0]).equals(this.myScopeChooserCombo.getSelectedScopeName());
        options.setScope((SearchScope)(searchWithinHierarchy && !this.myDoingOkAction ? GlobalSearchScope.projectScope((Project)this.getProject()) : this.myScopeChooserCombo.getSelectedScope()));
        options.setLooseMatching(true);
        options.setRecursiveSearch(this.isRecursiveSearchEnabled() && this.recursiveMatching.isSelected());
        this.ourFtSearchVariant = (FileType)this.fileTypes.getSelectedItem();
        ourDialect = (Language)this.dialects.getSelectedItem();
        ourContext = (String)this.contexts.getSelectedItem();
        FileType fileType = this.ourFtSearchVariant;
        options.setFileType(fileType);
        options.setDialect(ourDialect);
        options.setPatternContext(ourContext);
        options.setSearchPattern(this.searchCriteriaEdit.getDocument().getText());
        options.setCaseSensitiveMatch(this.caseSensitiveMatch.isSelected());
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.structuralsearch.plugin.ui.SearchDialog";
    }

    public void dispose() {
        Configuration.setActiveCreator(null);
        this.disposeEditorContent();
        this.myAlarm.cancelAllRequests();
        super.dispose();
        StructuralSearchPlugin.getInstance(this.getProject()).setDialogVisible(false);
    }

    protected void disposeEditorContent() {
        this.mySavedEditorText = this.searchCriteriaEdit.getDocument().getText();
        PsiFile file = PsiDocumentManager.getInstance((Project)this.searchContext.getProject()).getPsiFile(this.searchCriteriaEdit.getDocument());
        if (file != null) {
            DaemonCodeAnalyzer.getInstance((Project)this.searchContext.getProject()).setHighlightingEnabled(file, true);
        }
        EditorFactory.getInstance().releaseEditor(this.searchCriteriaEdit);
    }

    protected String getHelpId() {
        return "find.structuredSearch";
    }

    public SearchContext getSearchContext() {
        return this.searchContext;
    }
}

