/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac;

import com.intellij.ide.DataManager;
import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.ide.ReopenProjectAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.wm.impl.SystemDock;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MacDockDelegate
implements SystemDock.Delegate {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.mac.MacDockDelegate");
    private static boolean initialized = false;
    private static final SystemDock.Delegate instance = new MacDockDelegate();
    private static final PopupMenu dockMenu = new PopupMenu("DockMenu");
    private static final Menu recentProjectsMenu = new Menu("Recent projects");

    private MacDockDelegate() {
    }

    private static void initDockMenu() {
        dockMenu.add(recentProjectsMenu);
        try {
            MacDockDelegate.getAppMethod("setDockMenu", PopupMenu.class).invoke(MacDockDelegate.getApp(), dockMenu);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public void updateRecentProjectsMenu() {
        AnAction[] recentProjectActions = RecentProjectsManagerBase.getInstance().getRecentProjectsActions(false);
        recentProjectsMenu.removeAll();
        for (final AnAction action : recentProjectActions) {
            MenuItem menuItem = new MenuItem(((ReopenProjectAction)action).getProjectName());
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    action.actionPerformed(new AnActionEvent(null, DataManager.getInstance().getDataContext(null), "DockMenu", action.getTemplatePresentation(), ActionManager.getInstance(), 0));
                }
            });
            recentProjectsMenu.add(menuItem);
        }
    }

    private static Object getApp() throws NoSuchMethodException, ClassNotFoundException, InvocationTargetException, IllegalAccessException {
        return MacDockDelegate.getAppClass().getMethod("getApplication", new Class[0]).invoke(null, new Object[0]);
    }

    private static Method getAppMethod(String name, Class ... args) throws NoSuchMethodException, ClassNotFoundException {
        return MacDockDelegate.getAppClass().getMethod(name, args);
    }

    private static Class<?> getAppClass() throws ClassNotFoundException {
        return Class.forName("com.apple.eawt.Application");
    }

    public static synchronized SystemDock.Delegate getInstance() {
        if (!initialized) {
            MacDockDelegate.initDockMenu();
            initialized = true;
        }
        return instance;
    }
}

