/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.permanent;

import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.api.permanent.PermanentCommitsInfo;
import com.intellij.vcs.log.graph.utils.IntList;
import com.intellij.vcs.log.graph.utils.TimestampGetter;
import com.intellij.vcs.log.graph.utils.impl.CompressedIntList;
import com.intellij.vcs.log.graph.utils.impl.IntTimestampGetter;
import java.util.AbstractList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PermanentCommitsInfoIml<CommitId>
implements PermanentCommitsInfo<CommitId> {
    @NotNull
    private final TimestampGetter myTimestampGetter;
    @NotNull
    private final List<CommitId> myCommitIdIndexes;

    @NotNull
    public static <CommitId> PermanentCommitsInfoIml<CommitId> newInstance(final @NotNull List<? extends GraphCommit<CommitId>> graphCommits) {
        if (graphCommits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphCommits", "com/intellij/vcs/log/graph/impl/permanent/PermanentCommitsInfoIml", "newInstance"));
        }
        IntTimestampGetter timestampGetter = IntTimestampGetter.newInstance(new TimestampGetter(){

            @Override
            public int size() {
                return graphCommits.size();
            }

            @Override
            public long getTimestamp(int index) {
                return ((GraphCommit)graphCommits.get(index)).getTimestamp();
            }
        });
        boolean isIntegerCase = !graphCommits.isEmpty() && graphCommits.get(0).getId().getClass() == Integer.class;
        List commitIdIndex = isIntegerCase ? PermanentCommitsInfoIml.createCompressedIntList(graphCommits) : ContainerUtil.map(graphCommits, (Function)new Function<GraphCommit<CommitId>, CommitId>(){

            public CommitId fun(GraphCommit<CommitId> graphCommit) {
                return graphCommit.getId();
            }
        });
        PermanentCommitsInfoIml<CommitId> permanentCommitsInfoIml = new PermanentCommitsInfoIml<CommitId>(timestampGetter, commitIdIndex);
        if (permanentCommitsInfoIml == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/permanent/PermanentCommitsInfoIml", "newInstance"));
        }
        return permanentCommitsInfoIml;
    }

    @NotNull
    private static List<Integer> createCompressedIntList(final @NotNull List<? extends GraphCommit<Integer>> graphCommits) {
        if (graphCommits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphCommits", "com/intellij/vcs/log/graph/impl/permanent/PermanentCommitsInfoIml", "createCompressedIntList"));
        }
        final IntList compressedIntList = CompressedIntList.newInstance(new IntList(){

            @Override
            public int size() {
                return graphCommits.size();
            }

            @Override
            public int get(int index) {
                return (Integer)((GraphCommit)graphCommits.get(index)).getId();
            }
        }, 30);
        AbstractList<Integer> abstractList = new AbstractList<Integer>(){

            @Override
            public Integer get(int index) {
                return compressedIntList.get(index);
            }

            @Override
            public int size() {
                return compressedIntList.size();
            }
        };
        if (abstractList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/permanent/PermanentCommitsInfoIml", "createCompressedIntList"));
        }
        return abstractList;
    }

    public PermanentCommitsInfoIml(@NotNull TimestampGetter timestampGetter, @NotNull List<CommitId> commitIdIndex) {
        if (timestampGetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timestampGetter", "com/intellij/vcs/log/graph/impl/permanent/PermanentCommitsInfoIml", "<init>"));
        }
        if (commitIdIndex == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitIdIndex", "com/intellij/vcs/log/graph/impl/permanent/PermanentCommitsInfoIml", "<init>"));
        }
        this.myTimestampGetter = timestampGetter;
        this.myCommitIdIndexes = commitIdIndex;
    }

    @Override
    @NotNull
    public CommitId getCommitId(int permanentNodeIndex) {
        CommitId CommitId = this.myCommitIdIndexes.get(permanentNodeIndex);
        if (CommitId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/permanent/PermanentCommitsInfoIml", "getCommitId"));
        }
        return CommitId;
    }

    @Override
    public long getTimestamp(int permanentNodeIndex) {
        return this.myTimestampGetter.getTimestamp(permanentNodeIndex);
    }

    @NotNull
    public TimestampGetter getTimestampGetter() {
        TimestampGetter timestampGetter = this.myTimestampGetter;
        if (timestampGetter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/permanent/PermanentCommitsInfoIml", "getTimestampGetter"));
        }
        return timestampGetter;
    }

    @Override
    public int getPermanentNodeIndex(@NotNull CommitId commitId) {
        if (commitId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitId", "com/intellij/vcs/log/graph/impl/permanent/PermanentCommitsInfoIml", "getPermanentNodeIndex"));
        }
        return this.myCommitIdIndexes.indexOf(commitId);
    }

    @NotNull
    public List<CommitId> convertToCommitIdList(@NotNull Collection<Integer> commitIndexes) {
        if (commitIndexes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitIndexes", "com/intellij/vcs/log/graph/impl/permanent/PermanentCommitsInfoIml", "convertToCommitIdList"));
        }
        List list = ContainerUtil.map(commitIndexes, (Function)new Function<Integer, CommitId>(){

            public CommitId fun(Integer integer) {
                return PermanentCommitsInfoIml.this.getCommitId(integer);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/permanent/PermanentCommitsInfoIml", "convertToCommitIdList"));
        }
        return list;
    }

    @NotNull
    public Set<CommitId> convertToCommitIdSet(@NotNull Collection<Integer> commitIndexes) {
        if (commitIndexes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitIndexes", "com/intellij/vcs/log/graph/impl/permanent/PermanentCommitsInfoIml", "convertToCommitIdSet"));
        }
        Set set = ContainerUtil.map2Set(commitIndexes, (Function)new Function<Integer, CommitId>(){

            public CommitId fun(Integer integer) {
                return PermanentCommitsInfoIml.this.getCommitId(integer);
            }
        });
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/permanent/PermanentCommitsInfoIml", "convertToCommitIdSet"));
        }
        return set;
    }

    @Override
    @NotNull
    public Set<Integer> convertToCommitIndexes(@NotNull Collection<CommitId> commitIds) {
        if (commitIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitIds", "com/intellij/vcs/log/graph/impl/permanent/PermanentCommitsInfoIml", "convertToCommitIndexes"));
        }
        HashSet result = ContainerUtil.newHashSet();
        for (int i = 0; i < this.myCommitIdIndexes.size(); ++i) {
            CommitId commitId = this.myCommitIdIndexes.get(i);
            if (!commitIds.contains(commitId)) continue;
            result.add(i);
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/permanent/PermanentCommitsInfoIml", "convertToCommitIndexes"));
        }
        return hashSet;
    }
}

