/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentEP;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentProvider;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogSettings;
import com.intellij.vcs.log.data.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogManager;
import java.util.Arrays;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogContentProvider
implements ChangesViewContentProvider,
NotNullFunction<Project, Boolean> {
    public static final String TAB_NAME = "Log";
    private static final Logger LOG = Logger.getInstance(VcsLogContentProvider.class);
    @NotNull
    private final VcsLogManager myLogManager;
    @NotNull
    private final ProjectLevelVcsManager myVcsManager;

    public VcsLogContentProvider(@NotNull Project project, @NotNull ProjectLevelVcsManager manager, @NotNull VcsLogSettings settings, @NotNull VcsLogUiProperties uiProperties) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/impl/VcsLogContentProvider", "<init>"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/vcs/log/impl/VcsLogContentProvider", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/vcs/log/impl/VcsLogContentProvider", "<init>"));
        }
        if (uiProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiProperties", "com/intellij/vcs/log/impl/VcsLogContentProvider", "<init>"));
        }
        this.myVcsManager = manager;
        this.myLogManager = new VcsLogManager(project, settings, uiProperties);
    }

    @Nullable
    public static VcsLogManager findLogManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/impl/VcsLogContentProvider", "findLogManager"));
        }
        Object[] eps = (ChangesViewContentEP[])project.getExtensions(ChangesViewContentEP.EP_NAME);
        ChangesViewContentEP ep = (ChangesViewContentEP)ContainerUtil.find((Object[])eps, (Condition)new Condition<ChangesViewContentEP>(){

            public boolean value(ChangesViewContentEP ep) {
                return ep.getClassName().equals(VcsLogContentProvider.class.getName());
            }
        });
        if (ep == null) {
            LOG.warn("Proper content provider ep not found among [" + VcsLogContentProvider.toString((ChangesViewContentEP[])eps) + "]");
            return null;
        }
        ChangesViewContentProvider instance = ep.getInstance(project);
        if (!(instance instanceof VcsLogContentProvider)) {
            LOG.error("Class name matches, but the class doesn't. class name: " + ep.getClassName() + ", class: " + ep.getClass());
            return null;
        }
        VcsLogContentProvider provider = (VcsLogContentProvider)instance;
        return provider.myLogManager;
    }

    @NotNull
    private static String toString(@NotNull ChangesViewContentEP[] eps) {
        if (eps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eps", "com/intellij/vcs/log/impl/VcsLogContentProvider", "toString"));
        }
        String string = StringUtil.join((Object[])eps, (Function)new Function<ChangesViewContentEP, String>(){

            public String fun(ChangesViewContentEP ep) {
                return String.format("%s-%s-%s", ep.tabName, ep.className, ep.predicateClassName);
            }
        }, (String)",");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogContentProvider", "toString"));
        }
        return string;
    }

    @NotNull
    public Boolean fun(Project project) {
        Boolean bl = !this.myLogManager.findLogProviders(Arrays.asList(this.myVcsManager.getAllVcsRoots())).isEmpty();
        if (bl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogContentProvider", "fun"));
        }
        return bl;
    }

    @Override
    public JComponent initContent() {
        return this.myLogManager.initContent(Arrays.asList(this.myVcsManager.getAllVcsRoots()), TAB_NAME);
    }

    @Override
    public void disposeContent() {
        Disposer.dispose((Disposable)this.myLogManager);
    }
}

