/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.vcs.versionBrowser.DateFilterComponent;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.log.VcsLogDateFilter;
import com.intellij.vcs.log.data.VcsLogDateFilterImpl;
import com.intellij.vcs.log.ui.filter.FilterPopupComponent;
import com.intellij.vcs.log.ui.filter.VcsLogClassicFilterUi;
import java.awt.Component;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DateFilterPopupComponent
extends FilterPopupComponent<VcsLogDateFilter> {
    private Date myAfter;
    private Date myBefore;

    DateFilterPopupComponent(@NotNull VcsLogClassicFilterUi filterUi) {
        if (filterUi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterUi", "com/intellij/vcs/log/ui/filter/DateFilterPopupComponent", "<init>"));
        }
        super(filterUi, "Date");
    }

    @Override
    protected ActionGroup createActionGroup() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(6, -1);
        Date oneDayBefore = cal.getTime();
        cal.add(6, -6);
        Date oneWeekBefore = cal.getTime();
        DumbAwareAction allAction = new DumbAwareAction("All"){

            public void actionPerformed(AnActionEvent e) {
                DateFilterPopupComponent.this.myAfter = null;
                DateFilterPopupComponent.this.myBefore = null;
                DateFilterPopupComponent.this.applyFilters();
                DateFilterPopupComponent.this.setValue("All");
            }
        };
        return new DefaultActionGroup(new AnAction[]{allAction, new DateAction(oneDayBefore, "Last 24 hours"), new DateAction(oneWeekBefore, "Last 7 days"), new SelectAction()});
    }

    @Override
    @Nullable
    protected VcsLogDateFilter getFilter() {
        return this.myAfter == null && this.myBefore == null ? null : new VcsLogDateFilterImpl(this.myAfter, this.myBefore);
    }

    private void setOnlyAfter(Date after) {
        this.myAfter = after;
        this.myBefore = null;
    }

    private class SelectAction
    extends DumbAwareAction {
        SelectAction() {
            super("Select...");
        }

        public void actionPerformed(AnActionEvent e) {
            DateFilterComponent dateComponent = new DateFilterComponent(false, DateFormatUtil.getDateFormat().getDelegate());
            if (DateFilterPopupComponent.this.myBefore != null) {
                dateComponent.setBefore(DateFilterPopupComponent.this.myBefore.getTime());
            }
            if (DateFilterPopupComponent.this.myAfter != null) {
                dateComponent.setAfter(DateFilterPopupComponent.this.myAfter.getTime());
            }
            DialogBuilder db = new DialogBuilder((Component)DateFilterPopupComponent.this);
            db.addOkAction();
            db.setCenterPanel((JComponent)dateComponent.getPanel());
            db.setPreferredFocusComponent((JComponent)dateComponent.getPanel());
            db.setTitle("Select Period");
            if (0 == db.show()) {
                long after = dateComponent.getAfter();
                long before = dateComponent.getBefore();
                DateFilterPopupComponent.this.myAfter = after > 0L ? new Date(after) : null;
                DateFilterPopupComponent.this.myBefore = before > 0L ? new Date(before) : null;
                if (DateFilterPopupComponent.this.myAfter != null && DateFilterPopupComponent.this.myBefore != null) {
                    DateFilterPopupComponent.this.setValue(DateFormatUtil.formatDate((long)after) + "-" + DateFormatUtil.formatDate((long)before));
                } else if (DateFilterPopupComponent.this.myAfter != null) {
                    DateFilterPopupComponent.this.setValue("After " + DateFormatUtil.formatDate((long)after));
                } else {
                    DateFilterPopupComponent.this.setValue("Before " + DateFormatUtil.formatDate((long)before));
                }
                DateFilterPopupComponent.this.applyFilters();
            }
        }
    }

    private class DateAction
    extends DumbAwareAction {
        private final Date mySince;
        private final String myText;

        DateAction(Date since, String text) {
            super(text);
            this.mySince = since;
            this.myText = text;
        }

        public void actionPerformed(AnActionEvent e) {
            DateFilterPopupComponent.this.setValue(this.myText);
            DateFilterPopupComponent.this.setOnlyAfter(this.mySince);
            DateFilterPopupComponent.this.applyFilters();
        }
    }
}

