/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.CheckValidXmlInScriptBodyInspectionBase;
import org.jetbrains.annotations.NotNull;

public class CheckValidXmlInScriptBodyInspection
extends CheckValidXmlInScriptBodyInspectionBase {
    @Override
    protected InsertQuotedCharacterQuickFix createFix(PsiFile psiFile, PsiElement psiElement, int offsetInElement) {
        return new InsertQuotedCharacterQuickFix(psiFile, psiElement, offsetInElement);
    }

    private static class InsertQuotedCharacterQuickFix
    implements LocalQuickFix {
        private final PsiFile psiFile;
        private final PsiElement psiElement;
        private final int startInElement;

        public InsertQuotedCharacterQuickFix(PsiFile psiFile, PsiElement psiElement, int startInElement) {
            this.psiFile = psiFile;
            this.psiElement = psiElement;
            this.startInElement = startInElement;
        }

        @NotNull
        public String getName() {
            String character = this.getXmlCharacter();
            String string = XmlBundle.message((String)"unescaped.xml.character.fix.message", (Object[])new Object[]{character.equals("&") ? XmlBundle.message((String)"unescaped.xml.character.fix.message.parameter", (Object[])new Object[0]) : character});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/CheckValidXmlInScriptBodyInspection$InsertQuotedCharacterQuickFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/CheckValidXmlInScriptBodyInspection$InsertQuotedCharacterQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor problemDescriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xml/util/CheckValidXmlInScriptBodyInspection$InsertQuotedCharacterQuickFix", "applyFix"));
            }
            if (problemDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemDescriptor", "com/intellij/xml/util/CheckValidXmlInScriptBodyInspection$InsertQuotedCharacterQuickFix", "applyFix"));
            }
            if (!FileModificationService.getInstance().prepareFileForWrite(this.psiFile)) {
                return;
            }
            TextRange range = this.psiElement.getTextRange();
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, this.psiFile.getVirtualFile(), range.getStartOffset() + this.startInElement);
            Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
            if (editor == null) {
                return;
            }
            String xmlCharacter = this.getXmlCharacter();
            String replacement = xmlCharacter.equals("&") ? "&amp;" : "&lt;";
            replacement = this.psiElement.getText().replace(xmlCharacter, replacement);
            editor.getDocument().replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)replacement);
        }

        private String getXmlCharacter() {
            return this.psiElement.getText().substring(this.startInElement, this.startInElement + 1);
        }
    }
}

