/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeySetIterationMayUseEntrySetInspection
extends BaseInspection {
    @Override
    @NotNull
    @Nls
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("key.set.iteration.may.use.entry.set.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/KeySetIterationMayUseEntrySetInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("key.set.iteration.may.use.entry.set.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/KeySetIterationMayUseEntrySetInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new KeySetIterationMapUseEntrySetFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new KeySetIterationMayUseEntrySetVisitor();
    }

    private static class GetValueFromMapChecker
    extends JavaRecursiveElementVisitor {
        private final PsiVariable key;
        private final PsiVariable map;
        private boolean getValueFromMap;
        private boolean tainted;

        GetValueFromMapChecker(@NotNull PsiVariable map, @NotNull PsiVariable key) {
            if (map == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/siyeh/ig/performance/KeySetIterationMayUseEntrySetInspection$GetValueFromMapChecker", "<init>"));
            }
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/siyeh/ig/performance/KeySetIterationMayUseEntrySetInspection$GetValueFromMapChecker", "<init>"));
            }
            this.getValueFromMap = false;
            this.tainted = false;
            this.map = map;
            this.key = key;
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            if (this.tainted) {
                return;
            }
            super.visitReferenceExpression(expression);
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiAssignmentExpression) {
                PsiElement target = expression.resolve();
                if (this.key.equals(target) || this.map.equals(target)) {
                    this.tainted = true;
                }
            } else if (!(parent instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiReferenceExpression methodExpression = (PsiReferenceExpression)parent;
            PsiElement target = expression.resolve();
            if (!this.map.equals(target)) {
                return;
            }
            PsiExpression qualifierExpression = expression.getQualifierExpression();
            if (qualifierExpression != null && !(qualifierExpression instanceof PsiThisExpression) && !(qualifierExpression instanceof PsiSuperExpression)) {
                return;
            }
            String methodName = methodExpression.getReferenceName();
            if (!"get".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            if (!(argument instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)argument;
            PsiElement argumentTarget = referenceExpression.resolve();
            if (!this.key.equals(argumentTarget)) {
                return;
            }
            this.getValueFromMap = true;
        }

        public boolean isGetValueFromMap() {
            return this.getValueFromMap && !this.tainted;
        }
    }

    private static class KeySetIterationMayUseEntrySetVisitor
    extends BaseInspectionVisitor {
        private KeySetIterationMayUseEntrySetVisitor() {
        }

        public void visitForeachStatement(PsiForeachStatement statement) {
            PsiExpression iteratedExpression;
            super.visitForeachStatement(statement);
            PsiExpression iteratedValue = statement.getIteratedValue();
            if (iteratedValue == null) {
                return;
            }
            if (iteratedValue instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)iteratedValue;
                PsiElement target = referenceExpression.resolve();
                if (!(target instanceof PsiLocalVariable)) {
                    return;
                }
                PsiVariable variable = (PsiVariable)target;
                PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiMethod.class);
                if (VariableAccessUtils.variableIsAssignedAtPoint(variable, (PsiElement)containingMethod, (PsiElement)statement)) {
                    return;
                }
                iteratedExpression = variable.getInitializer();
            } else {
                iteratedExpression = iteratedValue;
            }
            PsiParameter parameter = statement.getIterationParameter();
            if (!KeySetIterationMayUseEntrySetVisitor.isMapKeySetIteration(iteratedExpression, (PsiVariable)parameter, (PsiElement)statement.getBody())) {
                return;
            }
            this.registerError((PsiElement)iteratedValue, new Object[0]);
        }

        private static boolean isMapKeySetIteration(PsiExpression iteratedExpression, PsiVariable key, @Nullable PsiElement context) {
            if (context == null) {
                return false;
            }
            if (!(iteratedExpression instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)iteratedExpression;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"keySet".equals(methodName)) {
                return false;
            }
            PsiExpression expression = methodExpression.getQualifierExpression();
            if (!(expression instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiVariable)) {
                return false;
            }
            PsiVariable targetVariable = (PsiVariable)target;
            PsiType type = targetVariable.getType();
            if (!(type instanceof PsiClassType)) {
                return false;
            }
            PsiClassType classType = (PsiClassType)type;
            PsiClass aClass = classType.resolve();
            if (aClass == null) {
                return false;
            }
            String className = aClass.getQualifiedName();
            if (!"java.util.Map".equals(className)) {
                return false;
            }
            GetValueFromMapChecker checker = new GetValueFromMapChecker(targetVariable, key);
            context.accept((PsiElementVisitor)checker);
            return checker.isGetValueFromMap();
        }
    }

    private static class KeySetIterationMapUseEntrySetFix
    extends InspectionGadgetsFix {
        private KeySetIterationMapUseEntrySetFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/KeySetIterationMayUseEntrySetInspection$KeySetIterationMapUseEntrySetFix", "getFamilyName"));
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("key.set.iteration.may.use.entry.set.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/KeySetIterationMayUseEntrySetInspection$KeySetIterationMapUseEntrySetFix", "getName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiModifierList modifierList;
            PsiElement map;
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiForeachStatement)) {
                return;
            }
            if (element instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
                PsiElement target = referenceExpression.resolve();
                if (!(target instanceof PsiVariable)) {
                    return;
                }
                PsiVariable variable = (PsiVariable)target;
                PsiExpression initializer = variable.getInitializer();
                if (!(initializer instanceof PsiMethodCallExpression)) {
                    return;
                }
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)initializer;
                PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                if (!(qualifier instanceof PsiReferenceExpression)) {
                    return;
                }
                PsiReferenceExpression reference = (PsiReferenceExpression)qualifier;
                map = reference.resolve();
                String qualifierText = qualifier.getText();
                PsiReplacementUtil.replaceExpression((PsiExpression)referenceExpression, qualifierText + ".entrySet()");
            } else if (element instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
                PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                if (!(qualifier instanceof PsiReferenceExpression)) {
                    return;
                }
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
                map = referenceExpression.resolve();
                String qualifierText = qualifier.getText();
                PsiReplacementUtil.replaceExpression((PsiExpression)methodCallExpression, qualifierText + ".entrySet()");
            } else {
                return;
            }
            PsiForeachStatement foreachStatement = (PsiForeachStatement)parent;
            PsiExpression iteratedValue = foreachStatement.getIteratedValue();
            if (iteratedValue == null) {
                return;
            }
            PsiType type = iteratedValue.getType();
            if (!(type instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)type;
            PsiType[] parameterTypes = classType.getParameters();
            PsiType parameterType = parameterTypes.length == 1 ? parameterTypes[0] : null;
            boolean insertCast = false;
            if (parameterType == null) {
                parameterType = TypeUtils.getObjectType((PsiElement)foreachStatement);
                insertCast = true;
            }
            PsiParameter parameter = foreachStatement.getIterationParameter();
            String variableName = KeySetIterationMapUseEntrySetFix.createNewVariableName((PsiElement)foreachStatement, parameterType);
            if (insertCast) {
                KeySetIterationMapUseEntrySetFix.replaceParameterAccess(parameter, "((Map.Entry)" + variableName + ')', map, (PsiElement)foreachStatement);
            } else {
                KeySetIterationMapUseEntrySetFix.replaceParameterAccess(parameter, variableName, map, (PsiElement)foreachStatement);
            }
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            PsiParameter newParameter = factory.createParameter(variableName, parameterType);
            if (parameter.hasModifierProperty("final") && (modifierList = newParameter.getModifierList()) != null) {
                modifierList.setModifierProperty("final", true);
            }
            parameter.replace((PsiElement)newParameter);
        }

        private static void replaceParameterAccess(PsiParameter parameter, @NonNls String variableName, PsiElement map, PsiElement context) {
            ParameterAccessCollector collector = new ParameterAccessCollector(parameter, map);
            context.accept((PsiElementVisitor)collector);
            List<PsiExpression> accesses = collector.getParameterAccesses();
            for (PsiExpression access : accesses) {
                if (access instanceof PsiMethodCallExpression) {
                    PsiReplacementUtil.replaceExpression(access, variableName + ".getValue()");
                    continue;
                }
                PsiReplacementUtil.replaceExpression(access, variableName + ".getKey()");
            }
        }

        private static String createNewVariableName(@NotNull PsiElement scope, @NotNull PsiType type) {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/siyeh/ig/performance/KeySetIterationMayUseEntrySetInspection$KeySetIterationMapUseEntrySetFix", "createNewVariableName"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/siyeh/ig/performance/KeySetIterationMayUseEntrySetInspection$KeySetIterationMapUseEntrySetFix", "createNewVariableName"));
            }
            Project project = scope.getProject();
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            SuggestedNameInfo suggestions = codeStyleManager.suggestVariableName(VariableKind.LOCAL_VARIABLE, null, null, type);
            String[] names = suggestions.names;
            String baseName = names != null && names.length > 0 ? names[0] : "entry";
            if (baseName == null || baseName.length() == 0) {
                baseName = "entry";
            }
            return codeStyleManager.suggestUniqueVariableName(baseName, scope, true);
        }

        private static class ParameterAccessCollector
        extends JavaRecursiveElementVisitor {
            private final PsiParameter parameter;
            private final PsiElement map;
            private final String parameterName;
            private final List<PsiExpression> parameterAccesses = new ArrayList<PsiExpression>();

            public ParameterAccessCollector(PsiParameter parameter, PsiElement map) {
                this.parameter = parameter;
                this.parameterName = parameter.getName();
                this.map = map;
            }

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                super.visitReferenceExpression(expression);
                if (expression.getQualifierExpression() != null) {
                    return;
                }
                String expressionText = expression.getText();
                if (!expressionText.equals(this.parameterName)) {
                    return;
                }
                PsiElement target = expression.resolve();
                if (!this.parameter.equals(target)) {
                    return;
                }
                try {
                    if (!this.collectValueUsage(expression)) {
                        this.parameterAccesses.add((PsiExpression)expression);
                    }
                }
                catch (IncorrectOperationException e) {
                    throw new RuntimeException(e);
                }
            }

            private boolean collectValueUsage(PsiReferenceExpression expression) throws IncorrectOperationException {
                PsiElement parent = expression.getParent();
                if (!(parent instanceof PsiExpressionList)) {
                    return false;
                }
                PsiElement grandParent = parent.getParent();
                if (!(grandParent instanceof PsiMethodCallExpression)) {
                    return false;
                }
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
                PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                String methodName = methodExpression.getReferenceName();
                if (!"get".equals(methodName)) {
                    return false;
                }
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                if (!(qualifier instanceof PsiReferenceExpression)) {
                    return false;
                }
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
                PsiElement target2 = referenceExpression.resolve();
                if (!this.map.equals(target2)) {
                    return false;
                }
                PsiExpression qualifierExpression = referenceExpression.getQualifierExpression();
                if (qualifierExpression != null && !(qualifier instanceof PsiThisExpression) || qualifierExpression instanceof PsiSuperExpression) {
                    return false;
                }
                this.parameterAccesses.add((PsiExpression)methodCallExpression);
                return true;
            }

            public List<PsiExpression> getParameterAccesses() {
                Collections.reverse(this.parameterAccesses);
                return this.parameterAccesses;
            }
        }
    }
}

