/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.fqnames;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.ImportUtils;
import com.siyeh.ig.style.UnnecessaryFullyQualifiedNameInspection;
import com.siyeh.ipp.base.PsiElementPredicate;

class FullyQualifiedNamePredicate
implements PsiElementPredicate {
    FullyQualifiedNamePredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        PsiElement target;
        if (!(element instanceof PsiJavaCodeReferenceElement)) {
            return false;
        }
        PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)element;
        if (!referenceElement.isQualified()) {
            return false;
        }
        PsiElement parent = referenceElement.getParent();
        if (parent instanceof PsiMethodCallExpression || parent instanceof PsiAssignmentExpression || parent instanceof PsiVariable) {
            return false;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiImportStatementBase.class, PsiPackageStatement.class, JavaCodeFragment.class}) != null) {
            return false;
        }
        Project project = element.getProject();
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getSettings((Project)project);
        if (UnnecessaryFullyQualifiedNameInspection.acceptFullyQualifiedNamesInJavadoc(referenceElement, codeStyleSettings)) {
            return false;
        }
        PsiElement qualifier = referenceElement.getQualifier();
        if (!(qualifier instanceof PsiJavaCodeReferenceElement)) {
            return false;
        }
        PsiJavaCodeReferenceElement qualifierReferenceElement = (PsiJavaCodeReferenceElement)qualifier;
        PsiElement resolved = qualifierReferenceElement.resolve();
        if (!(resolved instanceof PsiPackage)) {
            if (!(resolved instanceof PsiClass)) {
                return false;
            }
            if (!codeStyleSettings.INSERT_INNER_CLASS_IMPORTS) {
                return false;
            }
        }
        if (!((target = referenceElement.resolve()) instanceof PsiClass)) {
            return false;
        }
        PsiClass aClass = (PsiClass)target;
        String fqName = aClass.getQualifiedName();
        if (fqName == null) {
            return false;
        }
        return ImportUtils.nameCanBeImported(fqName, element);
    }
}

