/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.junit;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class DataPointHolderConversionIntention
extends PsiElementBaseIntentionAction {
    private static final String THEORIES_PACKAGE = "org.junit.experimental.theories";
    private static final String DATA_POINT_FQN = "org.junit.experimental.theories.DataPoint";
    private static final String DATA_POINTS_FQN = "org.junit.experimental.theories.DataPoints";
    private static final String REPLACE_BY_TEMPLATE = "Replace by @%s %s";

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/siyeh/ipp/junit/DataPointHolderConversionIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/junit/DataPointHolderConversionIntention", "invoke"));
        }
        PsiElement holder = element.getParent();
        PsiMethod createdElement = holder instanceof PsiField ? DataPointHolderConversionIntention.convertToMethod((PsiField)holder) : DataPointHolderConversionIntention.convertToField((PsiMethod)holder);
        PsiModifierListOwner oldElement = (PsiModifierListOwner)holder;
        PsiAnnotation psiAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)oldElement, (String[])new String[]{DATA_POINT_FQN, DATA_POINTS_FQN});
        assert (psiAnnotation != null);
        String annotation = psiAnnotation.getQualifiedName();
        assert (annotation != null);
        PsiModifierList modifierList = createdElement.getModifierList();
        assert (modifierList != null);
        modifierList.addAnnotation(annotation);
        modifierList.setModifierProperty("static", true);
        modifierList.setModifierProperty("public", true);
        createdElement = (PsiModifierListOwner)oldElement.replace((PsiElement)createdElement);
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        TemplateBuilder templateBuilder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)createdElement);
        PsiNameIdentifierOwner asNameIdOwner = (PsiNameIdentifierOwner)createdElement;
        templateBuilder.replaceElement(asNameIdOwner.getNameIdentifier(), asNameIdOwner.getName());
        templateBuilder.run(editor, false);
    }

    private static PsiField convertToField(PsiMethod method) {
        Project project = method.getProject();
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        String fieldName = codeStyleManager.propertyNameToVariableName(method.getName(), VariableKind.STATIC_FIELD);
        PsiType returnType = method.getReturnType();
        assert (returnType != null);
        PsiField field = elementFactory.createField(fieldName, returnType);
        PsiStatement returnStatement = (PsiStatement)PsiTreeUtil.findChildOfType((PsiElement)method, PsiStatement.class);
        if (returnStatement != null) {
            field.setInitializer(((PsiReturnStatement)returnStatement).getReturnValue());
        }
        return field;
    }

    private static PsiMethod convertToMethod(PsiField field) {
        Project project = field.getProject();
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        PsiExpression fieldInitializer = field.getInitializer();
        PsiMethod method = elementFactory.createMethod(codeStyleManager.variableNameToPropertyName(field.getName(), VariableKind.STATIC_FIELD), field.getType());
        PsiCodeBlock body = method.getBody();
        assert (body != null);
        PsiStatement methodCode = elementFactory.createStatementFromText("return " + fieldInitializer.getText() + ";", null);
        body.add((PsiElement)methodCode);
        return method;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/siyeh/ipp/junit/DataPointHolderConversionIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/junit/DataPointHolderConversionIntention", "isAvailable"));
        }
        Pair<PsiMember, PsiAnnotation> dataPointsHolder = DataPointHolderConversionIntention.extractDataPointsHolder(element);
        if (dataPointsHolder != null && DataPointHolderConversionIntention.isConvertible((PsiMember)dataPointsHolder.getFirst())) {
            String replaceType = dataPointsHolder.getFirst() instanceof PsiMethod ? "field" : "method";
            String annotation = StringUtil.getShortName((String)((PsiAnnotation)dataPointsHolder.getSecond()).getQualifiedName());
            this.setText(String.format(REPLACE_BY_TEMPLATE, annotation, replaceType));
            return true;
        }
        return false;
    }

    private static Pair<PsiMember, PsiAnnotation> extractDataPointsHolder(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/junit/DataPointHolderConversionIntention", "extractDataPointsHolder"));
        }
        if (!(element instanceof PsiIdentifier)) {
            return null;
        }
        PsiElement maybeHolder = element.getParent();
        if (maybeHolder == null || !(maybeHolder instanceof PsiMethod) && !(maybeHolder instanceof PsiField)) {
            return null;
        }
        PsiMember holder = (PsiMember)maybeHolder;
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)holder, (String[])new String[]{DATA_POINT_FQN, DATA_POINTS_FQN});
        return annotation == null ? null : Pair.create((Object)holder, (Object)annotation);
    }

    private static boolean isConvertible(@NotNull PsiMember member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/siyeh/ipp/junit/DataPointHolderConversionIntention", "isConvertible"));
        }
        if (!(member instanceof PsiMethod)) {
            return ((PsiField)member).getInitializer() != null;
        }
        PsiMethod method = (PsiMethod)member;
        PsiType returnType = method.getReturnType();
        if (returnType == null || returnType.equals(PsiType.VOID) || method.getParameterList().getParametersCount() != 0) {
            return false;
        }
        PsiCodeBlock body = method.getBody();
        if (body == null) {
            return false;
        }
        PsiStatement[] methodStatements = body.getStatements();
        switch (methodStatements.length) {
            case 1: {
                PsiStatement methodStatement = methodStatements[0];
                return methodStatement instanceof PsiReturnStatement;
            }
            case 0: {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public String getFamilyName() {
        if ("Convert @DataPoint(s) annotation holder" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/junit/DataPointHolderConversionIntention", "getFamilyName"));
        }
        return "Convert @DataPoint(s) annotation holder";
    }
}

