/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main.rels;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.CounterContainer;
import org.jetbrains.java.decompiler.main.collectors.VarNamesCollector;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.rels.MethodProcessorThread;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPaar;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructField;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.attr.StructLocalVariableTableAttribute;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.VBStyleCollection;

public class ClassWrapper {
    private StructClass classStruct;
    private Set<String> hiddenMembers = new HashSet<String>();
    private VBStyleCollection<Exprent, String> staticFieldInitializers = new VBStyleCollection();
    private VBStyleCollection<Exprent, String> dynamicFieldInitializers = new VBStyleCollection();
    private VBStyleCollection<MethodWrapper, String> methods = new VBStyleCollection();

    public ClassWrapper(StructClass classStruct) {
        this.classStruct = classStruct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws IOException {
        DecompilerContext.setProperty("CURRENT_CLASS", this.classStruct);
        DecompilerContext.getLogger().startClass(this.classStruct.qualifiedName);
        HashSet<String> setFieldNames = new HashSet<String>();
        for (StructField fd : this.classStruct.getFields()) {
            setFieldNames.add(fd.getName());
        }
        int maxsec = Integer.parseInt(DecompilerContext.getProperty("mpm").toString());
        for (StructMethod mt : this.classStruct.getMethods()) {
            StructLocalVariableTableAttribute attr;
            boolean isError;
            RootStatement root;
            VarProcessor varproc;
            CounterContainer counter;
            block16: {
                DecompilerContext.getLogger().startMethod(mt.getName() + " " + mt.getDescriptor());
                VarNamesCollector vc = new VarNamesCollector();
                DecompilerContext.setVarNamesCollector(vc);
                counter = new CounterContainer();
                DecompilerContext.setCounterContainer(counter);
                DecompilerContext.setProperty("CURRENT_METHOD", mt);
                DecompilerContext.setProperty("CURRENT_METHOD_DESCRIPTOR", MethodDescriptor.parseDescriptor(mt.getDescriptor()));
                varproc = new VarProcessor();
                DecompilerContext.setProperty("CURRENT_VAR_PROCESSOR", varproc);
                root = null;
                isError = false;
                try {
                    if (mt.containsCode()) {
                        if (maxsec == 0) {
                            root = MethodProcessorThread.codeToJava(mt, varproc);
                            break block16;
                        }
                        MethodProcessorThread mtproc = new MethodProcessorThread(mt, varproc, DecompilerContext.getCurrentContext());
                        Thread mtthread = new Thread(mtproc);
                        long stopAt = System.currentTimeMillis() + (long)(maxsec * 1000);
                        mtthread.start();
                        while (mtthread.isAlive()) {
                            Object object = mtproc.lock;
                            synchronized (object) {
                                mtproc.lock.wait(100L);
                            }
                            if (System.currentTimeMillis() < stopAt) continue;
                            String message = "Processing time limit exceeded for method " + mt.getName() + ", execution interrupted.";
                            DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.ERROR);
                            ClassWrapper.killThread(mtthread);
                            isError = true;
                            break;
                        }
                        if (!isError) {
                            root = mtproc.getResult();
                        }
                        break block16;
                    }
                    boolean thisvar = !mt.hasModifier(8);
                    MethodDescriptor md = MethodDescriptor.parseDescriptor(mt.getDescriptor());
                    int paramcount = 0;
                    if (thisvar) {
                        varproc.getThisvars().put(new VarVersionPaar(0, 0), this.classStruct.qualifiedName);
                        paramcount = 1;
                    }
                    paramcount += md.params.length;
                    int varindex = 0;
                    for (int i = 0; i < paramcount; ++i) {
                        varproc.setVarName(new VarVersionPaar(varindex, 0), vc.getFreeName(varindex));
                        if (thisvar) {
                            if (i == 0) {
                                ++varindex;
                                continue;
                            }
                            varindex += md.params[i - 1].stack_size;
                            continue;
                        }
                        varindex += md.params[i].stack_size;
                    }
                }
                catch (Throwable ex) {
                    DecompilerContext.getLogger().writeMessage("Method " + mt.getName() + " " + mt.getDescriptor() + " couldn't be decompiled.", ex);
                    isError = true;
                }
            }
            MethodWrapper meth = new MethodWrapper(root, varproc, mt, counter);
            meth.decompiledWithErrors = isError;
            this.methods.addWithKey(meth, InterpreterUtil.makeUniqueKey(mt.getName(), mt.getDescriptor()));
            varproc.refreshVarNames(new VarNamesCollector(setFieldNames));
            if (DecompilerContext.getOption("udv") && (attr = (StructLocalVariableTableAttribute)mt.getAttributes().getWithKey("LocalVariableTable")) != null) {
                varproc.setDebugVarNames(attr.getMapVarNames());
            }
            DecompilerContext.getLogger().endMethod();
        }
        DecompilerContext.getLogger().endClass();
    }

    private static void killThread(Thread thread) {
        thread.stop();
    }

    public MethodWrapper getMethodWrapper(String name, String descriptor) {
        return this.methods.getWithKey(InterpreterUtil.makeUniqueKey(name, descriptor));
    }

    public StructClass getClassStruct() {
        return this.classStruct;
    }

    public VBStyleCollection<MethodWrapper, String> getMethods() {
        return this.methods;
    }

    public Set<String> getHiddenMembers() {
        return this.hiddenMembers;
    }

    public VBStyleCollection<Exprent, String> getStaticFieldInitializers() {
        return this.staticFieldInitializers;
    }

    public VBStyleCollection<Exprent, String> getDynamicFieldInitializers() {
        return this.dynamicFieldInitializers;
    }
}

