/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.vars.CheckTypesResult;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class ArrayExprent
extends Exprent {
    private Exprent array;
    private Exprent index;
    private VarType hardtype;

    public ArrayExprent(Exprent array, Exprent index, VarType hardtype) {
        this.type = 1;
        this.array = array;
        this.index = index;
        this.hardtype = hardtype;
    }

    @Override
    public Exprent copy() {
        return new ArrayExprent(this.array.copy(), this.index.copy(), this.hardtype);
    }

    @Override
    public VarType getExprType() {
        VarType exprType = this.array.getExprType().copy();
        if (exprType.equals(VarType.VARTYPE_NULL)) {
            exprType = this.hardtype.copy();
        } else {
            exprType.decArrayDim();
        }
        return exprType;
    }

    @Override
    public int getExprentUse() {
        return this.array.getExprentUse() & this.index.getExprentUse() & 1;
    }

    @Override
    public CheckTypesResult checkExprTypeBounds() {
        CheckTypesResult result = new CheckTypesResult();
        result.addMinTypeExprent(this.index, VarType.VARTYPE_BYTECHAR);
        result.addMaxTypeExprent(this.index, VarType.VARTYPE_INT);
        return result;
    }

    @Override
    public List<Exprent> getAllExprents() {
        ArrayList<Exprent> lst = new ArrayList<Exprent>();
        lst.add(this.array);
        lst.add(this.index);
        return lst;
    }

    @Override
    public String toJava(int indent, BytecodeMappingTracer tracer) {
        String res = this.array.toJava(indent, tracer);
        if (this.array.getPrecedence() > this.getPrecedence()) {
            res = "(" + res + ")";
        }
        VarType arrtype = this.array.getExprType();
        if (arrtype.arraydim == 0) {
            VarType objarr = VarType.VARTYPE_OBJECT.copy();
            objarr.arraydim = 1;
            res = "((" + ExprProcessor.getCastTypeName(objarr) + ")" + res + ")";
        }
        tracer.addMapping(this.bytecode);
        return res + "[" + this.index.toJava(indent, tracer) + "]";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof ArrayExprent)) {
            return false;
        }
        ArrayExprent arr = (ArrayExprent)o;
        return InterpreterUtil.equalObjects(this.array, arr.getArray()) && InterpreterUtil.equalObjects(this.index, arr.getIndex());
    }

    @Override
    public void replaceExprent(Exprent oldexpr, Exprent newexpr) {
        if (oldexpr == this.array) {
            this.array = newexpr;
        }
        if (oldexpr == this.index) {
            this.index = newexpr;
        }
    }

    public Exprent getArray() {
        return this.array;
    }

    public Exprent getIndex() {
        return this.index;
    }
}

