/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.push.ui.VcsPushDialog;
import com.intellij.dvcs.repo.RepositoryUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitUtil;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitPushAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "git4idea/actions/GitPushAction", "actionPerformed"));
        }
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        List repositories = e.getData(CommonDataKeys.EDITOR) != null ? ContainerUtil.emptyList() : GitPushAction.collectRepositories(project, (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY));
        new VcsPushDialog(project, RepositoryUtil.sortRepositories((Collection)repositories)).show();
    }

    @NotNull
    private static Collection<GitRepository> collectRepositories(@NotNull Project project, @Nullable VirtualFile[] files) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/actions/GitPushAction", "collectRepositories"));
        }
        if (files == null) {
            List<GitRepository> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/actions/GitPushAction", "collectRepositories"));
            }
            return list;
        }
        GitRepositoryManager manager = GitUtil.getRepositoryManager(project);
        HashSet repositories = ContainerUtil.newHashSet();
        for (VirtualFile file : files) {
            GitRepository repo = (GitRepository)manager.getRepositoryForFile(file);
            if (repo == null) continue;
            repositories.add(repo);
        }
        HashSet hashSet = repositories;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/actions/GitPushAction", "collectRepositories"));
        }
        return hashSet;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "git4idea/actions/GitPushAction", "update"));
        }
        super.update(e);
        Project project = e.getProject();
        e.getPresentation().setEnabledAndVisible(project != null && !GitUtil.getRepositoryManager(project).getRepositories().isEmpty());
    }
}

