/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsEncodingConfigurationService;
import org.jetbrains.jps.model.JpsGlobal;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.serialization.JpsGlobalExtensionSerializer;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.JpsProjectExtensionSerializer;

public class JpsEncodingModelSerializerExtension
extends JpsModelSerializerExtension {
    @Override
    @NotNull
    public List<? extends JpsProjectExtensionSerializer> getProjectExtensionSerializers() {
        List<JpsEncodingConfigurationSerializer> list = Arrays.asList(new JpsEncodingConfigurationSerializer());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/serialization/JpsEncodingModelSerializerExtension", "getProjectExtensionSerializers"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<? extends JpsGlobalExtensionSerializer> getGlobalExtensionSerializers() {
        List<JpsGlobalEncodingSerializer> list = Arrays.asList(new JpsGlobalEncodingSerializer());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/serialization/JpsEncodingModelSerializerExtension", "getGlobalExtensionSerializers"));
        }
        return list;
    }

    private static class JpsGlobalEncodingSerializer
    extends JpsGlobalExtensionSerializer {
        public static final String ENCODING_ATTRIBUTE = "default_encoding";

        private JpsGlobalEncodingSerializer() {
            super("encoding.xml", "Encoding");
        }

        @Override
        public void loadExtension(@NotNull JpsGlobal global, @NotNull Element componentTag) {
            if (global == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "global", "org/jetbrains/jps/model/serialization/JpsEncodingModelSerializerExtension$JpsGlobalEncodingSerializer", "loadExtension"));
            }
            if (componentTag == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentTag", "org/jetbrains/jps/model/serialization/JpsEncodingModelSerializerExtension$JpsGlobalEncodingSerializer", "loadExtension"));
            }
            String encoding = componentTag.getAttributeValue(ENCODING_ATTRIBUTE);
            JpsEncodingConfigurationService.getInstance().setGlobalEncoding(global, StringUtil.nullize((String)encoding));
        }

        @Override
        public void saveExtension(@NotNull JpsGlobal global, @NotNull Element componentTag) {
            if (global == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "global", "org/jetbrains/jps/model/serialization/JpsEncodingModelSerializerExtension$JpsGlobalEncodingSerializer", "saveExtension"));
            }
            if (componentTag == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentTag", "org/jetbrains/jps/model/serialization/JpsEncodingModelSerializerExtension$JpsGlobalEncodingSerializer", "saveExtension"));
            }
            componentTag.setAttribute(ENCODING_ATTRIBUTE, JpsEncodingConfigurationService.getInstance().getGlobalEncoding(global));
        }
    }

    private static class JpsEncodingConfigurationSerializer
    extends JpsProjectExtensionSerializer {
        private JpsEncodingConfigurationSerializer() {
            super("encodings.xml", "Encoding");
        }

        @Override
        public void loadExtension(@NotNull JpsProject project, @NotNull Element componentTag) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jps/model/serialization/JpsEncodingModelSerializerExtension$JpsEncodingConfigurationSerializer", "loadExtension"));
            }
            if (componentTag == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentTag", "org/jetbrains/jps/model/serialization/JpsEncodingModelSerializerExtension$JpsEncodingConfigurationSerializer", "loadExtension"));
            }
            String projectEncoding = null;
            HashMap<String, String> urlToEncoding = new HashMap<String, String>();
            for (Element fileTag : JDOMUtil.getChildren((Element)componentTag, (String)"file")) {
                String url = fileTag.getAttributeValue("url");
                String encoding = fileTag.getAttributeValue("charset");
                if (url.equals("PROJECT")) {
                    projectEncoding = encoding;
                    continue;
                }
                urlToEncoding.put(url, encoding);
            }
            JpsEncodingConfigurationService.getInstance().setEncodingConfiguration(project, projectEncoding, urlToEncoding);
        }

        @Override
        public void saveExtension(@NotNull JpsProject project, @NotNull Element componentTag) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jps/model/serialization/JpsEncodingModelSerializerExtension$JpsEncodingConfigurationSerializer", "saveExtension"));
            }
            if (componentTag == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentTag", "org/jetbrains/jps/model/serialization/JpsEncodingModelSerializerExtension$JpsEncodingConfigurationSerializer", "saveExtension"));
            }
        }
    }
}

