/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.NestedCopiesBuilder;
import org.jetbrains.idea.svn.NestedCopyInfo;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.StatusReceiver;
import org.jetbrains.idea.svn.StatusWalkerPartner;
import org.jetbrains.idea.svn.SvnChangeProviderContext;
import org.jetbrains.idea.svn.SvnChangedFile;
import org.jetbrains.idea.svn.SvnContentRevision;
import org.jetbrains.idea.svn.SvnFileUrlMappingImpl;
import org.jetbrains.idea.svn.SvnRecursiveStatusWalker;
import org.jetbrains.idea.svn.SvnScopeZipper;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.actions.CleanupWorker;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnExceptionWrapper;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusType;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.ISVNStatusFileProvider;

public class SvnChangeProvider
implements ChangeProvider {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.SvnChangeProvider");
    public static final String ourDefaultListName = VcsBundle.message((String)"changes.default.changelist.name", (Object[])new Object[0]);
    public static final String PROPERTY_LAYER = "Property";
    private final SvnVcs myVcs;
    private final VcsContextFactory myFactory;
    private final SvnFileUrlMappingImpl mySvnFileUrlMapping;

    public SvnChangeProvider(SvnVcs vcs) {
        this.myVcs = vcs;
        this.myFactory = VcsContextFactory.SERVICE.getInstance();
        this.mySvnFileUrlMapping = (SvnFileUrlMappingImpl)vcs.getSvnFileUrlMapping();
    }

    public void getChanges(VcsDirtyScope dirtyScope, ChangelistBuilder builder, ProgressIndicator progress, ChangeListManagerGate addGate) throws VcsException {
        SvnScopeZipper zipper = new SvnScopeZipper(dirtyScope);
        zipper.run();
        Map<String, SvnScopeZipper.MyDirNonRecursive> nonRecursiveMap = zipper.getNonRecursiveDirs();
        ISVNStatusFileProvider fileProvider = this.createFileProvider(nonRecursiveMap);
        try {
            SvnChangeProviderContext context = new SvnChangeProviderContext(this.myVcs, builder, progress);
            StatusWalkerPartner partner = new StatusWalkerPartner(this.myVcs, progress);
            NestedCopiesBuilder nestedCopiesBuilder = new NestedCopiesBuilder(this.myVcs, this.mySvnFileUrlMapping);
            EventDispatcher statusReceiver = EventDispatcher.create(StatusReceiver.class);
            statusReceiver.addListener((EventListener)context);
            statusReceiver.addListener((EventListener)nestedCopiesBuilder);
            SvnRecursiveStatusWalker walker = new SvnRecursiveStatusWalker(this.myVcs, (StatusReceiver)statusReceiver.getMulticaster(), partner);
            for (FilePath path : zipper.getRecursiveDirs()) {
                walker.go(path, Depth.INFINITY);
            }
            partner.setFileProvider(fileProvider);
            for (SvnScopeZipper.MyDirNonRecursive item : nonRecursiveMap.values()) {
                walker.go(item.getDir(), Depth.IMMEDIATES);
            }
            ((StatusReceiver)statusReceiver.getMulticaster()).finish();
            this.processCopiedAndDeleted(context, dirtyScope);
            this.processUnsaved(dirtyScope, addGate, context);
            Set<NestedCopyInfo> nestedCopies = nestedCopiesBuilder.getCopies();
            this.mySvnFileUrlMapping.acceptNestedData(nestedCopies);
            SvnChangeProvider.putAdministrative17UnderVfsListener(nestedCopies);
        }
        catch (SvnExceptionWrapper e) {
            LOG.info((Throwable)e);
            throw new VcsException(e.getCause());
        }
        catch (SVNException e) {
            if (e.getCause() != null) {
                throw new VcsException(e.getMessage() + " " + e.getCause().getMessage(), (Throwable)e);
            }
            throw new VcsException((Throwable)e);
        }
    }

    private static void putAdministrative17UnderVfsListener(Set<NestedCopyInfo> pointInfos) {
        if (!SvnVcs.ourListenToWcDb) {
            return;
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        for (NestedCopyInfo info : pointInfos) {
            if (!WorkingCopyFormat.ONE_DOT_SEVEN.equals((Object)info.getFormat()) || NestedCopyType.switched.equals((Object)info.getType())) continue;
            VirtualFile root = info.getFile();
            lfs.refreshIoFiles(Collections.singletonList(SvnUtil.getWcDb(new File(root.getPath()))), true, false, null);
        }
    }

    private void processUnsaved(VcsDirtyScope dirtyScope, ChangeListManagerGate addGate, SvnChangeProviderContext context) throws SVNException {
        Document[] unsavedDocuments;
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        for (Document unsavedDocument : unsavedDocuments = fileDocumentManager.getUnsavedDocuments()) {
            FileStatus status;
            VirtualFile file = fileDocumentManager.getFile(unsavedDocument);
            if (file == null || !dirtyScope.belongsTo((FilePath)new FilePathImpl(file)) || !fileDocumentManager.isFileModified(file) || (status = addGate.getStatus(file)) != null && !FileStatus.NOT_CHANGED.equals(status)) continue;
            context.addModifiedNotSavedChange(file);
        }
    }

    private ISVNStatusFileProvider createFileProvider(Map<String, SvnScopeZipper.MyDirNonRecursive> nonRecursiveMap) {
        final HashMap preparedMap = new HashMap();
        for (SvnScopeZipper.MyDirNonRecursive item : nonRecursiveMap.values()) {
            HashMap<String, File> result = new HashMap<String, File>();
            for (FilePath path : item.getChildrenList()) {
                result.put(path.getName(), path.getIOFile());
            }
            preparedMap.put(item.getDir().getIOFile().getAbsolutePath(), result);
        }
        return new ISVNStatusFileProvider(){

            public Map getChildrenFiles(File parent) {
                return (Map)preparedMap.get(parent.getAbsolutePath());
            }
        };
    }

    private void processCopiedAndDeleted(SvnChangeProviderContext context, VcsDirtyScope dirtyScope) throws SVNException {
        for (SvnChangedFile copiedFile : context.getCopiedFiles()) {
            if (context.isCanceled()) {
                throw new ProcessCanceledException();
            }
            this.processCopiedFile(copiedFile, context.getBuilder(), context, dirtyScope);
        }
        for (SvnChangedFile deletedFile : context.getDeletedFiles()) {
            if (context.isCanceled()) {
                throw new ProcessCanceledException();
            }
            context.processStatus(deletedFile.getFilePath(), deletedFile.getStatus());
        }
    }

    public void getChanges(FilePath path, boolean recursive, ChangelistBuilder builder) throws SVNException, SvnBindException {
        SvnChangeProviderContext context = new SvnChangeProviderContext(this.myVcs, builder, null);
        StatusWalkerPartner partner = new StatusWalkerPartner(this.myVcs, ProgressManager.getInstance().getProgressIndicator());
        SvnRecursiveStatusWalker walker = new SvnRecursiveStatusWalker(this.myVcs, context, partner);
        walker.go(path, recursive ? Depth.INFINITY : Depth.IMMEDIATES);
        this.processCopiedAndDeleted(context, null);
    }

    private void processCopiedFile(SvnChangedFile copiedFile, ChangelistBuilder builder, SvnChangeProviderContext context, VcsDirtyScope dirtyScope) throws SVNException {
        boolean foundRename = false;
        Status copiedStatus = copiedFile.getStatus();
        String copyFromURL = copiedFile.getCopyFromURL();
        FilePath copiedToPath = copiedFile.getFilePath();
        HashSet<SvnChangedFile> deletedToDelete = new HashSet<SvnChangedFile>();
        for (SvnChangedFile deletedFile : context.getDeletedFiles()) {
            Status deletedStatus = deletedFile.getStatus();
            if (deletedStatus == null || deletedStatus.getURL() == null || !Comparing.equal((String)copyFromURL, (String)deletedStatus.getURL().toString())) continue;
            String clName = SvnUtil.getChangelistName(copiedFile.getStatus());
            Change newChange = context.createMovedChange(this.createBeforeRevision(deletedFile, true), CurrentContentRevision.create((FilePath)copiedFile.getFilePath()), copiedStatus, deletedStatus);
            this.applyMovedChange(copiedFile.getFilePath(), builder, dirtyScope, deletedToDelete, deletedFile, clName, newChange);
            for (SvnChangedFile deletedChild : context.getDeletedFiles()) {
                SVNURL childUrl;
                Status childStatus = deletedChild.getStatus();
                if (childStatus == null || (childUrl = childStatus.getURL()) == null) continue;
                String childURL = childUrl.toDecodedString();
                if (!StringUtil.startsWithConcatenation((String)childURL, (String[])new String[]{copyFromURL, "/"})) continue;
                String relativePath = childURL.substring(copyFromURL.length());
                File newPath = new File(copiedFile.getFilePath().getIOFile(), relativePath);
                FilePath newFilePath = this.myFactory.createFilePathOn(newPath);
                if (context.isDeleted(newFilePath)) continue;
                Change movedChange = context.createMovedChange(this.createBeforeRevision(deletedChild, true), CurrentContentRevision.create((FilePath)newFilePath), context.getTreeConflictStatus(newPath), childStatus);
                this.applyMovedChange(newFilePath, builder, dirtyScope, deletedToDelete, deletedChild, clName, movedChange);
            }
            foundRename = true;
            break;
        }
        List<SvnChangedFile> deletedFiles = context.getDeletedFiles();
        for (SvnChangedFile file : deletedToDelete) {
            deletedFiles.remove(file);
        }
        if (!foundRename && copiedStatus.getURL() != null) {
            Status status;
            File wcPath = SvnChangeProvider.guessWorkingCopyPath(copiedStatus.getFile(), copiedStatus.getURL(), copyFromURL);
            try {
                status = this.myVcs.getFactory(wcPath).createStatusClient().doStatus(wcPath, false);
            }
            catch (SvnBindException ex) {
                LOG.info((Throwable)((Object)ex));
                status = null;
            }
            if (status != null && status.is(StatusType.STATUS_DELETED)) {
                FilePath filePath = this.myFactory.createFilePathOnDeleted(wcPath, false);
                SvnContentRevision beforeRevision = SvnContentRevision.createBaseRevision(this.myVcs, filePath, status.getRevision());
                ContentRevision afterRevision = CurrentContentRevision.create((FilePath)copiedFile.getFilePath());
                builder.processChangeInList(context.createMovedChange(beforeRevision, afterRevision, copiedStatus, status), SvnUtil.getChangelistName(status), SvnVcs.getKey());
                foundRename = true;
            }
        }
        if (!foundRename) {
            LOG.info("Rename not found for " + copiedFile.getFilePath().getPresentableUrl());
            context.processStatus(copiedFile.getFilePath(), copiedStatus);
        }
    }

    private void applyMovedChange(FilePath oldPath, ChangelistBuilder builder, final VcsDirtyScope dirtyScope, Set<SvnChangedFile> deletedToDelete, SvnChangedFile deletedFile, String clName, final Change newChange) {
        boolean isUnder;
        boolean bl = isUnder = dirtyScope == null ? true : (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return ChangeListManagerImpl.isUnder((Change)newChange, (VcsDirtyScope)dirtyScope);
            }
        });
        if (isUnder) {
            builder.removeRegisteredChangeFor(oldPath);
            builder.processChangeInList(newChange, clName, SvnVcs.getKey());
            deletedToDelete.add(deletedFile);
        }
    }

    private SvnContentRevision createBeforeRevision(SvnChangedFile changedFile, boolean forDeleted) {
        return SvnContentRevision.createBaseRevision(this.myVcs, (FilePath)(forDeleted ? FilePathImpl.createForDeletedFile((File)changedFile.getStatus().getFile(), (boolean)changedFile.getFilePath().isDirectory()) : changedFile.getFilePath()), changedFile.getStatus().getRevision());
    }

    private static File guessWorkingCopyPath(File file, @NotNull SVNURL url, String copyFromURL) throws SVNException {
        int i;
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/svn/SvnChangeProvider", "guessWorkingCopyPath"));
        }
        String copiedPath = url.getPath();
        String copyFromPath = SVNURL.parseURIEncoded((String)copyFromURL).getPath();
        String commonPathAncestor = SVNPathUtil.getCommonPathAncestor((String)copiedPath, (String)copyFromPath);
        int pathSegmentCount = SVNPathUtil.getSegmentsCount((String)copiedPath);
        int ancestorSegmentCount = SVNPathUtil.getSegmentsCount((String)commonPathAncestor);
        boolean startsWithSlash = file.getAbsolutePath().startsWith("/");
        List segments = StringUtil.split((String)file.getPath(), (String)File.separator);
        List copyFromPathSegments = StringUtil.split((String)copyFromPath, (String)"/");
        ArrayList resultSegments = new ArrayList();
        int keepSegments = segments.size() - pathSegmentCount + ancestorSegmentCount;
        for (i = 0; i < keepSegments; ++i) {
            resultSegments.add(segments.get(i));
        }
        for (i = ancestorSegmentCount; i < copyFromPathSegments.size(); ++i) {
            resultSegments.add(copyFromPathSegments.get(i));
        }
        String result = StringUtil.join(resultSegments, (String)"/");
        if (startsWithSlash) {
            result = "/" + result;
        }
        return new File(result);
    }

    public boolean isModifiedDocumentTrackingRequired() {
        return true;
    }

    public void doCleanup(List<VirtualFile> files) {
        new CleanupWorker(VfsUtil.toVirtualFileArray(files), this.myVcs.getProject(), "action.Subversion.cleanup.progress.title").execute();
    }
}

