/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.continuation.ContinuationContext;
import com.intellij.util.continuation.Where;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationManager;
import org.jetbrains.idea.svn.integrate.BaseMergeTask;
import org.jetbrains.idea.svn.integrate.MergeContext;
import org.jetbrains.idea.svn.integrate.QuickMergeInteraction;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;

public class SourceUrlCorrectionTask
extends BaseMergeTask {
    public SourceUrlCorrectionTask(@NotNull MergeContext mergeContext, @NotNull QuickMergeInteraction interaction) {
        if (mergeContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeContext", "org/jetbrains/idea/svn/integrate/SourceUrlCorrectionTask", "<init>"));
        }
        if (interaction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interaction", "org/jetbrains/idea/svn/integrate/SourceUrlCorrectionTask", "<init>"));
        }
        super(mergeContext, interaction, "Checking branch", Where.POOLED);
    }

    public void run(ContinuationContext context) {
        String branchRelativePath;
        SVNURL branch = this.getWorkingBranch();
        if (branch != null && !this.isWorkingCopyRootUrl(branch) && !StringUtil.isEmpty((String)(branchRelativePath = SVNPathUtil.getRelativePath((String)branch.toString(), (String)this.myMergeContext.getWcInfo().getRootUrl())))) {
            this.myMergeContext.setSourceUrl(SVNPathUtil.append((String)this.myMergeContext.getSourceUrl(), (String)branchRelativePath));
        }
    }

    @Nullable
    private SVNURL getWorkingBranch() {
        return SvnBranchConfigurationManager.getInstance(this.myMergeContext.getProject()).getSvnBranchConfigManager().getWorkingBranchWithReload(this.myMergeContext.getWcInfo().getUrl(), this.myMergeContext.getRoot());
    }

    private boolean isWorkingCopyRootUrl(@NotNull SVNURL branch) {
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branch", "org/jetbrains/idea/svn/integrate/SourceUrlCorrectionTask", "isWorkingCopyRootUrl"));
        }
        return this.myMergeContext.getWcInfo().getUrl().equals((Object)branch);
    }
}

