/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.ide.todo.TodoPanelSettings;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.IgnoreSpaceEnum;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.util.PlatformUtils;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Property;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="VcsManagerConfiguration", storages={@Storage(file="$WORKSPACE_FILE$")})
public final class VcsConfiguration
implements PersistentStateComponent<VcsConfiguration> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.VcsConfiguration");
    public static final long ourMaximumFileForBaseRevisionSize = 500000L;
    @NonNls
    static final String VALUE_ATTR = "value";
    @NonNls
    public static final String PATCH = "patch";
    @NonNls
    public static final String DIFF = "diff";
    public boolean OFFER_MOVE_TO_ANOTHER_CHANGELIST_ON_PARTIAL_COMMIT = true;
    public boolean CHECK_CODE_SMELLS_BEFORE_PROJECT_COMMIT = !PlatformUtils.isPyCharm() && !PlatformUtils.isRubyMine();
    public boolean CHECK_CODE_CLEANUP_BEFORE_PROJECT_COMMIT = false;
    public boolean CHECK_NEW_TODO = true;
    public TodoPanelSettings myTodoPanelSettings = new TodoPanelSettings();
    public boolean PERFORM_UPDATE_IN_BACKGROUND = true;
    public boolean PERFORM_COMMIT_IN_BACKGROUND = true;
    public boolean PERFORM_EDIT_IN_BACKGROUND = true;
    public boolean PERFORM_CHECKOUT_IN_BACKGROUND = true;
    public boolean PERFORM_ADD_REMOVE_IN_BACKGROUND = true;
    public boolean PERFORM_ROLLBACK_IN_BACKGROUND = false;
    public volatile boolean CHECK_LOCALLY_CHANGED_CONFLICTS_IN_BACKGROUND = false;
    @OptionTag(tag="confirmMoveToFailedCommit", nameAttribute="")
    public VcsShowConfirmationOption.Value MOVE_TO_FAILED_COMMIT_CHANGELIST = VcsShowConfirmationOption.Value.SHOW_CONFIRMATION;
    @OptionTag(tag="confirmRemoveEmptyChangelist", nameAttribute="")
    public VcsShowConfirmationOption.Value REMOVE_EMPTY_INACTIVE_CHANGELISTS = VcsShowConfirmationOption.Value.SHOW_CONFIRMATION;
    public int CHANGED_ON_SERVER_INTERVAL = 60;
    public boolean SHOW_ONLY_CHANGED_IN_SELECTION_DIFF = true;
    public boolean CHECK_COMMIT_MESSAGE_SPELLING = true;
    public String DEFAULT_PATCH_EXTENSION = "patch";
    public boolean SHORT_DIFF_HORIZONTALLY = true;
    public int SHORT_DIFF_EXTRA_LINES = 2;
    public boolean SOFT_WRAPS_IN_SHORT_DIFF = true;
    public IgnoreSpaceEnum SHORT_DIFF_IGNORE_SPACE = IgnoreSpaceEnum.NO;
    public boolean INCLUDE_TEXT_INTO_PATCH = false;
    public boolean INCLUDE_TEXT_INTO_SHELF = false;
    public Boolean SHOW_PATCH_IN_EXPLORER = null;
    public boolean SHOW_FILE_HISTORY_DETAILS = true;
    public boolean SHOW_VCS_ERROR_NOTIFICATIONS = true;
    public boolean SHOW_DIRTY_RECURSIVELY = false;
    public boolean LIMIT_HISTORY = true;
    public int MAXIMUM_HISTORY_ROWS = 1000;
    public String UPDATE_FILTER_SCOPE_NAME = null;
    public boolean USE_COMMIT_MESSAGE_MARGIN = false;
    public int COMMIT_MESSAGE_MARGIN_SIZE = 72;
    public boolean WRAP_WHEN_TYPING_REACHES_RIGHT_MARGIN = false;
    public boolean FORCE_NON_EMPTY_COMMENT = false;
    public boolean CLEAR_INITIAL_COMMIT_MESSAGE = false;
    @Property(surroundWithTag=false)
    @AbstractCollection(elementTag="MESSAGE", elementValueAttribute="value", surroundWithTag=false)
    public List<String> myLastCommitMessages = new ArrayList<String>();
    public String LAST_COMMIT_MESSAGE = null;
    public boolean MAKE_NEW_CHANGELIST_ACTIVE = false;
    public boolean OPTIMIZE_IMPORTS_BEFORE_PROJECT_COMMIT = false;
    public boolean CHECK_FILES_UP_TO_DATE_BEFORE_COMMIT = false;
    public boolean REFORMAT_BEFORE_PROJECT_COMMIT = false;
    public boolean REFORMAT_BEFORE_FILE_COMMIT = false;
    public boolean REARRANGE_BEFORE_PROJECT_COMMIT = false;
    public Map<String, ChangeBrowserSettings> CHANGE_BROWSER_SETTINGS = new HashMap<String, ChangeBrowserSettings>();
    public float FILE_HISTORY_DIALOG_COMMENTS_SPLITTER_PROPORTION = 0.8f;
    public float FILE_HISTORY_DIALOG_SPLITTER_PROPORTION = 0.5f;
    public boolean UPDATE_GROUP_BY_PACKAGES = false;
    public boolean UPDATE_GROUP_BY_CHANGELIST = false;
    public boolean UPDATE_FILTER_BY_SCOPE = false;
    public boolean SHOW_FILE_HISTORY_AS_TREE = false;
    public float FILE_HISTORY_SPLITTER_PROPORTION = 0.6f;
    private static final int MAX_STORED_MESSAGES = 25;
    @NonNls
    static final String MESSAGE_ELEMENT_NAME = "MESSAGE";
    private final PerformInBackgroundOption myUpdateOption = new UpdateInBackgroundOption();
    private final PerformInBackgroundOption myCommitOption = new CommitInBackgroundOption();
    private final PerformInBackgroundOption myEditOption = new EditInBackgroundOption();
    private final PerformInBackgroundOption myCheckoutOption = new CheckoutInBackgroundOption();
    private final PerformInBackgroundOption myAddRemoveOption = new AddRemoveInBackgroundOption();

    @Override
    public VcsConfiguration getState() {
        return this;
    }

    @Override
    public void loadState(VcsConfiguration state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    public static VcsConfiguration getInstance(Project project) {
        return ServiceManager.getService(project, VcsConfiguration.class);
    }

    public void saveCommitMessage(String comment) {
        this.LAST_COMMIT_MESSAGE = comment;
        if (comment == null || comment.length() == 0) {
            return;
        }
        this.myLastCommitMessages.remove(comment);
        while (this.myLastCommitMessages.size() >= 25) {
            this.myLastCommitMessages.remove(0);
        }
        this.myLastCommitMessages.add(comment);
    }

    public String getLastNonEmptyCommitMessage() {
        if (this.myLastCommitMessages.isEmpty()) {
            return null;
        }
        return this.myLastCommitMessages.get(this.myLastCommitMessages.size() - 1);
    }

    @NotNull
    public ArrayList<String> getRecentMessages() {
        ArrayList<String> arrayList = new ArrayList<String>(this.myLastCommitMessages);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/VcsConfiguration", "getRecentMessages"));
        }
        return arrayList;
    }

    public void removeMessage(String content) {
        this.myLastCommitMessages.remove(content);
    }

    public PerformInBackgroundOption getUpdateOption() {
        return this.myUpdateOption;
    }

    public PerformInBackgroundOption getCommitOption() {
        return this.myCommitOption;
    }

    public PerformInBackgroundOption getEditOption() {
        return this.myEditOption;
    }

    public PerformInBackgroundOption getCheckoutOption() {
        return this.myCheckoutOption;
    }

    public PerformInBackgroundOption getAddRemoveOption() {
        return this.myAddRemoveOption;
    }

    public String getPatchFileExtension() {
        return this.DEFAULT_PATCH_EXTENSION;
    }

    public void acceptLastCreatedPatchName(String string) {
        if (StringUtil.isEmptyOrSpaces((String)string)) {
            return;
        }
        if (FileUtilRt.extensionEquals((String)string, (String)DIFF)) {
            this.DEFAULT_PATCH_EXTENSION = DIFF;
        } else if (FileUtilRt.extensionEquals((String)string, (String)PATCH)) {
            this.DEFAULT_PATCH_EXTENSION = PATCH;
        }
    }

    public boolean isChangedOnServerEnabled() {
        return this.CHECK_LOCALLY_CHANGED_CONFLICTS_IN_BACKGROUND;
    }

    private class AddRemoveInBackgroundOption
    implements PerformInBackgroundOption {
        private AddRemoveInBackgroundOption() {
        }

        @Override
        public boolean shouldStartInBackground() {
            return VcsConfiguration.this.PERFORM_ADD_REMOVE_IN_BACKGROUND;
        }

        @Override
        public void processSentToBackground() {
            VcsConfiguration.this.PERFORM_ADD_REMOVE_IN_BACKGROUND = true;
        }
    }

    private class CheckoutInBackgroundOption
    implements PerformInBackgroundOption {
        private CheckoutInBackgroundOption() {
        }

        @Override
        public boolean shouldStartInBackground() {
            return VcsConfiguration.this.PERFORM_CHECKOUT_IN_BACKGROUND;
        }

        @Override
        public void processSentToBackground() {
            VcsConfiguration.this.PERFORM_CHECKOUT_IN_BACKGROUND = true;
        }
    }

    private class EditInBackgroundOption
    implements PerformInBackgroundOption {
        private EditInBackgroundOption() {
        }

        @Override
        public boolean shouldStartInBackground() {
            return VcsConfiguration.this.PERFORM_EDIT_IN_BACKGROUND;
        }

        @Override
        public void processSentToBackground() {
            VcsConfiguration.this.PERFORM_EDIT_IN_BACKGROUND = true;
        }
    }

    private class CommitInBackgroundOption
    implements PerformInBackgroundOption {
        private CommitInBackgroundOption() {
        }

        @Override
        public boolean shouldStartInBackground() {
            return VcsConfiguration.this.PERFORM_COMMIT_IN_BACKGROUND;
        }

        @Override
        public void processSentToBackground() {
        }
    }

    private class UpdateInBackgroundOption
    implements PerformInBackgroundOption {
        private UpdateInBackgroundOption() {
        }

        @Override
        public boolean shouldStartInBackground() {
            return VcsConfiguration.this.PERFORM_UPDATE_IN_BACKGROUND;
        }

        @Override
        public void processSentToBackground() {
        }
    }

    public static enum StandardConfirmation {
        ADD(VcsBundle.message("vcs.command.name.add", new Object[0])),
        REMOVE(VcsBundle.message("vcs.command.name.remove", new Object[0]));

        private final String myId;

        private StandardConfirmation(String id) {
            this.myId = id;
        }

        public String getId() {
            return this.myId;
        }
    }

    public static enum StandardOption {
        ADD(VcsBundle.message("vcs.command.name.add", new Object[0])),
        REMOVE(VcsBundle.message("vcs.command.name.remove", new Object[0])),
        EDIT(VcsBundle.message("vcs.command.name.edit", new Object[0])),
        CHECKOUT(VcsBundle.message("vcs.command.name.checkout", new Object[0])),
        STATUS(VcsBundle.message("vcs.command.name.status", new Object[0])),
        UPDATE(VcsBundle.message("vcs.command.name.update", new Object[0]));

        private final String myId;

        private StandardOption(String id) {
            this.myId = id;
        }

        public String getId() {
            return this.myId;
        }
    }
}

