/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usageView;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiQualifiedReferenceElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartPsiFileRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UsageInfo {
    public static final UsageInfo[] EMPTY_ARRAY = new UsageInfo[0];
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.usageView.UsageInfo");
    private final SmartPsiElementPointer<?> mySmartPointer;
    private final SmartPsiFileRange myPsiFileRange;
    public final boolean isNonCodeUsage;
    protected boolean myDynamicUsage;

    public UsageInfo(@NotNull PsiElement element, int startOffset, int endOffset, boolean isNonCodeUsage) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/usageView/UsageInfo", "<init>"));
        }
        this.myDynamicUsage = false;
        element = element.getNavigationElement();
        PsiFile file = element.getContainingFile();
        PsiElement topElement = file == null ? element : file;
        LOG.assertTrue(topElement.isValid(), (Object)element);
        TextRange elementRange = element.getTextRange();
        if (elementRange == null) {
            throw new IllegalArgumentException("text range null for " + element + "; " + element.getClass());
        }
        if (startOffset == -1 && endOffset == -1) {
            startOffset = element.getTextOffset() - elementRange.getStartOffset();
            endOffset = elementRange.getEndOffset() - elementRange.getStartOffset();
        }
        if (startOffset < 0) {
            throw new IllegalArgumentException("element " + element + "; startOffset " + startOffset);
        }
        if (startOffset > endOffset) {
            throw new IllegalArgumentException("element " + element + "; diff " + (endOffset - startOffset));
        }
        Project project = topElement.getProject();
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance(project);
        this.mySmartPointer = smartPointerManager.createSmartPsiElementPointer(element, file);
        if (startOffset != element.getTextOffset() - elementRange.getStartOffset() || endOffset != elementRange.getLength()) {
            TextRange rangeToStore = file != null && InjectedLanguageManager.getInstance(project).isInjectedFragment(file) ? elementRange : TextRange.create((int)startOffset, (int)endOffset).shiftRight(elementRange.getStartOffset());
            this.myPsiFileRange = smartPointerManager.createSmartPsiFileRangePointer(file, rangeToStore);
        } else {
            this.myPsiFileRange = null;
        }
        this.isNonCodeUsage = isNonCodeUsage;
    }

    public UsageInfo(@NotNull SmartPsiElementPointer<?> smartPointer, SmartPsiFileRange psiFileRange, boolean dynamicUsage, boolean nonCodeUsage) {
        if (smartPointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "smartPointer", "com/intellij/usageView/UsageInfo", "<init>"));
        }
        this.myDynamicUsage = false;
        this.myDynamicUsage = dynamicUsage;
        this.isNonCodeUsage = nonCodeUsage;
        this.myPsiFileRange = psiFileRange;
        this.mySmartPointer = smartPointer;
    }

    @NotNull
    public SmartPsiElementPointer<?> getSmartPointer() {
        SmartPsiElementPointer<?> smartPsiElementPointer = this.mySmartPointer;
        if (smartPsiElementPointer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usageView/UsageInfo", "getSmartPointer"));
        }
        return smartPsiElementPointer;
    }

    public SmartPsiFileRange getPsiFileRange() {
        return this.myPsiFileRange;
    }

    public boolean isNonCodeUsage() {
        return this.isNonCodeUsage;
    }

    public void setDynamicUsage(boolean dynamicUsage) {
        this.myDynamicUsage = dynamicUsage;
    }

    public UsageInfo(@NotNull PsiElement element, boolean isNonCodeUsage) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/usageView/UsageInfo", "<init>"));
        }
        this(element, -1, -1, isNonCodeUsage);
    }

    public UsageInfo(@NotNull PsiElement element, int startOffset, int endOffset) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/usageView/UsageInfo", "<init>"));
        }
        this(element, startOffset, endOffset, false);
    }

    public UsageInfo(@NotNull PsiReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/usageView/UsageInfo", "<init>"));
        }
        this(reference.getElement(), reference.getRangeInElement().getStartOffset(), reference.getRangeInElement().getEndOffset());
        this.myDynamicUsage = reference.resolve() == null;
    }

    public UsageInfo(@NotNull PsiQualifiedReferenceElement reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/usageView/UsageInfo", "<init>"));
        }
        this((PsiElement)reference);
    }

    public UsageInfo(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/usageView/UsageInfo", "<init>"));
        }
        this(element, false);
    }

    @Nullable
    public PsiElement getElement() {
        return this.mySmartPointer.getElement();
    }

    @Nullable
    public PsiReference getReference() {
        PsiElement element = this.getElement();
        return element == null ? null : element.getReference();
    }

    public TextRange getRange() {
        return this.getRangeInElement();
    }

    @Nullable(value="null means range is invalid")
    public ProperTextRange getRangeInElement() {
        ProperTextRange result;
        PsiElement element = this.getElement();
        if (element == null) {
            return null;
        }
        TextRange elementRange = element.getTextRange();
        if (this.myPsiFileRange == null) {
            int startOffset = element.getTextOffset();
            result = ProperTextRange.create((int)startOffset, (int)elementRange.getEndOffset());
        } else {
            Segment rangeInFile = this.myPsiFileRange.getRange();
            if (rangeInFile == null) {
                return null;
            }
            result = ProperTextRange.create((Segment)rangeInFile);
        }
        int delta = elementRange.getStartOffset();
        return result.getStartOffset() < delta ? null : result.shiftRight(-delta);
    }

    public String getTooltipText() {
        return null;
    }

    public int getNavigationOffset() {
        Segment range;
        if (this.myPsiFileRange != null && (range = this.myPsiFileRange.getRange()) != null) {
            return range.getStartOffset();
        }
        PsiElement element = this.getElement();
        if (element == null) {
            return -1;
        }
        TextRange range2 = element.getTextRange();
        ProperTextRange rangeInElement = this.getRangeInElement();
        if (rangeInElement == null) {
            return -1;
        }
        return range2.getStartOffset() + rangeInElement.getStartOffset();
    }

    public boolean isValid() {
        return this.getSegment() != null;
    }

    @Nullable
    public Segment getSegment() {
        ProperTextRange rangeInElement;
        Document document;
        PsiElement element = this.getElement();
        if (element == null) {
            return null;
        }
        TextRange range = element.getTextRange();
        TextRange.assertProperRange((Segment)range, (Object)element);
        if (element instanceof PsiFile && (document = PsiDocumentManager.getInstance(this.getProject()).getDocument((PsiFile)element)) != null) {
            range = new ProperTextRange(0, document.getTextLength());
        }
        if ((rangeInElement = this.getRangeInElement()) == null) {
            return null;
        }
        return new ProperTextRange(Math.min(range.getEndOffset(), range.getStartOffset() + rangeInElement.getStartOffset()), Math.min(range.getEndOffset(), range.getStartOffset() + rangeInElement.getEndOffset()));
    }

    @NotNull
    public Project getProject() {
        Project project = this.mySmartPointer.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usageView/UsageInfo", "getProject"));
        }
        return project;
    }

    public final boolean isWritable() {
        PsiElement element = this.getElement();
        return element == null || element.isWritable();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        UsageInfo usageInfo = (UsageInfo)o;
        if (this.isNonCodeUsage != usageInfo.isNonCodeUsage) {
            return false;
        }
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance(this.getProject());
        return smartPointerManager.pointToTheSameElement(this.mySmartPointer, usageInfo.mySmartPointer) && (this.myPsiFileRange == null || usageInfo.myPsiFileRange != null && smartPointerManager.pointToTheSameElement(this.myPsiFileRange, usageInfo.myPsiFileRange));
    }

    public int hashCode() {
        int result = this.mySmartPointer != null ? this.mySmartPointer.hashCode() : 0;
        result = 29 * result + (this.myPsiFileRange == null ? 0 : this.myPsiFileRange.hashCode());
        result = 29 * result + (this.isNonCodeUsage ? 1 : 0);
        return result;
    }

    public String toString() {
        PsiReference reference = this.getReference();
        if (reference == null) {
            return super.toString();
        }
        return reference.getCanonicalText() + " (" + reference.getClass() + ")";
    }

    @Nullable
    public PsiFile getFile() {
        return this.mySmartPointer.getContainingFile();
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return this.mySmartPointer.getVirtualFile();
    }

    public boolean isDynamicUsage() {
        return this.myDynamicUsage;
    }

    @Nullable(value="null means could not copy because info is no longer valid")
    public UsageInfo copy() {
        Object element = this.mySmartPointer.getElement();
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance(this.getProject());
        PsiFile containingFile = this.myPsiFileRange == null ? null : this.myPsiFileRange.getContainingFile();
        Segment segment = containingFile == null ? null : this.myPsiFileRange.getRange();
        TextRange range = segment == null ? null : TextRange.create((Segment)segment);
        SmartPsiFileRange psiFileRange = range == null ? null : smartPointerManager.createSmartPsiFileRangePointer(containingFile, range);
        SmartPsiElementPointer<?> pointer = element == null || !this.isValid() ? null : smartPointerManager.createSmartPsiElementPointer(element);
        return pointer == null ? null : new UsageInfo(pointer, psiFileRange, this.isDynamicUsage(), this.isNonCodeUsage());
    }
}

