/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.FileEditorProvider;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.newStructureView.StructureViewComponent;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.ChooseSubsequentPropertyValueEditorAction;
import com.intellij.lang.properties.editor.NoPropertySelectedPanel;
import com.intellij.lang.properties.editor.PropertiesValueHighlighter;
import com.intellij.lang.properties.editor.ResourceBundleEditorViewElement;
import com.intellij.lang.properties.editor.ResourceBundlePropertyStructureViewElement;
import com.intellij.lang.properties.editor.ResourceBundleStructureViewComponent;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.PropertiesResourceBundleUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.Stack;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.Scrollable;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceBundleEditor
extends UserDataHolderBase
implements FileEditor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.properties.editor.ResourceBundleEditor");
    @NonNls
    private static final String VALUES = "values";
    @NonNls
    private static final String NO_PROPERTY_SELECTED = "noPropertySelected";
    private final StructureViewComponent myStructureViewComponent;
    private final Map<PropertiesFile, Editor> myEditors;
    private final ResourceBundle myResourceBundle;
    private final Map<PropertiesFile, JPanel> myTitledPanels;
    private final JComponent myNoPropertySelectedPanel;
    private final Project myProject;
    private final DataProviderPanel myDataProviderPanel;
    private final Set<PropertiesFile> myBackSlashPressed;
    private final Alarm mySelectionChangeAlarm;
    private JPanel myValuesPanel;
    private JPanel myStructureViewPanel;
    private boolean myDisposed;
    private VirtualFileListener myVfsListener;
    private Editor mySelectedEditor;

    public ResourceBundleEditor(@NotNull ResourceBundle resourceBundle) {
        if (resourceBundle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceBundle", "com/intellij/lang/properties/editor/ResourceBundleEditor", "<init>"));
        }
        this.myNoPropertySelectedPanel = new NoPropertySelectedPanel().getComponent();
        this.myBackSlashPressed = new THashSet();
        this.mySelectionChangeAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.myProject = resourceBundle.getProject();
        JPanel splitPanel = new JPanel();
        this.myValuesPanel = new JPanel();
        this.myStructureViewPanel = new JPanel();
        JBSplitter splitter = new JBSplitter(false);
        splitter.setFirstComponent((JComponent)this.myStructureViewPanel);
        splitter.setSecondComponent((JComponent)this.myValuesPanel);
        splitter.setShowDividerControls(true);
        splitter.setHonorComponentsMinimumSize(true);
        splitter.setAndLoadSplitterProportionKey(((Object)((Object)this)).getClass() + ".splitter");
        splitPanel.setLayout(new BorderLayout());
        splitPanel.add((Component)splitter, "Center");
        this.myResourceBundle = resourceBundle;
        this.myStructureViewComponent = new ResourceBundleStructureViewComponent(this.myResourceBundle, this);
        this.myStructureViewPanel.setLayout(new BorderLayout());
        this.myStructureViewPanel.add((Component)this.myStructureViewComponent, "Center");
        this.myStructureViewComponent.getTree().getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){
            private IProperty selectedProperty;
            private PropertiesFile selectedPropertiesFile;

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (Comparing.equal((Object)e.getNewLeadSelectionPath(), (Object)e.getOldLeadSelectionPath()) || ResourceBundleEditor.this.getSelectedProperty() == null) {
                    return;
                }
                if (!this.arePropertiesEquivalent(this.selectedProperty, ResourceBundleEditor.this.getSelectedProperty()) || !Comparing.equal((Object)this.selectedPropertiesFile, (Object)ResourceBundleEditor.this.getSelectedPropertiesFile())) {
                    if (e.getOldLeadSelectionPath() != null) {
                        for (Map.Entry entry : ResourceBundleEditor.this.myEditors.entrySet()) {
                            if (entry.getValue() != ResourceBundleEditor.this.mySelectedEditor) continue;
                            ResourceBundleEditor.this.writeEditorPropertyValue(ResourceBundleEditor.this.mySelectedEditor, (PropertiesFile)entry.getKey(), this.selectedProperty.getName());
                            break;
                        }
                    }
                    this.selectedProperty = ResourceBundleEditor.this.getSelectedProperty();
                    this.selectedPropertiesFile = ResourceBundleEditor.this.getSelectedPropertiesFile();
                    ResourceBundleEditor.this.selectionChanged();
                }
            }

            private boolean arePropertiesEquivalent(@Nullable IProperty p1, @Nullable IProperty p2) {
                if (p1 == p2) {
                    return true;
                }
                if (p1 == null || p2 == null) {
                    return false;
                }
                return p1.getPsiElement().isEquivalentTo(p2.getPsiElement());
            }
        });
        this.installPropertiesChangeListeners();
        this.myEditors = new THashMap();
        this.myTitledPanels = new THashMap();
        this.recreateEditorsPanel();
        TreeElement[] children = this.myStructureViewComponent.getTreeModel().getRoot().getChildren();
        if (children.length != 0) {
            TreeElement child = children[0];
            String propName = ((ResourceBundlePropertyStructureViewElement)child).getProperty().getUnescapedKey();
            this.setState(new ResourceBundleEditorState(propName));
        }
        this.myDataProviderPanel = new DataProviderPanel(splitPanel);
        this.myProject.getMessageBus().connect((Disposable)this.myProject).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerAdapter(){

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/properties/editor/ResourceBundleEditor$2", "selectionChanged"));
                }
                ResourceBundleEditor.this.onSelectionChanged(event);
            }
        });
    }

    public ResourceBundle getResourceBundle() {
        return this.myResourceBundle;
    }

    private void onSelectionChanged(@NotNull FileEditorManagerEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/properties/editor/ResourceBundleEditor", "onSelectionChanged"));
        }
        FileEditor oldEditor = event.getOldEditor();
        FileEditor newEditor = event.getNewEditor();
        if (oldEditor != this && newEditor != this) {
            return;
        }
        if (newEditor == this) {
            if (oldEditor instanceof TextEditor) {
                this.setStructureViewSelectionFromPropertiesFile(((TextEditor)oldEditor).getEditor());
            }
        } else if (newEditor instanceof TextEditor) {
            this.setPropertiesFileSelectionFromStructureView(((TextEditor)newEditor).getEditor());
        }
    }

    private void setStructureViewSelectionFromPropertiesFile(@NotNull Editor propertiesFileEditor) {
        if (propertiesFileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesFileEditor", "com/intellij/lang/properties/editor/ResourceBundleEditor", "setStructureViewSelectionFromPropertiesFile"));
        }
        int line = propertiesFileEditor.getCaretModel().getLogicalPosition().line;
        Document document = propertiesFileEditor.getDocument();
        if (line >= document.getLineCount()) {
            return;
        }
        String propertyName = ResourceBundleEditor.getPropertyName(document, line);
        if (propertyName == null) {
            return;
        }
        this.setStructureViewSelection(propertyName);
    }

    private void setStructureViewSelection(final @NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/lang/properties/editor/ResourceBundleEditor", "setStructureViewSelection"));
        }
        if (this.myStructureViewComponent.isDisposed()) {
            return;
        }
        JTree tree = this.myStructureViewComponent.getTree();
        if (tree == null) {
            return;
        }
        Object root = tree.getModel().getRoot();
        if (AbstractTreeUi.isLoadingChildrenFor((Object)root)) {
            this.mySelectionChangeAlarm.cancelAllRequests();
            this.mySelectionChangeAlarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    ResourceBundleEditor.this.mySelectionChangeAlarm.cancelAllRequests();
                    ResourceBundleEditor.this.setStructureViewSelection(propertyName);
                }
            }, 500);
            return;
        }
        Stack toCheck = ContainerUtilRt.newStack();
        toCheck.push((Object)((DefaultMutableTreeNode)root));
        DefaultMutableTreeNode nodeToSelect = null;
        while (!toCheck.isEmpty()) {
            String value;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)toCheck.pop();
            ResourceBundleEditorViewElement element = ResourceBundleEditor.getSelectedElement(node);
            String string = value = element instanceof ResourceBundlePropertyStructureViewElement ? ((ResourceBundlePropertyStructureViewElement)element).getProperty().getUnescapedKey() : null;
            if (propertyName.equals(value)) {
                nodeToSelect = node;
                break;
            }
            for (int i = 0; i < node.getChildCount(); ++i) {
                toCheck.push((Object)((DefaultMutableTreeNode)node.getChildAt(i)));
            }
        }
        if (nodeToSelect != null) {
            TreePath path = new TreePath(nodeToSelect.getPath());
            tree.setSelectionPath(path);
            tree.scrollPathToVisible(path);
        }
    }

    @Nullable
    private static String getPropertyName(@NotNull Document document, int line) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/properties/editor/ResourceBundleEditor", "getPropertyName"));
        }
        int startOffset = document.getLineStartOffset(line);
        int endOffset = StringUtil.indexOf((CharSequence)document.getCharsSequence(), (char)'=', (int)startOffset, (int)document.getLineEndOffset(line));
        if (endOffset <= startOffset) {
            return null;
        }
        String propertyName = ((Object)document.getCharsSequence().subSequence(startOffset, endOffset)).toString().trim();
        return propertyName.isEmpty() ? null : propertyName;
    }

    private void setPropertiesFileSelectionFromStructureView(@NotNull Editor propertiesFileEditor) {
        if (propertiesFileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesFileEditor", "com/intellij/lang/properties/editor/ResourceBundleEditor", "setPropertiesFileSelectionFromStructureView"));
        }
        String selectedPropertyName = this.getSelectedPropertyName();
        if (selectedPropertyName == null) {
            return;
        }
        Document document = propertiesFileEditor.getDocument();
        for (int i = 0; i < document.getLineCount(); ++i) {
            String propertyName = ResourceBundleEditor.getPropertyName(document, i);
            if (!selectedPropertyName.equals(propertyName)) continue;
            propertiesFileEditor.getCaretModel().moveToLogicalPosition(new LogicalPosition(i, 0));
            return;
        }
    }

    @Nullable
    private static ResourceBundleEditorViewElement getSelectedElement(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/properties/editor/ResourceBundleEditor", "getSelectedElement"));
        }
        Object userObject = node.getUserObject();
        if (!(userObject instanceof AbstractTreeNode)) {
            return null;
        }
        Object value = ((AbstractTreeNode)userObject).getValue();
        return value instanceof ResourceBundleEditorViewElement ? (ResourceBundleEditorViewElement)value : null;
    }

    private void writeEditorPropertyValue(Editor editor, final PropertiesFile propertiesFile, @Nullable String propertyName) {
        String currentSelectedProperty;
        final String currentValue = editor.getDocument().getText();
        String string = currentSelectedProperty = propertyName == null ? this.getSelectedPropertyName() : propertyName;
        if (currentSelectedProperty == null) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                WriteCommandAction.runWriteCommandAction((Project)ResourceBundleEditor.this.myProject, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        IProperty property = propertiesFile.findPropertyByKey(currentSelectedProperty);
                        try {
                            if (property == null) {
                                propertiesFile.addProperty(currentSelectedProperty, currentValue);
                            } else {
                                property.setValue(currentValue);
                            }
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                });
            }
        });
    }

    private void recreateEditorsPanel() {
        this.myValuesPanel.removeAll();
        this.myValuesPanel.setLayout(new CardLayout());
        if (!this.myProject.isOpen()) {
            return;
        }
        MyJPanel valuesPanelComponent = new MyJPanel(new GridBagLayout());
        this.myValuesPanel.add((Component)new JBScrollPane(valuesPanelComponent){

            public void updateUI() {
                super.updateUI();
                this.getViewport().setBackground(UIUtil.getPanelBackground());
            }
        }, VALUES);
        this.myValuesPanel.add((Component)this.myNoPropertySelectedPanel, NO_PROPERTY_SELECTED);
        List<PropertiesFile> propertiesFiles = this.myResourceBundle.getPropertiesFiles();
        GridBagConstraints gc = new GridBagConstraints(0, 0, 0, 0, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0);
        this.releaseAllEditors();
        this.myTitledPanels.clear();
        int y = 0;
        Editor previousEditor = null;
        Editor firstEditor = null;
        for (final PropertiesFile propertiesFile : propertiesFiles) {
            final Editor editor = ResourceBundleEditor.createEditor();
            Editor oldEditor = this.myEditors.put(propertiesFile, editor);
            if (firstEditor == null) {
                firstEditor = editor;
            }
            if (previousEditor != null) {
                editor.putUserData(ChooseSubsequentPropertyValueEditorAction.PREV_EDITOR_KEY, (Object)previousEditor);
                previousEditor.putUserData(ChooseSubsequentPropertyValueEditorAction.NEXT_EDITOR_KEY, (Object)editor);
            }
            previousEditor = editor;
            if (oldEditor != null) {
                EditorFactory.getInstance().releaseEditor(oldEditor);
            }
            ((EditorEx)editor).addFocusListener(new FocusChangeListener(){

                public void focusGained(Editor editor2) {
                    ResourceBundleEditor.this.mySelectedEditor = editor2;
                }

                public void focusLost(Editor eventEditor) {
                    ResourceBundleEditor.this.writeEditorPropertyValue(editor, propertiesFile, null);
                }
            });
            editor.getDocument().putUserData(UndoConstants.DONT_RECORD_UNDO, (Object)Boolean.TRUE);
            gc.gridx = 0;
            gc.gridy = y++;
            gc.gridheight = 1;
            gc.gridwidth = 0;
            gc.weightx = 1.0;
            gc.weighty = 1.0;
            gc.anchor = 10;
            Locale locale = propertiesFile.getLocale();
            ArrayList<String> names = new ArrayList<String>();
            if (!Comparing.strEqual((String)locale.getDisplayLanguage(), null)) {
                names.add(locale.getDisplayLanguage());
            }
            if (!Comparing.strEqual((String)locale.getDisplayCountry(), null)) {
                names.add(locale.getDisplayCountry());
            }
            if (!Comparing.strEqual((String)locale.getDisplayVariant(), null)) {
                names.add(locale.getDisplayVariant());
            }
            String title = propertiesFile.getName();
            if (!names.isEmpty()) {
                title = title + " (" + StringUtil.join(names, (String)"/") + ")";
            }
            JPanel comp = new JPanel(new BorderLayout()){

                @Override
                public Dimension getPreferredSize() {
                    Insets insets = this.getBorder().getBorderInsets(this);
                    return new Dimension(100, editor.getLineHeight() * 4 + insets.top + insets.bottom);
                }
            };
            comp.add((Component)editor.getComponent(), "Center");
            comp.setBorder((Border)IdeBorderFactory.createTitledBorder((String)title, (boolean)true));
            this.myTitledPanels.put(propertiesFile, comp);
            valuesPanelComponent.add((Component)comp, gc);
        }
        if (previousEditor != null) {
            previousEditor.putUserData(ChooseSubsequentPropertyValueEditorAction.NEXT_EDITOR_KEY, firstEditor);
            firstEditor.putUserData(ChooseSubsequentPropertyValueEditorAction.PREV_EDITOR_KEY, previousEditor);
        }
        gc.gridx = 0;
        gc.gridy = y;
        gc.gridheight = 0;
        gc.gridwidth = 0;
        gc.weightx = 10.0;
        gc.weighty = 1.0;
        valuesPanelComponent.add((Component)new JPanel(), gc);
        this.selectionChanged();
        this.myValuesPanel.repaint();
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                ResourceBundleEditor.this.updateEditorsFromProperties();
            }
        });
    }

    @NotNull
    public static String getPropertyEditorValue(@Nullable IProperty property) {
        if (property == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundleEditor", "getPropertyEditorValue"));
            }
            return "";
        }
        String rawValue = property.getValue();
        String string = rawValue == null ? "" : PropertiesResourceBundleUtil.fromPropertyValueToValueEditor(rawValue);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundleEditor", "getPropertyEditorValue"));
        }
        return string;
    }

    private void updateEditorsFromProperties() {
        String propertyName = this.getSelectedPropertyName();
        ((CardLayout)this.myValuesPanel.getLayout()).show(this.myValuesPanel, propertyName == null ? NO_PROPERTY_SELECTED : VALUES);
        if (propertyName == null) {
            return;
        }
        for (PropertiesFile propertiesFile : this.myResourceBundle.getPropertiesFiles(this.myProject)) {
            EditorEx editor = (EditorEx)this.myEditors.get(propertiesFile);
            if (editor == null) continue;
            final IProperty property = propertiesFile.findPropertyByKey(propertyName);
            DocumentEx document = editor.getDocument();
            CommandProcessor.getInstance().executeCommand(null, new Runnable((Document)document, propertiesFile){
                final /* synthetic */ Document val$document;
                final /* synthetic */ PropertiesFile val$propertiesFile;
                {
                    this.val$document = document;
                    this.val$propertiesFile = propertiesFile;
                }

                @Override
                public void run() {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            ResourceBundleEditor.this.updateDocumentFromPropertyValue(ResourceBundleEditor.getPropertyEditorValue(property), val$document, val$propertiesFile);
                        }
                    });
                }
            }, "", (Object)this);
            JPanel titledPanel = this.myTitledPanels.get(propertiesFile);
            ((TitledBorder)titledPanel.getBorder()).setTitleColor((Color)(property == null ? JBColor.RED : UIUtil.getLabelTextForeground()));
            titledPanel.repaint();
        }
    }

    private void installPropertiesChangeListeners() {
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        if (this.myVfsListener != null) {
            assert (false);
            virtualFileManager.removeVirtualFileListener(this.myVfsListener);
        }
        this.myVfsListener = new VirtualFileAdapter(){

            public void fileCreated(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/properties/editor/ResourceBundleEditor$10", "fileCreated"));
                }
                if (PropertiesImplUtil.isPropertiesFile(event.getFile(), ResourceBundleEditor.this.myProject)) {
                    ResourceBundleEditor.this.recreateEditorsPanel();
                }
            }

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/properties/editor/ResourceBundleEditor$10", "fileDeleted"));
                }
                for (PropertiesFile file : ResourceBundleEditor.this.myEditors.keySet()) {
                    if (!Comparing.equal((Object)file.getVirtualFile(), (Object)event.getFile())) continue;
                    ResourceBundleEditor.this.recreateEditorsPanel();
                    return;
                }
            }

            public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/properties/editor/ResourceBundleEditor$10", "propertyChanged"));
                }
                if (PropertiesImplUtil.isPropertiesFile(event.getFile(), ResourceBundleEditor.this.myProject)) {
                    if ("name".equals(event.getPropertyName())) {
                        ResourceBundleEditor.this.recreateEditorsPanel();
                    } else {
                        ResourceBundleEditor.this.updateEditorsFromProperties();
                    }
                }
            }
        };
        virtualFileManager.addVirtualFileListener(this.myVfsListener, (Disposable)this);
        PsiTreeChangeAdapter psiTreeChangeAdapter = new PsiTreeChangeAdapter(){

            public void childAdded(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/properties/editor/ResourceBundleEditor$11", "childAdded"));
                }
                this.childrenChanged(event);
            }

            public void childRemoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/properties/editor/ResourceBundleEditor$11", "childRemoved"));
                }
                this.childrenChanged(event);
            }

            public void childReplaced(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/properties/editor/ResourceBundleEditor$11", "childReplaced"));
                }
                this.childrenChanged(event);
            }

            public void childMoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/properties/editor/ResourceBundleEditor$11", "childMoved"));
                }
                this.childrenChanged(event);
            }

            public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/properties/editor/ResourceBundleEditor$11", "childrenChanged"));
                }
                PsiFile file = event.getFile();
                PropertiesFile propertiesFile = PropertiesImplUtil.getPropertiesFile(file);
                if (propertiesFile == null) {
                    return;
                }
                if (!propertiesFile.getResourceBundle().equals(ResourceBundleEditor.this.myResourceBundle)) {
                    return;
                }
                ResourceBundleEditor.this.updateEditorsFromProperties();
            }
        };
        PsiManager.getInstance((Project)this.myProject).addPsiTreeChangeListener((PsiTreeChangeListener)psiTreeChangeAdapter, (Disposable)this);
    }

    private void selectionChanged() {
        this.myBackSlashPressed.clear();
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                ResourceBundleEditor.this.updateEditorsFromProperties();
            }
        });
    }

    private void updateDocumentFromPropertyValue(String value, Document document, PropertiesFile propertiesFile) {
        String text = value;
        if (this.myBackSlashPressed.contains(propertiesFile)) {
            text = text + "\\";
        }
        document.replaceString(0, document.getTextLength(), (CharSequence)text);
    }

    @NotNull
    private Collection<DefaultMutableTreeNode> getSelectedNodes() {
        if (!this.isValid()) {
            List<DefaultMutableTreeNode> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundleEditor", "getSelectedNodes"));
            }
            return list;
        }
        JTree tree = this.myStructureViewComponent.getTree();
        if (tree == null) {
            List<DefaultMutableTreeNode> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundleEditor", "getSelectedNodes"));
            }
            return list;
        }
        Object[] selected = tree.getSelectionModel().getSelectionPaths();
        if (selected == null || selected.length == 0) {
            List<DefaultMutableTreeNode> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundleEditor", "getSelectedNodes"));
            }
            return list;
        }
        List list = ContainerUtil.map((Object[])selected, (Function)new Function<TreePath, DefaultMutableTreeNode>(){

            public DefaultMutableTreeNode fun(TreePath treePath) {
                return (DefaultMutableTreeNode)treePath.getLastPathComponent();
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundleEditor", "getSelectedNodes"));
        }
        return list;
    }

    @Nullable
    private String getSelectedPropertyName() {
        IProperty selectedProperty = this.getSelectedProperty();
        return selectedProperty == null ? null : selectedProperty.getName();
    }

    @Nullable
    private IProperty getSelectedProperty() {
        Collection<DefaultMutableTreeNode> selectedNode = this.getSelectedNodes();
        if (selectedNode.isEmpty()) {
            return null;
        }
        ResourceBundleEditorViewElement element = ResourceBundleEditor.getSelectedElement((DefaultMutableTreeNode)ContainerUtil.getFirstItem(selectedNode));
        return element instanceof ResourceBundlePropertyStructureViewElement ? ((ResourceBundlePropertyStructureViewElement)element).getProperty() : null;
    }

    @NotNull
    public Collection<ResourceBundleEditorViewElement> getSelectedElements() {
        Collection<DefaultMutableTreeNode> selectedNodes = this.getSelectedNodes();
        List list = ContainerUtil.mapNotNull(selectedNodes, (Function)new NullableFunction<DefaultMutableTreeNode, ResourceBundleEditorViewElement>(){

            @Nullable
            public ResourceBundleEditorViewElement fun(DefaultMutableTreeNode selectedNode) {
                Object userObject = selectedNode.getUserObject();
                if (!(userObject instanceof AbstractTreeNode)) {
                    return null;
                }
                Object value = ((AbstractTreeNode)userObject).getValue();
                return value instanceof ResourceBundleEditorViewElement ? (ResourceBundleEditorViewElement)value : null;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundleEditor", "getSelectedElements"));
        }
        return list;
    }

    @Nullable
    public ResourceBundleEditorViewElement getSelectedElementIfOnlyOne() {
        Collection<ResourceBundleEditorViewElement> selectedElements = this.getSelectedElements();
        return selectedElements.size() == 1 ? (ResourceBundleEditorViewElement)ContainerUtil.getFirstItem(selectedElements) : null;
    }

    @NotNull
    public JComponent getComponent() {
        DataProviderPanel dataProviderPanel = this.myDataProviderPanel;
        if (dataProviderPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundleEditor", "getComponent"));
        }
        return dataProviderPanel;
    }

    private Object getData(String dataId) {
        if (SelectInContext.DATA_KEY.is(dataId)) {
            return new SelectInContext(){

                @NotNull
                public Project getProject() {
                    Project project = ResourceBundleEditor.this.myProject;
                    if (project == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundleEditor$15", "getProject"));
                    }
                    return project;
                }

                @NotNull
                public VirtualFile getVirtualFile() {
                    VirtualFile virtualFile;
                    PropertiesFile selectedFile = ResourceBundleEditor.this.getSelectedPropertiesFile();
                    VirtualFile virtualFile2 = virtualFile = selectedFile == null ? null : selectedFile.getVirtualFile();
                    assert (virtualFile != null);
                    VirtualFile virtualFile3 = virtualFile;
                    if (virtualFile3 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundleEditor$15", "getVirtualFile"));
                    }
                    return virtualFile3;
                }

                public Object getSelectorInFile() {
                    return ResourceBundleEditor.this.getSelectedPropertiesFile();
                }

                public FileEditorProvider getFileEditorProvider() {
                    final PropertiesFile selectedPropertiesFile = ResourceBundleEditor.this.getSelectedPropertiesFile();
                    if (selectedPropertiesFile == null) {
                        return null;
                    }
                    return new FileEditorProvider(){

                        public FileEditor openFileEditor() {
                            VirtualFile file = selectedPropertiesFile.getVirtualFile();
                            if (file == null) {
                                return null;
                            }
                            return FileEditorManager.getInstance((Project)this.getProject()).openFile(file, false)[0];
                        }
                    };
                }
            };
        }
        return null;
    }

    private PropertiesFile getSelectedPropertiesFile() {
        if (this.mySelectedEditor == null) {
            return null;
        }
        PropertiesFile selectedFile = null;
        for (Map.Entry<PropertiesFile, Editor> entry : this.myEditors.entrySet()) {
            Editor editor = entry.getValue();
            if (editor != this.mySelectedEditor) continue;
            selectedFile = entry.getKey();
            break;
        }
        return selectedFile;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myStructureViewPanel;
    }

    @NotNull
    public String getName() {
        if ("Resource Bundle" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundleEditor", "getName"));
        }
        return "Resource Bundle";
    }

    @NotNull
    public ResourceBundleEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/lang/properties/editor/ResourceBundleEditor", "getState"));
        }
        ResourceBundleEditorState resourceBundleEditorState = new ResourceBundleEditorState(this.getSelectedPropertyName());
        if (resourceBundleEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundleEditor", "getState"));
        }
        return resourceBundleEditorState;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/properties/editor/ResourceBundleEditor", "setState"));
        }
        ResourceBundleEditorState myState = (ResourceBundleEditorState)state;
        String propertyName = myState.myPropertyName;
        if (propertyName != null) {
            this.myStructureViewComponent.select((Object)propertyName, true);
            this.selectionChanged();
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return !this.myDisposed && !this.myProject.isDisposed();
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/lang/properties/editor/ResourceBundleEditor", "addPropertyChangeListener"));
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/lang/properties/editor/ResourceBundleEditor", "removePropertyChangeListener"));
        }
    }

    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
        if (this.mySelectedEditor != null) {
            for (Map.Entry<PropertiesFile, Editor> entry : this.myEditors.entrySet()) {
                if (!this.mySelectedEditor.equals(entry.getValue())) continue;
                this.writeEditorPropertyValue(this.mySelectedEditor, entry.getKey(), null);
            }
        }
        VirtualFileManager.getInstance().removeVirtualFileListener(this.myVfsListener);
        this.myDisposed = true;
        Disposer.dispose((Disposable)this.myStructureViewComponent);
        this.releaseAllEditors();
    }

    private void releaseAllEditors() {
        for (Editor editor : this.myEditors.values()) {
            if (editor.isDisposed()) continue;
            EditorFactory.getInstance().releaseEditor(editor);
        }
        this.myEditors.clear();
    }

    private static Editor createEditor() {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document document = editorFactory.createDocument((CharSequence)"");
        EditorEx editor = (EditorEx)editorFactory.createEditor(document);
        ResourceBundleEditor.reinitSettings(editor);
        return editor;
    }

    private static void reinitSettings(EditorEx editor) {
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        editor.setColorsScheme(scheme);
        EditorSettings settings = editor.getSettings();
        settings.setLineNumbersShown(false);
        settings.setWhitespacesShown(false);
        settings.setLineMarkerAreaShown(false);
        settings.setIndentGuidesShown(false);
        settings.setFoldingOutlineShown(false);
        settings.setAdditionalColumnsCount(0);
        settings.setAdditionalLinesCount(0);
        settings.setRightMarginShown(true);
        settings.setRightMargin(60);
        settings.setVirtualSpace(false);
        editor.setHighlighter((EditorHighlighter)new LexerEditorHighlighter((SyntaxHighlighter)new PropertiesValueHighlighter(), scheme));
        editor.setVerticalScrollbarVisible(true);
    }

    private class MyJPanel
    extends JPanel
    implements Scrollable {
        private MyJPanel(LayoutManager layout) {
            super(layout);
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            Editor editor = (Editor)ResourceBundleEditor.this.myEditors.values().iterator().next();
            return editor.getLineHeight() * 4;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return visibleRect.height;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }

    private class DataProviderPanel
    extends JPanel
    implements DataProvider {
        private DataProviderPanel(JPanel panel) {
            super(new BorderLayout());
            this.add((Component)panel, "Center");
        }

        @Nullable
        public Object getData(String dataId) {
            return ResourceBundleEditor.this.getData(dataId);
        }
    }

    public static class ResourceBundleEditorState
    implements FileEditorState {
        private final String myPropertyName;

        public ResourceBundleEditorState(String propertyName) {
            this.myPropertyName = propertyName;
        }

        public boolean canBeMergedWith(FileEditorState otherState, FileEditorStateLevel level) {
            return false;
        }

        public String getPropertyName() {
            return this.myPropertyName;
        }
    }
}

