/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import groovy.lang.Closure;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.AntBuilder;
import org.gradle.api.CircularReferenceException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.PathValidation;
import org.gradle.api.Project;
import org.gradle.api.ProjectEvaluationListener;
import org.gradle.api.Task;
import org.gradle.api.UnknownProjectException;
import org.gradle.api.artifacts.dsl.ArtifactHandler;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.component.SoftwareComponentContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileTree;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.internal.BeanDynamicObject;
import org.gradle.api.internal.DynamicObject;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.DynamicPropertyNamer;
import org.gradle.api.internal.ExtensibleDynamicObject;
import org.gradle.api.internal.FactoryNamedDomainObjectContainer;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.PolymorphicDomainObjectContainerModelAdapter;
import org.gradle.api.internal.ProcessOperations;
import org.gradle.api.internal.artifacts.ModuleInternal;
import org.gradle.api.internal.artifacts.configurations.ConfigurationContainerInternal;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ScriptHandlerFactory;
import org.gradle.api.internal.plugins.DefaultObjectConfigurationAction;
import org.gradle.api.internal.plugins.ExtensionContainerInternal;
import org.gradle.api.internal.project.AbstractPluginAware;
import org.gradle.api.internal.project.DefaultProject;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectRegistry;
import org.gradle.api.internal.project.ProjectStateInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.resources.ResourceHandler;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.WorkResult;
import org.gradle.configuration.ScriptPluginFactory;
import org.gradle.configuration.project.ProjectConfigurationActionContainer;
import org.gradle.configuration.project.ProjectEvaluator;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.internal.Factory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.ServiceRegistryFactory;
import org.gradle.listener.ClosureBackedMethodInvocationDispatch;
import org.gradle.listener.ListenerBroadcast;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.logging.StandardOutputCapture;
import org.gradle.model.dsl.internal.GroovyModelDsl;
import org.gradle.model.internal.core.Inputs;
import org.gradle.model.internal.core.InstanceBackedModelCreator;
import org.gradle.model.internal.core.ModelAdapter;
import org.gradle.model.internal.core.ModelCreator;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelPromise;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelType;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.SimpleModelRuleDescriptor;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.process.ExecResult;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.DeprecationLogger;
import org.gradle.util.GUtil;
import org.gradle.util.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProject
extends AbstractPluginAware
implements ProjectInternal,
DynamicObjectAware {
    private static Logger buildLogger = Logging.getLogger(Project.class);
    private final ClassLoaderScope classLoaderScope;
    private final ClassLoaderScope baseClassLoaderScope;
    private ServiceRegistry services;
    private final ProjectInternal rootProject;
    private final GradleInternal gradle;
    private ProjectEvaluator projectEvaluator;
    private ScriptSource buildScriptSource;
    private final File projectDir;
    private final ProjectInternal parent;
    private final String name;
    private Object group;
    private Object version;
    private Object status;
    private final Map<String, Project> childProjects = new HashMap<String, Project>();
    private List<String> defaultTasks = new ArrayList<String>();
    private ProjectStateInternal state;
    private FileResolver fileResolver;
    private Factory<AntBuilder> antBuilderFactory;
    private AntBuilder ant;
    private Object buildDir = "build";
    private final int depth;
    private TaskContainerInternal taskContainer;
    private DependencyHandler dependencyHandler;
    private ConfigurationContainerInternal configurationContainer;
    private ArtifactHandler artifactHandler;
    private ListenerBroadcast<ProjectEvaluationListener> evaluationListener = new ListenerBroadcast<ProjectEvaluationListener>(ProjectEvaluationListener.class);
    private ExtensibleDynamicObject extensibleDynamicObject;
    private String description;
    private final Path path;

    public AbstractProject(String name, ProjectInternal parent, File projectDir, ScriptSource buildScriptSource, GradleInternal gradle, ServiceRegistryFactory serviceRegistryFactory, ClassLoaderScope selfClassLoaderScope, ClassLoaderScope baseClassLoaderScope) {
        this.classLoaderScope = selfClassLoaderScope;
        this.baseClassLoaderScope = baseClassLoaderScope;
        assert (name != null);
        this.rootProject = parent != null ? parent.getRootProject() : this;
        this.projectDir = projectDir;
        this.parent = parent;
        this.name = name;
        this.state = new ProjectStateInternal();
        this.buildScriptSource = buildScriptSource;
        this.gradle = gradle;
        if (parent == null) {
            this.path = Path.ROOT;
            this.depth = 0;
        } else {
            String path = parent.absoluteProjectPath(name);
            this.depth = parent.getDepth() + 1;
            this.path = Path.path(path);
        }
        this.services = serviceRegistryFactory.createFor(this);
        this.taskContainer = (TaskContainerInternal)this.services.newInstance(TaskContainerInternal.class);
        final ModelRegistry modelRegistry = (ModelRegistry)this.services.get(ModelRegistry.class);
        modelRegistry.create(InstanceBackedModelCreator.of((ModelReference)ModelReference.of((String)"serviceRegistry", ServiceRegistry.class), (ModelRuleDescriptor)new SimpleModelRuleDescriptor("Project.<init>.serviceRegistry()"), (Object)this.services));
        modelRegistry.create(InstanceBackedModelCreator.of((ModelReference)ModelReference.of((String)"buildDir", File.class), (ModelRuleDescriptor)new SimpleModelRuleDescriptor("Project.<init>.buildDir()"), (Factory)new Factory<File>(){

            public File create() {
                return AbstractProject.this.getBuildDir();
            }
        }));
        modelRegistry.create(InstanceBackedModelCreator.of((ModelReference)ModelReference.of((String)"projectIdentifier", ProjectIdentifier.class), (ModelRuleDescriptor)new SimpleModelRuleDescriptor("Project.<init>.projectIdentifier()"), (Object)this));
        modelRegistry.create(InstanceBackedModelCreator.of((ModelReference)ModelReference.of((String)"extensions", ExtensionContainer.class), (ModelRuleDescriptor)new SimpleModelRuleDescriptor("Project.<init>.extensions()"), (Factory)new Factory<ExtensionContainer>(){

            public ExtensionContainer create() {
                return AbstractProject.this.getExtensions();
            }
        }));
        final PolymorphicDomainObjectContainerModelAdapter<Task, TaskContainerInternal> tasksModelAdapter = new PolymorphicDomainObjectContainerModelAdapter<Task, TaskContainerInternal>(this.getTasks(), ModelType.of(TaskContainer.class), Task.class);
        modelRegistry.create(new ModelCreator(){

            public ModelPath getPath() {
                return TaskContainerInternal.MODEL_PATH;
            }

            public ModelPromise getPromise() {
                return tasksModelAdapter.asPromise();
            }

            public ModelAdapter create(Inputs inputs) {
                return tasksModelAdapter;
            }

            public List<ModelReference<?>> getInputs() {
                return Collections.emptyList();
            }

            public ModelRuleDescriptor getDescriptor() {
                return new SimpleModelRuleDescriptor("Project.<init>.tasks()");
            }
        });
        this.taskContainer.all(new Action<Task>(){

            public void execute(Task task) {
                String name = task.getName();
                ModelPath modelPath = TaskContainerInternal.MODEL_PATH.child(name);
                if (modelRegistry.state(modelPath) == null) {
                    modelRegistry.create(InstanceBackedModelCreator.of((ModelReference)ModelReference.of((ModelPath)modelPath, (ModelType)ModelType.of(Task.class)), (ModelRuleDescriptor)new SimpleModelRuleDescriptor("Project.<init>.tasks." + name + "()"), (Object)task));
                }
            }
        });
        this.taskContainer.whenObjectRemoved(new Action<Task>(){

            public void execute(Task task) {
                modelRegistry.remove(TaskContainerInternal.MODEL_PATH.child(task.getName()));
            }
        });
        this.extensibleDynamicObject = new ExtensibleDynamicObject(this, (Instantiator)this.services.get(Instantiator.class));
        if (parent != null) {
            this.extensibleDynamicObject.setParent(parent.getInheritedScope());
        }
        this.extensibleDynamicObject.addObject(this.taskContainer.getTasksAsDynamicObject(), ExtensibleDynamicObject.Location.AfterConvention);
        this.evaluationListener.add(gradle.getProjectEvaluationBroadcaster());
    }

    @Override
    public ProjectInternal getRootProject() {
        return this.rootProject;
    }

    @Override
    public GradleInternal getGradle() {
        return this.gradle;
    }

    @Override
    @Inject
    public PluginContainer getPlugins() {
        throw new UnsupportedOperationException();
    }

    public ProjectEvaluator getProjectEvaluator() {
        if (this.projectEvaluator == null) {
            this.projectEvaluator = (ProjectEvaluator)this.services.get(ProjectEvaluator.class);
        }
        return this.projectEvaluator;
    }

    public void setProjectEvaluator(ProjectEvaluator projectEvaluator) {
        this.projectEvaluator = projectEvaluator;
    }

    @Override
    @Inject
    public ScriptHandler getBuildscript() {
        throw new UnsupportedOperationException();
    }

    @Override
    public File getBuildFile() {
        return this.getBuildscript().getSourceFile();
    }

    @Override
    public void setScript(Script buildScript) {
        this.extensibleDynamicObject.addObject(new BeanDynamicObject(buildScript).withNoProperties().withNotImplementsMissing(), ExtensibleDynamicObject.Location.BeforeConvention);
    }

    @Override
    public ScriptSource getBuildScriptSource() {
        return this.buildScriptSource;
    }

    @Override
    public File getRootDir() {
        return this.rootProject.getProjectDir();
    }

    @Override
    public ProjectInternal getParent() {
        return this.parent;
    }

    @Override
    public ProjectIdentifier getParentIdentifier() {
        return this.parent;
    }

    @Override
    public DynamicObject getAsDynamicObject() {
        return this.extensibleDynamicObject;
    }

    @Override
    public DynamicObject getInheritedScope() {
        return this.extensibleDynamicObject.getInheritable();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Object getGroup() {
        if (this.group != null) {
            return this.group;
        }
        if (this == this.rootProject) {
            return "";
        }
        return this.rootProject.getName() + (this.getParent() == this.rootProject ? "" : "." + this.getParent().getPath().substring(1).replace(':', '.'));
    }

    @Override
    public void setGroup(Object group) {
        this.group = group;
    }

    @Override
    public Object getVersion() {
        return this.version == null ? "unspecified" : this.version;
    }

    @Override
    public void setVersion(Object version) {
        this.version = version;
    }

    @Override
    public Object getStatus() {
        return this.status == null ? "release" : this.status;
    }

    @Override
    public void setStatus(Object status) {
        this.status = status;
    }

    @Override
    public Map<String, Project> getChildProjects() {
        return this.childProjects;
    }

    @Override
    public List<String> getDefaultTasks() {
        return this.defaultTasks;
    }

    @Override
    public void setDefaultTasks(List<String> defaultTasks) {
        this.defaultTasks = defaultTasks;
    }

    @Override
    public ProjectStateInternal getState() {
        return this.state;
    }

    @Override
    public FileResolver getFileResolver() {
        if (this.fileResolver == null) {
            this.fileResolver = (FileResolver)this.services.get(FileResolver.class);
        }
        return this.fileResolver;
    }

    public void setFileResolver(FileResolver fileResolver) {
        this.fileResolver = fileResolver;
    }

    public void setAnt(AntBuilder ant) {
        this.ant = ant;
    }

    @Override
    public ArtifactHandler getArtifacts() {
        if (this.artifactHandler == null) {
            this.artifactHandler = (ArtifactHandler)this.services.get(ArtifactHandler.class);
        }
        return this.artifactHandler;
    }

    public void setArtifactHandler(ArtifactHandler artifactHandler) {
        this.artifactHandler = artifactHandler;
    }

    @Override
    @Inject
    public RepositoryHandler getRepositories() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ConfigurationContainerInternal getConfigurations() {
        if (this.configurationContainer == null) {
            this.configurationContainer = (ConfigurationContainerInternal)this.services.get(ConfigurationContainerInternal.class);
        }
        return this.configurationContainer;
    }

    public void setConfigurationContainer(ConfigurationContainerInternal configurationContainer) {
        this.configurationContainer = configurationContainer;
    }

    @Override
    public Convention getConvention() {
        return this.extensibleDynamicObject.getConvention();
    }

    @Override
    public String getPath() {
        return this.path.toString();
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    @Inject
    public ProjectRegistry<ProjectInternal> getProjectRegistry() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int depthCompare(Project otherProject) {
        return new Integer(this.getDepth()).compareTo(otherProject.getDepth());
    }

    @Override
    public int compareTo(Project otherProject) {
        int depthCompare = this.depthCompare(otherProject);
        if (depthCompare == 0) {
            return this.getPath().compareTo(otherProject.getPath());
        }
        return depthCompare;
    }

    @Override
    public String absoluteProjectPath(String path) {
        return this.path.absolutePath(path);
    }

    @Override
    public String relativeProjectPath(String path) {
        return this.path.relativePath(path);
    }

    @Override
    public ProjectInternal project(String path) {
        ProjectInternal project = this.findProject(path);
        if (project == null) {
            throw new UnknownProjectException(String.format("Project with path '%s' could not be found in %s.", path, this));
        }
        return project;
    }

    @Override
    public ProjectInternal findProject(String path) {
        if (!GUtil.isTrue(path)) {
            throw new InvalidUserDataException("A path must be specified!");
        }
        return this.getProjectRegistry().getProject(this.absoluteProjectPath(path));
    }

    @Override
    public Set<Project> getAllprojects() {
        return new TreeSet<Project>(this.getProjectRegistry().getAllProjects(this.getPath()));
    }

    @Override
    public Set<Project> getSubprojects() {
        return new TreeSet<Project>(this.getProjectRegistry().getSubProjects(this.getPath()));
    }

    @Override
    public void subprojects(Action<? super Project> action) {
        this.configure(this.getSubprojects(), action);
    }

    @Override
    public void allprojects(Action<? super Project> action) {
        this.configure(this.getAllprojects(), action);
    }

    @Override
    public <T> Iterable<T> configure(Iterable<T> objects, Action<? super T> configureAction) {
        for (T object : objects) {
            configureAction.execute(object);
        }
        return objects;
    }

    @Override
    public AntBuilder getAnt() {
        if (this.ant == null) {
            this.ant = this.createAntBuilder();
        }
        return this.ant;
    }

    @Override
    public AntBuilder createAntBuilder() {
        return (AntBuilder)((Object)this.getAntBuilderFactory().create());
    }

    @Override
    public Project getProject() {
        return this;
    }

    @Override
    public AbstractProject evaluate() {
        this.getProjectEvaluator().evaluate(this, this.state);
        this.state.rethrowFailure();
        return this;
    }

    @Override
    public TaskContainerInternal getTasks() {
        return this.taskContainer;
    }

    @Override
    public void defaultTasks(String ... defaultTasks) {
        if (defaultTasks == null) {
            throw new InvalidUserDataException("Default tasks must not be null!");
        }
        this.defaultTasks = new ArrayList<String>();
        for (String defaultTask : defaultTasks) {
            if (defaultTask == null) {
                throw new InvalidUserDataException("Default tasks must not be null!");
            }
            this.defaultTasks.add(defaultTask);
        }
    }

    @Override
    public void addChildProject(ProjectInternal childProject) {
        this.childProjects.put(childProject.getName(), childProject);
    }

    @Override
    public File getProjectDir() {
        return this.projectDir;
    }

    @Override
    public File getBuildDir() {
        return this.file(this.buildDir);
    }

    @Override
    public void setBuildDir(Object path) {
        this.buildDir = path;
    }

    @Override
    public void evaluationDependsOnChildren() {
        for (Project project : this.childProjects.values()) {
            DefaultProject defaultProjectToEvaluate = (DefaultProject)project;
            this.evaluationDependsOn(defaultProjectToEvaluate);
        }
    }

    @Override
    public Project evaluationDependsOn(String path) {
        if (!GUtil.isTrue(path)) {
            throw new InvalidUserDataException("You must specify a project!");
        }
        DefaultProject projectToEvaluate = (DefaultProject)this.project(path);
        return this.evaluationDependsOn(projectToEvaluate);
    }

    private Project evaluationDependsOn(DefaultProject projectToEvaluate) {
        if (projectToEvaluate.getState().getExecuting()) {
            throw new CircularReferenceException(String.format("Circular referencing during evaluation for %s.", projectToEvaluate));
        }
        return projectToEvaluate.evaluate();
    }

    public String toString() {
        if (this.parent != null) {
            return String.format("project '%s'", this.path);
        }
        return String.format("root project '%s'", this.name);
    }

    @Override
    public Map<Project, Set<Task>> getAllTasks(boolean recursive) {
        final TreeMap<Project, Set<Task>> foundTargets = new TreeMap<Project, Set<Task>>();
        Action<Project> action = new Action<Project>(){

            public void execute(Project project) {
                foundTargets.put(project, new TreeSet<Task>(project.getTasks()));
            }
        };
        if (recursive) {
            this.allprojects((Action<? super Project>)action);
        } else {
            action.execute((Object)this);
        }
        return foundTargets;
    }

    @Override
    public Set<Task> getTasksByName(final String name, boolean recursive) {
        if (!GUtil.isTrue(name)) {
            throw new InvalidUserDataException("Name is not specified!");
        }
        final HashSet<Task> foundTasks = new HashSet<Task>();
        Action<Project> action = new Action<Project>(){

            public void execute(Project project) {
                ((ProjectInternal)project).evaluate();
                Task task = (Task)project.getTasks().findByName(name);
                if (task != null) {
                    foundTasks.add(task);
                }
            }
        };
        if (recursive) {
            this.allprojects((Action<? super Project>)action);
        } else {
            action.execute((Object)this);
        }
        return foundTasks;
    }

    @Inject
    protected FileOperations getFileOperations() {
        throw new UnsupportedOperationException();
    }

    @Override
    public File file(Object path) {
        return this.getFileOperations().file(path);
    }

    @Override
    public File file(Object path, PathValidation validation) {
        return this.getFileOperations().file(path, validation);
    }

    @Override
    public URI uri(Object path) {
        return this.getFileOperations().uri(path);
    }

    @Override
    public ConfigurableFileCollection files(Object ... paths) {
        return this.getFileOperations().files(paths);
    }

    @Override
    public ConfigurableFileCollection files(Object paths, Closure closure) {
        return this.getFileOperations().files(paths, closure);
    }

    @Override
    public ConfigurableFileTree fileTree(Object baseDir) {
        return this.getFileOperations().fileTree(baseDir);
    }

    @Override
    public ConfigurableFileTree fileTree(Object baseDir, Closure closure) {
        return this.getFileOperations().fileTree(baseDir, closure);
    }

    @Override
    public ConfigurableFileTree fileTree(Map<String, ?> args) {
        return this.getFileOperations().fileTree(args);
    }

    @Override
    public FileTree zipTree(Object zipPath) {
        return this.getFileOperations().zipTree(zipPath);
    }

    @Override
    public FileTree tarTree(Object tarPath) {
        return this.getFileOperations().tarTree(tarPath);
    }

    @Override
    public ResourceHandler getResources() {
        return this.getFileOperations().getResources();
    }

    @Override
    public String relativePath(Object path) {
        return this.getFileOperations().relativePath(path);
    }

    @Override
    public File mkdir(Object path) {
        return this.getFileOperations().mkdir(path);
    }

    @Override
    public boolean delete(Object ... paths) {
        return this.getFileOperations().delete(paths);
    }

    public Factory<AntBuilder> getAntBuilderFactory() {
        if (this.antBuilderFactory == null) {
            this.antBuilderFactory = this.services.getFactory(AntBuilder.class);
        }
        return this.antBuilderFactory;
    }

    @Override
    public DependencyHandler getDependencies() {
        if (this.dependencyHandler == null) {
            this.dependencyHandler = (DependencyHandler)this.services.get(DependencyHandler.class);
        }
        return this.dependencyHandler;
    }

    public void setDependencyHandler(DependencyHandler dependencyHandler) {
        this.dependencyHandler = dependencyHandler;
    }

    @Override
    public ProjectEvaluationListener getProjectEvaluationBroadcaster() {
        return this.evaluationListener.getSource();
    }

    @Override
    public void beforeEvaluate(Action<? super Project> action) {
        this.evaluationListener.add("beforeEvaluate", action);
    }

    @Override
    public void afterEvaluate(Action<? super Project> action) {
        this.evaluationListener.add("afterEvaluate", action);
    }

    @Override
    public void beforeEvaluate(Closure closure) {
        this.evaluationListener.add(new ClosureBackedMethodInvocationDispatch("beforeEvaluate", closure));
    }

    @Override
    public void afterEvaluate(Closure closure) {
        this.evaluationListener.add(new ClosureBackedMethodInvocationDispatch("afterEvaluate", closure));
    }

    @Override
    public Logger getLogger() {
        return buildLogger;
    }

    @Override
    public StandardOutputCapture getStandardOutputCapture() {
        return this.getLogging();
    }

    @Override
    @Inject
    public LoggingManagerInternal getLogging() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Inject
    public SoftwareComponentContainer getComponents() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object property(String propertyName) throws MissingPropertyException {
        return this.extensibleDynamicObject.getProperty(propertyName);
    }

    @Override
    public void setProperty(String name, Object value) {
        this.extensibleDynamicObject.setProperty(name, value);
    }

    @Override
    public boolean hasProperty(String propertyName) {
        return this.extensibleDynamicObject.hasProperty(propertyName);
    }

    @Override
    public Map<String, ?> getProperties() {
        return (Map)DeprecationLogger.whileDisabled(new Factory<Map<String, ?>>(){

            public Map<String, ?> create() {
                return AbstractProject.this.extensibleDynamicObject.getProperties();
            }
        });
    }

    @Override
    public WorkResult copy(Closure closure) {
        return this.getFileOperations().copy(closure);
    }

    @Override
    public WorkResult sync(Action<? super CopySpec> action) {
        return this.getFileOperations().sync(action);
    }

    @Override
    public CopySpec copySpec(Closure closure) {
        return this.getFileOperations().copySpec(closure);
    }

    @Override
    public CopySpec copySpec(Action<? super CopySpec> action) {
        return this.getFileOperations().copySpec(action);
    }

    @Inject
    protected ProcessOperations getProcessOperations() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ExecResult javaexec(Closure closure) {
        return this.getProcessOperations().javaexec(closure);
    }

    @Override
    public ExecResult exec(Closure closure) {
        return this.getProcessOperations().exec(closure);
    }

    @Override
    public ServiceRegistry getServices() {
        return this.services;
    }

    @Override
    public ServiceRegistryFactory getServiceRegistryFactory() {
        return (ServiceRegistryFactory)this.services.get(ServiceRegistryFactory.class);
    }

    @Override
    public ModuleInternal getModule() {
        return ((DependencyMetaDataProvider)this.services.get(DependencyMetaDataProvider.class)).getModule();
    }

    @Override
    public AntBuilder ant(Closure configureClosure) {
        return ConfigureUtil.configure(configureClosure, this.getAnt());
    }

    @Override
    public void subprojects(Closure configureClosure) {
        this.configure(this.getSubprojects(), configureClosure);
    }

    @Override
    public void allprojects(Closure configureClosure) {
        this.configure(this.getAllprojects(), configureClosure);
    }

    @Override
    public Project project(String path, Closure configureClosure) {
        return ConfigureUtil.configure(configureClosure, this.project(path));
    }

    @Override
    public Object configure(Object object, Closure configureClosure) {
        return ConfigureUtil.configure(configureClosure, object);
    }

    @Override
    public Iterable<?> configure(Iterable<?> objects, Closure configureClosure) {
        for (Object object : objects) {
            this.configure(object, configureClosure);
        }
        return objects;
    }

    @Override
    public void configurations(Closure configureClosure) {
        this.getConfigurations().configure(configureClosure);
    }

    @Override
    public void repositories(Closure configureClosure) {
        ConfigureUtil.configure(configureClosure, this.getRepositories());
    }

    @Override
    public void dependencies(Closure configureClosure) {
        ConfigureUtil.configure(configureClosure, this.getDependencies());
    }

    @Override
    public void artifacts(Closure configureClosure) {
        ConfigureUtil.configure(configureClosure, this.getArtifacts());
    }

    @Override
    public void buildscript(Closure configureClosure) {
        ConfigureUtil.configure(configureClosure, this.getBuildscript());
    }

    @Override
    public Task task(String task) {
        return this.taskContainer.create(task);
    }

    public Task task(Object task) {
        return this.taskContainer.create(task.toString());
    }

    @Override
    public Task task(String task, Closure configureClosure) {
        return this.taskContainer.create(task).configure(configureClosure);
    }

    public Task task(Object task, Closure configureClosure) {
        return this.task(task.toString(), configureClosure);
    }

    public Task task(Map options, String task) {
        return this.taskContainer.create(GUtil.addMaps(options, Collections.singletonMap("name", task)));
    }

    public Task task(Map options, Object task) {
        return this.task(options, task.toString());
    }

    public Task task(Map options, String task, Closure configureClosure) {
        return this.taskContainer.create(GUtil.addMaps(options, Collections.singletonMap("name", task))).configure(configureClosure);
    }

    public Task task(Map options, Object task, Closure configureClosure) {
        return this.task(options, task.toString(), configureClosure);
    }

    @Override
    @Inject
    public ProjectConfigurationActionContainer getConfigurationActions() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Inject
    public ModelRegistry getModelRegistry() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected DefaultObjectConfigurationAction createObjectConfigurationAction() {
        return new DefaultObjectConfigurationAction(this.getFileResolver(), this.getScriptPluginFactory(), this.getScriptHandlerFactory(), this.getBaseClassLoaderScope(), this);
    }

    @Inject
    protected ScriptPluginFactory getScriptPluginFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ScriptHandlerFactory getScriptHandlerFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ClassLoaderScope getClassLoaderScope() {
        return this.classLoaderScope;
    }

    @Override
    public ClassLoaderScope getBaseClassLoaderScope() {
        return this.baseClassLoaderScope;
    }

    public Object passThrough(Object object) {
        return object;
    }

    @Override
    public <T> NamedDomainObjectContainer<T> container(Class<T> type) {
        Instantiator instantiator = (Instantiator)this.getServices().get(Instantiator.class);
        return (NamedDomainObjectContainer)instantiator.newInstance(FactoryNamedDomainObjectContainer.class, new Object[]{type, instantiator, new DynamicPropertyNamer()});
    }

    @Override
    public <T> NamedDomainObjectContainer<T> container(Class<T> type, NamedDomainObjectFactory<T> factory) {
        Instantiator instantiator = (Instantiator)this.getServices().get(Instantiator.class);
        return (NamedDomainObjectContainer)instantiator.newInstance(FactoryNamedDomainObjectContainer.class, new Object[]{type, instantiator, new DynamicPropertyNamer(), factory});
    }

    @Override
    public <T> NamedDomainObjectContainer<T> container(Class<T> type, Closure factoryClosure) {
        Instantiator instantiator = (Instantiator)this.getServices().get(Instantiator.class);
        return (NamedDomainObjectContainer)instantiator.newInstance(FactoryNamedDomainObjectContainer.class, new Object[]{type, instantiator, new DynamicPropertyNamer(), factoryClosure});
    }

    @Override
    public ExtensionContainerInternal getExtensions() {
        return (ExtensionContainerInternal)((Object)this.getConvention());
    }

    public void model(Closure action) {
        new GroovyModelDsl(this.getModelRegistry()).configure(action);
    }
}

