/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xpathView.search;

import com.intellij.find.FindProgressIndicator;
import com.intellij.find.FindSettings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import java.util.Collections;
import org.intellij.plugins.xpathView.Config;
import org.intellij.plugins.xpathView.XPathAppComponent;
import org.intellij.plugins.xpathView.XPathEvalAction;
import org.intellij.plugins.xpathView.XPathProjectComponent;
import org.intellij.plugins.xpathView.search.FindByExpressionDialog;
import org.intellij.plugins.xpathView.search.SearchScope;
import org.intellij.plugins.xpathView.search.XPathUsageSearcher;
import org.intellij.plugins.xpathView.support.XPathSupport;
import org.intellij.plugins.xpathView.ui.InputExpressionDialog;
import org.intellij.plugins.xpathView.util.Namespace;
import org.jaxen.JaxenException;
import org.jaxen.XPathSyntaxException;
import org.jetbrains.annotations.NotNull;

public class FindByXPathAction
extends AnAction {
    public void update(AnActionEvent e) {
        Project project = (Project)LangDataKeys.PROJECT.getData(e.getDataContext());
        e.getPresentation().setEnabled(project != null);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)LangDataKeys.PROJECT.getData(e.getDataContext());
        Module module = (Module)LangDataKeys.MODULE.getData(e.getDataContext());
        if (project != null) {
            this.executeSearch(project, module);
        }
    }

    private void executeSearch(final @NotNull Project project, final Module module) {
        XPathProjectComponent projectComponent;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/plugins/xpathView/search/FindByXPathAction", "executeSearch"));
        }
        final Config settings = XPathAppComponent.getInstance().getConfig();
        FindByExpressionDialog dlg = new FindByExpressionDialog(project, settings, (projectComponent = XPathProjectComponent.getInstance(project)).getFindHistory(), module);
        if (!dlg.show(null)) {
            return;
        }
        final SearchScope scope = dlg.getScope();
        settings.MATCH_RECURSIVELY = dlg.isMatchRecursively();
        settings.SEARCH_SCOPE = dlg.getScope();
        final InputExpressionDialog.Context context = dlg.getContext();
        projectComponent.addFindHistory(context.input);
        String expression = context.input.expression;
        if (!FindByXPathAction.validateExpression(project, expression)) {
            return;
        }
        UsageViewPresentation presentation = new UsageViewPresentation();
        presentation.setTargetsNodeText(settings.MATCH_RECURSIVELY ? "XPath Pattern" : "XPath Expression");
        presentation.setCodeUsages(false);
        presentation.setCodeUsagesString("Found Matches in " + scope.getName());
        presentation.setNonCodeUsagesString("Result");
        presentation.setUsagesString("results matching '" + expression + '\'');
        presentation.setUsagesWord("match");
        presentation.setTabText(StringUtil.shortenTextWithEllipsis((String)("XPath '" + expression + '\''), (int)60, (int)0, (boolean)true));
        presentation.setScopeText(scope.getName());
        presentation.setOpenInNewTab(FindSettings.getInstance().isShowResultsInSeparateView());
        FindUsagesProcessPresentation processPresentation = new FindUsagesProcessPresentation(presentation);
        processPresentation.setProgressIndicatorFactory((Factory)new Factory<ProgressIndicator>(){

            public ProgressIndicator create() {
                return new FindProgressIndicator(project, scope.getName());
            }
        });
        processPresentation.setShowPanelIfOnlyOneUsage(true);
        processPresentation.setShowNotFoundMessage(true);
        XPathEvalAction.MyUsageTarget usageTarget = new XPathEvalAction.MyUsageTarget(context.input.expression, null);
        UsageTarget[] usageTargets = new UsageTarget[]{usageTarget};
        Factory<UsageSearcher> searcherFactory = new Factory<UsageSearcher>(){

            public UsageSearcher create() {
                return new XPathUsageSearcher(project, context.input, scope, settings.MATCH_RECURSIVELY);
            }
        };
        UsageViewManager.UsageViewStateListener stateListener = new UsageViewManager.UsageViewStateListener(){

            public void usageViewCreated(@NotNull UsageView usageView) {
                if (usageView == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageView", "org/intellij/plugins/xpathView/search/FindByXPathAction$3", "usageViewCreated"));
                }
                usageView.addButtonToLowerPane((Runnable)new MyEditExpressionAction(project, module), "&Edit Expression");
            }

            public void findingUsagesFinished(UsageView usageView) {
            }
        };
        UsageViewManager.getInstance((Project)project).searchAndShowUsages(usageTargets, (Factory)searcherFactory, processPresentation, presentation, stateListener);
    }

    private static boolean validateExpression(Project project, String expression) {
        try {
            XPathSupport.getInstance().createXPath(null, expression, Collections.<Namespace>emptyList());
            return true;
        }
        catch (XPathSyntaxException e) {
            Messages.showErrorDialog((Project)project, (String)e.getMultilineMessage(), (String)"XPath Syntax Error");
        }
        catch (JaxenException e) {
            Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)"XPath Error");
        }
        return false;
    }

    private class MyEditExpressionAction
    extends XPathEvalAction.EditExpressionAction {
        private final Project myProject;
        private final Module myModule;

        public MyEditExpressionAction(Project project, Module module) {
            this.myProject = project;
            this.myModule = module;
        }

        @Override
        protected void execute() {
            FindByXPathAction.this.executeSearch(this.myProject, this.myModule);
        }
    }
}

