/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.SdkConstants;
import com.android.prefs.AndroidLocation;
import com.android.resources.Density;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.devices.Device;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.repository.local.LocalSdk;
import com.android.tools.idea.avdmanager.AvdWizardConstants;
import com.android.tools.idea.avdmanager.LogWrapper;
import com.android.tools.idea.avdmanager.SkinLayoutDefinition;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.util.io.FileUtil;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.android.util.ExecutionStatus;
import org.jetbrains.android.util.StringBuildingOutputProcessor;
import org.jetbrains.android.util.WaitingStrategies;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AvdManagerConnection {
    private static final Logger IJ_LOG = Logger.getInstance(AvdManagerConnection.class);
    private static final ILogger SDK_LOG = new LogWrapper(IJ_LOG){

        @Override
        public void error(Throwable t, String errorFormat, Object ... args) {
            IJ_LOG.error(String.format(errorFormat, args), t);
        }
    };
    private static final String AVD_INI_HW_LCD_DENSITY = "hw.lcd.density";
    private static AvdManager ourAvdManager;
    private static Map<File, SkinLayoutDefinition> ourSkinLayoutDefinitions;
    private static File ourEmulatorBinary;

    private static boolean initIfNecessary() {
        if (ourAvdManager == null) {
            AndroidSdkData androidSdkData = AndroidSdkUtils.tryToChooseAndroidSdk();
            if (androidSdkData == null) {
                IJ_LOG.error("No Android SDK Found");
                return false;
            }
            LocalSdk localSdk = androidSdkData.getLocalSdk();
            try {
                ourAvdManager = AvdManager.getInstance((LocalSdk)localSdk, (ILogger)SDK_LOG);
            }
            catch (AndroidLocation.AndroidLocationException e) {
                IJ_LOG.error("Could not instantiate AVD Manager from SDK", (Throwable)e);
                return false;
            }
            ourEmulatorBinary = new File(ourAvdManager.getLocalSdk().getLocation(), FileUtil.join((String[])new String[]{SdkConstants.OS_SDK_TOOLS_FOLDER, SdkConstants.FN_EMULATOR}));
            if (!ourEmulatorBinary.isFile()) {
                IJ_LOG.error("No emulator binary found!");
                return false;
            }
        }
        return true;
    }

    @NotNull
    public static List<AvdInfo> getAvds(boolean forceRefresh) {
        if (!AvdManagerConnection.initIfNecessary()) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdManagerConnection", "getAvds"));
            }
            return immutableList;
        }
        if (forceRefresh) {
            try {
                ourAvdManager.reloadAvds(SDK_LOG);
            }
            catch (AndroidLocation.AndroidLocationException e) {
                IJ_LOG.error("Could not find Android SDK!", (Throwable)e);
            }
        }
        ArrayList avdInfos = Lists.newArrayList((Object[])ourAvdManager.getAllAvds());
        boolean needsRefresh = false;
        for (AvdInfo info : avdInfos) {
            if (info.getStatus() == AvdInfo.AvdStatus.ERROR_IMAGE_DIR) {
                AvdManagerConnection.updateAvdImageFolder(info);
                needsRefresh = true;
                continue;
            }
            if (info.getStatus() != AvdInfo.AvdStatus.ERROR_DEVICE_CHANGED) continue;
            AvdManagerConnection.updateDeviceChanged(info);
            needsRefresh = true;
        }
        if (needsRefresh) {
            List<AvdInfo> list = AvdManagerConnection.getAvds(true);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdManagerConnection", "getAvds"));
            }
            return list;
        }
        ArrayList arrayList = avdInfos;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdManagerConnection", "getAvds"));
        }
        return arrayList;
    }

    @Nullable
    public static Dimension getAvdResolution(@NotNull AvdInfo info) {
        File layoutFile;
        File skinPath;
        File skinDir;
        Matcher m;
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/android/tools/idea/avdmanager/AvdManagerConnection", "getAvdResolution"));
        }
        if (!AvdManagerConnection.initIfNecessary()) {
            return null;
        }
        Map properties = info.getProperties();
        String skin = (String)properties.get("skin.name");
        if (skin != null && (m = AvdManager.NUMERIC_SKIN_SIZE.matcher(skin)).matches()) {
            int size1 = Integer.parseInt(m.group(1));
            int size2 = Integer.parseInt(m.group(2));
            return new Dimension(size1, size2);
        }
        skin = (String)properties.get("skin.path");
        if (skin != null && (skinDir = (skinPath = new File(skin)).isAbsolute() ? skinPath : new File(ourAvdManager.getLocalSdk().getLocation(), skin)).isDirectory() && (layoutFile = new File(skinDir, "layout")).isFile()) {
            return AvdManagerConnection.getResolutionFromLayoutFile(layoutFile);
        }
        return null;
    }

    @Nullable
    protected static Dimension getResolutionFromLayoutFile(@NotNull File layoutFile) {
        SkinLayoutDefinition layoutDefinition;
        if (layoutFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layoutFile", "com/android/tools/idea/avdmanager/AvdManagerConnection", "getResolutionFromLayoutFile"));
        }
        if (!ourSkinLayoutDefinitions.containsKey(layoutFile)) {
            ourSkinLayoutDefinitions.put(layoutFile, SkinLayoutDefinition.parseFile(layoutFile));
        }
        if ((layoutDefinition = ourSkinLayoutDefinitions.get(layoutFile)) != null) {
            String heightString = layoutDefinition.get("parts.device.display.height");
            String widthString = layoutDefinition.get("parts.device.display.width");
            if (widthString == null || heightString == null) {
                return null;
            }
            int height = Integer.parseInt(heightString);
            int width = Integer.parseInt(widthString);
            return new Dimension(width, height);
        }
        return null;
    }

    @Nullable
    public static Density getAvdDensity(@NotNull AvdInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/android/tools/idea/avdmanager/AvdManagerConnection", "getAvdDensity"));
        }
        Map properties = info.getProperties();
        String densityString = (String)properties.get(AVD_INI_HW_LCD_DENSITY);
        if (densityString != null) {
            int density = Integer.parseInt(densityString);
            Density[] knownDensities = Density.values();
            int i = 0;
            while (density < knownDensities[i].getDpiValue()) {
                ++i;
            }
            if (i < knownDensities.length) {
                return knownDensities[i];
            }
            return null;
        }
        return null;
    }

    public static void deleteAvd(@NotNull AvdInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/android/tools/idea/avdmanager/AvdManagerConnection", "deleteAvd"));
        }
        if (!AvdManagerConnection.initIfNecessary()) {
            return;
        }
        ourAvdManager.deleteAvd(info, SDK_LOG);
    }

    public static void startAvd(@NotNull AvdInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/android/tools/idea/avdmanager/AvdManagerConnection", "startAvd"));
        }
        if (!AvdManagerConnection.initIfNecessary()) {
            return;
        }
        final String avdName = info.getName();
        if (info.isRunning()) {
            return;
        }
        Map properties = info.getProperties();
        final String scaleFactor = (String)properties.get("runtime.scalefactor");
        final String netDelay = (String)properties.get("runtime.network.latency");
        final String netSpeed = (String)properties.get("runtime.network.speed");
        final ProgressWindow p = new ProgressWindow(false, true, null);
        p.setIndeterminate(false);
        p.setDelayInMillis(0);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                StringBuildingOutputProcessor processor;
                block12: {
                    GeneralCommandLine commandLine = new GeneralCommandLine();
                    commandLine.setExePath(ourEmulatorBinary.getPath());
                    if (scaleFactor != null) {
                        commandLine.addParameters(new String[]{"-scale", scaleFactor});
                    }
                    if (netDelay != null) {
                        commandLine.addParameters(new String[]{"-netdelay", netDelay});
                    }
                    if (netSpeed != null) {
                        commandLine.addParameters(new String[]{"-netspeed", netSpeed});
                    }
                    commandLine.addParameters(new String[]{"-avd", avdName});
                    processor = new StringBuildingOutputProcessor();
                    try {
                        if (AndroidUtils.executeCommand(commandLine, processor, WaitingStrategies.WaitForTime.getInstance(1000)) != ExecutionStatus.TIMEOUT) break block12;
                        try {
                            p.start();
                            p.setText("Starting AVD...");
                            for (double d = 0.0; d < 1.0; d += 0.05) {
                                p.setFraction(d);
                                Thread.sleep(100L);
                            }
                        }
                        catch (InterruptedException ignore) {
                        }
                        finally {
                            p.stop();
                        }
                        return;
                    }
                    catch (ExecutionException e) {
                        IJ_LOG.error((Throwable)e);
                        return;
                    }
                }
                final String message = processor.getMessage();
                if (message.toLowerCase().contains("error")) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            IJ_LOG.error("Cannot launch AVD in emulator.\nOutput:\n" + message, new String[]{avdName});
                        }
                    });
                }
            }
        });
    }

    @Nullable
    public static AvdInfo createOrUpdateAvd(@Nullable AvdInfo currentInfo, @NotNull String avdName, @NotNull Device device, @NotNull AvdWizardConstants.SystemImageDescription systemImageDescription, @NotNull ScreenOrientation orientation, boolean isCircular, @Nullable String sdCard, @Nullable File skinFolder, @NotNull Map<String, String> hardwareProperties, boolean createSnapshot) {
        File avdFolder;
        if (avdName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "avdName", "com/android/tools/idea/avdmanager/AvdManagerConnection", "createOrUpdateAvd"));
        }
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/avdmanager/AvdManagerConnection", "createOrUpdateAvd"));
        }
        if (systemImageDescription == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "systemImageDescription", "com/android/tools/idea/avdmanager/AvdManagerConnection", "createOrUpdateAvd"));
        }
        if (orientation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orientation", "com/android/tools/idea/avdmanager/AvdManagerConnection", "createOrUpdateAvd"));
        }
        if (hardwareProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hardwareProperties", "com/android/tools/idea/avdmanager/AvdManagerConnection", "createOrUpdateAvd"));
        }
        if (!AvdManagerConnection.initIfNecessary()) {
            return null;
        }
        try {
            avdFolder = AvdInfo.getDefaultAvdFolder((AvdManager)ourAvdManager, (String)avdName);
        }
        catch (AndroidLocation.AndroidLocationException e) {
            IJ_LOG.error("Could not create AVD " + avdName, (Throwable)e);
            return null;
        }
        ISystemImage image = systemImageDescription.systemImage;
        Dimension resolution = device.getScreenSize(device.getDefaultState().getOrientation());
        assert (resolution != null);
        String skinName = null;
        if (skinFolder == null && isCircular) {
            skinFolder = AvdManagerConnection.getRoundSkin(systemImageDescription);
        }
        if (skinFolder == null) {
            skinName = String.format("%dx%d", Math.round(resolution.getWidth()), Math.round(resolution.getHeight()));
        }
        return ourAvdManager.createAvd(avdFolder, avdName, systemImageDescription.target, image.getTag(), image.getAbiType(), skinFolder, skinName, sdCard, hardwareProperties, device.getBootProps(), createSnapshot, false, currentInfo != null, SDK_LOG);
    }

    @Nullable
    private static File getRoundSkin(AvdWizardConstants.SystemImageDescription systemImageDescription) {
        File[] skins;
        for (File skin : skins = systemImageDescription.systemImage.getSkins()) {
            if (!skin.getName().contains("Round")) continue;
            return skin;
        }
        return null;
    }

    public static boolean avdExists(String candidate) {
        if (!AvdManagerConnection.initIfNecessary()) {
            return false;
        }
        return ourAvdManager.getAvd(candidate, false) != null;
    }

    static boolean isAvdRepairable(AvdInfo.AvdStatus avdStatus) {
        return avdStatus == AvdInfo.AvdStatus.ERROR_IMAGE_DIR || avdStatus == AvdInfo.AvdStatus.ERROR_DEVICE_CHANGED || avdStatus == AvdInfo.AvdStatus.ERROR_DEVICE_MISSING;
    }

    public static boolean updateAvdImageFolder(@NotNull AvdInfo avdInfo) {
        if (avdInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "avdInfo", "com/android/tools/idea/avdmanager/AvdManagerConnection", "updateAvdImageFolder"));
        }
        if (AvdManagerConnection.initIfNecessary()) {
            try {
                ourAvdManager.updateAvd(avdInfo, SDK_LOG);
                return true;
            }
            catch (IOException e) {
                IJ_LOG.error("Could not update AVD " + avdInfo.getName(), (Throwable)e);
            }
        }
        return false;
    }

    public static boolean updateDeviceChanged(@NotNull AvdInfo avdInfo) {
        if (avdInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "avdInfo", "com/android/tools/idea/avdmanager/AvdManagerConnection", "updateDeviceChanged"));
        }
        if (AvdManagerConnection.initIfNecessary()) {
            try {
                ourAvdManager.updateDeviceChanged(avdInfo, SDK_LOG);
                return true;
            }
            catch (IOException e) {
                IJ_LOG.error("Could not update AVD Device " + avdInfo.getName(), (Throwable)e);
            }
        }
        return false;
    }

    public static boolean wipeUserData(@NotNull AvdInfo avdInfo) {
        if (avdInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "avdInfo", "com/android/tools/idea/avdmanager/AvdManagerConnection", "wipeUserData"));
        }
        if (AvdManagerConnection.initIfNecessary()) {
            File userdataImage = new File(avdInfo.getDataFolderPath(), "userdata-qemu.img");
            if (userdataImage.isFile()) {
                return userdataImage.delete();
            }
            return true;
        }
        return false;
    }

    static {
        ourSkinLayoutDefinitions = Maps.newHashMap();
    }
}

