/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.resources.Density;
import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenSize;
import com.android.sdklib.devices.CameraLocation;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.Storage;
import com.android.tools.idea.avdmanager.AvdConfigurationOptionHelpPanel;
import com.android.tools.idea.avdmanager.AvdScaleFactor;
import com.android.tools.idea.avdmanager.AvdWizardConstants;
import com.android.tools.idea.avdmanager.DeviceDefinitionList;
import com.android.tools.idea.avdmanager.DeviceDefinitionPreview;
import com.android.tools.idea.avdmanager.StorageField;
import com.android.tools.idea.avdmanager.SystemImagePreview;
import com.android.tools.idea.wizard.ASGallery;
import com.android.tools.idea.wizard.ChooseModuleTypeStep;
import com.android.tools.idea.wizard.DynamicWizard;
import com.android.tools.idea.wizard.DynamicWizardStepWithHeaderAndDescription;
import com.android.tools.idea.wizard.ScopedDataBinder;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import icons.AndroidIcons;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureAvdOptionsStep
extends DynamicWizardStepWithHeaderAndDescription {
    private static final String EXISTING_SDCARD = "existingsdcard";
    private static final String NEW_SDCARD = "newsdcard";
    private JBLabel myDeviceName;
    private JBLabel myDeviceDetails;
    private JButton myChangeDeviceButton;
    private JBLabel mySystemImageName;
    private JBLabel mySystemImageDetails;
    private JButton myChangeSystemImageButton;
    private TextFieldWithBrowseButton myExistingSdCard;
    private JPanel mySdCardSettings;
    private JComboBox myScalingComboBox;
    private ASGallery<ScreenOrientation> myOrientationToggle;
    private JPanel myRoot;
    private JCheckBox myUseHostGPUCheckBox;
    private JCheckBox myStoreASnapshotForCheckBox;
    private JComboBox myFrontCameraCombo;
    private JComboBox myBackCameraCombo;
    private JComboBox mySpeedCombo;
    private JComboBox myLatencyCombo;
    private JButton myShowAdvancedSettingsButton;
    private AvdConfigurationOptionHelpPanel myAvdConfigurationOptionHelpPanel;
    private JBLabel myToggleSdCardSettingsLabel;
    private JPanel myMemoryAndStoragePanel;
    private JPanel myStartupOptionsPanel;
    private JPanel myNetworkPanel;
    private JPanel myCameraPanel;
    private JPanel myPerformancePanel;
    private StorageField myRamStorage;
    private StorageField myVmHeapStorage;
    private StorageField myInternalStorage;
    private StorageField myNewSdCardStorage;
    private JBLabel myMemoryAndStorageLabel;
    private JBLabel myRamLabel;
    private JBLabel myVmHeapLabel;
    private JBLabel myInternalStorageLabel;
    private JBLabel mySdCardLabel;
    private JPanel mySkinPanel;
    private TextFieldWithBrowseButton myCustomSkinPath;
    private HyperlinkLabel myHardwareSkinHelpLabel;
    private Set<JComponent> myAdvancedOptionsComponents;
    private static final String ADVANCED_SETTINGS = "Advanced Settings";
    private static final String SHOW = "Show Advanced Settings";
    private static final String HIDE = "Hide Advanced Settings";
    private static final String SWITCH_TO_NEW_SD_CARD = "Or create a new image...";
    private static final String SWITCH_TO_EXISTING_SD_CARD = "Or use an existing data file...";
    private Set<JComponent> myErrorStateComponents;
    private static final ScopedStateStore.Key<String> CUSTOM_SKIN_PATH_KEY = ScopedStateStore.createKey("AvdManager.WizardOnly.CustomSkinPath", ScopedStateStore.Scope.STEP, String.class);
    private static final Map<ScreenOrientation, NamedIcon> ORIENTATIONS = ImmutableMap.of((Object)ScreenOrientation.PORTRAIT, (Object)new NamedIcon("Portrait", AndroidIcons.Portrait), (Object)ScreenOrientation.LANDSCAPE, (Object)new NamedIcon("Landscape", AndroidIcons.Landscape));
    private static final ScopedDataBinder.ComponentBinding<Device, JBLabel> DEVICE_NAME_BINDING = new ScopedDataBinder.ComponentBinding<Device, JBLabel>(){

        @Override
        public void setValue(@Nullable Device newValue, @NotNull JBLabel component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$15", "setValue"));
            }
            if (newValue != null) {
                component.setText(newValue.getDisplayName());
                Icon icon = DeviceDefinitionPreview.getIcon(newValue);
                component.setIcon(icon);
            }
        }
    };
    private static final ScopedDataBinder.ComponentBinding<Device, JBLabel> DEVICE_DETAILS_BINDING = new ScopedDataBinder.ComponentBinding<Device, JBLabel>(){

        @Override
        public void setValue(@Nullable Device newValue, @NotNull JBLabel component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$16", "setValue"));
            }
            if (newValue != null) {
                String description = Joiner.on((char)' ').join((Object)DeviceDefinitionList.getDiagonalSize(newValue), (Object)DeviceDefinitionList.getDimensionString(newValue), new Object[]{DeviceDefinitionList.getDensityString(newValue)});
                component.setText(description);
            }
        }
    };
    private static final ScopedDataBinder.ComponentBinding<AvdWizardConstants.SystemImageDescription, JBLabel> SYSTEM_IMAGE_NAME_BINDING = new ScopedDataBinder.ComponentBinding<AvdWizardConstants.SystemImageDescription, JBLabel>(){

        @Override
        public void setValue(@Nullable AvdWizardConstants.SystemImageDescription newValue, @NotNull JBLabel component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$17", "setValue"));
            }
            if (newValue != null) {
                String codeName = SystemImagePreview.getCodeName(newValue);
                component.setText(codeName);
                try {
                    Icon icon = IconLoader.getIcon((String)String.format("/icons/versions/%s_32.png", codeName), AndroidIcons.class);
                    component.setIcon(icon);
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
            }
        }
    };
    private static final ScopedDataBinder.ComponentBinding<AvdWizardConstants.SystemImageDescription, JBLabel> SYSTEM_IMAGE_DESCRIPTION_BINDING = new ScopedDataBinder.ComponentBinding<AvdWizardConstants.SystemImageDescription, JBLabel>(){

        @Override
        public void setValue(@Nullable AvdWizardConstants.SystemImageDescription newValue, @NotNull JBLabel component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$18", "setValue"));
            }
            if (newValue != null) {
                component.setText(newValue.target.getFullName() + " " + newValue.systemImage.getAbiType());
            }
        }
    };
    public static final ScopedDataBinder.ComponentBinding<ScreenOrientation, ASGallery<ScreenOrientation>> ORIENTATION_BINDING = new ScopedDataBinder.ComponentBinding<ScreenOrientation, ASGallery<ScreenOrientation>>(){

        @Override
        @Nullable
        public ScreenOrientation getValue(@NotNull ASGallery<ScreenOrientation> component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$19", "getValue"));
            }
            return component.getSelectedElement();
        }

        @Override
        public void setValue(@Nullable ScreenOrientation newValue, @NotNull ASGallery<ScreenOrientation> component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$19", "setValue"));
            }
            component.setSelectedElement(newValue);
        }
    };
    private static final ScopedDataBinder.ComponentBinding<String, JComboBox> STRING_COMBO_BINDING = new ScopedDataBinder.ComponentBinding<String, JComboBox>(){

        @Override
        public void setValue(@Nullable String newValue, @NotNull JComboBox component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$20", "setValue"));
            }
            if (newValue == null) {
                return;
            }
            for (int i = 0; i < component.getItemCount(); ++i) {
                if (!newValue.equalsIgnoreCase((String)component.getItemAt(i))) continue;
                component.setSelectedIndex(i);
            }
        }

        @Override
        @Nullable
        public String getValue(@NotNull JComboBox component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$20", "getValue"));
            }
            return component.getSelectedItem().toString().toLowerCase();
        }

        @Override
        public void addItemListener(@NotNull ItemListener listener, @NotNull JComboBox component) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$20", "addItemListener"));
            }
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$20", "addItemListener"));
            }
            component.addItemListener(listener);
        }
    };

    public ConfigureAvdOptionsStep(@Nullable Disposable parentDisposable) {
        super("Configure AVD", null, null, parentDisposable);
        this.$$$setupUI$$$();
        this.myErrorStateComponents = Sets.newHashSet();
        this.myAvdConfigurationOptionHelpPanel.setPreferredSize(new Dimension(360, -1));
        this.setBodyComponent(this.myRoot);
        this.registerAdvancedOptionsVisibility();
        this.toggleAdvancedSettings(false);
        this.myToggleSdCardSettingsLabel.setText(SWITCH_TO_EXISTING_SD_CARD);
        this.myShowAdvancedSettingsButton.setText(SHOW);
        ActionListener toggleAdvancedSettingsListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConfigureAvdOptionsStep.this.myShowAdvancedSettingsButton.getText().equals(ConfigureAvdOptionsStep.SHOW)) {
                    ConfigureAvdOptionsStep.this.toggleAdvancedSettings(true);
                    ConfigureAvdOptionsStep.this.myShowAdvancedSettingsButton.setText(ConfigureAvdOptionsStep.HIDE);
                } else {
                    ConfigureAvdOptionsStep.this.toggleAdvancedSettings(false);
                    ConfigureAvdOptionsStep.this.myShowAdvancedSettingsButton.setText(ConfigureAvdOptionsStep.SHOW);
                }
            }
        };
        this.myShowAdvancedSettingsButton.addActionListener(toggleAdvancedSettingsListener);
        this.myChangeDeviceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DynamicWizard wizard = ConfigureAvdOptionsStep.this.getWizard();
                if (wizard != null) {
                    wizard.navigateToNamedStep("Choose Device Definition Step", false);
                }
            }
        });
        this.myChangeSystemImageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DynamicWizard wizard = ConfigureAvdOptionsStep.this.getWizard();
                if (wizard != null) {
                    wizard.navigateToNamedStep("Choose System Image Step", false);
                }
            }
        });
        this.myToggleSdCardSettingsLabel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ConfigureAvdOptionsStep.this.toggleSdCardSettings(ConfigureAvdOptionsStep.SWITCH_TO_EXISTING_SD_CARD.equals(ConfigureAvdOptionsStep.this.myToggleSdCardSettingsLabel.getText()));
            }
        });
        this.myToggleSdCardSettingsLabel.setForeground((Color)JBColor.blue);
    }

    private void toggleSdCardSettings(boolean useExisting) {
        if (useExisting) {
            ((CardLayout)this.mySdCardSettings.getLayout()).show(this.mySdCardSettings, EXISTING_SDCARD);
            this.myToggleSdCardSettingsLabel.setText(SWITCH_TO_NEW_SD_CARD);
            this.myState.put(AvdWizardConstants.USE_EXISTING_SD_CARD, true);
        } else {
            ((CardLayout)this.mySdCardSettings.getLayout()).show(this.mySdCardSettings, NEW_SDCARD);
            this.myToggleSdCardSettingsLabel.setText(SWITCH_TO_EXISTING_SD_CARD);
            this.myState.put(AvdWizardConstants.USE_EXISTING_SD_CARD, false);
        }
    }

    @Override
    public void init() {
        super.init();
        this.registerComponents();
        this.deregister(this.getDescriptionText());
        this.getDescriptionText().setVisible(false);
    }

    @Override
    public void onEnterStep() {
        Boolean useExisting;
        super.onEnterStep();
        Device device = this.myState.get(AvdWizardConstants.DEVICE_DEFINITION_KEY);
        if (device != null) {
            this.toggleOptionals(device);
        }
        if ((useExisting = this.myState.get(AvdWizardConstants.USE_EXISTING_SD_CARD)) != null) {
            this.toggleSdCardSettings(useExisting);
        }
    }

    @Override
    public boolean validate() {
        File layoutFile;
        Boolean useExistingSd;
        Storage internal;
        Storage vmHeap;
        this.clearErrorState();
        boolean valid = true;
        Storage ram = this.myState.get(AvdWizardConstants.RAM_STORAGE_KEY);
        if (ram == null || ram.getSizeAsUnit(Storage.Unit.MiB) < 128L) {
            this.setErrorState("RAM must be a numeric (integer) value of at least 128Mb. Recommendation is 1Gb.", new JComponent[]{this.myMemoryAndStorageLabel, this.myRamLabel, this.myRamStorage});
            valid = false;
        }
        if ((vmHeap = this.myState.get(AvdWizardConstants.VM_HEAP_STORAGE_KEY)) == null || vmHeap.getSizeAsUnit(Storage.Unit.MiB) < 16L) {
            this.setErrorState("VM Heap must be a numeric (integer) value of at least 16Mb.", new JComponent[]{this.myMemoryAndStorageLabel, this.myVmHeapLabel, this.myVmHeapStorage});
            valid = false;
        }
        if ((internal = this.myState.get(AvdWizardConstants.INTERNAL_STORAGE_KEY)) == null || internal.getSizeAsUnit(Storage.Unit.MiB) < 200L) {
            this.setErrorState("Internal storage must be a numeric (integer) value of at least 200Mb.", new JComponent[]{this.myMemoryAndStorageLabel, this.myInternalStorageLabel, this.myInternalStorage});
            valid = false;
        }
        if ((useExistingSd = this.myState.get(AvdWizardConstants.USE_EXISTING_SD_CARD)) != null && useExistingSd.booleanValue()) {
            String path = this.myState.get(AvdWizardConstants.EXISTING_SD_LOCATION);
            if (path == null || !new File(path).isFile()) {
                this.setErrorState("The specified SD image file must be a valid image file", new JComponent[]{this.myMemoryAndStorageLabel, this.mySdCardLabel, this.myExistingSdCard});
                valid = false;
            }
        } else {
            Storage sdCard = this.myState.get(AvdWizardConstants.SD_CARD_STORAGE_KEY);
            if (sdCard != null && (sdCard.getSizeAsUnit(Storage.Unit.MiB) < 30L || sdCard.getSizeAsUnit(Storage.Unit.GiB) > 1023L)) {
                this.setErrorState("The SD card must be between 30Mb and 1023Gb", new JComponent[]{this.myMemoryAndStorageLabel, this.mySdCardLabel, this.myNewSdCardStorage});
                valid = false;
            }
        }
        File skinDir = this.myState.get(AvdWizardConstants.CUSTOM_SKIN_FILE_KEY);
        if (skinDir != null && !(layoutFile = new File(skinDir, "layout")).isFile()) {
            this.setErrorHtml("The skin directory does not point to a valid skin.");
            valid = false;
        }
        return valid;
    }

    private void clearErrorState() {
        for (JComponent c : this.myErrorStateComponents) {
            if (c instanceof JLabel) {
                c.setForeground(JBColor.foreground());
                ((JLabel)c).setIcon(null);
                continue;
            }
            if (c instanceof StorageField) {
                ((StorageField)c).setError(false);
                continue;
            }
            c.setBorder(null);
        }
        this.myAvdConfigurationOptionHelpPanel.setErrorMessage("");
    }

    private void setErrorState(String message, JComponent ... errorComponents) {
        this.myAvdConfigurationOptionHelpPanel.setErrorMessage(message);
        for (JComponent c : errorComponents) {
            if (c instanceof JLabel) {
                c.setForeground((Color)JBColor.RED);
                ((JLabel)c).setIcon(AllIcons.General.BalloonError);
            } else if (c instanceof StorageField) {
                ((StorageField)c).setError(true);
            } else {
                c.setBorder(new LineBorder((Color)JBColor.RED));
            }
            this.myErrorStateComponents.add(c);
        }
    }

    private void registerComponents() {
        this.register(AvdWizardConstants.DEVICE_DEFINITION_KEY, this.myDeviceName, DEVICE_NAME_BINDING);
        this.register(AvdWizardConstants.DEVICE_DEFINITION_KEY, this.myDeviceDetails, DEVICE_DETAILS_BINDING);
        this.register(AvdWizardConstants.SYSTEM_IMAGE_KEY, this.mySystemImageName, SYSTEM_IMAGE_NAME_BINDING);
        this.register(AvdWizardConstants.SYSTEM_IMAGE_KEY, this.mySystemImageDetails, SYSTEM_IMAGE_DESCRIPTION_BINDING);
        this.register(AvdWizardConstants.RAM_STORAGE_KEY, this.myRamStorage, this.myRamStorage.getBinding());
        this.setControlDescription(this.myRamStorage, this.myAvdConfigurationOptionHelpPanel.getDescription(AvdWizardConstants.RAM_STORAGE_KEY));
        this.register(AvdWizardConstants.VM_HEAP_STORAGE_KEY, this.myVmHeapStorage, this.myVmHeapStorage.getBinding());
        this.setControlDescription(this.myVmHeapStorage, this.myAvdConfigurationOptionHelpPanel.getDescription(AvdWizardConstants.VM_HEAP_STORAGE_KEY));
        this.register(AvdWizardConstants.INTERNAL_STORAGE_KEY, this.myInternalStorage, this.myInternalStorage.getBinding());
        this.setControlDescription(this.myInternalStorage, this.myAvdConfigurationOptionHelpPanel.getDescription(AvdWizardConstants.INTERNAL_STORAGE_KEY));
        this.register(AvdWizardConstants.SD_CARD_STORAGE_KEY, this.myNewSdCardStorage, this.myNewSdCardStorage.getBinding());
        this.setControlDescription(this.myNewSdCardStorage, this.myAvdConfigurationOptionHelpPanel.getDescription(AvdWizardConstants.SD_CARD_STORAGE_KEY));
        this.register(AvdWizardConstants.USE_SNAPSHOT_KEY, this.myStoreASnapshotForCheckBox);
        this.setControlDescription(this.myStoreASnapshotForCheckBox, this.myAvdConfigurationOptionHelpPanel.getDescription(AvdWizardConstants.USE_SNAPSHOT_KEY));
        this.register(AvdWizardConstants.USE_HOST_GPU_KEY, this.myUseHostGPUCheckBox);
        this.setControlDescription(this.myUseHostGPUCheckBox, this.myAvdConfigurationOptionHelpPanel.getDescription(AvdWizardConstants.USE_HOST_GPU_KEY));
        if (Boolean.FALSE.equals(this.myState.get(AvdWizardConstants.IS_IN_EDIT_MODE_KEY))) {
            this.registerValueDeriver(AvdWizardConstants.RAM_STORAGE_KEY, new MemoryValueDeriver(){

                @Override
                @Nullable
                protected Storage getStorage(@NotNull Device device) {
                    if (device == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$5", "getStorage"));
                    }
                    return device.getDefaultHardware().getRam();
                }
            });
            this.registerValueDeriver(AvdWizardConstants.VM_HEAP_STORAGE_KEY, new MemoryValueDeriver(){

                @Override
                @Nullable
                protected Storage getStorage(@NotNull Device device) {
                    if (device == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$6", "getStorage"));
                    }
                    return ConfigureAvdOptionsStep.calculateVmHeap(device);
                }
            });
        }
        this.registerValueDeriver(AvdWizardConstants.DEFAULT_ORIENTATION_KEY, new ScopedDataBinder.ValueDeriver<ScreenOrientation>(){

            @Override
            @Nullable
            public Set<ScopedStateStore.Key<?>> getTriggerKeys() {
                return 7.makeSetOf(AvdWizardConstants.DEVICE_DEFINITION_KEY);
            }

            @Override
            @Nullable
            public ScreenOrientation deriveValue(@NotNull ScopedStateStore state, @Nullable ScopedStateStore.Key changedKey, @Nullable ScreenOrientation currentValue) {
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$7", "deriveValue"));
                }
                Device device = state.get(AvdWizardConstants.DEVICE_DEFINITION_KEY);
                if (device != null) {
                    return device.getDefaultState().getOrientation();
                }
                return null;
            }
        });
        this.register(AvdWizardConstants.DEFAULT_ORIENTATION_KEY, this.myOrientationToggle, ORIENTATION_BINDING);
        this.setControlDescription(this.myOrientationToggle, this.myAvdConfigurationOptionHelpPanel.getDescription(AvdWizardConstants.DEFAULT_ORIENTATION_KEY));
        this.myOrientationToggle.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ConfigureAvdOptionsStep.this.saveState(ConfigureAvdOptionsStep.this.myOrientationToggle);
            }
        });
        FileChooserDescriptor fileChooserDescriptor = new FileChooserDescriptor(true, false, false, false, false, false){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                return super.isFileVisible(file, true);
            }
        };
        fileChooserDescriptor.setHideIgnored(false);
        this.myExistingSdCard.addBrowseFolderListener("Select SD Card", "Select an existing SD card image", this.getProject(), fileChooserDescriptor);
        this.register(AvdWizardConstants.EXISTING_SD_LOCATION, this.myExistingSdCard);
        this.setControlDescription((Component)this.myExistingSdCard, this.myAvdConfigurationOptionHelpPanel.getDescription(AvdWizardConstants.EXISTING_SD_LOCATION));
        this.register(AvdWizardConstants.FRONT_CAMERA_KEY, this.myFrontCameraCombo, STRING_COMBO_BINDING);
        this.setControlDescription(this.myFrontCameraCombo, this.myAvdConfigurationOptionHelpPanel.getDescription(AvdWizardConstants.FRONT_CAMERA_KEY));
        this.register(AvdWizardConstants.BACK_CAMERA_KEY, this.myBackCameraCombo, STRING_COMBO_BINDING);
        this.setControlDescription(this.myBackCameraCombo, this.myAvdConfigurationOptionHelpPanel.getDescription(AvdWizardConstants.BACK_CAMERA_KEY));
        this.register(AvdWizardConstants.SCALE_SELECTION_KEY, this.myScalingComboBox, new ScopedDataBinder.ComponentBinding<AvdScaleFactor, JComboBox>(){

            @Override
            public void addActionListener(@NotNull ActionListener listener, @NotNull JComboBox component) {
                if (listener == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$10", "addActionListener"));
                }
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$10", "addActionListener"));
                }
                component.addActionListener(listener);
            }

            @Override
            @Nullable
            public AvdScaleFactor getValue(@NotNull JComboBox component) {
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$10", "getValue"));
                }
                return (AvdScaleFactor)((Object)component.getSelectedItem());
            }

            @Override
            public void setValue(@Nullable AvdScaleFactor newValue, @NotNull JComboBox component) {
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$10", "setValue"));
                }
                if (newValue != null) {
                    component.setSelectedItem((Object)newValue);
                }
            }
        });
        this.setControlDescription(this.myScalingComboBox, this.myAvdConfigurationOptionHelpPanel.getDescription(AvdWizardConstants.SCALE_SELECTION_KEY));
        this.register(AvdWizardConstants.NETWORK_LATENCY_KEY, this.myLatencyCombo, STRING_COMBO_BINDING);
        this.setControlDescription(this.myLatencyCombo, this.myAvdConfigurationOptionHelpPanel.getDescription(AvdWizardConstants.NETWORK_LATENCY_KEY));
        this.register(AvdWizardConstants.NETWORK_SPEED_KEY, this.mySpeedCombo, STRING_COMBO_BINDING);
        this.setControlDescription(this.mySpeedCombo, this.myAvdConfigurationOptionHelpPanel.getDescription(AvdWizardConstants.NETWORK_SPEED_KEY));
        this.register(KEY_DESCRIPTION, this.myAvdConfigurationOptionHelpPanel, new ScopedDataBinder.ComponentBinding<String, AvdConfigurationOptionHelpPanel>(){

            @Override
            public void setValue(@Nullable String newValue, @NotNull AvdConfigurationOptionHelpPanel component) {
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$11", "setValue"));
                }
                component.setDescriptionText(newValue);
            }
        });
        File currentSkinFile = this.myState.get(AvdWizardConstants.CUSTOM_SKIN_FILE_KEY);
        if (currentSkinFile != null) {
            this.myState.put(CUSTOM_SKIN_PATH_KEY, currentSkinFile.getPath());
        }
        this.register(CUSTOM_SKIN_PATH_KEY, this.myCustomSkinPath);
        FileChooserDescriptor skinChooserDescriptor = new FileChooserDescriptor(false, true, false, false, false, false);
        this.myCustomSkinPath.addBrowseFolderListener("Select Custom Skin", "Select the directory containing your custom skin definition", this.getProject(), skinChooserDescriptor);
        this.setControlDescription((Component)this.myCustomSkinPath, this.myAvdConfigurationOptionHelpPanel.getDescription(AvdWizardConstants.CUSTOM_SKIN_FILE_KEY));
        this.registerValueDeriver(AvdWizardConstants.CUSTOM_SKIN_FILE_KEY, new ScopedDataBinder.ValueDeriver<File>(){

            @Override
            @Nullable
            public Set<ScopedStateStore.Key<?>> getTriggerKeys() {
                return 12.makeSetOf(CUSTOM_SKIN_PATH_KEY);
            }

            @Override
            @Nullable
            public File deriveValue(@NotNull ScopedStateStore state, @Nullable ScopedStateStore.Key changedKey, @Nullable File currentValue) {
                File file;
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$12", "deriveValue"));
                }
                String path = (String)state.get(CUSTOM_SKIN_PATH_KEY);
                if (path != null && (file = new File(path)).isDirectory()) {
                    return file;
                }
                return null;
            }
        });
        this.invokeUpdate(null);
    }

    private void createUIComponents() {
        this.myOrientationToggle = new ASGallery<ScreenOrientation>(JBList.createDefaultListModel((Object[])new Object[]{ScreenOrientation.PORTRAIT, ScreenOrientation.LANDSCAPE}), new Function<ScreenOrientation, Image>(){

            public Image apply(ScreenOrientation input) {
                return ChooseModuleTypeStep.iconToImage(((NamedIcon)ORIENTATIONS.get(input)).myIcon);
            }
        }, new Function<ScreenOrientation, String>(){

            public String apply(ScreenOrientation input) {
                return ((NamedIcon)ORIENTATIONS.get(input)).myName;
            }
        }, new Dimension(50, 50));
        this.myOrientationToggle.setCellMargin(new Insets(3, 5, 3, 5));
        this.myOrientationToggle.setBackground(JBColor.background());
        this.myOrientationToggle.setForeground(JBColor.foreground());
        this.myScalingComboBox = new ComboBox((ComboBoxModel)new EnumComboBoxModel(AvdScaleFactor.class));
        this.myHardwareSkinHelpLabel = new HyperlinkLabel("How do I create a custom hardware skin?");
        this.myHardwareSkinHelpLabel.setHyperlinkTarget("");
    }

    @Override
    @NotNull
    public String getStepName() {
        if ("Configure AVD Options" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep", "getStepName"));
        }
        return "Configure AVD Options";
    }

    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    private void registerAdvancedOptionsVisibility() {
        this.myAdvancedOptionsComponents = ImmutableSet.of((Object)this.myMemoryAndStoragePanel, (Object)this.myCameraPanel, (Object)this.myNetworkPanel, (Object)this.mySkinPanel);
    }

    private void toggleAdvancedSettings(boolean show) {
        for (JComponent c : this.myAdvancedOptionsComponents) {
            c.setVisible(show);
        }
        this.myRoot.validate();
    }

    private void toggleOptionals(@NotNull Device device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep", "toggleOptionals"));
        }
        this.myFrontCameraCombo.setEnabled(device.getDefaultHardware().getCamera(CameraLocation.FRONT) != null);
        this.myBackCameraCombo.setEnabled(device.getDefaultHardware().getCamera(CameraLocation.BACK) != null);
        this.myOrientationToggle.setEnabled(device.getDefaultState().getOrientation() != ScreenOrientation.SQUARE);
    }

    private static Storage calculateVmHeap(@NotNull Device device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep", "calculateVmHeap"));
        }
        Screen s = device.getDefaultHardware().getScreen();
        ScreenSize size = s.getSize();
        Density density = s.getPixelDensity();
        int vmHeapSize = 32;
        if (size.equals((Object)ScreenSize.XLARGE)) {
            switch (density) {
                case LOW: 
                case MEDIUM: {
                    vmHeapSize = 32;
                    break;
                }
                case TV: 
                case HIGH: {
                    vmHeapSize = 64;
                    break;
                }
                case XHIGH: 
                case XXHIGH: 
                case XXXHIGH: {
                    vmHeapSize = 128;
                    break;
                }
            }
        } else {
            switch (density) {
                case LOW: 
                case MEDIUM: {
                    vmHeapSize = 16;
                    break;
                }
                case TV: 
                case HIGH: {
                    vmHeapSize = 32;
                    break;
                }
                case XHIGH: 
                case XXHIGH: 
                case XXXHIGH: {
                    vmHeapSize = 64;
                    break;
                }
            }
        }
        return new Storage((long)vmHeapSize, Storage.Unit.MiB);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        AvdConfigurationOptionHelpPanel avdConfigurationOptionHelpPanel;
        JButton jButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JPanel jPanel2;
        JComboBox jComboBox;
        JComboBox jComboBox2;
        JPanel jPanel3;
        JComboBox jComboBox3;
        JComboBox jComboBox4;
        JPanel jPanel4;
        JPanel jPanel5;
        StorageField storageField;
        StorageField storageField2;
        StorageField storageField3;
        JBLabel jBLabel;
        JBLabel jBLabel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        StorageField storageField4;
        JPanel jPanel6;
        JBLabel jBLabel3;
        JBLabel jBLabel4;
        JBLabel jBLabel5;
        JBLabel jBLabel6;
        JPanel jPanel7;
        JButton jButton2;
        JButton jButton3;
        JBLabel jBLabel7;
        JBLabel jBLabel8;
        JBLabel jBLabel9;
        JBLabel jBLabel10;
        JPanel jPanel8;
        this.createUIComponents();
        this.myRoot = jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jBScrollPane.setHorizontalScrollBarPolicy(30);
        jPanel8.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, new Dimension(720, -1)));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(10, 3, new Insets(3, 3, 3, 10), -1, 5, false, false));
        jBScrollPane.setViewportView(jPanel9);
        this.myDeviceName = jBLabel10 = new JBLabel();
        jPanel9.add((Component)jBLabel10, new GridConstraints(0, 0, 1, 1, 8, 0, 2, 0, null, null, null));
        this.myDeviceDetails = jBLabel9 = new JBLabel();
        jBLabel9.setText("No Hardware Profile Selected");
        jPanel9.add((Component)jBLabel9, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        this.mySystemImageName = jBLabel8 = new JBLabel();
        jPanel9.add((Component)jBLabel8, new GridConstraints(2, 0, 1, 1, 8, 0, 2, 0, null, null, null));
        this.mySystemImageDetails = jBLabel7 = new JBLabel();
        jBLabel7.setText("No System Image Selected");
        jPanel9.add((Component)jBLabel7, new GridConstraints(2, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        this.myChangeSystemImageButton = jButton3 = new JButton();
        jButton3.setText("Change...");
        jPanel9.add((Component)jButton3, new GridConstraints(2, 2, 1, 1, 4, 0, 3, 0, null, null, null));
        this.myChangeDeviceButton = jButton2 = new JButton();
        jButton2.setText("Change...");
        jPanel9.add((Component)jButton2, new GridConstraints(0, 2, 1, 1, 4, 0, 3, 0, null, null, null));
        JSeparator jSeparator = new JSeparator();
        jPanel9.add((Component)jSeparator, new GridConstraints(1, 0, 1, 3, 1, 1, 3, 1, null, null, null));
        JSeparator jSeparator2 = new JSeparator();
        jPanel9.add((Component)jSeparator2, new GridConstraints(3, 0, 1, 3, 1, 1, 3, 1, null, null, null));
        this.myMemoryAndStoragePanel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel9.add((Component)jPanel7, new GridConstraints(5, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myMemoryAndStorageLabel = jBLabel6 = new JBLabel();
        jBLabel6.setHorizontalTextPosition(10);
        jBLabel6.setEnabled(true);
        jBLabel6.setText("<html>Memory<br>and<br>Storage</html>");
        jPanel7.add((Component)jBLabel6, new GridConstraints(0, 0, 5, 1, 9, 0, 2, 0, null, new Dimension(100, -1), null));
        this.myRamLabel = jBLabel5 = new JBLabel();
        jBLabel5.setText("RAM:");
        jPanel7.add((Component)jBLabel5, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVmHeapLabel = jBLabel4 = new JBLabel();
        jBLabel4.setText("VM heap:");
        jPanel7.add((Component)jBLabel4, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myInternalStorageLabel = jBLabel3 = new JBLabel();
        jBLabel3.setText("Internal Storage:");
        jPanel7.add((Component)jBLabel3, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySdCardSettings = jPanel6 = new JPanel();
        jPanel6.setLayout(new CardLayout(0, 0));
        jPanel7.add((Component)jPanel6, new GridConstraints(3, 2, 1, 1, 9, 0, 3, 0, null, new Dimension(200, -1), null));
        this.myNewSdCardStorage = storageField4 = new StorageField();
        jPanel6.add((Component)storageField4, NEW_SDCARD);
        this.myExistingSdCard = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel6.add((Component)textFieldWithBrowseButton2, EXISTING_SDCARD);
        this.mySdCardLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("SD card:");
        jPanel7.add((Component)jBLabel2, new GridConstraints(3, 1, 2, 1, 8, 0, 0, 0, null, null, null));
        this.myToggleSdCardSettingsLabel = jBLabel = new JBLabel();
        jPanel7.add((Component)jBLabel, new GridConstraints(4, 2, 1, 1, 8, 0, 2, 0, null, null, null));
        this.myRamStorage = storageField3 = new StorageField();
        jPanel7.add((Component)storageField3, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 3, null, new Dimension(200, -1), null));
        this.myVmHeapStorage = storageField2 = new StorageField();
        jPanel7.add((Component)storageField2, new GridConstraints(1, 2, 1, 1, 8, 0, 3, 3, null, new Dimension(200, -1), null));
        this.myInternalStorage = storageField = new StorageField();
        jPanel7.add((Component)storageField, new GridConstraints(2, 2, 1, 1, 8, 0, 3, 3, null, new Dimension(200, -1), null));
        JSeparator jSeparator3 = new JSeparator();
        jPanel7.add((Component)jSeparator3, new GridConstraints(5, 0, 1, 3, 1, 1, 3, 1, null, null, null));
        this.myStartupOptionsPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel9.add((Component)jPanel5, new GridConstraints(6, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel11 = new JBLabel();
        jBLabel11.setHorizontalTextPosition(10);
        jBLabel11.setEnabled(true);
        jBLabel11.setText("<html>Startup size<br>and<br>orientation</html>");
        jPanel5.add((Component)jBLabel11, new GridConstraints(0, 0, 1, 1, 9, 0, 0, 0, null, new Dimension(100, -1), null));
        JComboBox jComboBox5 = this.myScalingComboBox;
        jPanel5.add((Component)jComboBox5, new GridConstraints(0, 2, 1, 1, 8, 0, 2, 0, null, null, null));
        ASGallery<ScreenOrientation> aSGallery = this.myOrientationToggle;
        jPanel5.add(aSGallery, new GridConstraints(1, 2, 1, 1, 9, 0, 3, 3, null, new Dimension(200, 50), null));
        JBLabel jBLabel12 = new JBLabel();
        jBLabel12.setText("Scale:");
        jPanel5.add((Component)jBLabel12, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel13 = new JBLabel();
        jBLabel13.setText("Orientation:");
        jPanel5.add((Component)jBLabel13, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JSeparator jSeparator4 = new JSeparator();
        jPanel5.add((Component)jSeparator4, new GridConstraints(2, 0, 1, 3, 1, 1, 3, 1, null, null, null));
        this.myCameraPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel9.add((Component)jPanel4, new GridConstraints(8, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel14 = new JBLabel();
        jBLabel14.setHorizontalTextPosition(10);
        jBLabel14.setEnabled(true);
        jBLabel14.setText("Camera");
        jPanel4.add((Component)jBLabel14, new GridConstraints(1, 0, 2, 1, 9, 0, 0, 0, null, new Dimension(100, -1), null));
        JBLabel jBLabel15 = new JBLabel();
        jBLabel15.setText("Back:");
        jPanel4.add((Component)jBLabel15, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(82, 15), null));
        this.myFrontCameraCombo = jComboBox4 = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("None");
        defaultComboBoxModel.addElement("Emulated");
        defaultComboBoxModel.addElement("Webcam0");
        jComboBox4.setModel(defaultComboBoxModel);
        jPanel4.add(jComboBox4, new GridConstraints(1, 2, 1, 1, 8, 0, 6, 0, null, null, null));
        this.myBackCameraCombo = jComboBox3 = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel2 = new DefaultComboBoxModel<String>();
        defaultComboBoxModel2.addElement("None");
        defaultComboBoxModel2.addElement("Emulated");
        defaultComboBoxModel2.addElement("Webcam0");
        jComboBox3.setModel(defaultComboBoxModel2);
        jPanel4.add(jComboBox3, new GridConstraints(2, 2, 1, 1, 8, 0, 6, 0, null, null, null));
        JBLabel jBLabel16 = new JBLabel();
        jBLabel16.setText("Front:");
        jPanel4.add((Component)jBLabel16, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(82, 15), null));
        JSeparator jSeparator5 = new JSeparator();
        jPanel4.add((Component)jSeparator5, new GridConstraints(3, 0, 1, 3, 1, 1, 3, 1, null, null, null));
        JSeparator jSeparator6 = new JSeparator();
        jPanel4.add((Component)jSeparator6, new GridConstraints(0, 0, 1, 3, 1, 1, 3, 1, null, null, null));
        this.myNetworkPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel9.add((Component)jPanel3, new GridConstraints(9, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel17 = new JBLabel();
        jBLabel17.setText("Speed:");
        jPanel3.add((Component)jBLabel17, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(82, 15), null));
        JBLabel jBLabel18 = new JBLabel();
        jBLabel18.setText("Latency:");
        jPanel3.add((Component)jBLabel18, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(82, 15), null));
        this.mySpeedCombo = jComboBox2 = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel3 = new DefaultComboBoxModel<String>();
        defaultComboBoxModel3.addElement("Full");
        defaultComboBoxModel3.addElement("HSDPA");
        defaultComboBoxModel3.addElement("UMTS");
        defaultComboBoxModel3.addElement("EDGE");
        defaultComboBoxModel3.addElement("GPRS");
        defaultComboBoxModel3.addElement("HSCSD");
        defaultComboBoxModel3.addElement("GSM");
        jComboBox2.setModel(defaultComboBoxModel3);
        jPanel3.add(jComboBox2, new GridConstraints(0, 2, 1, 1, 8, 0, 6, 0, null, null, null));
        this.myLatencyCombo = jComboBox = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel4 = new DefaultComboBoxModel<String>();
        defaultComboBoxModel4.addElement("None");
        defaultComboBoxModel4.addElement("UMTS");
        defaultComboBoxModel4.addElement("EDGE");
        defaultComboBoxModel4.addElement("GPRS");
        jComboBox.setModel(defaultComboBoxModel4);
        jPanel3.add(jComboBox, new GridConstraints(1, 2, 1, 1, 8, 0, 6, 0, null, null, null));
        JBLabel jBLabel19 = new JBLabel();
        jBLabel19.setHorizontalTextPosition(10);
        jBLabel19.setEnabled(true);
        jBLabel19.setText("Network");
        jPanel3.add((Component)jBLabel19, new GridConstraints(0, 0, 2, 1, 9, 0, 0, 0, null, new Dimension(100, -1), null));
        this.myPerformancePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel9.add((Component)jPanel2, new GridConstraints(7, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel20 = new JBLabel();
        jBLabel20.setHorizontalTextPosition(10);
        jBLabel20.setEnabled(true);
        jBLabel20.setText("<html>Emulated<br>Performance</html>");
        jPanel2.add((Component)jBLabel20, new GridConstraints(0, 0, 3, 1, 9, 0, 2, 0, null, new Dimension(100, -1), null));
        this.myUseHostGPUCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Use Host GPU");
        jPanel2.add((Component)jCheckBox2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myStoreASnapshotForCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Store a snapshot for faster startup");
        jPanel2.add((Component)jCheckBox, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel21 = new JBLabel();
        jBLabel21.setEnabled(false);
        jBLabel21.setText("You can either use Host GPU or Snapshots");
        jPanel2.add((Component)jBLabel21, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySkinPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel9.add((Component)jPanel, new GridConstraints(4, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel22 = new JBLabel();
        jBLabel22.setText("<html>Custom<br>skin definition</html>");
        jPanel.add((Component)jBLabel22, new GridConstraints(0, 0, 2, 1, 9, 0, 0, 0, null, new Dimension(100, -1), null));
        this.myCustomSkinPath = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 1, 1, 3, 3, null, null, null));
        JSeparator jSeparator7 = new JSeparator();
        jPanel.add((Component)jSeparator7, new GridConstraints(2, 0, 1, 2, 1, 1, 3, 1, null, null, null));
        HyperlinkLabel hyperlinkLabel = this.myHardwareSkinHelpLabel;
        jPanel.add((Component)hyperlinkLabel, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myShowAdvancedSettingsButton = jButton = new JButton();
        jButton.setText("");
        jPanel8.add((Component)jButton, new GridConstraints(1, 0, 1, 1, 8, 0, 1, 0, null, null, null));
        this.myAvdConfigurationOptionHelpPanel = avdConfigurationOptionHelpPanel = new AvdConfigurationOptionHelpPanel();
        jPanel8.add((Component)avdConfigurationOptionHelpPanel, new GridConstraints(0, 1, 1, 1, 4, 2, 3, 3, null, new Dimension(360, -1), null));
        jBLabel2.setAnchor((JComponent)jPanel6);
        jBLabel12.setLabelFor(jComboBox5);
        jBLabel15.setLabelFor(jComboBox3);
        jBLabel16.setLabelFor(jComboBox4);
        jBLabel17.setLabelFor(jComboBox2);
        jBLabel18.setLabelFor(jComboBox);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jCheckBox2);
        buttonGroup.add(jCheckBox);
    }

    @Override
    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }

    private static abstract class MemoryValueDeriver
    extends ScopedDataBinder.ValueDeriver<Storage> {
        private MemoryValueDeriver() {
        }

        @Override
        @Nullable
        public Set<ScopedStateStore.Key<?>> getTriggerKeys() {
            return MemoryValueDeriver.makeSetOf(AvdWizardConstants.DEVICE_DEFINITION_KEY);
        }

        @Override
        @Nullable
        public Storage deriveValue(@NotNull ScopedStateStore state, @Nullable ScopedStateStore.Key changedKey, @Nullable Storage currentValue) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$MemoryValueDeriver", "deriveValue"));
            }
            Device device = state.get(AvdWizardConstants.DEVICE_DEFINITION_KEY);
            if (device != null) {
                return this.getStorage(device);
            }
            return null;
        }

        @Nullable
        protected abstract Storage getStorage(@NotNull Device var1);
    }

    private static final class NamedIcon {
        @NotNull
        private final String myName;
        @NotNull
        private final Icon myIcon;

        public NamedIcon(@NotNull String name, @NotNull Icon icon) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$NamedIcon", "<init>"));
            }
            if (icon == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$NamedIcon", "<init>"));
            }
            this.myName = name;
            this.myIcon = icon;
        }
    }
}

