/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.navigation;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Utilities {
    public static final Dimension ZERO_SIZE = new Dimension(0, 0);

    public static Point add(Point p1, Point p2) {
        return new Point(p1.x + p2.x, p1.y + p2.y);
    }

    public static Point diff(Point p1, Point p2) {
        return new Point(p1.x - p2.x, p1.y - p2.y);
    }

    public static double length(Point p) {
        return Math.sqrt(p.x * p.x + p.y * p.y);
    }

    public static Point max(Point p1, Point p2) {
        return new Point(Math.max(p1.x, p2.x), Math.max(p1.y, p2.y));
    }

    public static Point scale(Point p, float k) {
        return new Point((int)(k * (float)p.x), (int)(k * (float)p.y));
    }

    public static Dimension scale(Dimension d, float k) {
        return new Dimension((int)(k * (float)d.width), (int)(k * (float)d.height));
    }

    private static int snap(int i, int d) {
        return (int)Math.round((double)i / (double)d) * d;
    }

    public static Point snap(Point p, Dimension gridSize) {
        return new Point(Utilities.snap(p.x, gridSize.width), Utilities.snap(p.y, gridSize.height));
    }

    public static Point midPoint(Point p1, Point p2) {
        return Utilities.scale(Utilities.add(p1, p2), 0.5f);
    }

    public static Point midPoint(Dimension size) {
        return Utilities.point(Utilities.scale(size, 0.5f));
    }

    public static Point point(Dimension d) {
        return new Point(d.width, d.height);
    }

    public static Dimension dimension(Point p) {
        return new Dimension(Math.abs(p.x), Math.abs(p.y));
    }

    public static Point project(Point p, Rectangle r) {
        Point centre = Utilities.centre(r);
        Point diff = Utilities.diff(p, centre);
        boolean horizontal = Math.abs((float)diff.y / (float)diff.x) < Math.abs((float)r.height / (float)r.width);
        float scale = horizontal ? (float)r.width / 2.0f / (float)diff.x : (float)r.height / 2.0f / (float)diff.y;
        return Utilities.add(centre, Utilities.scale(diff, Math.abs(scale)));
    }

    public static Point centre(@NotNull Rectangle r) {
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/android/tools/idea/editors/navigation/Utilities", "centre"));
        }
        return new Point(r.x + r.width / 2, r.y + r.height / 2);
    }

    public static String getXmlFileNameFromJavaFileName(String javaFileName) {
        if (javaFileName.endsWith(".java")) {
            javaFileName = javaFileName.substring(0, javaFileName.length() - 5);
        }
        char[] charsJava = javaFileName.toCharArray();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < charsJava.length; ++i) {
            char currentChar = charsJava[i];
            if (Character.isUpperCase(currentChar) && i != 0) {
                stringBuilder.append('_');
            }
            stringBuilder.append(Character.toLowerCase(currentChar));
        }
        return stringBuilder.toString();
    }

    public static String getJavaFileNameFromXmlFileName(String xmlFileName) {
        if (xmlFileName.endsWith(".xml")) {
            xmlFileName = xmlFileName.substring(0, xmlFileName.length() - 4);
        }
        char[] charsXml = xmlFileName.toCharArray();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Character.toUpperCase(charsXml[0]));
        for (int i = 1; i < charsXml.length; ++i) {
            char currentChar = charsXml[i];
            if (currentChar == '_') {
                char toAppend = Character.toUpperCase(charsXml[++i]);
                stringBuilder.append(toAppend);
                continue;
            }
            stringBuilder.append(currentChar);
        }
        return stringBuilder.toString();
    }

    static void drawArrow(Graphics g1, int x1, int y1, int x2, int y2, int lineWidth) {
        Graphics2D g = (Graphics2D)g1.create();
        double dx = x2 - x1;
        double dy = y2 - y1;
        double angle = Math.atan2(dy, dx);
        int len = (int)Math.sqrt(dx * dx + dy * dy);
        AffineTransform t = AffineTransform.getTranslateInstance(x1, y1);
        t.concatenate(AffineTransform.getRotateInstance(angle));
        g.transform(t);
        g.drawLine(0, 0, len, 0);
        Dimension arrowHeadSize = new Dimension(lineWidth * 6, lineWidth * 3);
        int basePosition = len - arrowHeadSize.width;
        int height = arrowHeadSize.height;
        g.fillPolygon(new int[]{len, basePosition, basePosition, len}, new int[]{0, -height, height, 0}, 4);
    }

    static <T> Condition<T> not(final Condition<T> condition) {
        return new Condition<T>(){

            public boolean value(T t) {
                return !condition.value(t);
            }
        };
    }

    static <T> Condition<T> instanceOf(final Class<?> type) {
        return new Condition<T>(){

            public boolean value(Object o) {
                return type.isAssignableFrom(o.getClass());
            }
        };
    }

    static int sign(int x) {
        return x > 0 ? 1 : (x < 0 ? -1 : 0);
    }

    static Dimension notNull(@Nullable Dimension d) {
        return d == null ? ZERO_SIZE : d;
    }

    @Nullable
    public static PsiClass getPsiClass(Module module, String className) {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
        GlobalSearchScope scope = module.getModuleWithDependenciesAndLibrariesScope(false);
        return facade.findClass(className, scope);
    }

    @Nullable
    public static PsiMethod findMethodBySignature(Module module, String className, String signature) {
        PsiClass psiClass = Utilities.getPsiClass(module, className);
        return psiClass == null ? null : Utilities.findMethodBySignature(psiClass, signature);
    }

    @Nullable
    public static PsiMethod findMethodBySignature(@NotNull PsiClass psiClass, @NotNull String signature) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/android/tools/idea/editors/navigation/Utilities", "findMethodBySignature"));
        }
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "com/android/tools/idea/editors/navigation/Utilities", "findMethodBySignature"));
        }
        PsiMethod template = Utilities.createMethodFromText(psiClass, signature);
        return psiClass.findMethodBySignature(template, false);
    }

    public static PsiMethod createMethodFromText(PsiClass psiClass, String text) {
        return Utilities.createMethodFromText(psiClass.getProject(), text, (PsiElement)psiClass);
    }

    public static PsiMethod createMethodFromText(Project project, String text, @Nullable PsiElement context) {
        return JavaPsiFacade.getInstance((Project)project).getElementFactory().createMethodFromText(text, context);
    }

    public static PsiMethod createMethodFromText(Project project, String text) {
        return Utilities.createMethodFromText(project, text, null);
    }

    @Nullable
    public static VirtualFile virtualFile(File file) {
        return LocalFileSystem.getInstance().findFileByIoFile(file);
    }

    public static VirtualFile mkDirs(VirtualFile dir, String path) throws IOException {
        for (String dirName : path.split("/")) {
            VirtualFile existingDir = dir.findFileByRelativePath(dirName);
            dir = existingDir != null ? existingDir : dir.createChildDirectory(null, dirName);
        }
        return dir;
    }

    public static VirtualFile getNavigationFile(final VirtualFile baseDir, String deviceQualifier, final String fileName) {
        final String relativePathOfNavDir = ".navigation/" + deviceQualifier;
        VirtualFile navFile = baseDir.findFileByRelativePath(relativePathOfNavDir + "/" + fileName);
        if (navFile == null) {
            navFile = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

                public VirtualFile compute() {
                    try {
                        VirtualFile dir = Utilities.mkDirs(baseDir, relativePathOfNavDir);
                        return dir.createChildData(null, fileName);
                    }
                    catch (IOException e) {
                        assert (false);
                        return null;
                    }
                }
            });
        }
        return navFile;
    }
}

