/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.ViewInfo;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.intellij.psi.xml.XmlTag;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderedView
implements Iterable<RenderedView> {
    @Nullable
    public final RenderedView parent;
    @Nullable
    public final XmlTag tag;
    public final ViewInfo view;
    public final int x;
    public final int y;
    public final int w;
    public final int h;
    private List<RenderedView> myChildren;

    public RenderedView(@Nullable RenderedView parent, @Nullable ViewInfo view, @Nullable XmlTag tag, int x, int y, int w, int h) {
        this.parent = parent;
        this.view = view;
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.tag = tag;
    }

    public final int x2() {
        return this.x + this.w;
    }

    public final int y2() {
        return this.y + this.h;
    }

    @Nullable
    public RenderedView getParent() {
        return this.parent;
    }

    public void setChildren(List<RenderedView> children) {
        this.myChildren = children;
    }

    @NotNull
    public List<RenderedView> getChildren() {
        List<RenderedView> list = this.myChildren != null ? this.myChildren : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderedView", "getChildren"));
        }
        return list;
    }

    @Nullable
    public RenderedView findViewByTag(XmlTag tag) {
        if (this.tag == tag) {
            return this;
        }
        if (this.myChildren != null) {
            for (RenderedView child : this.myChildren) {
                RenderedView result = child.findViewByTag(tag);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    @Nullable
    public List<RenderedView> findViewsByTag(XmlTag tag) {
        if (this.tag == tag) {
            ArrayList list = Lists.newArrayList();
            list.add(this);
            return list;
        }
        List<RenderedView> result = null;
        if (this.myChildren != null) {
            for (RenderedView child : this.myChildren) {
                List<RenderedView> matches = child.findViewsByTag(tag);
                if (matches == null) continue;
                if (result != null) {
                    result.addAll(matches);
                    continue;
                }
                result = matches;
            }
        }
        return result;
    }

    @Nullable
    public RenderedView findLeafAt(int px, int py) {
        if (this.myChildren != null) {
            for (int i = this.myChildren.size() - 1; i >= 0; --i) {
                RenderedView child = this.myChildren.get(i);
                RenderedView result = child.findLeafAt(px, py);
                if (result == null) continue;
                return result;
            }
        }
        return this.x <= px && this.y <= py && this.x + this.w >= px && this.y + this.h >= py ? this : null;
    }

    public boolean isRoot() {
        return this.tag == null || !(this.tag.getParent() instanceof XmlTag);
    }

    @Override
    public Iterator<RenderedView> iterator() {
        if (this.myChildren == null) {
            return Iterators.emptyIterator();
        }
        return this.myChildren.iterator();
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.w, this.h);
    }
}

