/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.tools.idea.wizard.AndroidStudioWizardPath;
import com.android.tools.idea.wizard.DialogWrapperHost;
import com.android.tools.idea.wizard.DynamicWizardHost;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.ide.wizard.Step;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DynamicWizard
implements ScopedStateStore.ScopedStoreListener {
    Logger LOG;
    private final MergingUpdateQueue myUpdateQueue;
    private boolean myUpdateInProgress;
    @Nullable
    private Project myProject;
    @Nullable
    private Module myModule;
    @NotNull
    protected final DynamicWizardHost myHost;
    protected String myName;
    protected ArrayList<AndroidStudioWizardPath> myPaths;
    protected AndroidStudioWizardPath myCurrentPath;
    protected PathIterator myPathListIterator;
    private boolean myIsInitialized;
    private ScopedStateStore myState;
    private JPanel myContentPanel;
    private Map<JComponent, String> myComponentToIdMap;

    public DynamicWizard(@Nullable Project project, @Nullable Module module, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/wizard/DynamicWizard", "<init>"));
        }
        this(project, module, name, new DialogWrapperHost(project));
    }

    public DynamicWizard(@Nullable Project project, @Nullable Module module, @NotNull String name, @NotNull DynamicWizardHost host) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/wizard/DynamicWizard", "<init>"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/android/tools/idea/wizard/DynamicWizard", "<init>"));
        }
        this.LOG = Logger.getInstance(DynamicWizard.class);
        this.myPaths = Lists.newArrayList();
        this.myPathListIterator = new PathIterator(this.myPaths);
        this.myIsInitialized = false;
        this.myContentPanel = new JPanel(new CardLayout());
        this.myComponentToIdMap = Maps.newHashMap();
        this.myHost = host;
        this.myProject = project;
        this.myModule = module;
        this.myName = name;
        this.myUpdateQueue = ApplicationManager.getApplication().isUnitTestMode() ? null : new MergingUpdateQueue("wizard", 100, true, null, this.myHost.getDisposable(), null, false);
        this.myState = new ScopedStateStore(ScopedStateStore.Scope.WIZARD, null, this);
    }

    public void init() {
        this.myHost.init(this);
        this.myIsInitialized = true;
        if (this.myCurrentPath != null) {
            this.myCurrentPath.onPathStarted(true);
            this.showStep(this.myCurrentPath.getCurrentStep());
            this.myCurrentPath.updateCurrentStep();
        }
    }

    @Override
    public <T> void invokeUpdate(@Nullable ScopedStateStore.Key<T> changedKey) {
        if (this.myUpdateQueue != null) {
            this.myUpdateQueue.cancelAllUpdates();
            this.myUpdateQueue.queue(new Update("update"){

                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DynamicWizard.this.update();
                        }
                    });
                }
            });
        } else {
            this.update();
        }
    }

    private void update() {
        if (!this.myUpdateInProgress) {
            this.myUpdateInProgress = true;
            this.deriveValues(this.myState.getRecentUpdates());
            this.myState.clearRecentUpdates();
            this.myUpdateInProgress = false;
        }
    }

    public void deriveValues(Set<ScopedStateStore.Key> modified) {
    }

    public abstract void performFinishingActions();

    @Nullable
    protected final Project getProject() {
        return this.myProject;
    }

    @Nullable
    protected final Module getModule() {
        return this.myModule;
    }

    public final void setErrorHtml(String errorMessage) {
        if (this.myCurrentPath != null) {
            this.myCurrentPath.setErrorHtml(errorMessage);
        }
    }

    public final void updateButtons(boolean canGoPrev, boolean canGoNext, boolean canFinishCurrentPath) {
        if (!this.myIsInitialized) {
            return;
        }
        this.myHost.updateButtons(canGoPrev && this.hasPrevious(), canGoNext && this.hasNext(), canFinishCurrentPath && this.canFinish());
    }

    protected final void addPath(@NotNull AndroidStudioWizardPath path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/wizard/DynamicWizard", "addPath"));
        }
        this.myPaths.add(path);
        path.attachToWizard(this);
        if (this.myCurrentPath == null && path.isPathVisible()) {
            this.myCurrentPath = path;
        }
        this.myPathListIterator = new PathIterator(this.myPaths, this.myCurrentPath);
    }

    public final int getVisibleStepCount() {
        int sum = 0;
        for (AndroidStudioWizardPath path : this.myPaths) {
            sum += path.getVisibleStepCount();
        }
        return sum;
    }

    protected void showStep(@NotNull Step step) {
        if (step == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "step", "com/android/tools/idea/wizard/DynamicWizard", "showStep"));
        }
        JComponent component = step.getComponent();
        Icon icon = step.getIcon();
        this.myHost.setIcon(icon);
        String id = this.myComponentToIdMap.get(component);
        if (id == null) {
            id = String.valueOf(this.myComponentToIdMap.size());
            this.myComponentToIdMap.put(component, id);
            this.myContentPanel.add((Component)component, id);
        }
        ((CardLayout)this.myContentPanel.getLayout()).show(this.myContentPanel, id);
        JComponent focusedComponent = step.getPreferredFocusedComponent();
        if (focusedComponent != null) {
            IdeFocusManager.findInstanceByComponent((Component)focusedComponent).requestFocus((Component)focusedComponent, false);
        }
    }

    protected boolean canGoNext() {
        return this.myCurrentPath != null && this.myCurrentPath.canGoNext();
    }

    protected boolean canGoPrevious() {
        return this.myCurrentPath != null && this.myCurrentPath.canGoPrevious();
    }

    protected boolean hasNext() {
        return this.myCurrentPath != null && this.myCurrentPath.hasNext() || this.myPathListIterator.hasNext();
    }

    protected boolean hasPrevious() {
        return this.myCurrentPath != null && this.myCurrentPath.hasPrevious() || this.myPathListIterator.hasPrevious();
    }

    protected boolean canFinish() {
        if (!(this.myPathListIterator.hasNext() || this.myCurrentPath != null && this.myCurrentPath.hasNext())) {
            return true;
        }
        if (this.myCurrentPath != null && this.myCurrentPath.hasNext()) {
            return false;
        }
        boolean canFinish = true;
        PathIterator remainingPaths = this.myPathListIterator.getFreshCopy();
        while (canFinish && remainingPaths.hasNext()) {
            canFinish = !remainingPaths.next().isPathRequired();
        }
        return canFinish;
    }

    protected final boolean isLastStep() {
        if (this.myCurrentPath != null) {
            return !this.myPathListIterator.hasNext() && !this.myCurrentPath.hasNext();
        }
        return !this.myPathListIterator.hasNext();
    }

    public final void doNextAction() {
        Step newStep;
        assert (this.myCurrentPath != null);
        if (!this.myCurrentPath.canGoNext()) {
            this.myHost.shakeWindow();
            return;
        }
        if (!this.myCurrentPath.hasNext() && this.myPathListIterator.hasNext()) {
            if (!this.myCurrentPath.readyToLeavePath()) {
                this.myHost.shakeWindow();
                return;
            }
            this.myCurrentPath = this.myPathListIterator.next();
            this.myCurrentPath.onPathStarted(true);
            newStep = this.myCurrentPath.getCurrentStep();
        } else if (this.myCurrentPath.hasNext()) {
            newStep = this.myCurrentPath.next();
        } else {
            this.doFinishAction();
            return;
        }
        if (newStep != null) {
            this.showStep(newStep);
        }
    }

    public final void doPreviousAction() {
        Step newStep;
        assert (this.myCurrentPath != null);
        if (!this.myCurrentPath.canGoPrevious()) {
            this.myHost.shakeWindow();
            return;
        }
        if ((this.myCurrentPath == null || !this.myCurrentPath.hasPrevious()) && this.myPathListIterator.hasPrevious()) {
            this.myCurrentPath = this.myPathListIterator.previous();
            this.myCurrentPath.onPathStarted(false);
            newStep = this.myCurrentPath.getCurrentStep();
        } else if (this.myCurrentPath.hasPrevious()) {
            newStep = this.myCurrentPath.previous();
        } else {
            this.myHost.close(true);
            return;
        }
        if (newStep != null) {
            this.showStep(newStep);
        }
    }

    public final void doFinishAction() {
        if (this.myCurrentPath != null && !this.myCurrentPath.readyToLeavePath()) {
            this.myHost.shakeWindow();
            return;
        }
        this.myHost.close(false);
        new WriteCommandAction<Void>(this.getProject(), this.getWizardActionDescription(), (PsiFile[])null){

            protected void run(@NotNull Result<Void> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/wizard/DynamicWizard$2", "run"));
                }
                for (AndroidStudioWizardPath path : DynamicWizard.this.myPaths) {
                    if (!path.isPathVisible()) continue;
                    path.performFinishingActions();
                }
                DynamicWizard.this.performFinishingActions();
            }

            protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
                return DynamicWizard.this.getUndoConfirmationPolicy();
            }
        }.execute();
    }

    protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
        return UndoConfirmationPolicy.DEFAULT;
    }

    @Nullable
    public final JComponent getPreferredFocusedComponent() {
        Step currentStep = this.myCurrentPath.getCurrentStep();
        if (currentStep != null) {
            return currentStep.getPreferredFocusedComponent();
        }
        return null;
    }

    protected abstract String getWizardActionDescription();

    public final ScopedStateStore getState() {
        return this.myState;
    }

    public final void show() {
        this.myHost.show();
    }

    @NotNull
    public Disposable getDisposable() {
        Disposable disposable = this.myHost.getDisposable();
        if (disposable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/DynamicWizard", "getDisposable"));
        }
        return disposable;
    }

    public boolean showAndGet() {
        return this.myHost.showAndGet();
    }

    public final Component getContentPane() {
        return this.myContentPanel;
    }

    @Nullable
    public String getHelpId() {
        return null;
    }

    public void setTitle(String title) {
        this.myHost.setTitle(title);
    }

    public boolean containsStep(@NotNull String stepName, boolean visibleOnly) {
        if (stepName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stepName", "com/android/tools/idea/wizard/DynamicWizard", "containsStep"));
        }
        for (AndroidStudioWizardPath path : this.myPaths) {
            if (visibleOnly && !path.isPathVisible() || !path.containsStep(stepName, visibleOnly)) continue;
            return true;
        }
        return false;
    }

    public void navigateToNamedStep(@NotNull String stepName, boolean requireVisible) {
        if (stepName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stepName", "com/android/tools/idea/wizard/DynamicWizard", "navigateToNamedStep"));
        }
        for (AndroidStudioWizardPath path : this.myPaths) {
            if (requireVisible && !path.isPathVisible() || !path.containsStep(stepName, requireVisible)) continue;
            this.myCurrentPath = path;
            this.myPathListIterator.myCurrentIndex = this.myPathListIterator.myList.indexOf(this.myCurrentPath);
            this.myCurrentPath.navigateToNamedStep(stepName, requireVisible);
            this.showStep(this.myCurrentPath.getCurrentStep());
            return;
        }
    }

    protected static class PathIterator {
        private int myCurrentIndex;
        private ArrayList<AndroidStudioWizardPath> myList;

        public PathIterator(ArrayList<AndroidStudioWizardPath> list) {
            this.myList = list;
            this.myCurrentIndex = 0;
        }

        public PathIterator(ArrayList<AndroidStudioWizardPath> list, AndroidStudioWizardPath currentLocation) {
            this(list);
            int index = this.myList.indexOf(currentLocation);
            if (currentLocation != null && index != -1) {
                this.myCurrentIndex = index;
            }
        }

        public PathIterator getFreshCopy() {
            PathIterator toReturn = new PathIterator(this.myList);
            toReturn.myCurrentIndex = this.myCurrentIndex;
            return toReturn;
        }

        public boolean hasNext() {
            if (this.myCurrentIndex >= this.myList.size() - 1) {
                return false;
            }
            for (int i = this.myCurrentIndex + 1; i < this.myList.size(); ++i) {
                AndroidStudioWizardPath path = this.myList.get(i);
                if (!path.isPathVisible() || path.getVisibleStepCount() <= 0) continue;
                return true;
            }
            return false;
        }

        public boolean hasPrevious() {
            if (this.myCurrentIndex <= 0) {
                return false;
            }
            for (int i = this.myCurrentIndex - 1; i >= 0; --i) {
                if (!this.myList.get(i).isPathVisible()) continue;
                return true;
            }
            return false;
        }

        @Nullable
        public AndroidStudioWizardPath next() {
            do {
                ++this.myCurrentIndex;
            } while (this.myCurrentIndex < this.myList.size() && !this.myList.get(this.myCurrentIndex).isPathVisible());
            if (this.myCurrentIndex < this.myList.size()) {
                return this.myList.get(this.myCurrentIndex);
            }
            return null;
        }

        @Nullable
        public AndroidStudioWizardPath previous() {
            do {
                --this.myCurrentIndex;
            } while (this.myCurrentIndex >= 0 && !this.myList.get(this.myCurrentIndex).isPathVisible());
            if (this.myCurrentIndex >= 0) {
                return this.myList.get(this.myCurrentIndex);
            }
            return null;
        }
    }
}

