/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.designSurface.layout;

import com.intellij.android.designer.designSurface.AbstractEditOperation;
import com.intellij.android.designer.designSurface.feedbacks.TextFeedback;
import com.intellij.android.designer.designSurface.graphics.DesignerGraphics;
import com.intellij.android.designer.designSurface.graphics.DrawingStyle;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.layout.Gravity;
import com.intellij.designer.designSurface.FeedbackLayer;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.model.RadComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.containers.hash.HashSet;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class FrameLayoutOperation
extends AbstractEditOperation {
    private Set<Pair<Gravity, Gravity>> myExcludes = Collections.emptySet();
    private GravityFeedback myFeedback;
    private TextFeedback myTextFeedback;
    private Rectangle myBounds;
    private String myGravity;
    private static final Gravity[] HORIZONTALS = new Gravity[]{Gravity.left, Gravity.center, Gravity.right};
    private static final Gravity[] VERTICALS = new Gravity[]{Gravity.top, Gravity.center, Gravity.bottom};

    public FrameLayoutOperation(RadComponent container, OperationContext context) {
        super(container, context);
        if (context.isMove()) {
            this.myExcludes = new HashSet();
            for (RadComponent component : context.getComponents()) {
                this.myExcludes.add(Gravity.getSides(component));
            }
        }
    }

    private void createFeedback() {
        if (this.myFeedback == null) {
            FeedbackLayer layer = this.myContext.getArea().getFeedbackLayer();
            this.myBounds = ((RadViewComponent)this.myContainer).getPaddedBounds((Component)layer);
            this.myFeedback = new GravityFeedback();
            this.myFeedback.setBounds(this.myBounds);
            layer.add((Component)this.myFeedback);
            this.myTextFeedback = new TextFeedback();
            this.myTextFeedback.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)3, (int)2, (int)0));
            layer.add((Component)((Object)this.myTextFeedback));
            layer.repaint();
        }
    }

    public void showFeedback() {
        this.createFeedback();
        Point location = this.myContext.getLocation();
        Gravity horizontal = FrameLayoutOperation.calculateHorizontal(this.myBounds, location);
        Gravity vertical = FrameLayoutOperation.calculateVertical(this.myBounds, location);
        if (this.myContext.isMove() && this.exclude(horizontal, vertical)) {
            vertical = null;
            horizontal = null;
        }
        this.myFeedback.setGravity(horizontal, vertical);
        this.configureTextFeedback(this.myBounds, horizontal, vertical);
        this.myGravity = Gravity.getValue(horizontal, vertical);
    }

    private void configureTextFeedback(Rectangle bounds, @Nullable Gravity horizontal, @Nullable Gravity vertical) {
        this.myTextFeedback.clear();
        if (horizontal == null || vertical == null) {
            this.myTextFeedback.bold("None");
        } else {
            this.myTextFeedback.bold("[" + vertical.name() + ", " + horizontal.name() + "]");
        }
        this.myTextFeedback.centerTop(bounds);
    }

    public void eraseFeedback() {
        if (this.myFeedback != null) {
            FeedbackLayer layer = this.myContext.getArea().getFeedbackLayer();
            layer.remove((Component)this.myFeedback);
            layer.remove((Component)((Object)this.myTextFeedback));
            layer.repaint();
            this.myFeedback = null;
            this.myTextFeedback = null;
        }
    }

    @Nullable
    private static Gravity calculateHorizontal(Rectangle bounds, Point location) {
        if (bounds.width < 10) {
            return Gravity.left;
        }
        Gravity horizontal = null;
        double left = (double)bounds.x + (double)bounds.width / 3.0;
        double right = (double)bounds.x + (double)(2 * bounds.width) / 3.0;
        if ((double)location.x < left) {
            horizontal = Gravity.left;
        } else if (left < (double)location.x && (double)location.x < right) {
            horizontal = Gravity.center;
        } else if ((double)location.x > right) {
            horizontal = Gravity.right;
        }
        return horizontal;
    }

    @Nullable
    private static Gravity calculateVertical(Rectangle bounds, Point location) {
        if (bounds.height < 10) {
            return Gravity.top;
        }
        Gravity vertical = null;
        double top = (double)bounds.y + (double)bounds.height / 3.0;
        double bottom = (double)bounds.y + (double)(2 * bounds.height) / 3.0;
        if ((double)location.y < top) {
            vertical = Gravity.top;
        } else if (top < (double)location.y && (double)location.y < bottom) {
            vertical = Gravity.center;
        } else if ((double)location.y > bottom) {
            vertical = Gravity.bottom;
        }
        return vertical;
    }

    private boolean exclude(@Nullable Gravity horizontal, @Nullable Gravity vertical) {
        for (Pair<Gravity, Gravity> p : this.myExcludes) {
            if (p.first != horizontal || p.second != vertical) continue;
            return true;
        }
        return false;
    }

    public boolean canExecute() {
        return this.myGravity != null;
    }

    @Override
    public void execute() throws Exception {
        super.execute();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                for (RadComponent component : FrameLayoutOperation.this.myComponents) {
                    ((RadViewComponent)component).getTag().setAttribute("layout_gravity", "http://schemas.android.com/apk/res/android", FrameLayoutOperation.this.myGravity);
                }
            }
        });
    }

    private class GravityFeedback
    extends JComponent {
        @Nullable
        private Gravity myHorizontal;
        @Nullable
        private Gravity myVertical;

        public void setGravity(@Nullable Gravity horizontal, @Nullable Gravity vertical) {
            this.myHorizontal = horizontal;
            this.myVertical = vertical;
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Rectangle bounds = ((RadViewComponent)FrameLayoutOperation.this.myContainer).getPaddedBounds(this);
            DesignerGraphics.drawRect(DrawingStyle.DROP_PREVIEW, g, bounds.x, bounds.y, bounds.width, bounds.height);
            for (Gravity h : HORIZONTALS) {
                for (Gravity v : VERTICALS) {
                    boolean selection;
                    boolean bl = selection = this.myHorizontal == h && this.myVertical == v;
                    if (!selection && FrameLayoutOperation.this.exclude(h, v)) continue;
                    this.paintCell(g, h, v, selection);
                }
            }
        }

        private boolean paintCell(Graphics g, Gravity horizontal, Gravity vertical, boolean selection) {
            int vSpace;
            int x = 0;
            int width = (this.getWidth() - 2) / 3;
            if (horizontal == Gravity.center) {
                x = width + 1;
            } else if (horizontal == Gravity.right) {
                x = this.getWidth() - width;
            }
            int y = 0;
            int height = (this.getHeight() - 2) / 3;
            if (vertical == Gravity.center) {
                y = height + 1;
            } else if (vertical == Gravity.bottom) {
                y = this.getHeight() - height;
            }
            int hSpace = Math.min(5, Math.max(1, this.getWidth() / 30));
            if (hSpace > 1) {
                x += hSpace;
                width -= 2 * hSpace;
            }
            if ((vSpace = Math.min(5, Math.max(1, this.getHeight() / 30))) > 1) {
                y += vSpace;
                height -= 2 * vSpace;
            }
            if (selection) {
                if (this.myHorizontal == horizontal && this.myVertical == vertical) {
                    DesignerGraphics.drawFilledRect(DrawingStyle.DROP_ZONE_ACTIVE, g, x, y, width, height);
                    return true;
                }
            } else {
                DesignerGraphics.drawFilledRect(DrawingStyle.DROP_ZONE, g, x, y, width, height);
            }
            return false;
        }
    }
}

