/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model;

import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.rendering.ResourceHelper;
import com.intellij.android.designer.model.RadModelBuilder;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.RadViewContainer;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.model.RadComponentVisitor;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class IdManager {
    public static final String KEY = "IdManager";
    private final Set<String> myIdList = new HashSet<String>();

    @Nullable
    public static IdManager get(RadComponent component) {
        return RadModelBuilder.getIdManager(component);
    }

    @Nullable
    public static String getIdName(@Nullable String idValue) {
        if (idValue != null) {
            if (idValue.startsWith("@+id/")) {
                return idValue.substring("@+id/".length());
            }
            if (idValue.startsWith("@id/")) {
                return idValue.substring("@id/".length());
            }
        }
        return null;
    }

    public void addComponent(RadViewComponent component) {
        String idValue = IdManager.getIdName(component.getId());
        if (idValue != null) {
            this.myIdList.add(idValue);
        }
    }

    public void removeComponent(RadViewComponent component, boolean withChildren) {
        String idValue = IdManager.getIdName(component.getId());
        if (idValue != null) {
            this.myIdList.remove(idValue);
        }
        if (withChildren) {
            for (RadComponent child : component.getChildren()) {
                this.removeComponent((RadViewComponent)child, true);
            }
        }
    }

    public void clearIds() {
        this.myIdList.clear();
    }

    public String createId(RadViewComponent component) {
        String idValue = StringUtil.decapitalize((String)component.getMetaModel().getTag());
        XmlTag tag = component.getTag();
        Module module = AndroidPsiUtils.getModuleSafely((PsiElement)tag);
        if (module != null) {
            idValue = ResourceHelper.prependResourcePrefix(module, idValue);
        }
        String nextIdValue = idValue;
        int index = 0;
        NamesValidator validator = (NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage((Language)JavaLanguage.INSTANCE);
        Project project = tag.getProject();
        while (this.myIdList.contains(nextIdValue) || validator != null && validator.isKeyword(nextIdValue, project)) {
            if (!(++index != 1 || validator != null && validator.isKeyword(nextIdValue, project))) {
                nextIdValue = idValue;
                continue;
            }
            nextIdValue = idValue + Integer.toString(index);
        }
        this.myIdList.add(nextIdValue);
        String newId = "@+id/" + idValue + (index == 0 ? "" : Integer.toString(index));
        tag.setAttribute("id", "http://schemas.android.com/apk/res/android", newId);
        return newId;
    }

    public boolean needsDefaultId(RadViewComponent component) {
        if (component instanceof RadViewContainer) {
            return false;
        }
        String tag = component.getTag().getName();
        return !tag.equals("include") && !tag.equals("merge") && !tag.equals("Space") && !tag.equals("requestFocus") && (!tag.endsWith("Space") || tag.length() <= "Space".length() || tag.charAt(tag.length() - "Space".length()) != '.');
    }

    public void ensureIds(final RadViewComponent container) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                final ArrayList<Pair<Pair<String, String>, String>> replaceList = new ArrayList<Pair<Pair<String, String>, String>>();
                container.accept(new RadComponentVisitor(){

                    public void endVisit(RadComponent component) {
                        RadViewComponent viewComponent = (RadViewComponent)component;
                        String idValue = IdManager.getIdName(viewComponent.getId());
                        if (component == container) {
                            IdManager.this.createId(viewComponent);
                        } else if (idValue != null && IdManager.this.myIdList.contains(idValue)) {
                            IdManager.this.createId(viewComponent);
                            replaceList.add(Pair.create((Object)new Pair((Object)("@id/" + idValue), (Object)("@+id/" + idValue)), (Object)viewComponent.getId()));
                        } else {
                            IdManager.this.addComponent(viewComponent);
                        }
                    }
                }, true);
                if (!replaceList.isEmpty()) {
                    IdManager.replaceIds(container, replaceList);
                }
            }
        });
    }

    public static void replaceIds(RadViewComponent container, final List<Pair<Pair<String, String>, String>> replaceList) {
        container.accept(new RadComponentVisitor(){

            public void endVisit(RadComponent component) {
                XmlTag tag = ((RadViewComponent)component).getTag();
                block0: for (XmlAttribute attribute : tag.getAttributes()) {
                    String value = attribute.getValue();
                    for (Pair replace : replaceList) {
                        if (!((String)((Pair)replace.first).first).equals(value) && !((String)((Pair)replace.first).second).equals(value)) continue;
                        attribute.setValue((String)replace.second);
                        continue block0;
                    }
                }
            }
        }, true);
    }
}

