/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.resources;

import com.android.resources.ResourceType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceValue {
    private String myValue;
    private char myPrefix = '\u0000';
    private String myPackage;
    private String myResourceType;
    private String myResourceName;

    private ResourceValue() {
    }

    public char getPrefix() {
        return this.myPrefix;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceValue that = (ResourceValue)o;
        if (this.myPrefix != that.myPrefix) {
            return false;
        }
        if (this.myPackage != null ? !this.myPackage.equals(that.myPackage) : that.myPackage != null) {
            return false;
        }
        if (this.myResourceName != null ? !this.myResourceName.equals(that.myResourceName) : that.myResourceName != null) {
            return false;
        }
        if (this.myResourceType != null ? !this.myResourceType.equals(that.myResourceType) : that.myResourceType != null) {
            return false;
        }
        return !(this.myValue != null ? !this.myValue.equals(that.myValue) : that.myValue != null);
    }

    public int hashCode() {
        int result = this.myValue != null ? this.myValue.hashCode() : 0;
        result = 31 * result + this.myPrefix;
        result = 31 * result + (this.myPackage != null ? this.myPackage.hashCode() : 0);
        result = 31 * result + (this.myResourceType != null ? this.myResourceType.hashCode() : 0);
        result = 31 * result + (this.myResourceName != null ? this.myResourceName.hashCode() : 0);
        return result;
    }

    @Nullable
    public static ResourceValue parse(String s, boolean withLiterals, boolean withPrefix) {
        ResourceValue value;
        if (s == null) {
            return null;
        }
        if (s.startsWith("@") || s.startsWith("?")) {
            return ResourceValue.reference(s, true);
        }
        if (!withPrefix && (value = ResourceValue.reference(s, withPrefix)) != null) {
            return value;
        }
        return withLiterals ? ResourceValue.literal(s) : null;
    }

    public static ResourceValue literal(String value) {
        ResourceValue result = new ResourceValue();
        result.myValue = value;
        return result;
    }

    public static ResourceValue reference(String value) {
        return ResourceValue.reference(value, true);
    }

    public static ResourceValue reference(String value, boolean withPrefix) {
        ResourceValue result = new ResourceValue();
        if (withPrefix) {
            assert (value.length() > 0);
            result.myPrefix = value.charAt(0);
        }
        int startIndex = withPrefix ? 1 : 0;
        int pos = value.indexOf(47);
        if (pos > 0) {
            String suffix;
            String resType = value.substring(startIndex, pos);
            int colonIndex = resType.indexOf(58);
            if (colonIndex > 0) {
                result.myPackage = resType.substring(0, colonIndex);
                result.myResourceType = resType.substring(colonIndex + 1);
            } else {
                result.myResourceType = resType;
            }
            if (result.myResourceType.startsWith("+") && !result.myResourceType.equals("+id")) {
                result.myResourceType = result.myResourceType.substring(1);
            }
            if ((colonIndex = (suffix = value.substring(pos + 1)).indexOf(58)) > 0) {
                String aPackage = suffix.substring(0, colonIndex);
                if (result.myPackage == null || result.myPackage.length() == 0 || aPackage.equals(result.myPackage)) {
                    result.myPackage = aPackage;
                    result.myResourceName = suffix.substring(colonIndex + 1);
                }
                return result;
            }
            result.myResourceName = suffix;
        } else {
            int colonIndex = value.indexOf(58);
            if (colonIndex > startIndex) {
                result.myPackage = value.substring(startIndex, colonIndex);
                result.myResourceName = value.substring(colonIndex + 1);
            } else {
                result.myResourceName = value.substring(startIndex);
            }
        }
        return result;
    }

    public static ResourceValue referenceTo(char prefix, @Nullable String resPackage, @Nullable String resourceType, String resourceName) {
        ResourceValue result = new ResourceValue();
        result.myPrefix = prefix;
        result.myPackage = resPackage;
        result.myResourceType = resourceType;
        result.myResourceName = resourceName;
        return result;
    }

    public boolean isReference() {
        return this.myValue == null;
    }

    @Nullable
    public String getValue() {
        return this.myValue;
    }

    @Nullable
    public String getResourceType() {
        return this.myResourceType;
    }

    @Nullable
    public ResourceType getType() {
        if (this.myResourceType == null) {
            return null;
        }
        if (this.myResourceType.startsWith("+")) {
            assert ("+id".equals(this.myResourceType)) : this.myResourceType;
            return ResourceType.ID;
        }
        return ResourceType.getEnum((String)this.myResourceType);
    }

    @Nullable
    public String getResourceName() {
        return this.myResourceName;
    }

    @Nullable
    public String getPackage() {
        return this.myPackage;
    }

    @NotNull
    public String toString() {
        if (this.myValue != null) {
            String string = this.myValue;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/resources/ResourceValue", "toString"));
            }
            return string;
        }
        StringBuilder builder = new StringBuilder();
        if (this.myPrefix != '\u0000') {
            builder.append(this.myPrefix);
        }
        if (this.myPackage != null) {
            builder.append(this.myPackage).append(":");
        }
        if (this.myResourceType != null) {
            builder.append(this.myResourceType).append("/");
        }
        builder.append(this.myResourceName);
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/resources/ResourceValue", "toString"));
        }
        return string;
    }

    public void setResourceType(String resourceType) {
        this.myResourceType = resourceType;
    }
}

