/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.xml;

import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.dom.AndroidDomExtender;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.SimpleClassMapConstructor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AndroidXmlResourcesUtil {
    @NonNls
    public static final String APPWIDGET_PROVIDER_TAG_NAME = "appwidget-provider";
    @NonNls
    public static final String SEARCHABLE_TAG_NAME = "searchable";
    @NonNls
    public static final String KEYBOARD_TAG_NAME = "Keyboard";
    @NonNls
    public static final String DEVICE_ADMIN_TAG_NAME = "device-admin";
    @NonNls
    public static final String ACCOUNT_AUTHENTICATOR_TAG_NAME = "account-authenticator";
    @NonNls
    public static final String PREFERENCE_HEADERS_TAG_NAME = "preference-headers";
    public static final Map<String, String> SPECIAL_STYLEABLE_NAMES = new HashMap();
    public static final String PREFERENCE_CLASS_NAME = "android.preference.Preference";
    private static final String[] ROOT_TAGS = new String[]{"appwidget-provider", "searchable", "Keyboard", "device-admin", "account-authenticator", "preference-headers"};
    private static final Set<String> ROOT_TAGS_SET;

    private AndroidXmlResourcesUtil() {
    }

    @NotNull
    public static List<String> getPossibleRoots(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/dom/xml/AndroidXmlResourcesUtil", "getPossibleRoots"));
        }
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(AndroidDomUtil.removeUnambigiousNames(AndroidDomExtender.getPreferencesClassMap(facet)));
        result.addAll(Arrays.asList(ROOT_TAGS));
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/xml/AndroidXmlResourcesUtil", "getPossibleRoots"));
        }
        return arrayList;
    }

    public static boolean isSupportedRootTag(@NotNull AndroidFacet facet, @NotNull String rootTagName) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/dom/xml/AndroidXmlResourcesUtil", "isSupportedRootTag"));
        }
        if (rootTagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootTagName", "org/jetbrains/android/dom/xml/AndroidXmlResourcesUtil", "isSupportedRootTag"));
        }
        return ROOT_TAGS_SET.contains(rootTagName) || SimpleClassMapConstructor.findClassByTagName(facet, rootTagName, PREFERENCE_CLASS_NAME) != null;
    }

    static {
        SPECIAL_STYLEABLE_NAMES.put(APPWIDGET_PROVIDER_TAG_NAME, "AppWidgetProviderInfo");
        SPECIAL_STYLEABLE_NAMES.put(SEARCHABLE_TAG_NAME, "Searchable");
        SPECIAL_STYLEABLE_NAMES.put("actionkey", "SearchableActionKey");
        SPECIAL_STYLEABLE_NAMES.put("intent", "Intent");
        SPECIAL_STYLEABLE_NAMES.put(KEYBOARD_TAG_NAME, KEYBOARD_TAG_NAME);
        SPECIAL_STYLEABLE_NAMES.put("Row", "Keyboard_Row");
        SPECIAL_STYLEABLE_NAMES.put("Key", "Keyboard_Key");
        SPECIAL_STYLEABLE_NAMES.put(DEVICE_ADMIN_TAG_NAME, "DeviceAdmin");
        SPECIAL_STYLEABLE_NAMES.put(ACCOUNT_AUTHENTICATOR_TAG_NAME, "AccountAuthenticator");
        SPECIAL_STYLEABLE_NAMES.put("header", "PreferenceHeader");
        ROOT_TAGS_SET = new HashSet<String>(Arrays.asList(ROOT_TAGS));
    }
}

