/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageLineMarkerRenderer;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.history.FileRevisionTimestampComparator;
import com.intellij.history.LocalHistory;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.reference.SoftReference;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.diff.Diff;
import com.intellij.util.diff.FilesTooBigForDiffException;
import gnu.trove.TIntIntHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SrcFileAnnotator
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.coverage.SrcFileAnnotator");
    public static final Key<List<RangeHighlighter>> COVERAGE_HIGHLIGHTERS = Key.create((String)"COVERAGE_HIGHLIGHTERS");
    private static final Key<DocumentListener> COVERAGE_DOCUMENT_LISTENER = Key.create((String)"COVERAGE_DOCUMENT_LISTENER");
    public static final Key<Map<FileEditor, EditorNotificationPanel>> NOTIFICATION_PANELS = Key.create((String)"NOTIFICATION_PANELS");
    private PsiFile myFile;
    private Editor myEditor;
    private Document myDocument;
    private final Project myProject;
    private SoftReference<TIntIntHashMap> myNewToOldLines;
    private SoftReference<TIntIntHashMap> myOldToNewLines;
    private SoftReference<byte[]> myOldContent;
    private static final Object LOCK = new Object();
    private final Alarm myUpdateAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);

    public SrcFileAnnotator(PsiFile file, Editor editor) {
        this.myFile = file;
        this.myEditor = editor;
        this.myProject = file.getProject();
        this.myDocument = this.myEditor.getDocument();
    }

    public void hideCoverageData() {
        DocumentListener documentListener;
        Map map;
        if (this.myEditor == null) {
            return;
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.myProject);
        List highlighters = (List)this.myEditor.getUserData(COVERAGE_HIGHLIGHTERS);
        if (highlighters != null) {
            for (final RangeHighlighter highlighter : highlighters) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        highlighter.dispose();
                    }
                });
            }
            this.myEditor.putUserData(COVERAGE_HIGHLIGHTERS, null);
        }
        if ((map = (Map)this.myFile.getCopyableUserData(NOTIFICATION_PANELS)) != null) {
            VirtualFile vFile = this.myFile.getVirtualFile();
            LOG.assertTrue(vFile != null);
            boolean freeAll = !fileEditorManager.isFileOpen(vFile);
            this.myFile.putCopyableUserData(NOTIFICATION_PANELS, null);
            for (FileEditor fileEditor : map.keySet()) {
                if (!freeAll && !this.isCurrentEditor(fileEditor)) continue;
                fileEditorManager.removeTopComponent(fileEditor, (JComponent)map.get(fileEditor));
            }
        }
        if ((documentListener = (DocumentListener)this.myEditor.getUserData(COVERAGE_DOCUMENT_LISTENER)) != null) {
            this.myDocument.removeDocumentListener(documentListener);
            this.myEditor.putUserData(COVERAGE_DOCUMENT_LISTENER, null);
        }
    }

    @NotNull
    private static String[] getCoveredLines(@NotNull byte[] oldContent, VirtualFile vFile) {
        if (oldContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldContent", "com/intellij/coverage/SrcFileAnnotator", "getCoveredLines"));
        }
        String text = ((Object)LoadTextUtil.getTextByBinaryPresentation((byte[])oldContent, (VirtualFile)vFile, (boolean)false, (boolean)false)).toString();
        String[] stringArray = LineTokenizer.tokenize((CharSequence)text, (boolean)false);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coverage/SrcFileAnnotator", "getCoveredLines"));
        }
        return stringArray;
    }

    @NotNull
    private String[] getUpToDateLines() {
        final Ref linesRef = new Ref();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int lineCount = SrcFileAnnotator.this.myDocument.getLineCount();
                String[] lines = new String[lineCount];
                CharSequence chars = SrcFileAnnotator.this.myDocument.getCharsSequence();
                for (int i = 0; i < lineCount; ++i) {
                    lines[i] = ((Object)chars.subSequence(SrcFileAnnotator.this.myDocument.getLineStartOffset(i), SrcFileAnnotator.this.myDocument.getLineEndOffset(i))).toString();
                }
                linesRef.set((Object)lines);
            }
        };
        ApplicationManager.getApplication().runReadAction(runnable);
        String[] stringArray = (String[])linesRef.get();
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coverage/SrcFileAnnotator", "getUpToDateLines"));
        }
        return stringArray;
    }

    private static TIntIntHashMap getCoverageVersionToCurrentLineMapping(Diff.Change change, int firstNLines) {
        TIntIntHashMap result = new TIntIntHashMap();
        int prevLineInFirst = 0;
        int prevLineInSecond = 0;
        while (change != null) {
            for (int l = 0; l < change.line0 - prevLineInFirst; ++l) {
                result.put(prevLineInFirst + l, prevLineInSecond + l);
            }
            prevLineInFirst = change.line0 + change.deleted;
            prevLineInSecond = change.line1 + change.inserted;
            change = change.link;
        }
        for (int i = prevLineInFirst; i < firstNLines; ++i) {
            result.put(i, prevLineInSecond + i - prevLineInFirst);
        }
        return result;
    }

    @Nullable
    private TIntIntHashMap getOldToNewLineMapping(long date) {
        if (this.myOldToNewLines == null) {
            this.myOldToNewLines = this.doGetLineMapping(date, true);
            if (this.myOldToNewLines == null) {
                return null;
            }
        }
        return (TIntIntHashMap)this.myOldToNewLines.get();
    }

    @Nullable
    private TIntIntHashMap getNewToOldLineMapping(long date) {
        if (this.myNewToOldLines == null) {
            this.myNewToOldLines = this.doGetLineMapping(date, false);
            if (this.myNewToOldLines == null) {
                return null;
            }
        }
        return (TIntIntHashMap)this.myNewToOldLines.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private SoftReference<TIntIntHashMap> doGetLineMapping(final long date, boolean oldToNew) {
        byte[] oldContent;
        VirtualFile f = this.getVirtualFile();
        Object object = LOCK;
        synchronized (object) {
            if (this.myOldContent == null) {
                if (ApplicationManager.getApplication().isDispatchThread()) {
                    return null;
                }
                byte[] byteContent = LocalHistory.getInstance().getByteContent(f, new FileRevisionTimestampComparator(){

                    public boolean isSuitable(long revisionTimestamp) {
                        return revisionTimestamp < date;
                    }
                });
                this.myOldContent = new SoftReference((Object)byteContent);
            }
            oldContent = (byte[])this.myOldContent.get();
        }
        if (oldContent == null) {
            return null;
        }
        Object[] coveredLines = SrcFileAnnotator.getCoveredLines(oldContent, f);
        Object[] currentLines = this.getUpToDateLines();
        Object[] oldLines = oldToNew ? coveredLines : currentLines;
        Object[] newLines = oldToNew ? currentLines : coveredLines;
        Diff.Change change = null;
        try {
            change = Diff.buildChanges((Object[])oldLines, (Object[])newLines);
        }
        catch (FilesTooBigForDiffException e) {
            LOG.info((Throwable)e);
            return null;
        }
        return new SoftReference((Object)SrcFileAnnotator.getCoverageVersionToCurrentLineMapping(change, oldLines.length));
    }

    public void showCoverageInformation(final CoverageSuitesBundle suite) {
        TIntIntHashMap oldToNewLineMapping;
        if (this.myEditor == null || this.myFile == null) {
            return;
        }
        final MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)this.myDocument, (Project)this.myProject, (boolean)true);
        final ArrayList highlighters = new ArrayList();
        final ProjectData data = suite.getCoverageData();
        if (data == null) {
            this.coverageDataNotFound(suite);
            return;
        }
        final CoverageEngine engine = suite.getCoverageEngine();
        Set<String> qualifiedNames = engine.getQualifiedNames(this.myFile);
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        VirtualFile file = this.getVirtualFile();
        long fileTimeStamp = file.getTimeStamp();
        long coverageTimeStamp = suite.getLastCoverageTimeStamp();
        if (engine.isInLibraryClasses(this.myProject, file)) {
            return;
        }
        if (projectFileIndex.isInLibrarySource(file)) {
            if (fileTimeStamp > coverageTimeStamp) {
                this.showEditorWarningMessage(CodeInsightBundle.message((String)"coverage.data.outdated", (Object[])new Object[0]));
                return;
            }
            oldToNewLineMapping = null;
        } else {
            oldToNewLineMapping = this.getOldToNewLineMapping(coverageTimeStamp);
            if (oldToNewLineMapping == null && fileTimeStamp > coverageTimeStamp && SrcFileAnnotator.classesArePresentInCoverageData(data, qualifiedNames)) {
                this.showEditorWarningMessage(CodeInsightBundle.message((String)"coverage.data.outdated", (Object[])new Object[0]));
                return;
            }
        }
        if (this.myEditor.getUserData(COVERAGE_HIGHLIGHTERS) != null) {
            return;
        }
        Module module = (Module)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Module>(){

            @Nullable
            public Module compute() {
                return ModuleUtilCore.findModuleForPsiElement((PsiElement)SrcFileAnnotator.this.myFile);
            }
        });
        if (module != null && engine.recompileProjectAndRerunAction(module, suite, new Runnable(){

            @Override
            public void run() {
                CoverageDataManager.getInstance(SrcFileAnnotator.this.myProject).chooseSuitesBundle(suite);
            }
        })) {
            return;
        }
        Set<File> outputFiles = engine.getCorrespondingOutputFiles(this.myFile, module, suite);
        final boolean subCoverageActive = CoverageDataManager.getInstance(this.myProject).isSubCoverageActive();
        final boolean coverageByTestApplicable = suite.isCoverageByTestApplicable() && (!subCoverageActive || !suite.isCoverageByTestEnabled());
        final TreeMap executableLines = new TreeMap();
        final TreeMap classLines = new TreeMap();
        final TreeMap classNames = new TreeMap();
        class HighlightersCollector {
            HighlightersCollector() {
            }

            private void collect(File outputFile, final String qualifiedName) {
                ClassData fileData = data.getClassData(qualifiedName);
                if (fileData != null) {
                    Object[] lines = fileData.getLines();
                    if (lines != null) {
                        Object[] postProcessedLines;
                        for (Object lineData : postProcessedLines = suite.getCoverageEngine().postProcessExecutableLines(lines, SrcFileAnnotator.this.myEditor)) {
                            int lineNumberInCurrent;
                            if (!(lineData instanceof LineData)) continue;
                            final int line = ((LineData)lineData).getLineNumber() - 1;
                            if (oldToNewLineMapping != null) {
                                if (!oldToNewLineMapping.contains(line)) continue;
                                lineNumberInCurrent = oldToNewLineMapping.get(line);
                            } else {
                                lineNumberInCurrent = line;
                            }
                            LOG.assertTrue(lineNumberInCurrent < SrcFileAnnotator.this.myDocument.getLineCount());
                            executableLines.put(line, (LineData)lineData);
                            classLines.put(line, postProcessedLines);
                            classNames.put(line, qualifiedName);
                            ApplicationManager.getApplication().invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (SrcFileAnnotator.this.myDocument == null || lineNumberInCurrent >= SrcFileAnnotator.this.myDocument.getLineCount()) {
                                        return;
                                    }
                                    RangeHighlighter highlighter = SrcFileAnnotator.this.createRangeHighlighter(suite.getLastCoverageTimeStamp(), markupModel, coverageByTestApplicable, executableLines, qualifiedName, line, lineNumberInCurrent, suite, postProcessedLines);
                                    highlighters.add(highlighter);
                                }
                            });
                        }
                    }
                } else if (outputFile != null && !subCoverageActive && engine.includeUntouchedFileInCoverage(qualifiedName, outputFile, SrcFileAnnotator.this.myFile, suite)) {
                    SrcFileAnnotator.this.collectNonCoveredFileInfo(outputFile, highlighters, markupModel, executableLines, coverageByTestApplicable);
                }
            }
        }
        HighlightersCollector collector = new HighlightersCollector();
        if (!outputFiles.isEmpty()) {
            for (File outputFile : outputFiles) {
                String qualifiedName = engine.getQualifiedName(outputFile, this.myFile);
                if (qualifiedName == null) continue;
                collector.collect(outputFile, qualifiedName);
            }
        } else {
            for (String qName : qualifiedNames) {
                collector.collect(null, qName);
            }
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SrcFileAnnotator.this.myEditor != null && highlighters.size() > 0) {
                    SrcFileAnnotator.this.myEditor.putUserData(COVERAGE_HIGHLIGHTERS, (Object)highlighters);
                }
            }
        });
        DocumentAdapter documentListener = new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                SrcFileAnnotator.this.myNewToOldLines = null;
                SrcFileAnnotator.this.myOldToNewLines = null;
                ArrayList rangeHighlighters = (ArrayList)SrcFileAnnotator.this.myEditor.getUserData(COVERAGE_HIGHLIGHTERS);
                if (rangeHighlighters == null) {
                    rangeHighlighters = new ArrayList();
                }
                int offset = e.getOffset();
                final int lineNumber = SrcFileAnnotator.this.myDocument.getLineNumber(offset);
                final int lastLineNumber = SrcFileAnnotator.this.myDocument.getLineNumber(offset + e.getNewLength());
                TextRange changeRange = new TextRange(SrcFileAnnotator.this.myDocument.getLineStartOffset(lineNumber), SrcFileAnnotator.this.myDocument.getLineEndOffset(lastLineNumber));
                Iterator it = rangeHighlighters.iterator();
                while (it.hasNext()) {
                    RangeHighlighter highlighter = (RangeHighlighter)it.next();
                    if (highlighter.isValid() && !TextRange.create((Segment)highlighter).intersects(changeRange)) continue;
                    highlighter.dispose();
                    it.remove();
                }
                final ArrayList highlighters = rangeHighlighters;
                SrcFileAnnotator.this.myUpdateAlarm.cancelAllRequests();
                if (!SrcFileAnnotator.this.myUpdateAlarm.isDisposed()) {
                    SrcFileAnnotator.this.myUpdateAlarm.addRequest(new Runnable(){

                        @Override
                        public void run() {
                            final TIntIntHashMap newToOldLineMapping = SrcFileAnnotator.this.getNewToOldLineMapping(suite.getLastCoverageTimeStamp());
                            if (newToOldLineMapping != null) {
                                ApplicationManager.getApplication().invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (SrcFileAnnotator.this.myEditor == null) {
                                            return;
                                        }
                                        for (int line = lineNumber; line <= lastLineNumber; ++line) {
                                            int oldLineNumber = newToOldLineMapping.get(line);
                                            LineData lineData = (LineData)executableLines.get(oldLineNumber);
                                            if (lineData == null) continue;
                                            RangeHighlighter rangeHighlighter = SrcFileAnnotator.this.createRangeHighlighter(suite.getLastCoverageTimeStamp(), markupModel, coverageByTestApplicable, executableLines, (String)classNames.get(oldLineNumber), oldLineNumber, line, suite, (Object[])classLines.get(oldLineNumber));
                                            highlighters.add(rangeHighlighter);
                                        }
                                        SrcFileAnnotator.this.myEditor.putUserData(COVERAGE_HIGHLIGHTERS, highlighters.size() > 0 ? highlighters : null);
                                    }
                                });
                            }
                        }
                    }, 100);
                }
            }
        };
        this.myDocument.addDocumentListener((DocumentListener)documentListener);
        this.myEditor.putUserData(COVERAGE_DOCUMENT_LISTENER, (Object)documentListener);
    }

    private static boolean classesArePresentInCoverageData(ProjectData data, Set<String> qualifiedNames) {
        for (String qualifiedName : qualifiedNames) {
            if (data.getClassData(qualifiedName) == null) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private RangeHighlighter createRangeHighlighter(final long date, MarkupModel markupModel, boolean coverageByTestApplicable, TreeMap<Integer, LineData> executableLines, @Nullable String className, int line, int lineNumberInCurrent, @NotNull CoverageSuitesBundle coverageSuite, Object[] objectArray) {
        void lines;
        LineData lineData;
        if (coverageSuite == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineNumberInCurrent", "com/intellij/coverage/SrcFileAnnotator", "createRangeHighlighter"));
        }
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        TextAttributes attributes = scheme.getAttributes(CoverageLineMarkerRenderer.getAttributesKey(line, executableLines));
        TextAttributes textAttributes = null;
        if (attributes.getBackgroundColor() != null) {
            textAttributes = attributes;
        }
        int startOffset = this.myDocument.getLineStartOffset(lineNumberInCurrent);
        int endOffset = this.myDocument.getLineEndOffset(lineNumberInCurrent);
        RangeHighlighter highlighter = markupModel.addRangeHighlighter(startOffset, endOffset, 5999, textAttributes, HighlighterTargetArea.LINES_IN_RANGE);
        Function<Integer, Integer> newToOldConverter = new Function<Integer, Integer>(){

            public Integer fun(Integer newLine) {
                if (SrcFileAnnotator.this.myEditor == null) {
                    return -1;
                }
                TIntIntHashMap oldLineMapping = SrcFileAnnotator.this.getNewToOldLineMapping(date);
                return oldLineMapping != null ? oldLineMapping.get(newLine.intValue()) : newLine.intValue();
            }
        };
        Function<Integer, Integer> oldToNewConverter = new Function<Integer, Integer>(){

            public Integer fun(Integer newLine) {
                if (SrcFileAnnotator.this.myEditor == null) {
                    return -1;
                }
                TIntIntHashMap newLineMapping = SrcFileAnnotator.this.getOldToNewLineMapping(date);
                return newLineMapping != null ? newLineMapping.get(newLine.intValue()) : newLine.intValue();
            }
        };
        CoverageLineMarkerRenderer markerRenderer = coverageSuite.getCoverageEngine().getLineMarkerRenderer(line, className, executableLines, coverageByTestApplicable, coverageSuite, newToOldConverter, oldToNewConverter, CoverageDataManager.getInstance(this.myProject).isSubCoverageActive());
        highlighter.setLineMarkerRenderer((LineMarkerRenderer)markerRenderer);
        LineData lineData2 = lineData = className != null ? (LineData)lines[line + 1] : null;
        if (lineData != null && lineData.getStatus() == 0) {
            highlighter.setErrorStripeMarkColor(markerRenderer.getErrorStripeColor(this.myEditor));
            highlighter.setThinErrorStripeMark(true);
            highlighter.setGreedyToLeft(true);
            highlighter.setGreedyToRight(true);
        }
        return highlighter;
    }

    private void showEditorWarningMessage(final String message) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                FileEditor[] editors;
                if (SrcFileAnnotator.this.myEditor == null) {
                    return;
                }
                final FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)SrcFileAnnotator.this.myProject);
                VirtualFile vFile = SrcFileAnnotator.this.myFile.getVirtualFile();
                assert (vFile != null);
                HashMap<FileEditor, 1> map = (HashMap<FileEditor, 1>)SrcFileAnnotator.this.myFile.getCopyableUserData(NOTIFICATION_PANELS);
                if (map == null) {
                    map = new HashMap<FileEditor, 1>();
                    SrcFileAnnotator.this.myFile.putCopyableUserData(NOTIFICATION_PANELS, map);
                }
                for (final FileEditor editor : editors = fileEditorManager.getAllEditors(vFile)) {
                    if (!SrcFileAnnotator.this.isCurrentEditor(editor)) continue;
                    final EditorNotificationPanel panel = new EditorNotificationPanel(){
                        {
                            this.myLabel.setIcon(AllIcons.General.ExclMark);
                            this.myLabel.setText(message);
                        }
                    };
                    panel.createActionLabel("Close", new Runnable(){

                        @Override
                        public void run() {
                            fileEditorManager.removeTopComponent(editor, (JComponent)panel);
                        }
                    });
                    map.put(editor, panel);
                    fileEditorManager.addTopComponent(editor, (JComponent)panel);
                    break;
                }
            }
        });
    }

    private boolean isCurrentEditor(FileEditor editor) {
        return editor instanceof TextEditor && ((TextEditor)editor).getEditor() == this.myEditor;
    }

    private void collectNonCoveredFileInfo(File outputFile, List<RangeHighlighter> highlighters, MarkupModel markupModel, TreeMap<Integer, LineData> executableLines, boolean coverageByTestApplicable) {
        TIntIntHashMap mapping;
        CoverageSuitesBundle coverageSuite = CoverageDataManager.getInstance(this.myProject).getCurrentSuitesBundle();
        if (coverageSuite == null) {
            return;
        }
        if (outputFile.lastModified() < this.getVirtualFile().getTimeStamp()) {
            mapping = this.getOldToNewLineMapping(outputFile.lastModified());
            if (mapping == null) {
                return;
            }
        } else {
            mapping = null;
        }
        List<Integer> uncoveredLines = coverageSuite.getCoverageEngine().collectSrcLinesForUntouchedFile(outputFile, coverageSuite);
        int lineCount = this.myDocument.getLineCount();
        if (uncoveredLines == null) {
            for (int lineNumber = 0; lineNumber < lineCount; ++lineNumber) {
                this.addHighlighter(outputFile, highlighters, markupModel, executableLines, coverageByTestApplicable, coverageSuite, lineNumber, lineNumber);
            }
        } else {
            for (int lineNumber : uncoveredLines) {
                if (lineNumber >= lineCount) continue;
                int updatedLineNumber = mapping != null ? mapping.get(lineNumber) : lineNumber;
                this.addHighlighter(outputFile, highlighters, markupModel, executableLines, coverageByTestApplicable, coverageSuite, lineNumber, updatedLineNumber);
            }
        }
    }

    private void addHighlighter(final File outputFile, final List<RangeHighlighter> highlighters, final MarkupModel markupModel, final TreeMap<Integer, LineData> executableLines, final boolean coverageByTestApplicable, final CoverageSuitesBundle coverageSuite, final int lineNumber, final int updatedLineNumber) {
        executableLines.put(updatedLineNumber, null);
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SrcFileAnnotator.this.myEditor == null) {
                    return;
                }
                RangeHighlighter highlighter = SrcFileAnnotator.this.createRangeHighlighter(outputFile.lastModified(), markupModel, coverageByTestApplicable, executableLines, null, lineNumber, updatedLineNumber, coverageSuite, null);
                highlighters.add(highlighter);
            }
        });
    }

    private VirtualFile getVirtualFile() {
        VirtualFile vFile = this.myFile.getVirtualFile();
        LOG.assertTrue(vFile != null);
        return vFile;
    }

    private void coverageDataNotFound(CoverageSuitesBundle suite) {
        this.showEditorWarningMessage(CodeInsightBundle.message((String)"coverage.data.not.found", (Object[])new Object[0]));
        for (CoverageSuite coverageSuite : suite.getSuites()) {
            CoverageDataManager.getInstance(this.myProject).removeCoverageSuite(coverageSuite);
        }
    }

    public void dispose() {
        this.hideCoverageData();
        this.myEditor = null;
        this.myDocument = null;
        this.myFile = null;
    }
}

