/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.internal.build.BuildConfigGenerator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import gnu.trove.THashSet;
import gnu.trove.TObjectLongHashMap;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.android.compiler.artifact.AndroidArtifactSigningMode;
import org.jetbrains.android.compiler.tools.AndroidApt;
import org.jetbrains.android.compiler.tools.AndroidIdl;
import org.jetbrains.android.compiler.tools.AndroidRenderscript;
import org.jetbrains.android.util.AndroidBuildTestingManager;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidCompilerMessageKind;
import org.jetbrains.android.util.JavaFilesFilter;
import org.jetbrains.android.util.ResourceEntry;
import org.jetbrains.android.util.ResourceFileData;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.android.AndroidAptStateStorage;
import org.jetbrains.jps.android.AndroidAptValidityState;
import org.jetbrains.jps.android.AndroidBuildConfigState;
import org.jetbrains.jps.android.AndroidBuildConfigStateStorage;
import org.jetbrains.jps.android.AndroidBuildDataCache;
import org.jetbrains.jps.android.AndroidExcludedJavaSourceRootProvider;
import org.jetbrains.jps.android.AndroidFileSetState;
import org.jetbrains.jps.android.AndroidFinalPackageElementBuilder;
import org.jetbrains.jps.android.AndroidGenSourcesCopyingStorage;
import org.jetbrains.jps.android.AndroidJpsBundle;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.AndroidPlatform;
import org.jetbrains.jps.android.model.AndroidApplicationArtifactType;
import org.jetbrains.jps.android.model.JpsAndroidApplicationArtifactProperties;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.builders.java.ExcludedJavaSourceRootProvider;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.storage.SourceToOutputMapping;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.java.FormsParsing;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.java.JpsJavaClasspathKind;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleDependency;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.service.JpsServiceManager;

public class AndroidSourceGeneratingBuilder
extends ModuleLevelBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.incremental.android.AndroidSourceGeneratingBuilder");
    @NonNls
    private static final String ANDROID_VALIDATOR = "android-validator";
    @NonNls
    private static final String ANDROID_IDL_COMPILER = "android-idl-compiler";
    @NonNls
    private static final String ANDROID_RENDERSCRIPT_COMPILER = "android-renderscript-compiler";
    @NonNls
    private static final String ANDROID_BUILD_CONFIG_GENERATOR = "android-buildconfig-generator";
    @NonNls
    private static final String ANDROID_APT_COMPILER = "android-apt-compiler";
    @NonNls
    private static final String ANDROID_GENERATED_SOURCES_PROCESSOR = "android-generated-sources-processor";
    @NonNls
    private static final String BUILDER_NAME = "Android Source Generator";
    @NonNls
    private static final String AIDL_EXTENSION = "aidl";
    @NonNls
    private static final String RENDERSCRIPT_EXTENSION = "rs";
    @NonNls
    private static final String PERMISSION_TAG = "permission";
    @NonNls
    private static final String PERMISSION_GROUP_TAG = "permission-group";
    @NonNls
    private static final String NAME_ATTRIBUTE = "name";
    private static final int MIN_PLATFORM_TOOLS_REVISION = 11;
    private static final int MIN_SDK_TOOLS_REVISION = 19;
    public static final Key<Boolean> IS_ENABLED = Key.create((String)"_android_source_generator_enabled_");
    @NonNls
    private static final String R_TXT_OUTPUT_DIR_NAME = "r_txt";

    public AndroidSourceGeneratingBuilder() {
        super(BuilderCategory.SOURCE_GENERATOR);
    }

    public void buildStarted(CompileContext context) {
        IS_ENABLED.set((UserDataHolder)context, (Object)true);
    }

    public void buildFinished(CompileContext context) {
        AndroidBuildDataCache.clean();
    }

    public ModuleLevelBuilder.ExitCode build(CompileContext context, ModuleChunk chunk, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, ModuleLevelBuilder.OutputConsumer outputConsumer) throws ProjectBuildException {
        if (!((Boolean)IS_ENABLED.get((UserDataHolder)context, (Object)Boolean.TRUE)).booleanValue() || chunk.containsTests() || !AndroidJpsUtil.isAndroidProjectWithoutGradleFacet(chunk)) {
            return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        }
        try {
            return AndroidSourceGeneratingBuilder.doBuild(context, chunk, dirtyFilesHolder);
        }
        catch (Exception e) {
            return AndroidJpsUtil.handleException(context, e, BUILDER_NAME, LOG);
        }
    }

    public List<String> getCompilableFileExtensions() {
        return Arrays.asList(AIDL_EXTENSION, RENDERSCRIPT_EXTENSION);
    }

    private static ModuleLevelBuilder.ExitCode doBuild(CompileContext context, ModuleChunk chunk, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder) throws IOException {
        MyExitStatus status;
        Map<JpsModule, MyModuleData> moduleDataMap = AndroidSourceGeneratingBuilder.computeModuleDatas(chunk.getModules(), context);
        if (moduleDataMap == null || moduleDataMap.size() == 0) {
            return ModuleLevelBuilder.ExitCode.ABORT;
        }
        if (!AndroidSourceGeneratingBuilder.checkVersions(moduleDataMap, context)) {
            return ModuleLevelBuilder.ExitCode.ABORT;
        }
        AndroidSourceGeneratingBuilder.checkAndroidDependencies(moduleDataMap, context);
        if (!AndroidSourceGeneratingBuilder.checkArtifacts(context)) {
            return ModuleLevelBuilder.ExitCode.ABORT;
        }
        if (JavaBuilderUtil.isForcedRecompilationAllJavaModules((CompileContext)context) && !AndroidSourceGeneratingBuilder.clearAndroidStorages(context, chunk.getModules())) {
            return ModuleLevelBuilder.ExitCode.ABORT;
        }
        HashMap idlFilesToCompile = new HashMap();
        HashMap rsFilesToCompile = new HashMap();
        dirtyFilesHolder.processDirtyFiles((FileProcessor)new FileProcessor<JavaSourceRootDescriptor, ModuleBuildTarget>((Map)idlFilesToCompile, (Map)rsFilesToCompile){
            final /* synthetic */ Map val$idlFilesToCompile;
            final /* synthetic */ Map val$rsFilesToCompile;
            {
                this.val$idlFilesToCompile = map;
                this.val$rsFilesToCompile = map2;
            }

            public boolean apply(ModuleBuildTarget target, File file, JavaSourceRootDescriptor sourceRoot) throws IOException {
                JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(target.getModule());
                if (extension == null) {
                    return true;
                }
                String fileName = file.getName();
                if (FileUtilRt.extensionEquals((String)fileName, (String)AndroidSourceGeneratingBuilder.AIDL_EXTENSION)) {
                    this.val$idlFilesToCompile.put(file, target);
                } else if (FileUtilRt.extensionEquals((String)fileName, (String)AndroidSourceGeneratingBuilder.RENDERSCRIPT_EXTENSION)) {
                    this.val$rsFilesToCompile.put(file, target);
                }
                return true;
            }
        });
        boolean success = true;
        BuildDataManager dataManager = context.getProjectDescriptor().dataManager;
        if (JavaBuilderUtil.isForcedRecompilationAllJavaModules((CompileContext)context)) {
            for (JpsModule module : moduleDataMap.keySet()) {
                File generatedResourcesStorage;
                File generatedSourcesStorage = AndroidJpsUtil.getGeneratedSourcesStorage(module, dataManager);
                if (generatedSourcesStorage.exists() && !AndroidSourceGeneratingBuilder.deleteAndMarkRecursively(generatedSourcesStorage, context, BUILDER_NAME)) {
                    success = false;
                }
                if (!(generatedResourcesStorage = AndroidJpsUtil.getGeneratedResourcesStorage(module, dataManager)).exists() || AndroidSourceGeneratingBuilder.deleteAndMarkRecursively(generatedResourcesStorage, context, BUILDER_NAME)) continue;
                success = false;
            }
        }
        if (!success) {
            return ModuleLevelBuilder.ExitCode.ABORT;
        }
        boolean didSomething = false;
        if (idlFilesToCompile.size() > 0) {
            if (!AndroidSourceGeneratingBuilder.runAidlCompiler(context, (Map<File, ModuleBuildTarget>)idlFilesToCompile, moduleDataMap)) {
                success = false;
            }
            didSomething = true;
        }
        if (rsFilesToCompile.size() > 0) {
            if (!AndroidSourceGeneratingBuilder.runRenderscriptCompiler(context, (Map<File, ModuleBuildTarget>)rsFilesToCompile, moduleDataMap)) {
                success = false;
            }
            didSomething = true;
        }
        if ((status = AndroidSourceGeneratingBuilder.runAaptCompiler(context, moduleDataMap)) == MyExitStatus.FAIL) {
            success = false;
        } else if (status == MyExitStatus.OK) {
            didSomething = true;
        }
        status = AndroidSourceGeneratingBuilder.runBuildConfigGeneration(context, moduleDataMap);
        if (status == MyExitStatus.FAIL) {
            success = false;
        } else if (status == MyExitStatus.OK) {
            didSomething = true;
        }
        if (!success) {
            return ModuleLevelBuilder.ExitCode.ABORT;
        }
        status = AndroidSourceGeneratingBuilder.copyGeneratedSources(moduleDataMap, dataManager, context);
        if (status == MyExitStatus.FAIL) {
            return ModuleLevelBuilder.ExitCode.ABORT;
        }
        if (status == MyExitStatus.OK) {
            didSomething = true;
        }
        if (didSomething) {
            return ModuleLevelBuilder.ExitCode.OK;
        }
        return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
    }

    @NotNull
    private static List<String> filterExcludedByOtherProviders(@NotNull JpsModule module, @NotNull Collection<String> genRoots) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "filterExcludedByOtherProviders"));
        }
        if (genRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "genRoots", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "filterExcludedByOtherProviders"));
        }
        THashSet genRootPaths = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
        for (String genRoot : genRoots) {
            genRootPaths.add(FileUtil.toSystemIndependentName((String)genRoot));
        }
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<JpsModuleSourceRoot> genSourceRoots = new ArrayList<JpsModuleSourceRoot>();
        for (JpsModuleSourceRoot root : module.getSourceRoots()) {
            if (!genRootPaths.contains(FileUtil.toSystemIndependentName((String)root.getFile().getPath()))) continue;
            genSourceRoots.add(root);
        }
        Iterable excludedRootProviders = JpsServiceManager.getInstance().getExtensions(ExcludedJavaSourceRootProvider.class);
        for (JpsModuleSourceRoot genSourceRoot : genSourceRoots) {
            boolean excluded = false;
            for (ExcludedJavaSourceRootProvider provider : excludedRootProviders) {
                if (provider instanceof AndroidExcludedJavaSourceRootProvider || !provider.isExcludedFromCompilation(module, genSourceRoot)) continue;
                excluded = true;
                break;
            }
            String genRootFilePath = genSourceRoot.getFile().getPath();
            if (excluded) continue;
            result.add(genRootFilePath);
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "filterExcludedByOtherProviders"));
        }
        return arrayList;
    }

    @NotNull
    private static MyExitStatus copyGeneratedSources(@NotNull Map<JpsModule, MyModuleData> moduleDataMap, @NotNull BuildDataManager dataManager, final @NotNull CompileContext context) throws IOException {
        if (moduleDataMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleDataMap", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "copyGeneratedSources"));
        }
        if (dataManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataManager", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "copyGeneratedSources"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "copyGeneratedSources"));
        }
        final Ref didSomething = Ref.create((Object)false);
        final Ref success = Ref.create((Object)true);
        for (Map.Entry<JpsModule, MyModuleData> entry : moduleDataMap.entrySet()) {
            ArrayList<String> deletedFiles;
            JpsModule module = entry.getKey();
            MyModuleData data = entry.getValue();
            if (!data.getAndroidExtension().isCopyCustomGeneratedSources()) continue;
            ModuleBuildTarget moduleTarget = new ModuleBuildTarget(module, JavaModuleBuildTargetType.PRODUCTION);
            AndroidGenSourcesCopyingStorage storage = (AndroidGenSourcesCopyingStorage)context.getProjectDescriptor().dataManager.getStorage((BuildTarget)moduleTarget, AndroidGenSourcesCopyingStorage.PROVIDER);
            Set<String> genDirs = AndroidJpsUtil.getGenDirs(data.getAndroidExtension());
            List<String> filteredGenDirs = AndroidSourceGeneratingBuilder.filterExcludedByOtherProviders(module, genDirs);
            HashSet forciblyExcludedDirs = new HashSet(genDirs);
            forciblyExcludedDirs.removeAll(filteredGenDirs);
            AndroidSourceGeneratingBuilder.warnUserAboutForciblyExcludedRoots((Set<String>)forciblyExcludedDirs, context);
            AndroidFileSetState savedState = storage.read();
            AndroidFileSetState currentState = new AndroidFileSetState(filteredGenDirs, new Condition<File>(){

                public boolean value(File file) {
                    try {
                        return AndroidSourceGeneratingBuilder.shouldBeCopied(file);
                    }
                    catch (IOException e) {
                        return false;
                    }
                }
            }, true);
            if (currentState.equalsTo(savedState)) continue;
            final File outDir = AndroidJpsUtil.getCopiedSourcesStorage(module, dataManager.getDataPaths());
            AndroidSourceGeneratingBuilder.clearDirectoryIfNotEmpty(outDir, context, ANDROID_GENERATED_SOURCES_PROCESSOR);
            final ArrayList<Pair<String, String>> copiedFiles = new ArrayList<Pair<String, String>>();
            for (String path : filteredGenDirs) {
                final File dir = new File(path);
                if (!dir.isDirectory()) continue;
                FileUtil.processFilesRecursively((File)dir, (Processor)new Processor<File>(){

                    public boolean process(File file) {
                        try {
                            if (!AndroidSourceGeneratingBuilder.shouldBeCopied(file)) {
                                return true;
                            }
                            String relPath = FileUtil.getRelativePath((File)dir, (File)file);
                            File dstFile = new File(outDir.getPath() + "/" + relPath);
                            File dstDir = dstFile.getParentFile();
                            if (!dstDir.exists() && !dstDir.mkdirs()) {
                                context.processMessage((BuildMessage)new CompilerMessage(AndroidSourceGeneratingBuilder.ANDROID_GENERATED_SOURCES_PROCESSOR, BuildMessage.Kind.ERROR, AndroidJpsBundle.message("android.jps.cannot.create.directory", dstDir.getPath())));
                                return true;
                            }
                            FileUtil.copy((File)file, (File)dstFile);
                            copiedFiles.add(Pair.create((Object)file.getPath(), (Object)dstFile.getPath()));
                            didSomething.set((Object)true);
                        }
                        catch (IOException e) {
                            AndroidJpsUtil.reportExceptionError(context, null, e, AndroidSourceGeneratingBuilder.ANDROID_GENERATED_SOURCES_PROCESSOR);
                            success.set((Object)false);
                            return true;
                        }
                        return true;
                    }
                });
            }
            File generatedSourcesDir = AndroidJpsUtil.getGeneratedSourcesStorage(module, dataManager.getDataPaths());
            if (!AndroidSourceGeneratingBuilder.removeCopiedFilesDuplicatingGeneratedFiles(context, outDir, generatedSourcesDir, deletedFiles = new ArrayList<String>())) {
                success.set((Object)false);
                continue;
            }
            AndroidBuildTestingManager testingManager = AndroidBuildTestingManager.getTestingManager();
            if (testingManager != null) {
                AndroidSourceGeneratingBuilder.logGeneratedSourcesProcessing(testingManager, copiedFiles, deletedFiles);
            }
            AndroidSourceGeneratingBuilder.markDirtyRecursively(outDir, context, ANDROID_GENERATED_SOURCES_PROCESSOR, false);
            storage.saveState(currentState);
        }
        if (((Boolean)didSomething.get()).booleanValue()) {
            MyExitStatus myExitStatus = (Boolean)success.get() != false ? MyExitStatus.OK : MyExitStatus.FAIL;
            if (myExitStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "copyGeneratedSources"));
            }
            return myExitStatus;
        }
        MyExitStatus myExitStatus = MyExitStatus.NOTHING_CHANGED;
        if (myExitStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "copyGeneratedSources"));
        }
        return myExitStatus;
    }

    private static void warnUserAboutForciblyExcludedRoots(@NotNull Set<String> paths, @NotNull CompileContext context) {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "warnUserAboutForciblyExcludedRoots"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "warnUserAboutForciblyExcludedRoots"));
        }
        for (String dir : paths) {
            boolean hasFileToCopy = !FileUtil.processFilesRecursively((File)new File(dir), (Processor)new Processor<File>(){

                public boolean process(File file) {
                    try {
                        return !AndroidSourceGeneratingBuilder.shouldBeCopied(file);
                    }
                    catch (IOException e) {
                        return false;
                    }
                }
            });
            if (!hasFileToCopy) continue;
            context.processMessage((BuildMessage)new CompilerMessage(ANDROID_GENERATED_SOURCES_PROCESSOR, BuildMessage.Kind.WARNING, "Source root " + FileUtil.toSystemDependentName((String)dir) + " was forcibly excluded by the IDE, so custom generated files won't be compiled"));
        }
    }

    private static boolean shouldBeCopied(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "shouldBeCopied"));
        }
        return file.isFile() && (!FileUtilRt.extensionEquals((String)file.getName(), (String)"java") || !AndroidSourceGeneratingBuilder.isGeneratedByIdea(file));
    }

    private static boolean removeCopiedFilesDuplicatingGeneratedFiles(final CompileContext context, final File copiedFilesDir, File generatedSourcesDir, final List<String> deletedFiles) {
        if (!generatedSourcesDir.isDirectory()) {
            return true;
        }
        final File[] genRoots = generatedSourcesDir.listFiles();
        if (genRoots == null || genRoots.length == 0) {
            return true;
        }
        final Ref success = Ref.create((Object)true);
        FileUtil.processFilesRecursively((File)copiedFilesDir, (Processor)new Processor<File>(){

            public boolean process(File file) {
                if (!file.isFile()) {
                    return true;
                }
                String relPath = FileUtil.getRelativePath((File)copiedFilesDir, (File)file);
                if (relPath != null) {
                    boolean toDelete = false;
                    for (File genRoot : genRoots) {
                        File genFile = new File(genRoot.getPath() + "/" + relPath);
                        if (!genFile.exists()) continue;
                        LOG.debug("File " + file.getPath() + " duplicates generated file " + genFile.getPath() + ", so it'll be deleted");
                        toDelete = true;
                        break;
                    }
                    if (toDelete) {
                        if (!FileUtil.delete((File)file)) {
                            context.processMessage((BuildMessage)new CompilerMessage(AndroidSourceGeneratingBuilder.ANDROID_GENERATED_SOURCES_PROCESSOR, BuildMessage.Kind.ERROR, "Cannot remove file " + file.getPath()));
                            success.set((Object)false);
                        } else {
                            deletedFiles.add(file.getPath());
                        }
                    }
                }
                return true;
            }
        });
        return (Boolean)success.get();
    }

    private static void logGeneratedSourcesProcessing(AndroidBuildTestingManager manager, List<Pair<String, String>> copiedFiles, List<String> deletedFiles) {
        if (copiedFiles.size() == 0 && deletedFiles.size() == 0) {
            return;
        }
        StringBuilder message = new StringBuilder(ANDROID_GENERATED_SOURCES_PROCESSOR);
        message.append("\n");
        if (copiedFiles.size() > 0) {
            Collections.sort(copiedFiles, new Comparator<Pair<String, String>>(){

                @Override
                public int compare(Pair<String, String> o1, Pair<String, String> o2) {
                    return ((String)o1.getFirst() + (String)o1.getSecond()).compareTo((String)o2.getFirst() + (String)o2.getSecond());
                }
            });
            message.append("Copied files\n");
            for (Pair pair : copiedFiles) {
                message.append((String)pair.getFirst()).append('\n').append((String)pair.getSecond()).append('\n');
            }
        }
        if (deletedFiles.size() > 0) {
            Collections.sort(deletedFiles);
            message.append("Deleted files\n");
            for (String string : deletedFiles) {
                message.append(string).append('\n');
            }
        }
        manager.getCommandExecutor().log(message.toString());
    }

    private static boolean isGeneratedByIdea(File file) throws IOException {
        String text = FileUtil.loadFile((File)file);
        return text.startsWith("/*___Generated_by_IDEA___*/");
    }

    private static boolean clearAndroidStorages(@NotNull CompileContext context, @NotNull Collection<JpsModule> modules) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "clearAndroidStorages"));
        }
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "clearAndroidStorages"));
        }
        for (JpsModule module : modules) {
            File dir = AndroidJpsUtil.getDirectoryForIntermediateArtifacts(context, module);
            if (!dir.exists() || FileUtil.delete((File)dir)) continue;
            context.processMessage((BuildMessage)new CompilerMessage(BUILDER_NAME, BuildMessage.Kind.ERROR, AndroidJpsBundle.message("android.jps.cannot.delete", dir.getPath())));
            return false;
        }
        return true;
    }

    private static boolean checkVersions(@NotNull Map<JpsModule, MyModuleData> dataMap, @NotNull CompileContext context) {
        if (dataMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataMap", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "checkVersions"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "checkVersions"));
        }
        for (Map.Entry<JpsModule, MyModuleData> entry : dataMap.entrySet()) {
            int sdkToolsRevision;
            JpsModule module = entry.getKey();
            AndroidPlatform platform = entry.getValue().getPlatform();
            boolean success = true;
            int platformToolsRevision = platform.getPlatformToolsRevision();
            if (platformToolsRevision >= 0 && platformToolsRevision < 11) {
                String message = '[' + module.getName() + "] Incompatible version of Android SDK Platform-tools package. Min version is " + 11 + ". Please, update it though SDK manager";
                context.processMessage((BuildMessage)new CompilerMessage(ANDROID_VALIDATOR, BuildMessage.Kind.ERROR, message));
                success = false;
            }
            if ((sdkToolsRevision = platform.getSdkToolsRevision()) >= 0 && sdkToolsRevision < 19) {
                String message = '[' + module.getName() + "] Incompatible version " + sdkToolsRevision + " of Android SDK Tools package. Min version is " + 19 + ". Please, update it though SDK manager";
                context.processMessage((BuildMessage)new CompilerMessage(ANDROID_VALIDATOR, BuildMessage.Kind.ERROR, message));
                success = false;
            }
            if (success) continue;
            return false;
        }
        return true;
    }

    private static void checkAndroidDependencies(@NotNull Map<JpsModule, MyModuleData> moduleDataMap, @NotNull CompileContext context) {
        if (moduleDataMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleDataMap", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "checkAndroidDependencies"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "checkAndroidDependencies"));
        }
        for (Map.Entry<JpsModule, MyModuleData> entry : moduleDataMap.entrySet()) {
            JpsModule module = entry.getKey();
            MyModuleData moduleData = entry.getValue();
            JpsAndroidModuleExtension extension = moduleData.getAndroidExtension();
            if (extension.isLibrary()) continue;
            for (JpsDependencyElement item : JpsJavaExtensionService.getInstance().getDependencies(module, JpsJavaClasspathKind.PRODUCTION_RUNTIME, false)) {
                JpsAndroidModuleExtension depExtension;
                JpsModule depModule;
                if (!(item instanceof JpsModuleDependency) || (depModule = ((JpsModuleDependency)item).getModule()) == null || (depExtension = AndroidJpsUtil.getExtension(depModule)) == null || depExtension.isLibrary()) continue;
                String message = "Suspicious module dependency " + module.getName() + " -> " + depModule.getName() + ": Android application module depends on other application module. Possibly, you should " + "change type of module '" + depModule.getName() + "' to 'Library' or change the dependency scope to 'Provided'.";
                context.processMessage((BuildMessage)new CompilerMessage(ANDROID_VALIDATOR, BuildMessage.Kind.WARNING, message));
            }
        }
    }

    private static MyExitStatus runBuildConfigGeneration(@NotNull CompileContext context, @NotNull Map<JpsModule, MyModuleData> moduleDataMap) throws IOException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "runBuildConfigGeneration"));
        }
        if (moduleDataMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleDataMap", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "runBuildConfigGeneration"));
        }
        boolean success = true;
        boolean didSomething = false;
        for (Map.Entry<JpsModule, MyModuleData> entry : moduleDataMap.entrySet()) {
            JpsModule module = entry.getKey();
            ModuleBuildTarget moduleTarget = new ModuleBuildTarget(module, JavaModuleBuildTargetType.PRODUCTION);
            AndroidBuildConfigStateStorage storage = (AndroidBuildConfigStateStorage)context.getProjectDescriptor().dataManager.getStorage((BuildTarget)moduleTarget, AndroidBuildConfigStateStorage.PROVIDER);
            MyModuleData moduleData = entry.getValue();
            JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(module);
            File generatedSourcesDir = AndroidJpsUtil.getGeneratedSourcesStorage(module, context.getProjectDescriptor().dataManager);
            File outputDirectory = new File(generatedSourcesDir, "build_config");
            try {
                if (extension == null || AndroidSourceGeneratingBuilder.isLibraryWithBadCircularDependency(extension)) {
                    if (AndroidSourceGeneratingBuilder.clearDirectoryIfNotEmpty(outputDirectory, context, ANDROID_BUILD_CONFIG_GENERATOR)) continue;
                    success = false;
                    continue;
                }
                String packageName = moduleData.getPackage();
                boolean debug = !AndroidJpsUtil.isReleaseBuild(context);
                HashSet libPackages = new HashSet(AndroidSourceGeneratingBuilder.getDepLibPackages(module).values());
                libPackages.remove(packageName);
                AndroidBuildConfigState newState = new AndroidBuildConfigState(packageName, (Collection<String>)libPackages, debug);
                AndroidBuildConfigState oldState = (AndroidBuildConfigState)storage.getState(module.getName());
                if (newState.equalsTo(oldState)) continue;
                didSomething = true;
                context.processMessage((BuildMessage)new ProgressMessage(AndroidJpsBundle.message("android.jps.progress.build.config", module.getName())));
                if (!AndroidSourceGeneratingBuilder.clearDirectory(outputDirectory, context, ANDROID_BUILD_CONFIG_GENERATOR)) {
                    success = false;
                    continue;
                }
                if (AndroidSourceGeneratingBuilder.doBuildConfigGeneration(packageName, (Collection<String>)libPackages, debug, outputDirectory, context)) {
                    storage.update(module.getName(), newState);
                    AndroidSourceGeneratingBuilder.markDirtyRecursively(outputDirectory, context, ANDROID_BUILD_CONFIG_GENERATOR, true);
                    continue;
                }
                storage.update(module.getName(), null);
                success = false;
            }
            catch (IOException e) {
                AndroidJpsUtil.reportExceptionError(context, null, e, ANDROID_BUILD_CONFIG_GENERATOR);
                success = false;
            }
        }
        if (!success) {
            return MyExitStatus.FAIL;
        }
        if (didSomething) {
            return MyExitStatus.OK;
        }
        return MyExitStatus.NOTHING_CHANGED;
    }

    private static boolean doBuildConfigGeneration(@NotNull String packageName, @NotNull Collection<String> libPackages, boolean debug, @NotNull File outputDirectory, @NotNull CompileContext context) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "doBuildConfigGeneration"));
        }
        if (libPackages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libPackages", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "doBuildConfigGeneration"));
        }
        if (outputDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputDirectory", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "doBuildConfigGeneration"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "doBuildConfigGeneration"));
        }
        if (!AndroidSourceGeneratingBuilder.doBuildConfigGeneration(packageName, debug, outputDirectory.getPath(), context)) {
            return false;
        }
        for (String libPackage : libPackages) {
            if (AndroidSourceGeneratingBuilder.doBuildConfigGeneration(libPackage, debug, outputDirectory.getPath(), context)) continue;
            return false;
        }
        return true;
    }

    private static boolean doBuildConfigGeneration(@NotNull String packageName, boolean debug, @NotNull String outputDirOsPath, @NotNull CompileContext context) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "doBuildConfigGeneration"));
        }
        if (outputDirOsPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputDirOsPath", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "doBuildConfigGeneration"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "doBuildConfigGeneration"));
        }
        BuildConfigGenerator generator = new BuildConfigGenerator(outputDirOsPath, packageName, debug);
        try {
            generator.generate();
            return true;
        }
        catch (IOException e) {
            AndroidJpsUtil.reportExceptionError(context, null, e, ANDROID_BUILD_CONFIG_GENERATOR);
            return false;
        }
    }

    private static boolean runAidlCompiler(@NotNull CompileContext context, @NotNull Map<File, ModuleBuildTarget> files, @NotNull Map<JpsModule, MyModuleData> moduleDataMap) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "runAidlCompiler"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "runAidlCompiler"));
        }
        if (moduleDataMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleDataMap", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "runAidlCompiler"));
        }
        if (files.size() > 0) {
            context.processMessage((BuildMessage)new ProgressMessage(AndroidJpsBundle.message("android.jps.progress.aidl", new Object[0])));
        }
        boolean success = true;
        for (Map.Entry<File, ModuleBuildTarget> entry : files.entrySet()) {
            File file = entry.getKey();
            ModuleBuildTarget buildTarget = entry.getValue();
            String filePath = file.getPath();
            MyModuleData moduleData = moduleDataMap.get(buildTarget.getModule());
            if (!LOG.assertTrue(moduleData != null)) {
                context.processMessage((BuildMessage)new CompilerMessage(ANDROID_IDL_COMPILER, BuildMessage.Kind.ERROR, AndroidJpsBundle.message("android.jps.internal.error", new Object[0])));
                success = false;
                continue;
            }
            File generatedSourcesDir = AndroidJpsUtil.getGeneratedSourcesStorage(buildTarget.getModule(), context.getProjectDescriptor().dataManager);
            File aidlOutputDirectory = new File(generatedSourcesDir, AIDL_EXTENSION);
            if (!aidlOutputDirectory.exists() && !aidlOutputDirectory.mkdirs()) {
                context.processMessage((BuildMessage)new CompilerMessage(ANDROID_IDL_COMPILER, BuildMessage.Kind.ERROR, AndroidJpsBundle.message("android.jps.cannot.create.directory", aidlOutputDirectory.getPath())));
                success = false;
                continue;
            }
            IAndroidTarget target = moduleData.getPlatform().getTarget();
            try {
                File[] sourceRoots = AndroidJpsUtil.getSourceRootsForModuleAndDependencies(buildTarget.getModule());
                String[] sourceRootPaths = AndroidJpsUtil.toPaths(sourceRoots);
                String packageName = AndroidSourceGeneratingBuilder.computePackageForFile(context, file);
                if (packageName == null) {
                    context.processMessage((BuildMessage)new CompilerMessage(ANDROID_IDL_COMPILER, BuildMessage.Kind.ERROR, AndroidJpsBundle.message("android.jps.errors.cannot.compute.package", filePath)));
                    success = false;
                    continue;
                }
                File outputFile = new File(aidlOutputDirectory, packageName.replace('.', File.separatorChar) + File.separator + FileUtil.getNameWithoutExtension((File)file) + ".java");
                String outputFilePath = outputFile.getPath();
                Map messages = AndroidIdl.execute((IAndroidTarget)target, (String)filePath, (String)outputFilePath, (String[])sourceRootPaths);
                AndroidSourceGeneratingBuilder.addMessages(context, messages, filePath, ANDROID_IDL_COMPILER);
                if (((List)messages.get(AndroidCompilerMessageKind.ERROR)).size() > 0) {
                    success = false;
                    continue;
                }
                if (!outputFile.exists()) continue;
                SourceToOutputMapping sourceToOutputMap = context.getProjectDescriptor().dataManager.getSourceToOutputMap((BuildTarget)buildTarget);
                sourceToOutputMap.setOutput(filePath, outputFilePath);
                FSOperations.markDirty((CompileContext)context, (File)outputFile);
            }
            catch (IOException e) {
                AndroidJpsUtil.reportExceptionError(context, filePath, e, ANDROID_IDL_COMPILER);
                success = false;
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean runRenderscriptCompiler(@NotNull CompileContext context, @NotNull Map<File, ModuleBuildTarget> files, @NotNull Map<JpsModule, MyModuleData> moduleDataMap) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "runRenderscriptCompiler"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "runRenderscriptCompiler"));
        }
        if (moduleDataMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleDataMap", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "runRenderscriptCompiler"));
        }
        if (files.size() > 0) {
            context.processMessage((BuildMessage)new ProgressMessage(AndroidJpsBundle.message("android.jps.progress.renderscript", new Object[0])));
        }
        boolean success = true;
        for (Map.Entry<File, ModuleBuildTarget> entry : files.entrySet()) {
            File file = entry.getKey();
            ModuleBuildTarget buildTarget = entry.getValue();
            MyModuleData moduleData = moduleDataMap.get(buildTarget.getModule());
            if (!LOG.assertTrue(moduleData != null)) {
                context.processMessage((BuildMessage)new CompilerMessage(ANDROID_RENDERSCRIPT_COMPILER, BuildMessage.Kind.ERROR, AndroidJpsBundle.message("android.jps.internal.error", new Object[0])));
                success = false;
                continue;
            }
            BuildDataManager dataManager = context.getProjectDescriptor().dataManager;
            File generatedSourcesDir = AndroidJpsUtil.getGeneratedSourcesStorage(buildTarget.getModule(), dataManager);
            File rsOutputDirectory = new File(generatedSourcesDir, RENDERSCRIPT_EXTENSION);
            if (!rsOutputDirectory.exists() && !rsOutputDirectory.mkdirs()) {
                context.processMessage((BuildMessage)new CompilerMessage(ANDROID_RENDERSCRIPT_COMPILER, BuildMessage.Kind.ERROR, AndroidJpsBundle.message("android.jps.cannot.create.directory", rsOutputDirectory.getPath())));
                success = false;
                continue;
            }
            File generatedResourcesDir = AndroidJpsUtil.getGeneratedResourcesStorage(buildTarget.getModule(), dataManager);
            File rawDir = new File(generatedResourcesDir, "raw");
            if (!rawDir.exists() && !rawDir.mkdirs()) {
                context.processMessage((BuildMessage)new CompilerMessage(ANDROID_RENDERSCRIPT_COMPILER, BuildMessage.Kind.ERROR, AndroidJpsBundle.message("android.jps.cannot.create.directory", rawDir.getPath())));
                success = false;
                continue;
            }
            AndroidPlatform platform = moduleData.getPlatform();
            IAndroidTarget target = platform.getTarget();
            String sdkLocation = platform.getSdk().getHomePath();
            String filePath = file.getPath();
            File tmpOutputDirectory = null;
            try {
                tmpOutputDirectory = FileUtil.createTempDirectory((String)"generated-rs-temp", null);
                String depFolderPath = AndroidSourceGeneratingBuilder.getDependencyFolder(context, file, tmpOutputDirectory);
                Map messages = AndroidRenderscript.execute((String)sdkLocation, (IAndroidTarget)target, (String)filePath, (String)tmpOutputDirectory.getPath(), (String)depFolderPath, (String)rawDir.getPath());
                AndroidSourceGeneratingBuilder.addMessages(context, messages, filePath, ANDROID_RENDERSCRIPT_COMPILER);
                if (((List)messages.get(AndroidCompilerMessageKind.ERROR)).size() > 0) {
                    success = false;
                    continue;
                }
                ArrayList<File> newFiles = new ArrayList<File>();
                AndroidCommonUtils.moveAllFiles((File)tmpOutputDirectory, (File)rsOutputDirectory, newFiles);
                File bcFile = new File(rawDir, FileUtil.getNameWithoutExtension((File)file) + ".bc");
                if (bcFile.exists()) {
                    newFiles.add(bcFile);
                }
                List<String> newFilePaths = Arrays.asList(AndroidJpsUtil.toPaths(newFiles.toArray(new File[newFiles.size()])));
                SourceToOutputMapping sourceToOutputMap = dataManager.getSourceToOutputMap((BuildTarget)buildTarget);
                sourceToOutputMap.setOutputs(filePath, newFilePaths);
                for (File newFile : newFiles) {
                    FSOperations.markDirty((CompileContext)context, (File)newFile);
                }
            }
            catch (IOException e) {
                AndroidJpsUtil.reportExceptionError(context, filePath, e, ANDROID_RENDERSCRIPT_COMPILER);
                success = false;
            }
            finally {
                if (tmpOutputDirectory == null) continue;
                FileUtil.delete((File)tmpOutputDirectory);
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MyExitStatus runAaptCompiler(@NotNull CompileContext context, @NotNull Map<JpsModule, MyModuleData> moduleDataMap) throws IOException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "runAaptCompiler"));
        }
        if (moduleDataMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleDataMap", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "runAaptCompiler"));
        }
        boolean success = true;
        boolean didSomething = false;
        for (Map.Entry<JpsModule, MyModuleData> entry : moduleDataMap.entrySet()) {
            JpsModule module = entry.getKey();
            ModuleBuildTarget moduleTarget = new ModuleBuildTarget(module, JavaModuleBuildTargetType.PRODUCTION);
            AndroidAptStateStorage storage = (AndroidAptStateStorage)context.getProjectDescriptor().dataManager.getStorage((BuildTarget)moduleTarget, AndroidAptStateStorage.PROVIDER);
            MyModuleData moduleData = entry.getValue();
            JpsAndroidModuleExtension extension = moduleData.getAndroidExtension();
            File generatedSourcesDir = AndroidJpsUtil.getGeneratedSourcesStorage(module, context.getProjectDescriptor().dataManager);
            File aptOutputDirectory = new File(generatedSourcesDir, "aapt");
            IAndroidTarget target = moduleData.getPlatform().getTarget();
            try {
                AndroidAptValidityState newState;
                String proguardOutputCfgFilePath;
                AndroidAptValidityState oldState;
                String[] resPaths = AndroidJpsUtil.collectResourceDirsForCompilation(extension, false, context, true);
                if (resPaths.length == 0) {
                    if (AndroidSourceGeneratingBuilder.clearDirectoryIfNotEmpty(aptOutputDirectory, context, ANDROID_APT_COMPILER)) continue;
                    success = false;
                    continue;
                }
                String packageName = moduleData.getPackage();
                File manifestFile = extension.isLibrary() || !extension.isManifestMergingEnabled() ? moduleData.getManifestFileForCompiler() : new File(AndroidJpsUtil.getPreprocessedManifestDirectory(module, context.getProjectDescriptor().dataManager.getDataPaths()), "AndroidManifest.xml");
                if (AndroidSourceGeneratingBuilder.isLibraryWithBadCircularDependency(extension)) {
                    if (AndroidSourceGeneratingBuilder.clearDirectoryIfNotEmpty(aptOutputDirectory, context, ANDROID_APT_COMPILER)) continue;
                    success = false;
                    continue;
                }
                Map<JpsModule, String> packageMap = AndroidSourceGeneratingBuilder.getDepLibPackages(module);
                packageMap.put(module, packageName);
                JpsModule circularDepLibWithSamePackage = AndroidSourceGeneratingBuilder.findCircularDependencyOnLibraryWithSamePackage(extension, packageMap);
                if (circularDepLibWithSamePackage != null && !extension.isLibrary()) {
                    String message = "Generated fields in " + packageName + ".R class in module '" + module.getName() + "' won't be final, because of circular dependency on module '" + circularDepLibWithSamePackage.getName() + "'";
                    context.processMessage((BuildMessage)new CompilerMessage(ANDROID_APT_COMPILER, BuildMessage.Kind.WARNING, message));
                }
                boolean generateNonFinalFields = extension.isLibrary() || circularDepLibWithSamePackage != null;
                try {
                    oldState = (AndroidAptValidityState)storage.getState(module.getName());
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                    oldState = null;
                }
                HashMap resources = new HashMap();
                TObjectLongHashMap valueResFilesTimestamps = new TObjectLongHashMap();
                AndroidSourceGeneratingBuilder.collectResources(resPaths, (Map<String, ResourceFileData>)resources, (TObjectLongHashMap<String>)valueResFilesTimestamps, oldState);
                List<ResourceEntry> manifestElements = AndroidSourceGeneratingBuilder.collectManifestElements(manifestFile);
                ArrayList<Pair<String, String>> libRTextFilesAndPackages = new ArrayList<Pair<String, String>>(packageMap.size());
                for (Map.Entry<JpsModule, String> entry1 : packageMap.entrySet()) {
                    String libPackage = entry1.getValue();
                    if (packageName.equals(libPackage)) continue;
                    String libRTxtFilePath = new File(new File(AndroidJpsUtil.getDirectoryForIntermediateArtifacts(context, entry1.getKey()), R_TXT_OUTPUT_DIR_NAME), "R.txt").getPath();
                    libRTextFilesAndPackages.add((Pair<String, String>)Pair.create((Object)libRTxtFilePath, (Object)libPackage));
                }
                AndroidJpsUtil.collectRTextFilesFromAarDeps(module, libRTextFilesAndPackages);
                File outputDirForArtifacts = AndroidJpsUtil.getDirectoryForIntermediateArtifacts(context, module);
                if (AndroidJpsUtil.getProGuardConfigIfShouldRun(context, extension) != null) {
                    if (AndroidJpsUtil.createDirIfNotExist(outputDirForArtifacts, context, BUILDER_NAME) == null) {
                        success = false;
                        continue;
                    }
                    proguardOutputCfgFilePath = new File(outputDirForArtifacts, "proguard.txt").getPath();
                } else {
                    proguardOutputCfgFilePath = null;
                }
                String rTxtOutDirOsPath = null;
                if (extension.isLibrary() || libRTextFilesAndPackages.size() > 0) {
                    File rTxtOutDir = new File(outputDirForArtifacts, R_TXT_OUTPUT_DIR_NAME);
                    if (AndroidJpsUtil.createDirIfNotExist(rTxtOutDir, context, BUILDER_NAME) == null) {
                        success = false;
                        continue;
                    }
                    rTxtOutDirOsPath = rTxtOutDir.getPath();
                }
                if ((newState = new AndroidAptValidityState((Map<String, ResourceFileData>)resources, (TObjectLongHashMap<String>)valueResFilesTimestamps, manifestElements, libRTextFilesAndPackages, packageName, proguardOutputCfgFilePath, rTxtOutDirOsPath, extension.isLibrary())).equalsTo(oldState)) {
                    storage.update(module.getName(), newState);
                    continue;
                }
                didSomething = true;
                context.processMessage((BuildMessage)new ProgressMessage(AndroidJpsBundle.message("android.jps.progress.aapt", module.getName())));
                File tmpOutputDir = null;
                try {
                    tmpOutputDir = FileUtil.createTempDirectory((String)"android_apt_output", (String)"tmp");
                    Map messages = AndroidApt.compile((IAndroidTarget)target, (int)-1, (String)manifestFile.getPath(), (String)packageName, (String)tmpOutputDir.getPath(), (String[])resPaths, libRTextFilesAndPackages, (boolean)generateNonFinalFields, (String)proguardOutputCfgFilePath, (String)rTxtOutDirOsPath, (!extension.isLibrary() ? 1 : 0) != 0);
                    AndroidJpsUtil.addMessages(context, messages, ANDROID_APT_COMPILER, module.getName());
                    if (((List)messages.get(AndroidCompilerMessageKind.ERROR)).size() > 0) {
                        success = false;
                        storage.update(module.getName(), null);
                        continue;
                    }
                    if (!AndroidCommonUtils.directoriesContainSameContent((File)tmpOutputDir, (File)aptOutputDirectory, (FileFilter)JavaFilesFilter.INSTANCE)) {
                        if (!AndroidSourceGeneratingBuilder.deleteAndMarkRecursively(aptOutputDirectory, context, ANDROID_APT_COMPILER)) {
                            success = false;
                            continue;
                        }
                        File parent = aptOutputDirectory.getParentFile();
                        if (parent != null && !parent.exists() && !parent.mkdirs()) {
                            context.processMessage((BuildMessage)new CompilerMessage(ANDROID_APT_COMPILER, BuildMessage.Kind.ERROR, AndroidJpsBundle.message("android.jps.cannot.create.directory", parent.getPath())));
                            success = false;
                            continue;
                        }
                        FileUtil.copyDir((File)tmpOutputDir, (File)aptOutputDirectory);
                        AndroidSourceGeneratingBuilder.markDirtyRecursively(aptOutputDirectory, context, ANDROID_APT_COMPILER, true);
                    }
                    storage.update(module.getName(), newState);
                }
                finally {
                    if (tmpOutputDir == null) continue;
                    FileUtil.delete((File)tmpOutputDir);
                }
            }
            catch (IOException e) {
                AndroidJpsUtil.reportExceptionError(context, null, e, ANDROID_APT_COMPILER);
                success = false;
            }
        }
        if (!success) {
            return MyExitStatus.FAIL;
        }
        if (didSomething) {
            return MyExitStatus.OK;
        }
        return MyExitStatus.NOTHING_CHANGED;
    }

    private static boolean clearDirectory(File dir, CompileContext context, String compilerName) throws IOException {
        if (!AndroidSourceGeneratingBuilder.deleteAndMarkRecursively(dir, context, compilerName)) {
            return false;
        }
        if (!dir.mkdirs()) {
            context.processMessage((BuildMessage)new CompilerMessage(compilerName, BuildMessage.Kind.ERROR, AndroidJpsBundle.message("android.jps.cannot.create.directory", dir.getPath())));
            return false;
        }
        return true;
    }

    private static boolean clearDirectoryIfNotEmpty(@NotNull File dir, @NotNull CompileContext context, String compilerName) throws IOException {
        String[] list;
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "clearDirectoryIfNotEmpty"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "clearDirectoryIfNotEmpty"));
        }
        if (dir.isDirectory() && (list = dir.list()) != null && list.length > 0) {
            return AndroidSourceGeneratingBuilder.clearDirectory(dir, context, compilerName);
        }
        return true;
    }

    private static boolean deleteAndMarkRecursively(@NotNull File dir, @NotNull CompileContext context, @NotNull String compilerName) throws IOException {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "deleteAndMarkRecursively"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "deleteAndMarkRecursively"));
        }
        if (compilerName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerName", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "deleteAndMarkRecursively"));
        }
        if (dir.exists()) {
            List<File> filesToDelete = AndroidSourceGeneratingBuilder.collectJavaFilesRecursively(dir);
            if (!FileUtil.delete((File)dir)) {
                context.processMessage((BuildMessage)new CompilerMessage(compilerName, BuildMessage.Kind.ERROR, AndroidJpsBundle.message("android.jps.cannot.delete", dir.getPath())));
                return false;
            }
            for (File file : filesToDelete) {
                FSOperations.markDeleted((CompileContext)context, (File)file);
            }
        }
        return true;
    }

    private static boolean markDirtyRecursively(@NotNull File dir, final @NotNull CompileContext context, final @NotNull String compilerName, final boolean javaFilesOnly) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "markDirtyRecursively"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "markDirtyRecursively"));
        }
        if (compilerName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerName", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "markDirtyRecursively"));
        }
        final Ref success = Ref.create((Object)true);
        FileUtil.processFilesRecursively((File)dir, (Processor)new Processor<File>(){

            public boolean process(File file) {
                if (file.isFile() && (!javaFilesOnly || FileUtilRt.extensionEquals((String)file.getName(), (String)"java"))) {
                    try {
                        FSOperations.markDirty((CompileContext)context, (File)file);
                    }
                    catch (IOException e) {
                        AndroidJpsUtil.reportExceptionError(context, null, e, compilerName);
                        success.set((Object)false);
                        return false;
                    }
                }
                return true;
            }
        });
        return (Boolean)success.get();
    }

    @NotNull
    private static List<File> collectJavaFilesRecursively(@NotNull File dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "collectJavaFilesRecursively"));
        }
        final ArrayList<File> result = new ArrayList<File>();
        FileUtil.processFilesRecursively((File)dir, (Processor)new Processor<File>(){

            public boolean process(File file) {
                if (file.isFile() && FileUtilRt.extensionEquals((String)file.getName(), (String)"java")) {
                    result.add(file);
                }
                return true;
            }
        });
        ArrayList<File> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "collectJavaFilesRecursively"));
        }
        return arrayList;
    }

    @NotNull
    private static Map<JpsModule, String> getDepLibPackages(@NotNull JpsModule module) throws IOException {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "getDepLibPackages"));
        }
        HashMap result = new HashMap();
        for (JpsAndroidModuleExtension depExtension : AndroidJpsUtil.getAllAndroidDependencies(module, true)) {
            String packageName;
            File depManifestFile = AndroidJpsUtil.getManifestFileForCompilationPath(depExtension);
            if (depManifestFile == null || !depManifestFile.exists() || (packageName = AndroidJpsUtil.parsePackageNameFromManifestFile(depManifestFile)) == null) continue;
            result.put(depExtension.getModule(), packageName);
        }
        HashMap hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "getDepLibPackages"));
        }
        return hashMap;
    }

    @NotNull
    private static Map<String, ResourceFileData> collectResources(@NotNull String[] resPaths, @NotNull Map<String, ResourceFileData> resDataMap, @NotNull TObjectLongHashMap<String> valueResFilesTimestamps, @Nullable AndroidAptValidityState oldState) throws IOException {
        if (resPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resPaths", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "collectResources"));
        }
        if (resDataMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resDataMap", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "collectResources"));
        }
        if (valueResFilesTimestamps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueResFilesTimestamps", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "collectResources"));
        }
        for (String resDirPath : resPaths) {
            File[] resSubdirs = new File(resDirPath).listFiles();
            if (resSubdirs == null) continue;
            for (File resSubdir : resSubdirs) {
                File[] resFiles;
                String resType = AndroidCommonUtils.getResourceTypeByDirName((String)resSubdir.getName());
                if (resType == null || (resFiles = resSubdir.listFiles()) == null) continue;
                for (File resFile : resFiles) {
                    AndroidSourceGeneratingBuilder.collectResources(resFile, resType, resDataMap, valueResFilesTimestamps, oldState);
                }
            }
        }
        Map<String, ResourceFileData> map = resDataMap;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "collectResources"));
        }
        return map;
    }

    private static void collectResources(@NotNull File resFile, @NotNull String resType, @NotNull Map<String, ResourceFileData> resDataMap, @NotNull TObjectLongHashMap<String> valueResFilesTimestamps, @Nullable AndroidAptValidityState oldState) throws IOException {
        if (resFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resFile", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "collectResources"));
        }
        if (resType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resType", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "collectResources"));
        }
        if (resDataMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resDataMap", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "collectResources"));
        }
        if (valueResFilesTimestamps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueResFilesTimestamps", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "collectResources"));
        }
        String resFilePath = FileUtil.toSystemIndependentName((String)resFile.getPath());
        long resFileTimestamp = resFile.lastModified();
        if (ResourceFolderType.VALUES.getName().equals(resType) && FileUtilRt.extensionEquals((String)resFile.getName(), (String)"xml")) {
            long oldTimestamp;
            ResourceFileData dataToReuse = null;
            if (oldState != null && resFileTimestamp == (oldTimestamp = oldState.getValueResourceFilesTimestamps().get((Object)resFilePath))) {
                dataToReuse = oldState.getResources().get(resFilePath);
            }
            if (dataToReuse != null) {
                resDataMap.put(resFilePath, dataToReuse);
            } else {
                List<ResourceEntry> entries = AndroidBuildDataCache.getInstance().getParsedValueResourceFile(resFile);
                resDataMap.put(resFilePath, new ResourceFileData(entries, 0L));
            }
            valueResFilesTimestamps.put((Object)resFilePath, resFileTimestamp);
        } else {
            ResourceType resTypeObj = ResourceType.getEnum((String)resType);
            boolean idProvidingType = resTypeObj != null && ArrayUtil.find((Object[])AndroidCommonUtils.ID_PROVIDING_RESOURCE_TYPES, (Object)resTypeObj) >= 0;
            ResourceFileData data = new ResourceFileData(Collections.emptyList(), idProvidingType ? resFileTimestamp : 0L);
            resDataMap.put(resFilePath, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static List<ResourceEntry> collectManifestElements(@NotNull File manifestFile) throws IOException {
        if (manifestFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manifestFile", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "collectManifestElements"));
        }
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(manifestFile));
        final ArrayList<ResourceEntry> result = new ArrayList<ResourceEntry>();
        FormsParsing.parse((InputStream)inputStream, (IXMLBuilder)new FormsParsing.IXMLBuilderAdapter(){
            String myLastName;

            public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
                this.myLastName = null;
            }

            public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) throws Exception {
                if (value != null && AndroidSourceGeneratingBuilder.NAME_ATTRIBUTE.equals(key)) {
                    this.myLastName = value;
                }
            }

            public void elementAttributesProcessed(String name, String nsPrefix, String nsURI) throws Exception {
                if (this.myLastName != null && AndroidSourceGeneratingBuilder.PERMISSION_TAG.equals(name) || AndroidSourceGeneratingBuilder.PERMISSION_GROUP_TAG.equals(name)) {
                    assert (this.myLastName != null);
                    result.add(new ResourceEntry(name, this.myLastName, ""));
                }
            }
        });
        ArrayList<ResourceEntry> arrayList = result;
        ArrayList<ResourceEntry> arrayList2 = arrayList;
        if (arrayList2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "collectManifestElements"));
        }
        return arrayList2;
        finally {
            ((InputStream)inputStream).close();
        }
    }

    @Nullable
    private static String getDependencyFolder(@NotNull CompileContext context, @NotNull File sourceFile, @NotNull File genFolder) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "getDependencyFolder"));
        }
        if (sourceFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFile", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "getDependencyFolder"));
        }
        if (genFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "genFolder", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "getDependencyFolder"));
        }
        JavaSourceRootDescriptor descriptor = context.getProjectDescriptor().getBuildRootIndex().findJavaRootDescriptor(context, sourceFile);
        if (descriptor == null) {
            return null;
        }
        File sourceRoot = descriptor.root;
        File parent = FileUtilRt.getParentFile((File)sourceFile);
        if (parent == null) {
            return null;
        }
        if (FileUtil.filesEqual((File)parent, (File)sourceRoot)) {
            return genFolder.getPath();
        }
        String relativePath = FileUtil.getRelativePath((File)sourceRoot, (File)parent);
        assert (relativePath != null);
        return genFolder.getPath() + '/' + relativePath;
    }

    @Nullable
    private static Map<JpsModule, MyModuleData> computeModuleDatas(@NotNull Collection<JpsModule> modules, @NotNull CompileContext context) throws IOException {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "computeModuleDatas"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "computeModuleDatas"));
        }
        HashMap moduleDataMap = new HashMap();
        boolean success = true;
        for (JpsModule module : modules) {
            JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(module);
            if (extension == null) continue;
            AndroidPlatform platform = AndroidJpsUtil.getAndroidPlatform(module, context, BUILDER_NAME);
            if (platform == null) {
                success = false;
                continue;
            }
            File manifestFile = AndroidJpsUtil.getManifestFileForCompilationPath(extension);
            if (manifestFile == null || !manifestFile.exists()) {
                context.processMessage((BuildMessage)new CompilerMessage(BUILDER_NAME, BuildMessage.Kind.ERROR, AndroidJpsBundle.message("android.jps.errors.manifest.not.found", module.getName())));
                success = false;
                continue;
            }
            String packageName = AndroidJpsUtil.parsePackageNameFromManifestFile(manifestFile);
            if (packageName == null || packageName.length() == 0) {
                context.processMessage((BuildMessage)new CompilerMessage(BUILDER_NAME, BuildMessage.Kind.ERROR, AndroidJpsBundle.message("android.jps.errors.package.not.specified", module.getName())));
                success = false;
                continue;
            }
            if (!AndroidCommonUtils.contains2Identifiers((String)packageName)) {
                context.processMessage((BuildMessage)new CompilerMessage(BUILDER_NAME, extension.isLibrary() ? BuildMessage.Kind.WARNING : BuildMessage.Kind.ERROR, AndroidJpsBundle.message("android.jps.errors.incorrect.package.name", module.getName())));
                success = false;
                continue;
            }
            moduleDataMap.put(module, new MyModuleData(platform, extension, manifestFile, packageName));
        }
        return success ? moduleDataMap : null;
    }

    @Nullable
    private static String computePackageForFile(@NotNull CompileContext context, @NotNull File file) throws IOException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "computePackageForFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "computePackageForFile"));
        }
        JavaSourceRootDescriptor descriptor = context.getProjectDescriptor().getBuildRootIndex().findJavaRootDescriptor(context, file);
        if (descriptor == null) {
            return null;
        }
        String relPath = FileUtil.getRelativePath((File)descriptor.root, (File)FileUtilRt.getParentFile((File)file));
        if (relPath == null) {
            return null;
        }
        return FileUtil.toSystemIndependentName((String)relPath).replace('/', '.');
    }

    @NotNull
    public String getPresentableName() {
        if (BUILDER_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "getPresentableName"));
        }
        return BUILDER_NAME;
    }

    private static boolean isLibraryWithBadCircularDependency(@NotNull JpsAndroidModuleExtension extension) throws IOException {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "isLibraryWithBadCircularDependency"));
        }
        if (!extension.isLibrary()) {
            return false;
        }
        List<JpsAndroidModuleExtension> dependencies = AndroidJpsUtil.getAllAndroidDependencies(extension.getModule(), false);
        for (JpsAndroidModuleExtension depExtension : dependencies) {
            List<JpsAndroidModuleExtension> depDependencies = AndroidJpsUtil.getAllAndroidDependencies(depExtension.getModule(), true);
            if (!depDependencies.contains(extension) || !dependencies.contains(depExtension) || depExtension.getModule().getName().compareTo(extension.getModule().getName()) >= 0 && depExtension.isLibrary()) continue;
            return true;
        }
        return false;
    }

    private static void addMessages(@NotNull CompileContext context, @NotNull Map<AndroidCompilerMessageKind, List<String>> messages, @NotNull String sourcePath, @NotNull String builderName) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "addMessages"));
        }
        if (messages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messages", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "addMessages"));
        }
        if (sourcePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourcePath", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "addMessages"));
        }
        if (builderName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builderName", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "addMessages"));
        }
        for (Map.Entry<AndroidCompilerMessageKind, List<String>> entry : messages.entrySet()) {
            AndroidCompilerMessageKind kind = entry.getKey();
            BuildMessage.Kind buildMessageKind = AndroidJpsUtil.toBuildMessageKind(kind);
            if (buildMessageKind == null) continue;
            for (String message : entry.getValue()) {
                context.processMessage((BuildMessage)new CompilerMessage(builderName, buildMessageKind, message, sourcePath));
            }
        }
    }

    @Nullable
    public static JpsModule findCircularDependencyOnLibraryWithSamePackage(@NotNull JpsAndroidModuleExtension extension, @NotNull Map<JpsModule, String> packageMap) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "findCircularDependencyOnLibraryWithSamePackage"));
        }
        if (packageMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageMap", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "findCircularDependencyOnLibraryWithSamePackage"));
        }
        String aPackage = packageMap.get(extension.getModule());
        if (aPackage == null || aPackage.length() == 0) {
            return null;
        }
        for (JpsAndroidModuleExtension depExtension : AndroidJpsUtil.getAllAndroidDependencies(extension.getModule(), true)) {
            List<JpsAndroidModuleExtension> depDependencies;
            if (!aPackage.equals(packageMap.get(depExtension.getModule())) || !(depDependencies = AndroidJpsUtil.getAllAndroidDependencies(depExtension.getModule(), false)).contains(extension)) continue;
            return depExtension.getModule();
        }
        return null;
    }

    private static boolean checkUnambiguousAndRecursiveArtifacts(CompileContext context, List<JpsArtifact> artifacts) {
        boolean success = true;
        for (JpsArtifact artifact : artifacts) {
            JpsAndroidModuleExtension facet;
            String apkPath;
            if (!(artifact.getArtifactType() instanceof AndroidApplicationArtifactType)) continue;
            List<JpsAndroidModuleExtension> facets = AndroidJpsUtil.getAllPackagedFacets(artifact);
            if (facets.size() > 1) {
                context.processMessage((BuildMessage)new CompilerMessage(ANDROID_VALIDATOR, BuildMessage.Kind.ERROR, "Cannot build artifact '" + artifact.getName() + "' because it contains more than one Android package"));
                success = false;
                continue;
            }
            String artifactOutputPath = artifact.getOutputFilePath();
            if (artifactOutputPath == null || facets.size() <= 0 || !FileUtil.pathsEqual((String)(apkPath = AndroidFinalPackageElementBuilder.getApkPath(facet = facets.get(0))), (String)artifactOutputPath)) continue;
            context.processMessage((BuildMessage)new CompilerMessage(ANDROID_VALIDATOR, BuildMessage.Kind.ERROR, "Incorrect output path for artifact '" + artifact.getName() + "': " + FileUtil.toSystemDependentName((String)apkPath)));
            success = false;
        }
        return success;
    }

    private static boolean checkArtifacts(@NotNull CompileContext context) {
        String message;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "checkArtifacts"));
        }
        List<JpsArtifact> artifacts = AndroidJpsUtil.getAndroidArtifactsToBuild(context);
        if (!AndroidSourceGeneratingBuilder.checkUnambiguousAndRecursiveArtifacts(context, artifacts)) {
            return false;
        }
        HashSet debugArtifacts = new HashSet();
        HashSet releaseArtifacts = new HashSet();
        HashMap moduleName2Artifact = new HashMap();
        for (JpsArtifact artifact : artifacts) {
            JpsAndroidModuleExtension facet;
            JpsElement properties = artifact.getProperties();
            if (!(properties instanceof JpsAndroidApplicationArtifactProperties)) continue;
            AndroidArtifactSigningMode mode = ((JpsAndroidApplicationArtifactProperties)properties).getSigningMode();
            if (mode == AndroidArtifactSigningMode.DEBUG || mode == AndroidArtifactSigningMode.DEBUG_WITH_CUSTOM_CERTIFICATE) {
                debugArtifacts.add(artifact);
            } else {
                releaseArtifacts.add(artifact);
            }
            if ((facet = AndroidJpsUtil.getPackagedFacet(artifact)) == null) continue;
            String moduleName = facet.getModule().getName();
            ArrayList<JpsArtifact> list = (ArrayList<JpsArtifact>)moduleName2Artifact.get(moduleName);
            if (list == null) {
                list = new ArrayList<JpsArtifact>();
                moduleName2Artifact.put(moduleName, list);
            }
            list.add(artifact);
        }
        boolean success = true;
        if (debugArtifacts.size() > 0 && releaseArtifacts.size() > 0) {
            message = "Cannot build debug and release Android artifacts in the same session\nDebug artifacts: " + AndroidSourceGeneratingBuilder.artifactsToString((Collection<JpsArtifact>)debugArtifacts) + "\n" + "Release artifacts: " + AndroidSourceGeneratingBuilder.artifactsToString((Collection<JpsArtifact>)releaseArtifacts);
            context.processMessage((BuildMessage)new CompilerMessage(ANDROID_VALIDATOR, BuildMessage.Kind.ERROR, message));
            success = false;
        }
        if (releaseArtifacts.size() > 0 && AndroidJpsUtil.getRunConfigurationTypeId(context) != null) {
            message = "Cannot build release Android artifacts in the 'make before run' session\nRelease artifacts: " + AndroidSourceGeneratingBuilder.artifactsToString((Collection<JpsArtifact>)releaseArtifacts);
            context.processMessage((BuildMessage)new CompilerMessage(ANDROID_VALIDATOR, BuildMessage.Kind.ERROR, message));
            success = false;
        }
        block1: for (Map.Entry entry : moduleName2Artifact.entrySet()) {
            List list = (List)entry.getValue();
            String moduleName = (String)entry.getKey();
            if (list.size() <= 1) continue;
            JpsArtifact firstArtifact = (JpsArtifact)list.get(0);
            Object[] firstArtifactProGuardOptions = AndroidSourceGeneratingBuilder.getProGuardOptions(firstArtifact);
            for (int i = 1; i < list.size(); ++i) {
                JpsArtifact artifact = (JpsArtifact)list.get(i);
                if (Arrays.equals(AndroidSourceGeneratingBuilder.getProGuardOptions(artifact), firstArtifactProGuardOptions)) continue;
                context.processMessage((BuildMessage)new CompilerMessage(ANDROID_VALIDATOR, BuildMessage.Kind.ERROR, "Artifacts related to the same module '" + moduleName + "' have different ProGuard options: " + firstArtifact.getName() + ", " + artifact.getName()));
                success = false;
                continue block1;
            }
        }
        return success;
    }

    @NotNull
    private static Object[] getProGuardOptions(@NotNull JpsArtifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "getProGuardOptions"));
        }
        JpsElement properties = artifact.getProperties();
        if (properties instanceof JpsAndroidApplicationArtifactProperties) {
            Object[] objectArray;
            JpsAndroidApplicationArtifactProperties p = (JpsAndroidApplicationArtifactProperties)properties;
            boolean runProGuard = p.isRunProGuard();
            if (runProGuard) {
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = runProGuard;
                objectArray = objectArray2;
                objectArray2[1] = p.getProGuardCfgFiles();
            } else {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = runProGuard;
            }
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "getProGuardOptions"));
            }
            return objectArray;
        }
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "getProGuardOptions"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @NotNull
    private static String artifactsToString(Collection<JpsArtifact> artifacts) {
        StringBuilder result = new StringBuilder();
        for (JpsArtifact artifact : artifacts) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(artifact.getName());
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder", "artifactsToString"));
        }
        return string;
    }

    private static enum MyExitStatus {
        OK,
        FAIL,
        NOTHING_CHANGED;

    }

    private static class MyModuleData {
        private final AndroidPlatform myPlatform;
        private final JpsAndroidModuleExtension myAndroidExtension;
        private final File myManifestFileForCompiler;
        private final String myPackage;

        private MyModuleData(@NotNull AndroidPlatform platform, @NotNull JpsAndroidModuleExtension extension, @NotNull File manifestFileForCompiler, @NotNull String aPackage) {
            if (platform == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platform", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder$MyModuleData", "<init>"));
            }
            if (extension == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder$MyModuleData", "<init>"));
            }
            if (manifestFileForCompiler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manifestFileForCompiler", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder$MyModuleData", "<init>"));
            }
            if (aPackage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aPackage", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder$MyModuleData", "<init>"));
            }
            this.myPlatform = platform;
            this.myAndroidExtension = extension;
            this.myManifestFileForCompiler = manifestFileForCompiler;
            this.myPackage = aPackage;
        }

        @NotNull
        public AndroidPlatform getPlatform() {
            AndroidPlatform androidPlatform = this.myPlatform;
            if (androidPlatform == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder$MyModuleData", "getPlatform"));
            }
            return androidPlatform;
        }

        @NotNull
        public JpsAndroidModuleExtension getAndroidExtension() {
            JpsAndroidModuleExtension jpsAndroidModuleExtension = this.myAndroidExtension;
            if (jpsAndroidModuleExtension == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder$MyModuleData", "getAndroidExtension"));
            }
            return jpsAndroidModuleExtension;
        }

        @NotNull
        public File getManifestFileForCompiler() {
            File file = this.myManifestFileForCompiler;
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder$MyModuleData", "getManifestFileForCompiler"));
            }
            return file;
        }

        @NotNull
        public String getPackage() {
            String string = this.myPackage;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/AndroidSourceGeneratingBuilder$MyModuleData", "getPackage"));
            }
            return string;
        }
    }
}

