/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.config;

import com.intellij.compiler.server.BuildManager;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ExternalFilter;
import com.intellij.openapi.externalSystem.model.ExternalProject;
import com.intellij.openapi.externalSystem.model.ExternalSourceDirectorySet;
import com.intellij.openapi.externalSystem.model.ExternalSourceSet;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectType;
import com.intellij.openapi.project.ProjectTypeService;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.gradle.model.impl.GradleModuleResourceConfiguration;
import org.jetbrains.jps.gradle.model.impl.GradleProjectConfiguration;
import org.jetbrains.jps.gradle.model.impl.ModuleVersion;
import org.jetbrains.jps.gradle.model.impl.ResourceRootConfiguration;
import org.jetbrains.jps.gradle.model.impl.ResourceRootFilter;
import org.jetbrains.plugins.gradle.service.project.data.ExternalProjectDataService;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleResourceCompilerConfigurationGenerator {
    private static Logger LOG = Logger.getInstance(GradleResourceCompilerConfigurationGenerator.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final CompileContext myContext;
    @NotNull
    private final Map<String, ExternalProject> myExternalProjectMap;
    private final ExternalProjectDataService myExternalProjectDataService;

    public GradleResourceCompilerConfigurationGenerator(@NotNull Project project, @NotNull CompileContext context) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/config/GradleResourceCompilerConfigurationGenerator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/gradle/config/GradleResourceCompilerConfigurationGenerator", "<init>"));
        }
        this.myProject = project;
        this.myContext = context;
        this.myExternalProjectDataService = (ExternalProjectDataService)((ProjectDataManager)ServiceManager.getService(ProjectDataManager.class)).getDataService(ExternalProjectDataService.KEY);
        assert (this.myExternalProjectDataService != null);
        this.myExternalProjectMap = new FactoryMap<String, ExternalProject>(){

            @Nullable
            protected ExternalProject create(String gradleProjectPath) {
                return GradleResourceCompilerConfigurationGenerator.this.myExternalProjectDataService.getRootExternalProject(GradleConstants.SYSTEM_ID, new File(gradleProjectPath));
            }
        };
    }

    public void generateBuildConfiguration() {
        if (GradleResourceCompilerConfigurationGenerator.shouldBeBuiltByExternalSystem(this.myProject)) {
            return;
        }
        if (!this.hasGradleModules()) {
            return;
        }
        final BuildManager buildManager = BuildManager.getInstance();
        File projectSystemDir = buildManager.getProjectSystemDirectory(this.myProject);
        if (projectSystemDir == null) {
            return;
        }
        final File gradleConfigFile = new File(projectSystemDir, "gradle/configuration.xml");
        GradleProjectConfiguration projectConfig = new GradleProjectConfiguration();
        for (Module module : this.myContext.getCompileScope().getAffectedModules()) {
            if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module) || GradleResourceCompilerConfigurationGenerator.shouldBeBuiltByExternalSystem(module)) continue;
            String gradleProjectPath = module.getOptionValue("external.root.project.path");
            assert (gradleProjectPath != null);
            ExternalProject externalRootProject = this.myExternalProjectMap.get(gradleProjectPath);
            if (externalRootProject == null) {
                this.myContext.addMessage(CompilerMessageCategory.ERROR, String.format("Unable to make the module: %s, related gradle configuration was not found. Please, re-import the Gradle project and try again.", module.getName()), VfsUtilCore.pathToUrl((String)gradleProjectPath), -1, -1);
                continue;
            }
            ExternalProject externalProject = this.myExternalProjectDataService.findExternalProject(externalRootProject, module);
            if (externalProject == null) {
                LOG.warn("Unable to find config for module: " + module.getName());
                continue;
            }
            CompilerModuleExtension compilerModuleExtension = CompilerModuleExtension.getInstance((Module)module);
            assert (compilerModuleExtension != null);
            GradleModuleResourceConfiguration resourceConfig = new GradleModuleResourceConfiguration();
            resourceConfig.id = new ModuleVersion(externalProject.getGroup(), externalProject.getName(), externalProject.getVersion());
            resourceConfig.directory = FileUtil.toSystemIndependentName((String)externalProject.getProjectDir().getPath());
            ExternalSourceSet mainSourcesSet = (ExternalSourceSet)externalProject.getSourceSets().get("main");
            GradleResourceCompilerConfigurationGenerator.addResources(resourceConfig.resources, mainSourcesSet, ExternalSystemSourceType.RESOURCE);
            ExternalSourceSet testSourcesSet = (ExternalSourceSet)externalProject.getSourceSets().get("test");
            GradleResourceCompilerConfigurationGenerator.addResources(resourceConfig.testResources, testSourcesSet, ExternalSystemSourceType.TEST_RESOURCE);
            projectConfig.moduleConfigurations.put(module.getName(), resourceConfig);
        }
        final Document document = new Document(new Element("gradle-project-configuration"));
        XmlSerializer.serializeInto((Object)projectConfig, (Element)document.getRootElement());
        buildManager.runCommand(new Runnable(){

            @Override
            public void run() {
                buildManager.clearState(GradleResourceCompilerConfigurationGenerator.this.myProject);
                FileUtil.createIfDoesntExist((File)gradleConfigFile);
                try {
                    JDOMUtil.writeDocument((Document)document, (File)gradleConfigFile, (String)"\n");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private static boolean shouldBeBuiltByExternalSystem(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/config/GradleResourceCompilerConfigurationGenerator", "shouldBeBuiltByExternalSystem"));
        }
        ProjectType projectType = ProjectTypeService.getProjectType((Project)project);
        return projectType != null && "Android".equals(projectType.getId());
    }

    private static boolean shouldBeBuiltByExternalSystem(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/gradle/config/GradleResourceCompilerConfigurationGenerator", "shouldBeBuiltByExternalSystem"));
        }
        for (Facet facet : FacetManager.getInstance((Module)module).getAllFacets()) {
            if (!ArrayUtil.contains((String)facet.getName(), (String[])new String[]{"Android", "Android-Gradle", "Java-Gradle"})) continue;
            return true;
        }
        return false;
    }

    private boolean hasGradleModules() {
        for (Module module : this.myContext.getCompileScope().getAffectedModules()) {
            if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) continue;
            return true;
        }
        return false;
    }

    private static void addResources(@NotNull List<ResourceRootConfiguration> container, @Nullable ExternalSourceSet externalSourceSet, @NotNull ExternalSystemSourceType sourceType) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "org/jetbrains/plugins/gradle/config/GradleResourceCompilerConfigurationGenerator", "addResources"));
        }
        if (sourceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceType", "org/jetbrains/plugins/gradle/config/GradleResourceCompilerConfigurationGenerator", "addResources"));
        }
        if (externalSourceSet == null) {
            return;
        }
        ExternalSourceDirectorySet directorySet = (ExternalSourceDirectorySet)externalSourceSet.getSources().get(sourceType);
        if (directorySet == null) {
            return;
        }
        for (File file : directorySet.getSrcDirs()) {
            String dir = file.getPath();
            ResourceRootConfiguration rootConfiguration = new ResourceRootConfiguration();
            rootConfiguration.directory = FileUtil.toSystemIndependentName((String)dir);
            String target = directorySet.getOutputDir().getPath();
            rootConfiguration.targetPath = FileUtil.toSystemIndependentName((String)target);
            rootConfiguration.includes.clear();
            for (String include : directorySet.getIncludes()) {
                rootConfiguration.includes.add(include.trim());
            }
            rootConfiguration.excludes.clear();
            for (String exclude : directorySet.getExcludes()) {
                rootConfiguration.excludes.add(exclude.trim());
            }
            rootConfiguration.isFiltered = !directorySet.getFilters().isEmpty();
            rootConfiguration.filters.clear();
            for (ExternalFilter filter : directorySet.getFilters()) {
                ResourceRootFilter resourceRootFilter = new ResourceRootFilter();
                resourceRootFilter.filterType = filter.getFilterType();
                resourceRootFilter.properties = filter.getPropertiesAsJsonMap();
                rootConfiguration.filters.add(resourceRootFilter);
            }
            container.add(rootConfiguration);
        }
    }
}

