/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.internal.IResultListener;

public class IDEATestNGRemoteListener
implements ISuiteListener,
IResultListener {
    private String myCurrentClassName;

    public void onConfigurationSuccess(ITestResult itr) {
    }

    public void onConfigurationFailure(ITestResult itr) {
    }

    public void onConfigurationSkip(ITestResult itr) {
    }

    public void onStart(ISuite suite) {
        System.out.println("##teamcity[testSuiteStarted name ='" + suite.getName() + "']");
    }

    public void onFinish(ISuite suite) {
        System.out.println("##teamcity[testSuiteFinished name='" + suite.getName() + "']");
    }

    public void onTestStart(ITestResult result) {
        String className = result.getTestClass().getName();
        if (this.myCurrentClassName == null || !this.myCurrentClassName.equals(className)) {
            if (this.myCurrentClassName != null) {
                System.out.println("##teamcity[testSuiteFinished name='" + this.myCurrentClassName + "']");
            }
            System.out.println("##teamcity[testSuiteStarted name ='" + className + "']");
            this.myCurrentClassName = className;
        }
        System.out.println("##teamcity[testStarted name='" + result.getMethod().getMethodName() + "']");
    }

    public void onTestSuccess(ITestResult result) {
        System.out.println("##teamcity[testFinished name='" + result.getMethod().getMethodName() + "']");
    }

    public String getTrace(Throwable tr) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        tr.printStackTrace(writer);
        StringBuffer buffer = stringWriter.getBuffer();
        return buffer.toString();
    }

    public void onTestFailure(ITestResult result) {
        Throwable ex = result.getThrowable();
        String trace = this.getTrace(ex);
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("name", result.getMethod().getMethodName());
        String failureMessage = ex.getMessage();
        attrs.put("message", failureMessage != null ? failureMessage : "");
        attrs.put("details", trace);
        attrs.put("error", "true");
        System.out.println(ServiceMessage.asString((String)"testFailed", attrs));
        System.out.println("##teamcity[testFinished name='" + result.getMethod().getMethodName() + "']");
    }

    public void onTestSkipped(ITestResult result) {
        System.out.println("##teamcity[testFinished name='" + result.getMethod().getMethodName() + "']");
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
    }

    public void onStart(ITestContext context) {
    }

    public void onFinish(ITestContext context) {
        if (this.myCurrentClassName != null) {
            System.out.println("##teamcity[testSuiteFinished name='" + this.myCurrentClassName + "']");
        }
    }
}

