/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.importer;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.options.SchemeImportException;
import com.intellij.openapi.options.SchemeImporter;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.util.ArrayUtil;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.importer.EclipseImportMap;
import org.jetbrains.idea.eclipse.importer.EclipseXmlProfileElements;
import org.jetbrains.idea.eclipse.importer.EclipseXmlProfileReader;

public class EclipseCodeStyleSchemeImporter
implements SchemeImporter<CodeStyleScheme>,
EclipseXmlProfileElements {
    private static final Logger LOG = Logger.getInstance((String)("#" + EclipseCodeStyleSchemeImporter.class.getName()));
    private static final String PROGRAMMATIC_IMPORT_KEY = "<Programmatic>";
    private final EclipseImportMap myImportMap = new EclipseImportMap();

    public EclipseCodeStyleSchemeImporter() {
        this.myImportMap.load();
    }

    public String getSourceExtension() {
        return "xml";
    }

    @NotNull
    public String[] readSchemeNames(@NotNull InputStream inputStream) throws SchemeImportException {
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "org/jetbrains/idea/eclipse/importer/EclipseCodeStyleSchemeImporter", "readSchemeNames"));
        }
        final HashSet names = new HashSet();
        EclipseXmlProfileReader reader = new EclipseXmlProfileReader(new EclipseXmlProfileReader.OptionHandler(){

            @Override
            public void handleOption(@NotNull String eclipseKey, @NotNull String value) throws SchemeImportException {
                if (eclipseKey == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eclipseKey", "org/jetbrains/idea/eclipse/importer/EclipseCodeStyleSchemeImporter$1", "handleOption"));
                }
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/idea/eclipse/importer/EclipseCodeStyleSchemeImporter$1", "handleOption"));
                }
            }

            @Override
            public void handleName(String name) {
                names.add(name);
            }
        });
        reader.readSettings(inputStream);
        String[] stringArray = ArrayUtil.toStringArray(names);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/eclipse/importer/EclipseCodeStyleSchemeImporter", "readSchemeNames"));
        }
        return stringArray;
    }

    public void importScheme(@NotNull InputStream inputStream, final @Nullable String sourceScheme, CodeStyleScheme scheme) throws SchemeImportException {
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "org/jetbrains/idea/eclipse/importer/EclipseCodeStyleSchemeImporter", "importScheme"));
        }
        final CodeStyleSettings settings = scheme.getCodeStyleSettings();
        EclipseXmlProfileReader reader = new EclipseXmlProfileReader(new EclipseXmlProfileReader.OptionHandler(){
            private String myCurrScheme;

            @Override
            public void handleOption(@NotNull String eclipseKey, @NotNull String value) throws SchemeImportException {
                if (eclipseKey == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eclipseKey", "org/jetbrains/idea/eclipse/importer/EclipseCodeStyleSchemeImporter$2", "handleOption"));
                }
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/idea/eclipse/importer/EclipseCodeStyleSchemeImporter$2", "handleOption"));
                }
                if (sourceScheme == null || this.myCurrScheme != null && this.myCurrScheme.equals(sourceScheme)) {
                    EclipseCodeStyleSchemeImporter.this.setCodeStyleOption(settings, eclipseKey, value);
                }
            }

            @Override
            public void handleName(String name) {
                this.myCurrScheme = name;
            }
        });
        reader.readSettings(inputStream);
    }

    private void setCodeStyleOption(@NotNull CodeStyleSettings settings, @NotNull String key, @NotNull String value) throws SchemeImportException {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/jetbrains/idea/eclipse/importer/EclipseCodeStyleSchemeImporter", "setCodeStyleOption"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/idea/eclipse/importer/EclipseCodeStyleSchemeImporter", "setCodeStyleOption"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/idea/eclipse/importer/EclipseCodeStyleSchemeImporter", "setCodeStyleOption"));
        }
        EclipseImportMap.ImportDescriptor importDescriptor = this.myImportMap.getImportDescriptor(key);
        if (importDescriptor != null) {
            try {
                if (importDescriptor.isLanguageSpecific()) {
                    CommonCodeStyleSettings languageSettings = settings.getCommonSettings(importDescriptor.getLanguage());
                    if (languageSettings != null) {
                        if (importDescriptor.isIndentOptions()) {
                            CommonCodeStyleSettings.IndentOptions indentOptions = languageSettings.getIndentOptions();
                            if (indentOptions != null) {
                                EclipseCodeStyleSchemeImporter.setValue(indentOptions, key, importDescriptor.getFieldName(), value);
                            }
                        } else {
                            EclipseCodeStyleSchemeImporter.setValue(languageSettings, key, importDescriptor.getFieldName(), value);
                        }
                    }
                } else {
                    EclipseCodeStyleSchemeImporter.setValue(settings, key, importDescriptor.getFieldName(), value);
                }
            }
            catch (Exception e) {
                throw new SchemeImportException((Throwable)e);
            }
        }
    }

    private static void setValue(Object object, String key, String fieldName, String value) throws SchemeImportException {
        if (PROGRAMMATIC_IMPORT_KEY.equalsIgnoreCase(fieldName)) {
            EclipseCodeStyleSchemeImporter.setProgrammatically(object, key, value);
            return;
        }
        try {
            Field targetField = object.getClass().getField(fieldName);
            Class<?> fieldType = targetField.getType();
            if (fieldType.isPrimitive()) {
                if (Boolean.TYPE.equals(fieldType)) {
                    targetField.setBoolean(object, EclipseCodeStyleSchemeImporter.valueToBoolean(key, value));
                } else if (Integer.TYPE.equals(fieldType)) {
                    targetField.setInt(object, EclipseCodeStyleSchemeImporter.valueToInt(value));
                }
            } else if (fieldType.equals(String.class)) {
                targetField.set(object, value);
            }
        }
        catch (IllegalAccessException e) {
            LOG.error((Throwable)e);
        }
        catch (NoSuchFieldException e) {
            LOG.error("Field '" + fieldName + "' does not exist in " + object.getClass().getName(), (Throwable)e);
        }
    }

    private static boolean valueToBoolean(@NotNull String key, @NotNull String value) throws SchemeImportException {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/idea/eclipse/importer/EclipseCodeStyleSchemeImporter", "valueToBoolean"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/idea/eclipse/importer/EclipseCodeStyleSchemeImporter", "valueToBoolean"));
        }
        if ("insert".equals(value) || "true".equals(value)) {
            return true;
        }
        if (!"do not insert".equals(value) && !"false".equals(value)) {
            throw new SchemeImportException("Unrecognized boolean value: " + value + ", key: " + key);
        }
        return false;
    }

    private static int valueToInt(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/idea/eclipse/importer/EclipseCodeStyleSchemeImporter", "valueToInt"));
        }
        if ("end_of_line".equals(value)) {
            return 1;
        }
        if ("next_line".equals(value)) {
            return 2;
        }
        if ("next_line_shifted".equals(value)) {
            return 3;
        }
        if ("next_line_on_wrap".equals(value)) {
            return 5;
        }
        return Integer.parseInt(value);
    }

    private static void setProgrammatically(@NotNull Object object, @NotNull String key, @NotNull String value) throws SchemeImportException {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "org/jetbrains/idea/eclipse/importer/EclipseCodeStyleSchemeImporter", "setProgrammatically"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/idea/eclipse/importer/EclipseCodeStyleSchemeImporter", "setProgrammatically"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/idea/eclipse/importer/EclipseCodeStyleSchemeImporter", "setProgrammatically"));
        }
        if (key.contains("alignment") && value.matches("\\d*") && object instanceof CommonCodeStyleSettings && EclipseCodeStyleSchemeImporter.setAlignmentAndWrappingOptions((CommonCodeStyleSettings)object, key, value)) {
            return;
        }
        if (object instanceof CodeStyleSettings) {
            CodeStyleSettings settings = (CodeStyleSettings)object;
            if ("org.eclipse.jdt.core.formatter.comment.clear_blank_lines_in_javadoc_comment".equals(key)) {
                settings.JD_KEEP_EMPTY_LINES = !EclipseCodeStyleSchemeImporter.valueToBoolean(key, value);
            } else if ("org.eclipse.jdt.core.formatter.insert_new_line_at_end_of_file_if_missing".equals(key)) {
                EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
                editorSettings.setEnsureNewLineAtEOF(EclipseCodeStyleSchemeImporter.valueToBoolean(key, value));
            }
        } else if (object instanceof CommonCodeStyleSettings) {
            CommonCodeStyleSettings commonSettings = (CommonCodeStyleSettings)object;
            if ("org.eclipse.jdt.core.formatter.insert_space_after_binary_operator".equals(key)) {
                boolean addSpace;
                commonSettings.SPACE_AROUND_SHIFT_OPERATORS = commonSettings.SPACE_AROUND_EQUALITY_OPERATORS = (addSpace = EclipseCodeStyleSchemeImporter.valueToBoolean(key, value));
                commonSettings.SPACE_AROUND_RELATIONAL_OPERATORS = commonSettings.SPACE_AROUND_EQUALITY_OPERATORS;
                commonSettings.SPACE_AROUND_MULTIPLICATIVE_OPERATORS = commonSettings.SPACE_AROUND_EQUALITY_OPERATORS;
                commonSettings.SPACE_AROUND_LOGICAL_OPERATORS = commonSettings.SPACE_AROUND_EQUALITY_OPERATORS;
                commonSettings.SPACE_AROUND_BITWISE_OPERATORS = commonSettings.SPACE_AROUND_EQUALITY_OPERATORS;
                commonSettings.SPACE_AROUND_ADDITIVE_OPERATORS = commonSettings.SPACE_AROUND_EQUALITY_OPERATORS;
            } else if ("org.eclipse.jdt.core.formatter.indent_body_declarations_compare_to_type_header".equals(key)) {
                commonSettings.DO_NOT_INDENT_TOP_LEVEL_CLASS_MEMBERS = !EclipseCodeStyleSchemeImporter.valueToBoolean(key, value);
            } else if ("org.eclipse.jdt.core.formatter.blank_lines_before_first_class_body_declaration".equals(key)) {
                int intValue;
                commonSettings.BLANK_LINES_AFTER_CLASS_HEADER = intValue = EclipseCodeStyleSchemeImporter.valueToInt(value);
                commonSettings.BLANK_LINES_AFTER_ANONYMOUS_CLASS_HEADER = intValue;
            } else if ("org.eclipse.jdt.core.formatter.number_of_empty_lines_to_preserve".equals(key)) {
                int intValue;
                commonSettings.KEEP_BLANK_LINES_IN_CODE = intValue = EclipseCodeStyleSchemeImporter.valueToInt(value);
                commonSettings.KEEP_BLANK_LINES_IN_DECLARATIONS = intValue;
                commonSettings.KEEP_BLANK_LINES_BEFORE_RBRACE = intValue;
            } else if ("org.eclipse.jdt.core.formatter.insert_space_after_closing_brace_in_block".equals(key)) {
                boolean insertSpace;
                commonSettings.SPACE_BEFORE_ELSE_KEYWORD = insertSpace = EclipseCodeStyleSchemeImporter.valueToBoolean(key, value);
                commonSettings.SPACE_BEFORE_CATCH_KEYWORD = insertSpace;
                commonSettings.SPACE_BEFORE_FINALLY_KEYWORD = insertSpace;
            } else if ("org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_block".equals(key)) {
                boolean insertSpace;
                commonSettings.SPACE_BEFORE_IF_LBRACE = insertSpace = EclipseCodeStyleSchemeImporter.valueToBoolean(key, value);
                commonSettings.SPACE_BEFORE_FOR_LBRACE = insertSpace;
                commonSettings.SPACE_BEFORE_WHILE_LBRACE = insertSpace;
                commonSettings.SPACE_BEFORE_DO_LBRACE = insertSpace;
                commonSettings.SPACE_BEFORE_TRY_LBRACE = insertSpace;
                commonSettings.SPACE_BEFORE_CATCH_LBRACE = insertSpace;
                commonSettings.SPACE_BEFORE_FINALLY_LBRACE = insertSpace;
                commonSettings.SPACE_BEFORE_SYNCHRONIZED_LBRACE = insertSpace;
            }
        } else if (object instanceof CommonCodeStyleSettings.IndentOptions) {
            CommonCodeStyleSettings.IndentOptions indentOptions = (CommonCodeStyleSettings.IndentOptions)object;
            if ("org.eclipse.jdt.core.formatter.tabulation.char".equals(key)) {
                if ("tab".equals(value) || "mixed".equals(value)) {
                    indentOptions.USE_TAB_CHARACTER = true;
                } else if ("space".equals(value)) {
                    indentOptions.USE_TAB_CHARACTER = false;
                }
            } else if ("org.eclipse.jdt.core.formatter.continuation_indentation".equals(key)) {
                indentOptions.CONTINUATION_INDENT_SIZE = indentOptions.TAB_SIZE * EclipseCodeStyleSchemeImporter.valueToInt(value);
            } else if ("org.eclipse.jdt.core.formatter.tabulation.size".equals(key)) {
                int newTabSize = EclipseCodeStyleSchemeImporter.valueToInt(value);
                int continuationTabs = indentOptions.TAB_SIZE > 0 ? indentOptions.CONTINUATION_INDENT_SIZE / indentOptions.TAB_SIZE : -1;
                indentOptions.TAB_SIZE = newTabSize;
                if (continuationTabs >= 0) {
                    indentOptions.CONTINUATION_INDENT_SIZE = continuationTabs * newTabSize;
                }
            }
        }
    }

    private static boolean setAlignmentAndWrappingOptions(@NotNull CommonCodeStyleSettings settings, @NotNull String key, @NotNull String value) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/jetbrains/idea/eclipse/importer/EclipseCodeStyleSchemeImporter", "setAlignmentAndWrappingOptions"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/idea/eclipse/importer/EclipseCodeStyleSchemeImporter", "setAlignmentAndWrappingOptions"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/idea/eclipse/importer/EclipseCodeStyleSchemeImporter", "setAlignmentAndWrappingOptions"));
        }
        int encodedValue = Integer.parseInt(value);
        AlignmentAndWrapValueDecoder decoder = new AlignmentAndWrapValueDecoder(encodedValue);
        if ("org.eclipse.jdt.core.formatter.alignment_for_arguments_in_annotation".equals(key)) {
            settings.VARIABLE_ANNOTATION_WRAP = settings.CLASS_ANNOTATION_WRAP = decoder.getWrapType();
            settings.PARAMETER_ANNOTATION_WRAP = settings.CLASS_ANNOTATION_WRAP;
            settings.METHOD_ANNOTATION_WRAP = settings.CLASS_ANNOTATION_WRAP;
            settings.FIELD_ANNOTATION_WRAP = settings.CLASS_ANNOTATION_WRAP;
            return true;
        }
        if ("org.eclipse.jdt.core.formatter.alignment_for_expressions_in_array_initializer".equals(key)) {
            settings.ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION = decoder.isAlignmentOn();
            settings.ARRAY_INITIALIZER_WRAP = decoder.getWrapType();
            settings.ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE = decoder.isFirstElementWrapped();
            return true;
        }
        if ("org.eclipse.jdt.core.formatter.alignment_for_arguments_in_method_invocation".equals(key)) {
            settings.ALIGN_MULTILINE_PARAMETERS_IN_CALLS = decoder.isAlignmentOn();
            settings.CALL_PARAMETERS_WRAP = decoder.getWrapType();
            settings.CALL_PARAMETERS_LPAREN_ON_NEXT_LINE = decoder.isFirstElementWrapped();
            return true;
        }
        if ("org.eclipse.jdt.core.formatter.alignment_for_superinterfaces_in_type_declaration".equals(key)) {
            settings.ALIGN_MULTILINE_EXTENDS_LIST = decoder.isAlignmentOn();
            settings.EXTENDS_KEYWORD_WRAP = decoder.getFirstElementWrapType();
            settings.EXTENDS_LIST_WRAP = decoder.getWrapType();
            return true;
        }
        if ("org.eclipse.jdt.core.formatter.alignment_for_assignment".equals(key)) {
            settings.ALIGN_MULTILINE_ASSIGNMENT = decoder.isAlignmentOn();
            settings.ASSIGNMENT_WRAP = decoder.getWrapType();
            return true;
        }
        if ("org.eclipse.jdt.core.formatter.alignment_for_parameters_in_method_declaration".equals(key)) {
            settings.ALIGN_MULTILINE_PARAMETERS = decoder.isAlignmentOn();
            settings.METHOD_PARAMETERS_WRAP = decoder.getWrapType();
            settings.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE = decoder.isFirstElementWrapped();
            return true;
        }
        if ("org.eclipse.jdt.core.formatter.alignment_for_binary_expression".equals(key)) {
            settings.ALIGN_MULTILINE_BINARY_OPERATION = decoder.isAlignmentOn();
            settings.BINARY_OPERATION_WRAP = decoder.getWrapType();
            return true;
        }
        if ("org.eclipse.jdt.core.formatter.alignment_for_throws_clause_in_method_declaration".equals(key)) {
            settings.ALIGN_MULTILINE_THROWS_LIST = decoder.isAlignmentOn();
            settings.THROWS_KEYWORD_WRAP = decoder.getFirstElementWrapType();
            settings.THROWS_LIST_WRAP = decoder.getWrapType();
            return true;
        }
        if ("org.eclipse.jdt.core.formatter.alignment_for_resources_in_try".equals(key)) {
            settings.ALIGN_MULTILINE_RESOURCES = decoder.isAlignmentOn();
            settings.RESOURCE_LIST_WRAP = decoder.getWrapType();
            settings.RESOURCE_LIST_LPAREN_ON_NEXT_LINE = decoder.isFirstElementWrapped();
            return true;
        }
        if ("org.eclipse.jdt.core.formatter.alignment_for_selector_in_method_invocation".equals(key)) {
            settings.METHOD_CALL_CHAIN_WRAP = decoder.getWrapType();
            settings.ALIGN_MULTILINE_CHAINED_METHODS = decoder.isAlignmentOn();
        } else if ("org.eclipse.jdt.core.formatter.alignment_for_conditional_expression".equals(key)) {
            settings.TERNARY_OPERATION_WRAP = decoder.getWrapType();
            settings.ALIGN_MULTILINE_TERNARY_OPERATION = decoder.isAlignmentOn();
        }
        return false;
    }

    private static class AlignmentAndWrapValueDecoder {
        int myEncodedValue;

        public AlignmentAndWrapValueDecoder(int encodedValue) {
            this.myEncodedValue = encodedValue;
        }

        public int getWrapType() {
            switch (this.getEclipseWrap()) {
                case 16: 
                case 32: {
                    return 1;
                }
                case 48: 
                case 64: 
                case 80: {
                    return 5;
                }
            }
            return 0;
        }

        public int getFirstElementWrapType() {
            return this.isNewLineBeforeFirst() ? 2 : (this.getEclipseWrap() == 80 ? 0 : 1);
        }

        public boolean isFirstElementWrapped() {
            int eclipseWrapValue = this.getEclipseWrap();
            return eclipseWrapValue == 32 || eclipseWrapValue == 64 || eclipseWrapValue == 48 || this.isNewLineBeforeFirst();
        }

        public boolean isNewLineBeforeFirst() {
            return (this.myEncodedValue & 1) != 0;
        }

        public boolean isAlignmentOn() {
            return (this.myEncodedValue & 2) != 0;
        }

        public int getEclipseWrap() {
            return this.myEncodedValue & 0x70;
        }
    }
}

