/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.local;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.daemon.impl.GlobalUsageHelper;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.PostHighlightingPass;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspection;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.codeInspection.GroovyQuickFixFactory;
import org.jetbrains.plugins.groovy.codeInspection.GroovySuppressableInspectionTool;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrNamedElement;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyImportUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyPostHighlightingPass
extends TextEditorHighlightingPass {
    private final GroovyFile myFile;
    private final Editor myEditor;
    private volatile Set<GrImportStatement> myUnusedImports;
    private volatile List<HighlightInfo> myUnusedDeclarations;

    public GroovyPostHighlightingPass(GroovyFile file, Editor editor) {
        super(file.getProject(), editor.getDocument(), true);
        this.myFile = file;
        this.myEditor = editor;
    }

    public void doCollectInformation(final @NotNull ProgressIndicator progress) {
        VirtualFile virtualFile;
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "org/jetbrains/plugins/groovy/codeInspection/local/GroovyPostHighlightingPass", "doCollectInformation"));
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        if (!fileIndex.isInContent(virtualFile = this.myFile.getViewProvider().getVirtualFile())) {
            return;
        }
        InspectionProfile profile = InspectionProjectProfileManager.getInstance((Project)this.myProject).getInspectionProfile();
        final HighlightDisplayKey unusedDefKey = HighlightDisplayKey.find((String)"GroovyUnusedDeclaration");
        final boolean deadCodeEnabled = profile.isToolEnabled(unusedDefKey, (PsiElement)this.myFile);
        final UnusedDeclarationInspection deadCodeInspection = (UnusedDeclarationInspection)profile.getUnwrappedTool("UnusedDeclaration", (PsiElement)this.myFile);
        final GlobalUsageHelper usageHelper = new GlobalUsageHelper(){

            public boolean isCurrentFileAlreadyChecked() {
                return false;
            }

            public boolean isLocallyUsed(@NotNull PsiNamedElement member) {
                if (member == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "org/jetbrains/plugins/groovy/codeInspection/local/GroovyPostHighlightingPass$1", "isLocallyUsed"));
                }
                return false;
            }

            public boolean shouldCheckUsages(@NotNull PsiMember member) {
                if (member == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "org/jetbrains/plugins/groovy/codeInspection/local/GroovyPostHighlightingPass$1", "shouldCheckUsages"));
                }
                return deadCodeInspection == null || !deadCodeInspection.isEntryPoint((PsiElement)member);
            }
        };
        final ArrayList<HighlightInfo> unusedDeclarations = new ArrayList<HighlightInfo>();
        final HashMap usedParams = new HashMap();
        this.myFile.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                PsiElement nameId;
                if (element instanceof GrReferenceElement) {
                    for (GroovyResolveResult result : ((GrReferenceElement)element).multiResolve(true)) {
                        PsiElement resolved = result.getElement();
                        if (!(resolved instanceof GrParameter) || resolved.getContainingFile() != GroovyPostHighlightingPass.this.myFile) continue;
                        usedParams.put((GrParameter)resolved, Boolean.TRUE);
                    }
                }
                if (deadCodeEnabled && element instanceof GrNamedElement && element instanceof PsiModifierListOwner && !PostHighlightingPass.isImplicitUsage((Project)element.getProject(), (PsiModifierListOwner)((PsiModifierListOwner)element), (ProgressIndicator)progress) && !GroovySuppressableInspectionTool.isElementToolSuppressedIn(element, "GroovyUnusedDeclaration") && (nameId = ((GrNamedElement)element).getNameIdentifierGroovy()).getNode().getElementType() == GroovyTokenTypes.mIDENT) {
                    String name = ((GrNamedElement)element).getName();
                    if (element instanceof GrTypeDefinition && !PostHighlightingPass.isClassUsed((Project)GroovyPostHighlightingPass.this.myProject, (PsiFile)element.getContainingFile(), (PsiClass)((GrTypeDefinition)element), (ProgressIndicator)progress, (GlobalUsageHelper)usageHelper)) {
                        HighlightInfo highlightInfo = PostHighlightingPass.createUnusedSymbolInfo((PsiElement)nameId, (String)("Class " + name + " is unused"), (HighlightInfoType)HighlightInfoType.UNUSED_SYMBOL);
                        QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QuickFixFactory.getInstance().createSafeDeleteFix(element), (HighlightDisplayKey)unusedDefKey);
                        ContainerUtil.addIfNotNull((Collection)unusedDeclarations, (Object)highlightInfo);
                    } else if (element instanceof GrMethod) {
                        GrMethod method = (GrMethod)element;
                        if (!PostHighlightingPass.isMethodReferenced((Project)method.getProject(), (PsiFile)method.getContainingFile(), (PsiMethod)method, (ProgressIndicator)progress, (GlobalUsageHelper)usageHelper)) {
                            String message = (method.isConstructor() ? "Constructor" : "Method") + " " + name + " is unused";
                            HighlightInfo highlightInfo = PostHighlightingPass.createUnusedSymbolInfo((PsiElement)nameId, (String)message, (HighlightInfoType)HighlightInfoType.UNUSED_SYMBOL);
                            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QuickFixFactory.getInstance().createSafeDeleteFix((PsiElement)method), (HighlightDisplayKey)unusedDefKey);
                            ContainerUtil.addIfNotNull((Collection)unusedDeclarations, (Object)highlightInfo);
                        }
                    } else if (element instanceof GrField && GroovyPostHighlightingPass.isFieldUnused((GrField)element, progress, usageHelper)) {
                        HighlightInfo highlightInfo = PostHighlightingPass.createUnusedSymbolInfo((PsiElement)nameId, (String)("Property " + name + " is unused"), (HighlightInfoType)HighlightInfoType.UNUSED_SYMBOL);
                        QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QuickFixFactory.getInstance().createSafeDeleteFix(element), (HighlightDisplayKey)unusedDefKey);
                        ContainerUtil.addIfNotNull((Collection)unusedDeclarations, (Object)highlightInfo);
                    } else if (element instanceof GrParameter && !usedParams.containsKey(element)) {
                        usedParams.put((GrParameter)element, Boolean.FALSE);
                    }
                }
                super.visitElement(element);
            }
        });
        HashSet<GrImportStatement> unusedImports = new HashSet<GrImportStatement>(PsiUtil.getValidImportStatements(this.myFile));
        unusedImports.removeAll(GroovyImportUtil.findUsedImports(this.myFile));
        this.myUnusedImports = unusedImports;
        if (deadCodeEnabled) {
            for (GrParameter parameter : usedParams.keySet()) {
                if (((Boolean)usedParams.get(parameter)).booleanValue()) continue;
                PsiElement scope = parameter.getDeclarationScope();
                if (scope instanceof GrMethod) {
                    GrMethod method = (GrMethod)scope;
                    if (!GroovyPostHighlightingPass.methodMayHaveUnusedParameters(method)) continue;
                    PsiElement identifier = parameter.getNameIdentifierGroovy();
                    HighlightInfo highlightInfo = PostHighlightingPass.createUnusedSymbolInfo((PsiElement)identifier, (String)("Parameter " + parameter.getName() + " is unused"), (HighlightInfoType)HighlightInfoType.UNUSED_SYMBOL);
                    QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)GroovyQuickFixFactory.getInstance().createRemoveUnusedGrParameterFix(parameter), (HighlightDisplayKey)unusedDefKey);
                    ContainerUtil.addIfNotNull(unusedDeclarations, (Object)highlightInfo);
                    continue;
                }
                if (!(scope instanceof GrClosableBlock)) continue;
            }
        }
        this.myUnusedDeclarations = unusedDeclarations;
    }

    private static boolean methodMayHaveUnusedParameters(GrMethod method) {
        return (method.isConstructor() || method.hasModifierProperty("private") || method.hasModifierProperty("static") || !method.hasModifierProperty("abstract") && !GroovyPostHighlightingPass.isOverriddenOrOverrides(method)) && !method.hasModifierProperty("native") && !JavaHighlightUtil.isSerializationRelatedMethod((PsiMethod)method, (PsiClass)method.getContainingClass()) && !PsiClassImplUtil.isMainOrPremainMethod((PsiMethod)method);
    }

    private static boolean isFieldUnused(GrField field, ProgressIndicator progress, GlobalUsageHelper usageHelper) {
        if (!PostHighlightingPass.isFieldUnused((Project)field.getProject(), (PsiFile)field.getContainingFile(), (PsiField)field, (ProgressIndicator)progress, (GlobalUsageHelper)usageHelper)) {
            return false;
        }
        GrAccessorMethod[] getters = field.getGetters();
        GrAccessorMethod setter = field.getSetter();
        for (GrAccessorMethod getter : getters) {
            if (getter.findSuperMethods().length <= 0) continue;
            return false;
        }
        return setter == null || setter.findSuperMethods().length <= 0;
    }

    private static boolean isOverriddenOrOverrides(PsiMethod method) {
        boolean overrides = SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false).findFirst() != null;
        return overrides || OverridingMethodsSearch.search((PsiMethod)method).findFirst() != null;
    }

    public void doApplyInformationToEditor() {
        IntentionAction fix;
        if (this.myUnusedDeclarations == null || this.myUnusedImports == null) {
            return;
        }
        AnnotationHolderImpl annotationHolder = new AnnotationHolderImpl(new AnnotationSession((PsiFile)this.myFile));
        ArrayList<HighlightInfo> infos = new ArrayList<HighlightInfo>(this.myUnusedDeclarations);
        for (GrImportStatement unusedImport : this.myUnusedImports) {
            Annotation annotation = annotationHolder.createWarningAnnotation(GroovyPostHighlightingPass.calculateRangeToUse(unusedImport), GroovyInspectionBundle.message("unused.import", new Object[0]));
            annotation.setHighlightType(ProblemHighlightType.LIKE_UNUSED_SYMBOL);
            annotation.registerFix(GroovyQuickFixFactory.getInstance().createOptimizeImportsFix(false));
            infos.add(HighlightInfo.fromAnnotation((Annotation)annotation));
        }
        UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)this.myDocument, (int)0, (int)this.myFile.getTextLength(), infos, (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
        if (this.myUnusedImports != null && !this.myUnusedImports.isEmpty() && (fix = GroovyQuickFixFactory.getInstance().createOptimizeImportsFix(true)).isAvailable(this.myProject, this.myEditor, (PsiFile)this.myFile) && this.myFile.isWritable()) {
            fix.invoke(this.myProject, this.myEditor, (PsiFile)this.myFile);
        }
    }

    private static TextRange calculateRangeToUse(GrImportStatement unusedImport) {
        TextRange range = unusedImport.getTextRange();
        if (StringUtil.isEmptyOrSpaces((String)unusedImport.getAnnotationList().getText())) {
            return range;
        }
        int start = 0;
        for (PsiElement child = unusedImport.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNode().getElementType() != GroovyTokenTypes.kIMPORT) continue;
            start = child.getTextRange().getStartOffset();
        }
        return new TextRange(start, range.getEndOffset());
    }
}

