/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.util;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

public abstract class GroovyUtils {
    public static File[] getFilesInDirectoryByPattern(String dirPath, String patternString) {
        Pattern pattern = Pattern.compile(patternString);
        return LibrariesUtil.getFilesInDirectoryByPattern(dirPath, pattern);
    }

    public static <E> List<E> flatten(Collection<? extends Collection<E>> collections) {
        ArrayList<E> result = new ArrayList<E>();
        for (Collection<E> list : collections) {
            result.addAll(list);
        }
        return result;
    }

    @Nullable
    public static GrTypeDefinition getPublicClass(@Nullable VirtualFile virtualFile, PsiManager manager) {
        if (virtualFile == null) {
            return null;
        }
        PsiFile psiFile = manager.findFile(virtualFile);
        if (psiFile instanceof GroovyFile) {
            return GroovyUtils.getClassDefinition((GroovyFile)psiFile);
        }
        return null;
    }

    @Nullable
    public static GrTypeDefinition getClassDefinition(@NotNull GroovyFile groovyFile) {
        if (groovyFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groovyFile", "org/jetbrains/plugins/groovy/util/GroovyUtils", "getClassDefinition"));
        }
        String fileName = groovyFile.getName();
        int idx = fileName.lastIndexOf(46);
        if (idx < 0) {
            return null;
        }
        return GroovyUtils.getClassDefinition(groovyFile, fileName.substring(0, idx));
    }

    @Nullable
    public static GrTypeDefinition getClassDefinition(@NotNull GroovyFile groovyFile, @NotNull String classSimpleName) {
        if (groovyFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groovyFile", "org/jetbrains/plugins/groovy/util/GroovyUtils", "getClassDefinition"));
        }
        if (classSimpleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classSimpleName", "org/jetbrains/plugins/groovy/util/GroovyUtils", "getClassDefinition"));
        }
        for (GrTypeDefinition definition : groovyFile.getTypeDefinitions()) {
            if (!classSimpleName.equals(definition.getName())) continue;
            return definition;
        }
        return null;
    }
}

