/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.checkout;

import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.checkout.CheckoutClient;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnKitCheckoutClient
extends BaseSvnClient
implements CheckoutClient {
    public static final List<WorkingCopyFormat> SUPPORTED_FORMATS;

    @Override
    public void checkout(@NotNull SvnTarget source, @NotNull File destination, @Nullable SVNRevision revision, @Nullable Depth depth, boolean ignoreExternals, boolean force, @NotNull WorkingCopyFormat format, @Nullable ProgressTracker handler) throws VcsException {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/idea/svn/checkout/SvnKitCheckoutClient", "checkout"));
        }
        if (destination == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destination", "org/jetbrains/idea/svn/checkout/SvnKitCheckoutClient", "checkout"));
        }
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "org/jetbrains/idea/svn/checkout/SvnKitCheckoutClient", "checkout"));
        }
        this.assertUrl(source);
        this.validateFormat(format, this.getSupportedFormats());
        SVNUpdateClient client = this.myVcs.getSvnKitManager().createUpdateClient();
        if (WorkingCopyFormat.ONE_DOT_SIX.equals((Object)format)) {
            client.getOperationsFactory().setPrimaryWcGeneration(SvnWcGeneration.V16);
        }
        client.setIgnoreExternals(ignoreExternals);
        client.setEventHandler(SvnKitCheckoutClient.toEventHandler(handler));
        try {
            client.doCheckout(source.getURL(), destination, source.getPegRevision(), revision, SvnKitCheckoutClient.toDepth(depth), force);
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    @Override
    public List<WorkingCopyFormat> getSupportedFormats() throws VcsException {
        return SUPPORTED_FORMATS;
    }

    static {
        ArrayList<WorkingCopyFormat> supportedFormats = new ArrayList<WorkingCopyFormat>();
        supportedFormats.add(WorkingCopyFormat.ONE_DOT_SEVEN);
        supportedFormats.add(WorkingCopyFormat.ONE_DOT_SIX);
        SUPPORTED_FORMATS = Collections.unmodifiableList(supportedFormats);
    }
}

