/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler;

import com.intellij.icons.AllIcons;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.compiled.ClassFileDecompilers;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.ui.Gray;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.jar.Manifest;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.decompiler.IdeaDecompilerBundle;
import org.jetbrains.java.decompiler.IdeaLogger;
import org.jetbrains.java.decompiler.main.decompiler.BaseDecompiler;
import org.jetbrains.java.decompiler.main.extern.IBytecodeProvider;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;

public class IdeaDecompiler
extends ClassFileDecompilers.Light {
    public static final String BANNER = "//\n// Source code recreated from a .class file by IntelliJ IDEA\n// (powered by Fernflower decompiler)\n//\n\n";
    private static final String LEGAL_NOTICE_KEY = "decompiler.legal.notice.accepted";
    private final IFernflowerLogger myLogger = new IdeaLogger();
    private final Map<String, Object> myOptions = new HashMap<String, Object>();
    private boolean myLegalNoticeAccepted;

    public IdeaDecompiler() {
        this.myOptions.put("hdc", "0");
        this.myOptions.put("dgs", "1");
        this.myOptions.put("rsy", "1");
        this.myOptions.put("rbr", "1");
        this.myOptions.put("lit", "1");
        this.myOptions.put("nls", "1");
        Project project = DefaultProjectFactory.getInstance().getDefaultProject();
        CodeStyleSettings settings = CodeStyleSettingsManager.getInstance((Project)project).getCurrentSettings();
        CommonCodeStyleSettings.IndentOptions options = settings.getIndentOptions((FileType)JavaFileType.INSTANCE);
        this.myOptions.put("ind", StringUtil.repeat((String)" ", (int)options.INDENT_SIZE));
        Application app = ApplicationManager.getApplication();
        boolean bl = this.myLegalNoticeAccepted = app.isUnitTestMode() || PropertiesComponent.getInstance().isValueSet(LEGAL_NOTICE_KEY);
        if (!this.myLegalNoticeAccepted) {
            MessageBusConnection connection = app.getMessageBus().connect((Disposable)app);
            connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerAdapter(){

                public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                    CharSequence text;
                    FileEditor editor;
                    if (source == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/java/decompiler/IdeaDecompiler$1", "fileOpened"));
                    }
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/java/decompiler/IdeaDecompiler$1", "fileOpened"));
                    }
                    if (file.getFileType() == StdFileTypes.CLASS && (editor = source.getSelectedEditor(file)) instanceof TextEditor && StringUtil.startsWith((CharSequence)(text = ((TextEditor)editor).getEditor().getDocument().getImmutableCharSequence()), (CharSequence)IdeaDecompiler.BANNER)) {
                        IdeaDecompiler.this.showLegalNotice(source.getProject(), file);
                    }
                }
            });
        }
    }

    private void showLegalNotice(final Project project, final VirtualFile file) {
        if (!this.myLegalNoticeAccepted) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!IdeaDecompiler.this.myLegalNoticeAccepted) {
                        new LegalNoticeDialog(project, file).show();
                    }
                }
            }, ModalityState.NON_MODAL);
        }
    }

    public boolean accepts(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/java/decompiler/IdeaDecompiler", "accepts"));
        }
        return true;
    }

    @NotNull
    public CharSequence getText(@NotNull VirtualFile file) throws ClassFileDecompilers.Light.CannotDecompileException {
        String string;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/java/decompiler/IdeaDecompiler", "getText"));
        }
        if ("package-info.class".equals(file.getName())) {
            CharSequence charSequence = ClsFileImpl.decompile((VirtualFile)file);
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/java/decompiler/IdeaDecompiler", "getText"));
            }
            return charSequence;
        }
        try {
            LinkedHashMap files = ContainerUtil.newLinkedHashMap();
            files.put(file.getPath(), file);
            String mask = file.getNameWithoutExtension() + "$";
            for (VirtualFile child : file.getParent().getChildren()) {
                String name = child.getNameWithoutExtension();
                if (!name.startsWith(mask) || name.length() <= mask.length() || file.getFileType() != StdFileTypes.CLASS) continue;
                files.put(FileUtil.toSystemIndependentName((String)child.getPath()), child);
            }
            MyBytecodeProvider provider = new MyBytecodeProvider(files);
            MyResultSaver saver = new MyResultSaver();
            BaseDecompiler decompiler = new BaseDecompiler(provider, saver, this.myOptions, this.myLogger);
            for (String path : files.keySet()) {
                decompiler.addSpace(new File(path), true);
            }
            decompiler.decompileContext();
            string = BANNER + saver.myResult;
        }
        catch (Exception e) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                AssertionError error = new AssertionError((Object)file.getUrl());
                ((Throwable)((Object)error)).initCause(e);
                throw error;
            }
            throw new ClassFileDecompilers.Light.CannotDecompileException((Throwable)e);
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/java/decompiler/IdeaDecompiler", "getText"));
        }
        return string;
    }

    private class LegalNoticeDialog
    extends DialogWrapper {
        private final Project myProject;
        private final VirtualFile myFile;
        private JEditorPane myMessage;

        public LegalNoticeDialog(Project project, VirtualFile file) {
            super(project);
            this.myProject = project;
            this.myFile = file;
            this.setTitle(IdeaDecompilerBundle.message("legal.notice.title", new Object[0]));
            this.setOKButtonText(IdeaDecompilerBundle.message("legal.notice.action.accept", new Object[0]));
            this.setCancelButtonText(IdeaDecompilerBundle.message("legal.notice.action.postpone", new Object[0]));
            this.init();
            this.pack();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            JBPanel iconPanel = new JBPanel((LayoutManager)new BorderLayout());
            iconPanel.add((Component)new JBLabel(AllIcons.General.WarningDialog), "North");
            this.myMessage = new JEditorPane();
            this.myMessage.setEditorKit(UIUtil.getHTMLEditorKit());
            this.myMessage.setEditable(false);
            this.myMessage.setPreferredSize(new Dimension(500, 100));
            this.myMessage.setBorder(BorderFactory.createLineBorder((Color)Gray._200));
            String text = "<div style='margin:5px;'>" + IdeaDecompilerBundle.message("legal.notice.text", new Object[0]) + "</div>";
            this.myMessage.setText(text);
            JBPanel panel = new JBPanel((LayoutManager)new BorderLayout(10, 0));
            panel.add((Component)iconPanel, "West");
            panel.add((Component)this.myMessage, "Center");
            return panel;
        }

        @NotNull
        protected Action[] createActions() {
            DialogWrapper.DialogWrapperAction decline = new DialogWrapper.DialogWrapperAction(IdeaDecompilerBundle.message("legal.notice.action.reject", new Object[0])){

                protected void doAction(ActionEvent e) {
                    LegalNoticeDialog.this.doDeclineAction();
                }
            };
            Action[] actionArray = new Action[]{this.getOKAction(), decline, this.getCancelAction()};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/java/decompiler/IdeaDecompiler$LegalNoticeDialog", "createActions"));
            }
            return actionArray;
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myMessage;
        }

        protected void doOKAction() {
            super.doOKAction();
            PropertiesComponent.getInstance().setValue(IdeaDecompiler.LEGAL_NOTICE_KEY, Boolean.TRUE.toString());
            IdeaDecompiler.this.myLegalNoticeAccepted = true;
        }

        private void doDeclineAction() {
            this.doCancelAction();
            PluginManagerCore.disablePlugin((String)"org.jetbrains.java.decompiler");
            ApplicationManagerEx.getApplicationEx().restart(true);
        }

        public void doCancelAction() {
            super.doCancelAction();
            FileEditorManager.getInstance((Project)this.myProject).closeFile(this.myFile);
        }
    }

    private static class MyResultSaver
    implements IResultSaver {
        private String myResult = "";

        private MyResultSaver() {
        }

        @Override
        public void saveClassFile(String path, String qualifiedName, String entryName, String content) {
            if (this.myResult.isEmpty()) {
                this.myResult = content;
            }
        }

        @Override
        public void saveFolder(String path) {
        }

        @Override
        public void copyFile(String source, String path, String entryName) {
        }

        @Override
        public void createArchive(String path, String archiveName, Manifest manifest) {
        }

        @Override
        public void saveDirEntry(String path, String archiveName, String entryName) {
        }

        @Override
        public void copyEntry(String source, String path, String archiveName, String entry) {
        }

        @Override
        public void saveClassEntry(String path, String archiveName, String qualifiedName, String entryName, String content) {
        }

        @Override
        public void closeArchive(String path, String archiveName) {
        }
    }

    private static class MyBytecodeProvider
    implements IBytecodeProvider {
        private final Map<String, VirtualFile> myFiles;

        private MyBytecodeProvider(@NotNull Map<String, VirtualFile> files) {
            if (files == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/java/decompiler/IdeaDecompiler$MyBytecodeProvider", "<init>"));
            }
            this.myFiles = files;
        }

        @Override
        public byte[] getBytecode(String externalPath, String internalPath) {
            try {
                String path = FileUtil.toSystemIndependentName((String)externalPath);
                VirtualFile file = this.myFiles.get(path);
                assert (file != null) : path + " not in " + this.myFiles.keySet();
                return file.contentsToByteArray();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

