/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class MonitorExprent
extends Exprent {
    public static final int MONITOR_ENTER = 0;
    public static final int MONITOR_EXIT = 1;
    private int montype;
    private Exprent value;

    public MonitorExprent(int montype, Exprent value) {
        this.type = 9;
        this.montype = montype;
        this.value = value;
    }

    @Override
    public Exprent copy() {
        return new MonitorExprent(this.montype, this.value.copy());
    }

    @Override
    public List<Exprent> getAllExprents() {
        ArrayList<Exprent> lst = new ArrayList<Exprent>();
        lst.add(this.value);
        return lst;
    }

    @Override
    public String toJava(int indent, BytecodeMappingTracer tracer) {
        tracer.addMapping(this.bytecode);
        if (this.montype == 0) {
            return "synchronized(" + this.value.toJava(indent, tracer) + ")";
        }
        return "";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof MonitorExprent)) {
            return false;
        }
        MonitorExprent me = (MonitorExprent)o;
        return this.montype == me.getMontype() && InterpreterUtil.equalObjects(this.value, me.getValue());
    }

    @Override
    public void replaceExprent(Exprent oldexpr, Exprent newexpr) {
        if (oldexpr == this.value) {
            this.value = newexpr;
        }
    }

    public int getMontype() {
        return this.montype;
    }

    public Exprent getValue() {
        return this.value;
    }
}

