/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Manifest;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;
import org.jetbrains.java.decompiler.struct.IDecompiledData;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.lazy.LazyLoader;
import org.jetbrains.java.decompiler.util.DataInputFullStream;

public class ContextUnit {
    public static final int TYPE_FOLDER = 0;
    public static final int TYPE_JAR = 1;
    public static final int TYPE_ZIP = 2;
    private final int type;
    private final boolean own;
    private final String archivePath;
    private final String filename;
    private final IResultSaver resultSaver;
    private final IDecompiledData decompiledData;
    private final List<String> classEntries = new ArrayList<String>();
    private final List<String> dirEntries = new ArrayList<String>();
    private final List<String[]> otherEntries = new ArrayList<String[]>();
    private List<StructClass> classes = new ArrayList<StructClass>();
    private Manifest manifest;

    public ContextUnit(int type, String archivePath, String filename, boolean own, IResultSaver resultSaver, IDecompiledData decompiledData) {
        this.type = type;
        this.own = own;
        this.archivePath = archivePath;
        this.filename = filename;
        this.resultSaver = resultSaver;
        this.decompiledData = decompiledData;
    }

    public void addClass(StructClass cl, String entryName) {
        this.classes.add(cl);
        this.classEntries.add(entryName);
    }

    public void addDirEntry(String entry) {
        this.dirEntries.add(entry);
    }

    public void addOtherEntry(String fullPath, String entry) {
        this.otherEntries.add(new String[]{fullPath, entry});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(LazyLoader loader) throws IOException {
        ArrayList<StructClass> lstClasses = new ArrayList<StructClass>();
        for (StructClass cl : this.classes) {
            StructClass newCl;
            String oldName = cl.qualifiedName;
            DataInputFullStream in = loader.getClassStream(oldName);
            try {
                newCl = new StructClass(in, cl.isOwn(), loader);
            }
            finally {
                in.close();
            }
            lstClasses.add(newCl);
            LazyLoader.Link lnk = loader.getClassLink(oldName);
            loader.removeClassLink(oldName);
            loader.addClassLink(newCl.qualifiedName, lnk);
        }
        this.classes = lstClasses;
    }

    public void save() {
        switch (this.type) {
            case 0: {
                this.resultSaver.saveFolder(this.filename);
                for (String[] pair : this.otherEntries) {
                    this.resultSaver.copyFile(pair[0], this.filename, pair[1]);
                }
                for (int i = 0; i < this.classes.size(); ++i) {
                    String content;
                    StructClass cl = this.classes.get(i);
                    String entryName = this.decompiledData.getClassEntryName(cl, this.classEntries.get(i));
                    if (entryName == null || (content = this.decompiledData.getClassContent(cl)) == null) continue;
                    this.resultSaver.saveClassFile(this.filename, cl.qualifiedName, entryName, content);
                }
                break;
            }
            case 1: 
            case 2: {
                this.resultSaver.saveFolder(this.archivePath);
                this.resultSaver.createArchive(this.archivePath, this.filename, this.manifest);
                for (String dirEntry : this.dirEntries) {
                    this.resultSaver.saveDirEntry(this.archivePath, this.filename, dirEntry);
                }
                for (String[] pair : this.otherEntries) {
                    if (this.type == 1 && "META-INF/MANIFEST.MF".equalsIgnoreCase(pair[1])) continue;
                    this.resultSaver.copyEntry(pair[0], this.archivePath, this.filename, pair[1]);
                }
                for (int i = 0; i < this.classes.size(); ++i) {
                    StructClass cl = this.classes.get(i);
                    String entryName = this.decompiledData.getClassEntryName(cl, this.classEntries.get(i));
                    if (entryName == null) continue;
                    String content = this.decompiledData.getClassContent(cl);
                    this.resultSaver.saveClassEntry(this.archivePath, this.filename, cl.qualifiedName, entryName, content);
                }
                this.resultSaver.closeArchive(this.archivePath, this.filename);
            }
        }
    }

    public void setManifest(Manifest manifest) {
        this.manifest = manifest;
    }

    public boolean isOwn() {
        return this.own;
    }

    public List<StructClass> getClasses() {
        return this.classes;
    }
}

