/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl.configuration;

import com.intellij.icons.AllIcons;
import com.intellij.ide.macro.MacrosDialog;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.config.impl.AntClasspathEntry;
import com.intellij.lang.ant.config.impl.AntInstallation;
import com.intellij.lang.ant.config.impl.AntReference;
import com.intellij.lang.ant.config.impl.GlobalAntConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.OrderEntryAppearanceService;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.CellEditorComponentWithBrowseButton;
import icons.AntIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;
import javax.swing.text.BadLocationException;

public class AntUIUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ant.impl.configuration.AntUIUtil");

    private AntUIUtil() {
    }

    public static void customizeReference(AntReference antReference, SimpleColoredComponent component, GlobalAntConfiguration configuration) {
        AntInstallation antInstallation = antReference.find(configuration);
        if (antInstallation != null) {
            AntUIUtil.customizeAnt(antInstallation.getProperties(), component);
        } else {
            component.setIcon(PlatformIcons.INVALID_ENTRY_ICON);
            component.append(antReference.getName(), SimpleTextAttributes.ERROR_ATTRIBUTES);
        }
    }

    public static void customizeAnt(AbstractProperty.AbstractPropertyContainer antProperties, SimpleColoredComponent component) {
        component.setIcon(AntIcons.AntInstallation);
        String name = (String)AntInstallation.NAME.get(antProperties);
        component.append(name, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        String versionString = (String)AntInstallation.VERSION.get(antProperties);
        if (name.indexOf(versionString) == -1) {
            component.append(" (" + versionString + ")", SimpleTextAttributes.SYNTHETIC_ATTRIBUTES);
        }
    }

    public static class ProjectJdkRenderer
    extends ColoredListCellRenderer {
        private final boolean myInComboBox;
        private final String myProjectJdkName;

        public ProjectJdkRenderer(boolean inComboBox, String projectJdkName) {
            this.myInComboBox = inComboBox;
            this.myProjectJdkName = projectJdkName != null ? projectJdkName : "";
        }

        protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            Sdk jdk;
            String jdkName = (String)value;
            if (jdkName == null || jdkName.length() == 0) {
                jdkName = "";
            }
            if ((jdk = GlobalAntConfiguration.findJdk(jdkName)) == null) {
                if (this.myProjectJdkName.length() > 0) {
                    this.setIcon(AllIcons.General.Jdk);
                    this.append(AntBundle.message("project.jdk.project.jdk.name.list.column.value", this.myProjectJdkName), selected && (!SystemInfo.isWinVistaOrNewer || !UIManager.getLookAndFeel().getName().contains("Windows")) ? SimpleTextAttributes.SELECTED_SIMPLE_CELL_ATTRIBUTES : SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES);
                } else {
                    this.setIcon(PlatformIcons.INVALID_ENTRY_ICON);
                    this.append(AntBundle.message("project.jdk.not.specified.list.column.value", new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
                }
            } else {
                OrderEntryAppearanceService.getInstance().forJdk(jdk, this.myInComboBox, selected, true).customize((SimpleColoredComponent)this);
            }
        }
    }

    public static class PropertyValueCellEditor
    extends AbstractTableCellEditor {
        private final CellEditorComponentWithBrowseButton<JTextField> myComponent = new CellEditorComponentWithBrowseButton((ComponentWithBrowseButton)new TextFieldWithBrowseButton(), (TableCellEditor)((Object)this));

        public PropertyValueCellEditor() {
            this.getChildComponent().setBorder(BorderFactory.createLineBorder(Color.black));
            FixedSizeButton button = this.myComponent.getComponentWithButton().getButton();
            button.setIcon(IconUtil.getAddIcon());
            button.setToolTipText(AntBundle.message("ant.property.value.editor.insert.macro.tooltip.text", new Object[0]));
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MacrosDialog dialog = new MacrosDialog((Component)PropertyValueCellEditor.this.getChildComponent());
                    dialog.show();
                    if (dialog.isOK() && dialog.getSelectedMacro() != null) {
                        JTextField textField = PropertyValueCellEditor.this.getChildComponent();
                        String macro = dialog.getSelectedMacro().getName();
                        int position = textField.getCaretPosition();
                        try {
                            textField.getDocument().insertString(position, "$" + macro + "$", null);
                            textField.setCaretPosition(position + macro.length() + 2);
                        }
                        catch (BadLocationException ex) {
                            LOG.error((Throwable)ex);
                        }
                        textField.requestFocus();
                    }
                }
            });
        }

        public Object getCellEditorValue() {
            return this.getChildComponent().getText();
        }

        protected void initializeEditor(Object value) {
            this.getChildComponent().setText((String)value);
        }

        private JTextField getChildComponent() {
            return (JTextField)this.myComponent.getChildComponent();
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.getChildComponent().setText((String)value);
            return this.myComponent;
        }
    }

    public static class ClasspathRenderer
    extends ColoredListCellRenderer {
        protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            AntClasspathEntry entry = (AntClasspathEntry)value;
            entry.getAppearance().customize((SimpleColoredComponent)this);
        }
    }

    public static class AntReferenceRenderer
    extends ColoredListCellRenderer {
        private final GlobalAntConfiguration myConfiguration;

        public AntReferenceRenderer(GlobalAntConfiguration configuration) {
            this.myConfiguration = configuration;
        }

        protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            if (value == null) {
                return;
            }
            AntUIUtil.customizeReference((AntReference)value, (SimpleColoredComponent)this, this.myConfiguration);
        }
    }

    public static class AntInstallationRenderer
    extends ColoredListCellRenderer {
        private final PropertiesEditor<AntInstallation> myEditor;

        public AntInstallationRenderer(PropertiesEditor<AntInstallation> editor) {
            this.myEditor = editor != null ? editor : new PropertiesEditor<AntInstallation>(){

                @Override
                public AbstractProperty.AbstractPropertyContainer getProperties(AntInstallation antInstallation) {
                    return antInstallation.getProperties();
                }
            };
        }

        protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            AntInstallation ant = (AntInstallation)value;
            if (ant == null) {
                return;
            }
            AbstractProperty.AbstractPropertyContainer container = this.myEditor.getProperties(ant);
            AntUIUtil.customizeAnt(container, (SimpleColoredComponent)this);
        }
    }

    public static interface PropertiesEditor<T> {
        public AbstractProperty.AbstractPropertyContainer getProperties(T var1);
    }
}

