/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.actions;

import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.util.gotoByName.ChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.SimpleChooseByNameModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.actions.ConfigureServersAction;
import com.intellij.tasks.actions.OpenTaskDialog;
import com.intellij.tasks.actions.TaskCellRenderer;
import com.intellij.tasks.actions.TaskItemProvider;
import com.intellij.tasks.doc.TaskPsiElement;
import com.intellij.tasks.impl.TaskManagerImpl;
import com.intellij.tasks.impl.TaskUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IconUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoTaskAction
extends GotoActionBase
implements DumbAware {
    public static final CreateNewTaskAction CREATE_NEW_TASK_ACTION = new CreateNewTaskAction();
    public static final String ID = "tasks.goto";
    private static final Logger LOG = Logger.getInstance(GotoTaskAction.class);
    public static final int PAGE_SIZE = 20;

    public GotoTaskAction() {
        this.getTemplatePresentation().setText("Open Task...");
        this.getTemplatePresentation().setIcon(IconUtil.getAddIcon());
    }

    protected void gotoActionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        this.perform(project);
    }

    void perform(final Project project) {
        final Ref shiftPressed = Ref.create((Object)false);
        final MyChooseByNamePopup popup = GotoTaskAction.createPopup(project, (ChooseByNameModel)new GotoTaskPopupModel(project), new TaskItemProvider(project));
        popup.setShowListForEmptyPattern(true);
        popup.setSearchInAnyPlace(true);
        popup.setFixLostTyping(false);
        popup.setAlwaysHasMore(true);
        popup.setAdText("<html>Press SHIFT to merge with current context<br/>Pressing " + KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("QuickJavaDoc")) + " would show task description and comments</html>");
        popup.registerAction("shiftPressed", KeyStroke.getKeyStroke("shift pressed SHIFT"), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                shiftPressed.set((Object)true);
            }
        });
        popup.registerAction("shiftReleased", KeyStroke.getKeyStroke("released SHIFT"), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                shiftPressed.set((Object)false);
            }
        });
        DefaultActionGroup group = new DefaultActionGroup(new AnAction[]{new ConfigureServersAction(){

            @Override
            protected void serversChanged() {
                popup.rebuildList(true);
            }
        }});
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true);
        actionToolbar.setLayoutPolicy(0);
        actionToolbar.updateActionsImmediately();
        actionToolbar.getComponent().setFocusable(false);
        actionToolbar.getComponent().setBorder(null);
        popup.setToolArea(actionToolbar.getComponent());
        popup.setMaximumListSizeLimit(20);
        popup.setListSizeIncreasing(20);
        this.showNavigationPopup((GotoActionBase.GotoActionCallback)new GotoActionBase.GotoActionCallback<Object>(){

            public void elementChosen(ChooseByNamePopup popup, Object element) {
                TaskManager taskManager = TaskManager.getManager((Project)project);
                if (element instanceof TaskPsiElement) {
                    Task task = ((TaskPsiElement)((Object)element)).getTask();
                    LocalTask localTask = taskManager.findTask(task.getId());
                    if (localTask != null) {
                        taskManager.activateTask((Task)localTask, (Boolean)shiftPressed.get() == false);
                    } else {
                        GotoTaskAction.showOpenTaskDialog(project, task);
                    }
                } else if (element == CREATE_NEW_TASK_ACTION) {
                    LocalTask localTask = taskManager.createLocalTask(CREATE_NEW_TASK_ACTION.getTaskName());
                    GotoTaskAction.showOpenTaskDialog(project, (Task)localTask);
                }
            }
        }, null, popup);
    }

    private static void showOpenTaskDialog(final Project project, final Task task) {
        JBPopup hint = DocumentationManager.getInstance((Project)project).getDocInfoHint();
        if (hint != null) {
            hint.cancel();
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                new OpenTaskDialog(project, task).show();
            }
        });
    }

    private static MyChooseByNamePopup createPopup(Project project, ChooseByNameModel model, ChooseByNameItemProvider provider) {
        ChooseByNamePopup oldPopup;
        ChooseByNamePopup chooseByNamePopup = oldPopup = project == null ? null : (ChooseByNamePopup)project.getUserData(ChooseByNamePopup.CHOOSE_BY_NAME_POPUP_IN_PROJECT_KEY);
        if (oldPopup != null) {
            oldPopup.close(false);
        }
        MyChooseByNamePopup newPopup = new MyChooseByNamePopup(project, model, provider, oldPopup, null, false, 0);
        if (project != null) {
            project.putUserData(ChooseByNamePopup.CHOOSE_BY_NAME_POPUP_IN_PROJECT_KEY, (Object)newPopup);
        }
        return newPopup;
    }

    public static class CreateNewTaskAction {
        private String taskName;

        public String getActionText() {
            return "Create New Task '" + this.taskName + "'";
        }

        public void setTaskName(String taskName) {
            this.taskName = taskName;
        }

        public String getTaskName() {
            return this.taskName;
        }
    }

    private static class MyChooseByNamePopup
    extends ChooseByNamePopup {
        private MyChooseByNamePopup(@Nullable Project project, @NotNull ChooseByNameModel model, @NotNull ChooseByNameItemProvider provider, @Nullable ChooseByNamePopup oldPopup, @Nullable String predefinedText, boolean mayRequestOpenInCurrentWindow, int initialIndex) {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/tasks/actions/GotoTaskAction$MyChooseByNamePopup", "<init>"));
            }
            if (provider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/tasks/actions/GotoTaskAction$MyChooseByNamePopup", "<init>"));
            }
            super(project, model, provider, oldPopup, predefinedText, mayRequestOpenInCurrentWindow, initialIndex);
        }

        public void close(boolean isOk) {
            super.close(isOk);
            Disposer.dispose((Disposable)((TaskItemProvider)this.myProvider));
        }
    }

    private static class GotoTaskPopupModel
    extends SimpleChooseByNameModel {
        private ListCellRenderer myListCellRenderer;

        protected GotoTaskPopupModel(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/tasks/actions/GotoTaskAction$GotoTaskPopupModel", "<init>"));
            }
            super(project, "Enter task name:", null);
            this.myListCellRenderer = new TaskCellRenderer(project);
        }

        public String[] getNames() {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }

        protected Object[] getElementsByName(String name, String pattern) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }

        public ListCellRenderer getListCellRenderer() {
            return this.myListCellRenderer;
        }

        public String getElementName(Object element) {
            if (element instanceof TaskPsiElement) {
                return TaskUtil.getTrimmedSummary(((TaskPsiElement)((Object)element)).getTask());
            }
            if (element == CREATE_NEW_TASK_ACTION) {
                return CREATE_NEW_TASK_ACTION.getActionText();
            }
            return null;
        }

        public String getCheckBoxName() {
            return "Include closed tasks";
        }

        public void saveInitialCheckBoxState(boolean state) {
            ((TaskManagerImpl)TaskManager.getManager((Project)this.getProject())).getState().searchClosedTasks = state;
        }

        public boolean loadInitialCheckBoxState() {
            return ((TaskManagerImpl)TaskManager.getManager((Project)this.getProject())).getState().searchClosedTasks;
        }
    }
}

