/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.refactoring.ui.JavaVisibilityPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class CodeStyleGenerationConfigurable
implements Configurable {
    private final JavaVisibilityPanel myJavaVisibilityPanel;
    JPanel myPanel;
    private JTextField myFieldPrefixField;
    private JTextField myStaticFieldPrefixField;
    private JTextField myParameterPrefixField;
    private JTextField myLocalVariablePrefixField;
    private JTextField myFieldSuffixField;
    private JTextField myStaticFieldSuffixField;
    private JTextField myParameterSuffixField;
    private JTextField myLocalVariableSuffixField;
    private JCheckBox myCbPreferLongerNames;
    private JCheckBox myCbLineCommentAtFirstColumn;
    private JCheckBox myCbBlockCommentAtFirstColumn;
    private final MembersOrderList myMembersOrderList;
    private final CodeStyleSettings mySettings;
    private JCheckBox myCbGenerateFinalParameters;
    private JCheckBox myCbGenerateFinalLocals;
    private JCheckBox myCbUseExternalAnnotations;
    private JCheckBox myInsertOverrideAnnotationCheckBox;
    private JPanel myMembersPanel;
    private JCheckBox myRepeatSynchronizedCheckBox;
    private JPanel myVisibilityPanel;

    public CodeStyleGenerationConfigurable(CodeStyleSettings settings) {
        this.mySettings = settings;
        this.$$$setupUI$$$();
        this.myMembersOrderList = new MembersOrderList();
        this.myPanel.setBorder(IdeBorderFactory.createEmptyBorder((int)2, (int)2, (int)2, (int)2));
        this.myJavaVisibilityPanel = new JavaVisibilityPanel(false, true);
    }

    public JComponent createComponent() {
        JPanel panel = ToolbarDecorator.createDecorator((JList)((Object)this.myMembersOrderList)).disableAddAction().disableRemoveAction().createPanel();
        this.myMembersPanel.add((Component)panel, "Center");
        this.myVisibilityPanel.add((Component)this.myJavaVisibilityPanel, "Center");
        return this.myPanel;
    }

    public void disposeUIResources() {
    }

    public String getDisplayName() {
        return ApplicationBundle.message((String)"title.code.generation", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return "reference.settingsdialog.IDE.globalcodestyle.codegen";
    }

    public void reset(CodeStyleSettings settings) {
        CommonCodeStyleSettings javaCommonSettings = settings.getCommonSettings((Language)JavaLanguage.INSTANCE);
        this.myCbPreferLongerNames.setSelected(settings.PREFER_LONGER_NAMES);
        this.myFieldPrefixField.setText(settings.FIELD_NAME_PREFIX);
        this.myStaticFieldPrefixField.setText(settings.STATIC_FIELD_NAME_PREFIX);
        this.myParameterPrefixField.setText(settings.PARAMETER_NAME_PREFIX);
        this.myLocalVariablePrefixField.setText(settings.LOCAL_VARIABLE_NAME_PREFIX);
        this.myFieldSuffixField.setText(settings.FIELD_NAME_SUFFIX);
        this.myStaticFieldSuffixField.setText(settings.STATIC_FIELD_NAME_SUFFIX);
        this.myParameterSuffixField.setText(settings.PARAMETER_NAME_SUFFIX);
        this.myLocalVariableSuffixField.setText(settings.LOCAL_VARIABLE_NAME_SUFFIX);
        this.myCbLineCommentAtFirstColumn.setSelected(javaCommonSettings.LINE_COMMENT_AT_FIRST_COLUMN);
        this.myCbBlockCommentAtFirstColumn.setSelected(javaCommonSettings.BLOCK_COMMENT_AT_FIRST_COLUMN);
        this.myCbGenerateFinalLocals.setSelected(settings.GENERATE_FINAL_LOCALS);
        this.myCbGenerateFinalParameters.setSelected(settings.GENERATE_FINAL_PARAMETERS);
        this.myMembersOrderList.reset(this.mySettings);
        this.myCbUseExternalAnnotations.setSelected(settings.USE_EXTERNAL_ANNOTATIONS);
        this.myInsertOverrideAnnotationCheckBox.setSelected(settings.INSERT_OVERRIDE_ANNOTATION);
        this.myRepeatSynchronizedCheckBox.setSelected(settings.REPEAT_SYNCHRONIZED);
        this.myJavaVisibilityPanel.setVisibility(settings.VISIBILITY);
    }

    public void reset() {
        this.reset(this.mySettings);
    }

    public void apply(CodeStyleSettings settings) throws ConfigurationException {
        CommonCodeStyleSettings javaCommonSettings = settings.getCommonSettings((Language)JavaLanguage.INSTANCE);
        settings.PREFER_LONGER_NAMES = this.myCbPreferLongerNames.isSelected();
        settings.FIELD_NAME_PREFIX = CodeStyleGenerationConfigurable.setPrefixSuffix(this.myFieldPrefixField.getText(), true);
        settings.STATIC_FIELD_NAME_PREFIX = CodeStyleGenerationConfigurable.setPrefixSuffix(this.myStaticFieldPrefixField.getText(), true);
        settings.PARAMETER_NAME_PREFIX = CodeStyleGenerationConfigurable.setPrefixSuffix(this.myParameterPrefixField.getText(), true);
        settings.LOCAL_VARIABLE_NAME_PREFIX = CodeStyleGenerationConfigurable.setPrefixSuffix(this.myLocalVariablePrefixField.getText(), true);
        settings.FIELD_NAME_SUFFIX = CodeStyleGenerationConfigurable.setPrefixSuffix(this.myFieldSuffixField.getText(), false);
        settings.STATIC_FIELD_NAME_SUFFIX = CodeStyleGenerationConfigurable.setPrefixSuffix(this.myStaticFieldSuffixField.getText(), false);
        settings.PARAMETER_NAME_SUFFIX = CodeStyleGenerationConfigurable.setPrefixSuffix(this.myParameterSuffixField.getText(), false);
        settings.LOCAL_VARIABLE_NAME_SUFFIX = CodeStyleGenerationConfigurable.setPrefixSuffix(this.myLocalVariableSuffixField.getText(), false);
        javaCommonSettings.LINE_COMMENT_AT_FIRST_COLUMN = this.myCbLineCommentAtFirstColumn.isSelected();
        javaCommonSettings.BLOCK_COMMENT_AT_FIRST_COLUMN = this.myCbBlockCommentAtFirstColumn.isSelected();
        settings.GENERATE_FINAL_LOCALS = this.myCbGenerateFinalLocals.isSelected();
        settings.GENERATE_FINAL_PARAMETERS = this.myCbGenerateFinalParameters.isSelected();
        settings.USE_EXTERNAL_ANNOTATIONS = this.myCbUseExternalAnnotations.isSelected();
        settings.INSERT_OVERRIDE_ANNOTATION = this.myInsertOverrideAnnotationCheckBox.isSelected();
        settings.REPEAT_SYNCHRONIZED = this.myRepeatSynchronizedCheckBox.isSelected();
        settings.VISIBILITY = this.myJavaVisibilityPanel.getVisibility();
        this.myMembersOrderList.apply(settings);
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            DaemonCodeAnalyzer.getInstance((Project)project).settingsChanged();
        }
    }

    private static String setPrefixSuffix(String text, boolean prefix) throws ConfigurationException {
        if ((text = text.trim()).isEmpty()) {
            return text;
        }
        if (!StringUtil.isJavaIdentifier((String)text)) {
            throw new ConfigurationException("Not a valid java identifier part in " + (prefix ? "prefix" : "suffix") + " '" + text + "'");
        }
        return text;
    }

    public void apply() throws ConfigurationException {
        this.apply(this.mySettings);
    }

    public boolean isModified(CodeStyleSettings settings) {
        CommonCodeStyleSettings javaCommonSettings = settings.getCommonSettings((Language)JavaLanguage.INSTANCE);
        boolean isModified = CodeStyleGenerationConfigurable.isModified(this.myCbPreferLongerNames, settings.PREFER_LONGER_NAMES);
        isModified |= CodeStyleGenerationConfigurable.isModified(this.myFieldPrefixField, settings.FIELD_NAME_PREFIX);
        isModified |= CodeStyleGenerationConfigurable.isModified(this.myStaticFieldPrefixField, settings.STATIC_FIELD_NAME_PREFIX);
        isModified |= CodeStyleGenerationConfigurable.isModified(this.myParameterPrefixField, settings.PARAMETER_NAME_PREFIX);
        isModified |= CodeStyleGenerationConfigurable.isModified(this.myLocalVariablePrefixField, settings.LOCAL_VARIABLE_NAME_PREFIX);
        isModified |= CodeStyleGenerationConfigurable.isModified(this.myFieldSuffixField, settings.FIELD_NAME_SUFFIX);
        isModified |= CodeStyleGenerationConfigurable.isModified(this.myStaticFieldSuffixField, settings.STATIC_FIELD_NAME_SUFFIX);
        isModified |= CodeStyleGenerationConfigurable.isModified(this.myParameterSuffixField, settings.PARAMETER_NAME_SUFFIX);
        isModified |= CodeStyleGenerationConfigurable.isModified(this.myLocalVariableSuffixField, settings.LOCAL_VARIABLE_NAME_SUFFIX);
        isModified |= CodeStyleGenerationConfigurable.isModified(this.myCbLineCommentAtFirstColumn, javaCommonSettings.LINE_COMMENT_AT_FIRST_COLUMN);
        isModified |= CodeStyleGenerationConfigurable.isModified(this.myCbBlockCommentAtFirstColumn, javaCommonSettings.BLOCK_COMMENT_AT_FIRST_COLUMN);
        isModified |= CodeStyleGenerationConfigurable.isModified(this.myCbGenerateFinalLocals, settings.GENERATE_FINAL_LOCALS);
        isModified |= CodeStyleGenerationConfigurable.isModified(this.myCbGenerateFinalParameters, settings.GENERATE_FINAL_PARAMETERS);
        isModified |= CodeStyleGenerationConfigurable.isModified(this.myCbUseExternalAnnotations, settings.USE_EXTERNAL_ANNOTATIONS);
        isModified |= CodeStyleGenerationConfigurable.isModified(this.myInsertOverrideAnnotationCheckBox, settings.INSERT_OVERRIDE_ANNOTATION);
        isModified |= CodeStyleGenerationConfigurable.isModified(this.myRepeatSynchronizedCheckBox, settings.REPEAT_SYNCHRONIZED);
        isModified |= this.myMembersOrderList.isModified(settings);
        return isModified |= !settings.VISIBILITY.equals(this.myJavaVisibilityPanel.getVisibility());
    }

    public boolean isModified() {
        return this.isModified(this.mySettings);
    }

    private static boolean isModified(JCheckBox checkBox, boolean value) {
        return checkBox.isSelected() != value;
    }

    private static boolean isModified(JTextField textField, String value) {
        return !textField.getText().trim().equals(value);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JPanel jPanel2;
        JTextField jTextField;
        JTextField jTextField2;
        JTextField jTextField3;
        JTextField jTextField4;
        JTextField jTextField5;
        JTextField jTextField6;
        JTextField jTextField7;
        JTextField jTextField8;
        JCheckBox jCheckBox8;
        JPanel jPanel3;
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel3.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jBScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/ApplicationBundle").getString("title.naming"), (int)0, (int)0, null, null));
        this.myCbPreferLongerNames = jCheckBox8 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox8, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.prefer.longer.names"));
        jPanel5.add((Component)jCheckBox8, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(1, 0, 2, 1, 1, 3, 0, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.naming.parameter"));
        jPanel6.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.naming.static.field"));
        jPanel6.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.naming.field"));
        jPanel6.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.naming.local.variable"));
        jPanel6.add((Component)jLabel4, new GridConstraints(4, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myFieldPrefixField = jTextField8 = new JTextField();
        jTextField8.setText("");
        jPanel6.add((Component)jTextField8, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(60, -1), null));
        this.myStaticFieldPrefixField = jTextField7 = new JTextField();
        jPanel6.add((Component)jTextField7, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(60, -1), null));
        this.myParameterPrefixField = jTextField6 = new JTextField();
        jPanel6.add((Component)jTextField6, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(60, -1), null));
        this.myLocalVariablePrefixField = jTextField5 = new JTextField();
        jPanel6.add((Component)jTextField5, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(60, -1), null));
        this.myFieldSuffixField = jTextField4 = new JTextField();
        jPanel6.add((Component)jTextField4, new GridConstraints(1, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(60, -1), null));
        this.myStaticFieldSuffixField = jTextField3 = new JTextField();
        jPanel6.add((Component)jTextField3, new GridConstraints(2, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(60, -1), null));
        this.myParameterSuffixField = jTextField2 = new JTextField();
        jPanel6.add((Component)jTextField2, new GridConstraints(3, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(60, -1), null));
        this.myLocalVariableSuffixField = jTextField = new JTextField();
        jPanel6.add((Component)jTextField, new GridConstraints(4, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(60, -1), null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.name.suffix"));
        jPanel6.add((Component)jLabel5, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.name.prefix"));
        jPanel6.add((Component)jLabel6, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMembersPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel4.add((Component)jPanel2, new GridConstraints(0, 1, 2, 1, 1, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/ApplicationBundle").getString("title.order.of.members"), (int)0, (int)0, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel7, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel7.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/ApplicationBundle").getString("title.naming.comment.code"), (int)0, (int)0, null, null));
        this.myCbLineCommentAtFirstColumn = jCheckBox7 = new JCheckBox();
        jCheckBox7.setMargin(new Insets(5, 10, 2, 2));
        jCheckBox7.setLabel(ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.line.comment.at.first.column"));
        this.$$$loadButtonText$$$(jCheckBox7, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.line.comment.at.first.column"));
        jPanel7.add((Component)jCheckBox7, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbBlockCommentAtFirstColumn = jCheckBox6 = new JCheckBox();
        jCheckBox6.setMargin(new Insets(2, 10, 2, 2));
        jCheckBox6.setLabel(ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.block.comment.at.first.column"));
        this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.block.comment.at.first.column"));
        jPanel7.add((Component)jCheckBox6, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel8, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel8.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/ApplicationBundle").getString("title.naming.final.modifier"), (int)0, (int)0, null, null));
        this.myCbGenerateFinalLocals = jCheckBox5 = new JCheckBox();
        jCheckBox5.setMargin(new Insets(5, 10, 2, 2));
        this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.make.generated.local.variables.final"));
        jPanel8.add((Component)jCheckBox5, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbGenerateFinalParameters = jCheckBox4 = new JCheckBox();
        jCheckBox4.setMargin(new Insets(5, 10, 2, 2));
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.make.generated.parameters.final"));
        jPanel8.add((Component)jCheckBox4, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbUseExternalAnnotations = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("use.external.annotations"));
        jPanel4.add((Component)jCheckBox3, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel9.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel9, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel9.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Override Method Signature", (int)0, (int)0, null, null));
        this.myInsertOverrideAnnotationCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("insert.override.annotation"));
        jPanel9.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myRepeatSynchronizedCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Repeat synchronized modifier");
        jCheckBox.setMnemonic('S');
        jCheckBox.setDisplayedMnemonicIndex(7);
        jPanel9.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myVisibilityPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel, new GridConstraints(2, 1, 3, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, "Center");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class MembersOrderList
    extends JBList {
        private static final Map<String, PropertyManager> PROPERTIES = new HashMap<String, PropertyManager>();
        private final DefaultListModel myModel = new DefaultListModel();

        public MembersOrderList() {
            this.setModel(this.myModel);
            this.setVisibleRowCount(PROPERTIES.size());
        }

        public void reset(CodeStyleSettings settings) {
            this.myModel.removeAllElements();
            for (String string : MembersOrderList.getPropertyNames(settings)) {
                this.myModel.addElement(string);
            }
            this.setSelectedIndex(0);
        }

        private static void init() {
            PropertyManager staticFieldManager = new PropertyManager("listbox.members.order.static.fields"){

                @Override
                void apply(CodeStyleSettings settings, int value) {
                    settings.STATIC_FIELDS_ORDER_WEIGHT = value;
                }

                @Override
                int getValue(CodeStyleSettings settings) {
                    return settings.STATIC_FIELDS_ORDER_WEIGHT;
                }
            };
            PROPERTIES.put(staticFieldManager.myName, staticFieldManager);
            PropertyManager instanceFieldManager = new PropertyManager("listbox.members.order.fields"){

                @Override
                void apply(CodeStyleSettings settings, int value) {
                    settings.FIELDS_ORDER_WEIGHT = value;
                }

                @Override
                int getValue(CodeStyleSettings settings) {
                    return settings.FIELDS_ORDER_WEIGHT;
                }
            };
            PROPERTIES.put(instanceFieldManager.myName, instanceFieldManager);
            PropertyManager constructorManager = new PropertyManager("listbox.members.order.constructors"){

                @Override
                void apply(CodeStyleSettings settings, int value) {
                    settings.CONSTRUCTORS_ORDER_WEIGHT = value;
                }

                @Override
                int getValue(CodeStyleSettings settings) {
                    return settings.CONSTRUCTORS_ORDER_WEIGHT;
                }
            };
            PROPERTIES.put(constructorManager.myName, constructorManager);
            PropertyManager staticMethodManager = new PropertyManager("listbox.members.order.static.methods"){

                @Override
                void apply(CodeStyleSettings settings, int value) {
                    settings.STATIC_METHODS_ORDER_WEIGHT = value;
                }

                @Override
                int getValue(CodeStyleSettings settings) {
                    return settings.STATIC_METHODS_ORDER_WEIGHT;
                }
            };
            PROPERTIES.put(staticMethodManager.myName, staticMethodManager);
            PropertyManager instanceMethodManager = new PropertyManager("listbox.members.order.methods"){

                @Override
                void apply(CodeStyleSettings settings, int value) {
                    settings.METHODS_ORDER_WEIGHT = value;
                }

                @Override
                int getValue(CodeStyleSettings settings) {
                    return settings.METHODS_ORDER_WEIGHT;
                }
            };
            PROPERTIES.put(instanceMethodManager.myName, instanceMethodManager);
            PropertyManager staticInnerClassManager = new PropertyManager("listbox.members.order.inner.static.classes"){

                @Override
                void apply(CodeStyleSettings settings, int value) {
                    settings.STATIC_INNER_CLASSES_ORDER_WEIGHT = value;
                }

                @Override
                int getValue(CodeStyleSettings settings) {
                    return settings.STATIC_INNER_CLASSES_ORDER_WEIGHT;
                }
            };
            PROPERTIES.put(staticInnerClassManager.myName, staticInnerClassManager);
            PropertyManager innerClassManager = new PropertyManager("listbox.members.order.inner.classes"){

                @Override
                void apply(CodeStyleSettings settings, int value) {
                    settings.INNER_CLASSES_ORDER_WEIGHT = value;
                }

                @Override
                int getValue(CodeStyleSettings settings) {
                    return settings.INNER_CLASSES_ORDER_WEIGHT;
                }
            };
            PROPERTIES.put(innerClassManager.myName, innerClassManager);
        }

        private static Iterable<String> getPropertyNames(final CodeStyleSettings settings) {
            ArrayList<String> result = new ArrayList<String>(PROPERTIES.keySet());
            Collections.sort(result, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    int weight1 = this.getWeight(o1);
                    int weight2 = this.getWeight(o2);
                    return weight1 - weight2;
                }

                private int getWeight(String o) {
                    PropertyManager propertyManager = (PropertyManager)PROPERTIES.get(o);
                    if (propertyManager == null) {
                        throw new IllegalArgumentException("unexpected " + o);
                    }
                    return propertyManager.getValue(settings);
                }
            });
            return result;
        }

        public void apply(CodeStyleSettings settings) {
            for (int i = 0; i < this.myModel.size(); ++i) {
                Object o = this.myModel.getElementAt(i);
                if (o == null) {
                    throw new IllegalArgumentException("unexpected " + o);
                }
                PropertyManager propertyManager = PROPERTIES.get(o.toString());
                if (propertyManager == null) {
                    throw new IllegalArgumentException("unexpected " + o);
                }
                propertyManager.apply(settings, i + 1);
            }
        }

        public boolean isModified(CodeStyleSettings settings) {
            Iterable<String> oldProperties = MembersOrderList.getPropertyNames(settings);
            int i = 0;
            for (String property : oldProperties) {
                if (i >= this.myModel.size() || !property.equals(this.myModel.getElementAt(i))) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        static {
            MembersOrderList.init();
        }

        private static abstract class PropertyManager {
            public final String myName;

            protected PropertyManager(String nameKey) {
                this.myName = ApplicationBundle.message((String)nameKey, (Object[])new Object[0]);
            }

            abstract void apply(CodeStyleSettings var1, int var2);

            abstract int getValue(CodeStyleSettings var1);
        }
    }
}

